/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.comment;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.doxygen.comment.ComplexItemBuilder;
import com.jetbrains.cidr.doxygen.comment.InfoItemImpl;
import com.jetbrains.cidr.doxygen.psi.impl.DxPsiImplUtil;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCommentGroup;
import com.jetbrains.cidr.lang.documentation.doxygen.api.InfoItem;
import com.jetbrains.cidr.lang.documentation.doxygen.api.TagItem;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DoxygenCommentGroupImpl
implements DoxygenCommentGroup {
    @NotNull
    private final String options;
    @NotNull
    private final List<InfoItem> items;

    private DoxygenCommentGroupImpl(@NotNull String options, @NotNull List<InfoItem> items) {
        this.options = options;
        this.items = items;
    }

    @Override
    @NotNull
    public String getOptions() {
        return this.options;
    }

    @Override
    @NotNull
    public List<InfoItem> getContent() {
        return this.items;
    }

    @Override
    public boolean isEmpty() {
        return this.options.isEmpty() && this.items.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoxygenCommentGroupImpl commentGroup = (DoxygenCommentGroupImpl)o;
        if (!this.options.equals(commentGroup.options)) {
            return false;
        }
        int size = this.items.size();
        if (size != commentGroup.items.size()) {
            return false;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            if (this.items.get(i2).equals(commentGroup.items.get(i2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result2 = this.options.hashCode();
        result2 = 31 * result2 + this.items.hashCode();
        return result2;
    }

    public String getDescription() {
        return StringUtil.join(this.items, InfoItem::getDescription, (String)" ");
    }

    static class Builder
    implements ComplexItemBuilder {
        private final List<InfoItem> tags = new ArrayList<InfoItem>();
        private String options = "";

        Builder() {
        }

        public void addOptions(@NotNull ASTNode node) {
            assert (this.options.isEmpty());
            List<String> optionList = DxPsiImplUtil.extractOptions(node);
            this.options = "[" + StringUtil.join(optionList, (String)", ") + "]";
        }

        @Override
        public void addTag(@NotNull TagItem tag) {
            this.tags.add(tag);
        }

        @Override
        public void addText(@NotNull String text) {
            if ((text = text.trim()).isEmpty()) {
                return;
            }
            this.tags.add(new InfoItemImpl(text));
        }

        public DoxygenCommentGroupImpl build() {
            return new DoxygenCommentGroupImpl(this.options, this.tags);
        }
    }
}

