/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.comment;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.doxygen.DoxygenUtil;
import com.jetbrains.cidr.doxygen.comment.ComplexItemBuilder;
import com.jetbrains.cidr.doxygen.comment.DoxygenCommentGroupImpl;
import com.jetbrains.cidr.doxygen.comment.DoxygenCommentTagImpl;
import com.jetbrains.cidr.doxygen.comment.DxCommentProcessorUtil;
import com.jetbrains.cidr.doxygen.psi.DxDocComment;
import com.jetbrains.cidr.doxygen.psi.DxDocTag;
import com.jetbrains.cidr.doxygen.psi.DxTypes;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCmd;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DxCommentProcessor {
    public static final Set<String> PLAIN_TAGS = ContainerUtil.set((Object[])new String[]{DoxygenCmd.BRIEF.toString()});
    final PsiElement element;
    private static final Result NONE = new Result(null, true);

    public DxCommentProcessor(@Nullable PsiElement element) {
        this.element = element;
    }

    @NotNull
    public DoxygenCommentGroupImpl getCommentGroup() {
        List<PsiNamedElement> params;
        List<PsiComment> comments = DxCommentProcessorUtil.findOCCommentFor(this.element);
        DoxygenCommentGroupImpl.Builder builder = DxCommentProcessor.process(comments);
        PsiElement curElement = this.element;
        if (curElement instanceof OCDeclarator) {
            curElement = curElement.getParent();
        }
        if (curElement instanceof OCCallable && (params = ((OCCallable)curElement).getParameters()) != null) {
            for (PsiNamedElement param : params) {
                List<PsiComment> paramComments;
                DoxygenCommentGroupImpl paramGroup;
                String name = param.getName();
                if ("<unnamed>".equals(name) || (paramGroup = DxCommentProcessor.process(paramComments = DxCommentProcessorUtil.findOCCommentFor((PsiElement)param)).build()).isEmpty()) continue;
                builder.addTag(new DoxygenCommentTagImpl("param", paramGroup.getOptions(), name, paramGroup.getDescription()));
            }
        }
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static DoxygenCommentGroupImpl.Builder process(@NotNull List<PsiComment> comments) {
        boolean isOptionFound = false;
        DoxygenCommentGroupImpl.Builder builder = new DoxygenCommentGroupImpl.Builder();
        Comment comment = new Comment(comments);
        PsiElement element = comment.getFistChild();
        while (true) {
            block7: {
                Result result2;
                StringBuilder description;
                if (element == null) {
                    return builder;
                }
                IElementType type2 = element.getNode().getElementType();
                if (type2 == DxTypes.DOC_COMMENT_DATA) {
                    description = new StringBuilder();
                    result2 = DxCommentProcessor.processDocData(comment, element, description);
                    element = result2.element;
                    builder.addText(description.toString());
                    continue;
                }
                if (type2 == DxTypes.TAG_OPTION) {
                    if (!isOptionFound) {
                        isOptionFound = true;
                        builder.addOptions(element.getNode());
                        break block7;
                    } else {
                        description = new StringBuilder();
                        result2 = DxCommentProcessor.processDocData(comment, element, description);
                        element = result2.element;
                        builder.addText(description.toString());
                        continue;
                    }
                }
                if (type2 == DxTypes.DOC_TAG) {
                    Result result3 = DxCommentProcessor.processTag(comment, element, builder);
                    element = result3.element;
                    continue;
                }
            }
            element = comment.nextSibling(element);
        }
    }

    @NotNull
    private static Result processDocData(@NotNull Comment comment, @Nullable PsiElement element, @NotNull StringBuilder description) {
        if (element == null) {
            return NONE;
        }
        IElementType type2 = element.getNode().getElementType();
        if (type2 == DxTypes.DOC_COMMENT_DATA || type2 == DxTypes.TAG_OPTION) {
            String text = element.getText().trim();
            description.append(text);
            return DxCommentProcessor.processDocData(comment, comment.nextSibling(element), description);
        }
        description.append(" ");
        while (element != null) {
            IElementType t = element.getNode().getElementType();
            if (t == DxTypes.DOC_TAG) {
                return new Result(element, true);
            }
            if (t == DxTypes.DOC_COMMENT_DATA || t == DxTypes.TAG_OPTION) {
                return DxCommentProcessor.processDocData(comment, element, description);
            }
            if (t == DxTypes.EOF_DOC_COMMENT_START || t == TokenType.WHITE_SPACE) {
                Result result2 = DxCommentProcessor.processWS(comment, element);
                if (!result2.proceed) {
                    return result2;
                }
                element = result2.element;
                continue;
            }
            element = comment.nextSibling(element);
        }
        return NONE;
    }

    @NotNull
    private static Result processTag(@NotNull Comment comment, @NotNull PsiElement element, @NotNull DoxygenCommentGroupImpl.Builder builder) {
        DxDocTag tag = (DxDocTag)element;
        String name = tag.getName();
        if (DoxygenCmd.SURROUND_TAGS.containsKey(name)) {
            element = DxCommentProcessor.processSurroundTag(comment, element, builder);
            return new Result(element, true);
        }
        if (DoxygenCmd.SURROUND_TAGS.containsValue(name)) {
            element = comment.nextSibling(element);
            return new Result(element, true);
        }
        DoxygenCommentTagImpl curTag = new DoxygenCommentTagImpl(tag);
        builder.addTag(curTag);
        element = comment.nextSibling(element);
        while (element != null) {
            IElementType type2 = element.getNode().getElementType();
            if (type2 == DxTypes.DOC_COMMENT_DATA || type2 == DxTypes.TAG_OPTION) {
                StringBuilder description = new StringBuilder();
                Result result2 = DxCommentProcessor.processDocData(comment, element, description);
                curTag.addText(description.toString().trim());
                element = result2.element;
                if (result2.proceed) continue;
                return result2;
            }
            if (type2 == DxTypes.DOC_TAG) {
                if (!PLAIN_TAGS.contains(name) && DoxygenCmd.SURROUND_TAGS.containsKey(((DxDocTag)element).getName())) {
                    element = DxCommentProcessor.processSurroundTag(comment, element, curTag);
                    continue;
                }
                return new Result(element, true);
            }
            if (type2 == DxTypes.EOF_DOC_COMMENT_START || type2 == TokenType.WHITE_SPACE) {
                Result result3 = DxCommentProcessor.processWS(comment, element);
                element = result3.element;
                if (result3.proceed) continue;
                return result3;
            }
            element = comment.nextSibling(element);
        }
        return NONE;
    }

    @Nullable
    private static PsiElement processSurroundTag(@NotNull Comment comment, @NotNull PsiElement element, @NotNull ComplexItemBuilder builder) {
        DoxygenCommentTagImpl tag = new DoxygenCommentTagImpl((DxDocTag)element);
        String stopName = DoxygenCmd.SURROUND_TAGS.get(tag.getName());
        builder.addTag(tag);
        StringBuilder description = new StringBuilder();
        element = comment.nextSibling(element);
        while (element != null) {
            String text = element.getText();
            IElementType type2 = element.getNode().getElementType();
            if (type2 == TokenType.WHITE_SPACE) {
                int count = StringUtil.getLineBreakCount((CharSequence)text);
                if (count > 0 && text.contains("*")) {
                    for (int i2 = 0; i2 < count; ++i2) {
                        if (description.length() <= 0) continue;
                        description.append("\n");
                    }
                } else {
                    description.append(text);
                }
            } else if (type2 == DxTypes.EOF_DOC_COMMENT_START) {
                if (description.length() > 0) {
                    description.append("\n");
                }
            } else {
                if (type2 == DxTypes.DOC_TAG && stopName.equals(((DxDocTag)element).getName()) || type2 == DxTypes.DOC_COMMENT_END) break;
                description.append(text);
            }
            element = comment.nextSibling(element);
        }
        String descriptionText = StringUtil.trimTrailing((String)description.toString());
        tag.addText(StringUtil.trimStart((String)descriptionText, (String)"\n"));
        if (element != null) {
            return comment.nextSibling(element);
        }
        return null;
    }

    @NotNull
    private static Result processWS(@NotNull Comment comment, @NotNull PsiElement element) {
        int breaks = 0;
        while (element != null) {
            IElementType t = element.getNode().getElementType();
            if (t == TokenType.WHITE_SPACE) {
                breaks += StringUtil.getLineBreakCount((CharSequence)element.getText());
            } else {
                if (t != DxTypes.EOF_DOC_COMMENT_START) break;
                ++breaks;
            }
            element = comment.nextSibling(element);
        }
        boolean proceed = breaks <= 1;
        return new Result(element, proceed);
    }

    private static class Comment {
        private int idx = 0;
        private final List<PsiComment> comments;

        public Comment(@NotNull List<PsiComment> comments) {
            this.comments = comments;
        }

        @Nullable
        public PsiElement getFistChild() {
            return this.getFirstElementChild(0);
        }

        @Nullable
        private PsiElement getFirstElementChild(int index) {
            DxDocComment docComment;
            if (index < this.comments.size() && (docComment = DoxygenUtil.convertToDoxygen(this.comments.get(index))) != null) {
                return docComment.getFirstChild();
            }
            return null;
        }

        public PsiElement nextSibling(@NotNull PsiElement element) {
            PsiElement next = element.getNextSibling();
            if (next == null) {
                return this.getFirstElementChild(++this.idx);
            }
            return next;
        }
    }

    private static class Result {
        public final PsiElement element;
        public final boolean proceed;

        public Result(PsiElement element, boolean proceed) {
            this.element = element;
            this.proceed = proceed;
        }
    }
}

