/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.spellchecker;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.quickfixes.AcceptWordAsCorrect;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.jetbrains.cidr.doxygen.psi.DxTypes;
import org.jetbrains.annotations.NotNull;

public class DxSpellCheckingStrategy
extends SpellcheckingStrategy {
    @Override
    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        ASTNode node = element.getNode();
        if (node != null && node.getElementType() == DxTypes.DOC_COMMENT_DATA) {
            return TEXT_TOKENIZER;
        }
        return super.getTokenizer(element);
    }

    @Override
    public SpellCheckerQuickFix[] getRegularFixes(PsiElement element, int offset, @NotNull TextRange textRange, boolean useRename, String wordWithTypo) {
        return new SpellCheckerQuickFix[]{new AcceptWordAsCorrect(wordWithTypo)};
    }
}

