/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildConfigurationProblems {
    @NotNull
    public String title;
    @NotNull
    public final List<String> problems = new SmartList();
    @NotNull
    public final List<Fix> fixes = new SmartList();

    @NotNull
    public String getTitle() {
        return this.title;
    }

    @NotNull
    public List<String> getProblems() {
        return this.problems;
    }

    public boolean hasProblems() {
        return !this.problems.isEmpty();
    }

    @NotNull
    public String getHtmlProblems() {
        return StringUtil.join(this.problems, (String)"<br>");
    }

    @NotNull
    public String getTextProblems() {
        return StringUtil.join(this.problems, (String)"\n");
    }

    @NotNull
    public String getText() {
        String result2 = this.getTitle();
        if (this.hasProblems()) {
            result2 = result2 + "\n" + this.getTextProblems();
        }
        return result2;
    }

    @NotNull
    public List<Fix> getFixes() {
        return this.fixes;
    }

    @Nullable
    public Fix findFix(@Nullable String name) {
        for (Fix each : this.fixes) {
            if (!each.name.equals(name)) continue;
            return each;
        }
        return null;
    }

    public static abstract class Fix {
        @NotNull
        private final String name;
        private final boolean special;

        protected Fix(@NotNull String name, boolean special) {
            this.name = name;
            this.special = special;
        }

        public abstract void apply();

        @NotNull
        public String getName() {
            return this.name;
        }
    }
}

