/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrOrderMerger {
    @NotNull
    public static <T> List<T> mergeWithUpdatedOrderPrecedence(@NotNull List<T> originalOrder, @NotNull List<T> updatedOrder, boolean useIdentity) {
        Function<T, Object> wrapper = CidrOrderMerger.wrapper(useIdentity);
        Function<Object, T> unwrapper = CidrOrderMerger.unwrapper(useIdentity);
        LinkedHashSet<Object> mergedOrder = new LinkedHashSet<Object>();
        for (T eachPreviousEntry : originalOrder) {
            int index;
            int n = index = useIdentity ? ContainerUtil.indexOfIdentity(updatedOrder, eachPreviousEntry) : updatedOrder.indexOf(eachPreviousEntry);
            if (index == -1) {
                mergedOrder.add(wrapper.fun(eachPreviousEntry));
                continue;
            }
            mergedOrder.addAll(ContainerUtil.map(updatedOrder.subList(0, index + 1), wrapper));
            updatedOrder = updatedOrder.subList(index + 1, updatedOrder.size());
        }
        mergedOrder.addAll(ContainerUtil.map(updatedOrder, wrapper));
        return ContainerUtil.map(mergedOrder, unwrapper);
    }

    @NotNull
    public static <T> List<T> mergeWithOriginalOrderPrecedence(@NotNull List<T> currentEntries, @NotNull List<T> updatedEntries, boolean useIdentity) {
        Function<T, Object> wrapper = CidrOrderMerger.wrapper(useIdentity);
        Function<Object, T> unwrapper = CidrOrderMerger.unwrapper(useIdentity);
        ArrayList<Pair> currentEntriesWithIndicesInUpdatedList = new ArrayList<Pair>();
        for (T each : currentEntries) {
            int index = useIdentity ? ContainerUtil.indexOfIdentity(updatedEntries, each) : updatedEntries.indexOf(each);
            currentEntriesWithIndicesInUpdatedList.add(Pair.create(each, (Object)index));
        }
        ArrayList sortedIndicesInUpdatedList = new ArrayList(ContainerUtil.mapNotNull(currentEntriesWithIndicesInUpdatedList, pair -> (Integer)pair.second == -1 ? null : (Integer)pair.second));
        sortedIndicesInUpdatedList.sort(Integer::compareTo);
        int smallestIndexInUpdatedList = (Integer)ContainerUtil.getFirstItem(sortedIndicesInUpdatedList, (Object)-1);
        LinkedHashSet<Object> mergedOrder = new LinkedHashSet<Object>();
        for (Pair eachEntryWithIndex : currentEntriesWithIndicesInUpdatedList) {
            Integer nextGreaterIndexInUpdatedList;
            int indexInUpdatedList = (Integer)eachEntryWithIndex.second;
            if (indexInUpdatedList == -1) {
                mergedOrder.add(wrapper.fun(eachEntryWithIndex.first));
                continue;
            }
            if (indexInUpdatedList == smallestIndexInUpdatedList) {
                mergedOrder.addAll(ContainerUtil.map(updatedEntries.subList(0, indexInUpdatedList), wrapper));
            }
            if ((nextGreaterIndexInUpdatedList = (Integer)ContainerUtil.find(sortedIndicesInUpdatedList, eachSortedIndex -> eachSortedIndex > indexInUpdatedList)) == null) {
                nextGreaterIndexInUpdatedList = updatedEntries.size();
            }
            mergedOrder.addAll(ContainerUtil.map(updatedEntries.subList(indexInUpdatedList, nextGreaterIndexInUpdatedList), wrapper));
        }
        mergedOrder.addAll(ContainerUtil.map(updatedEntries, wrapper));
        return ContainerUtil.map(mergedOrder, unwrapper);
    }

    private static <T> Function<T, Object> wrapper(boolean useIdentity) {
        return object -> useIdentity ? new IdentityWrapper(object) : object;
    }

    private static <T> Function<Object, T> unwrapper(boolean useIdentity) {
        return wrapped -> useIdentity ? ((IdentityWrapper)wrapped).wrappee : wrapped;
    }

    private static class IdentityWrapper {
        final Object wrappee;

        public IdentityWrapper(Object wrappee) {
            this.wrappee = wrappee;
        }

        public boolean equals(Object o) {
            return this.wrappee == ((IdentityWrapper)o).wrappee;
        }

        public int hashCode() {
            return System.identityHashCode(this.wrappee);
        }
    }
}

