/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.ReverseCharSequence;
import com.jetbrains.cidr.execution.DimmableFilter;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrPathConsoleFilter
implements Filter,
DumbAware,
DimmableFilter {
    public static final int MAX_TIME_PER_LINE = 250;
    private static final String FILE_CHARS = "-+\\p{LC}\\d~._\\(\\)|";
    private static final String LINE_NUMBER = "\\d{1,5}";
    private static final Pattern ABSOLUTE_WIN_PATH_PREFIX = Pattern.compile("^(/|([A-Za-z]:([/\\\\]))).*");
    public static final String LINE_PATTERN_TEXT = "(?:\\((\\d{1,5})\\))|:(\\d{1,5})";
    private static final Pattern LINE_NUMBER_PATTERN = Pattern.compile("[^:](?:(?:\\((\\d{1,5})\\))|:(\\d{1,5})(?::(\\d{1,5}))?(?::?\\b|_))");
    private static final Pattern REVERSE_FILE_PATH_PATTERN = Pattern.compile(SystemInfo.isWindows ? "^(([-+\\p{LC}\\d~._\\(\\)|]+([-+\\p{LC}\\d~._\\(\\)|\t ]*([/\\\\])+)?)+)(:[A-Za-z])?" : "^(([-+\\p{LC}\\d~._\\(\\)|]+([-+\\p{LC}\\d~._\\(\\)|\t ]*/+)?)+)");
    private static final int FILE_GROUP = 0;
    public static final int MSVC_LINE_GROUP = 1;
    public static final int REGULAR_LINE_GROUP = 2;
    public static final int COLUMN_GROUP = 3;
    @NotNull
    protected final Project myProject;
    @Nullable
    private final CidrToolEnvironment myEnvironment;
    @Nullable
    private final File myBaseDir;
    private boolean myDimHighlighting;

    public CidrPathConsoleFilter(@NotNull Project project2, @Nullable CidrToolEnvironment environment, @Nullable File baseDir) {
        this.myProject = project2;
        this.myEnvironment = environment;
        this.myBaseDir = baseDir;
    }

    @Override
    public void dimHighlighting() {
        this.myDimHighlighting = true;
    }

    @Nullable
    public Filter.Result applyFilter(@Nullable String line, int entireLength) {
        if (line == null) {
            return null;
        }
        if (!StringUtil.containsAnyChar((String)line, (String)":(")) {
            return null;
        }
        CharSequence expiringLine = CidrPathConsoleFilter.timeLimitedSequence(line);
        Matcher cm = LINE_NUMBER_PATTERN.matcher(expiringLine);
        Matcher fm = null;
        List results = null;
        int searchPosition = 0;
        int endPosition = 0;
        int lineStart = entireLength - line.length();
        try {
            while (cm.find(searchPosition)) {
                int pathStart;
                String filename;
                HyperlinkInfo link;
                int lineNumber;
                int fileSearchPosition = searchPosition;
                int lineNumberGroup = cm.group(1) != null ? 1 : 2;
                searchPosition = cm.start(lineNumberGroup);
                endPosition = cm.end(lineNumberGroup);
                if (lineNumberGroup == 1) {
                    ++endPosition;
                }
                try {
                    lineNumber = Math.max(0, Integer.valueOf(cm.group(lineNumberGroup)) - 1);
                }
                catch (NumberFormatException ignore) {
                    continue;
                }
                int columnNumber = 0;
                if (cm.group(3) != null) {
                    try {
                        columnNumber = Math.max(0, Integer.valueOf(cm.group(3)) - 1);
                        searchPosition = cm.start(3);
                        endPosition = cm.end(3);
                    }
                    catch (NumberFormatException ignore) {
                        continue;
                    }
                }
                if (fm == null) {
                    fm = REVERSE_FILE_PATH_PATTERN.matcher((CharSequence)new ReverseCharSequence(expiringLine));
                }
                fm.region(line.length() - cm.start() - 1, line.length() - fileSearchPosition);
                if (!fm.find() || (link = this.processMatch(filename = line.substring(pathStart = line.length() - fm.end(0), line.length() - fm.start()), lineNumber, columnNumber)) == null) continue;
                if (results == null) {
                    results = ContainerUtil.newSmartList();
                }
                results.add(new Filter.ResultItem(lineStart + pathStart, lineStart + endPosition, link, this.myDimHighlighting));
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return results == null || results.size() == 0 ? null : new Filter.Result(results);
    }

    private static CharSequence timeLimitedSequence(String line) {
        final long expirationTime = System.currentTimeMillis() + 250L;
        return new StringUtil.BombedCharSequence(line){

            protected void checkCanceled() {
                if (System.currentTimeMillis() > expirationTime) {
                    throw new ProcessCanceledException();
                }
            }
        };
    }

    @Nullable
    protected HyperlinkInfo processMatch(@NotNull String matchedPath, int line, int column) {
        VirtualFile file2;
        boolean hasSeparator;
        boolean isAbsolute = SystemInfo.isWindows ? ABSOLUTE_WIN_PATH_PREFIX.matcher(matchedPath).matches() : matchedPath.startsWith("/");
        boolean isHomePath = !isAbsolute && !SystemInfo.isWindows && matchedPath.startsWith("~");
        boolean bl = hasSeparator = !isHomePath && (matchedPath.contains(File.separator) || SystemInfo.isWindows && matchedPath.contains("/"));
        if (this.myEnvironment != null && (isAbsolute || hasSeparator) && this.myBaseDir != null) {
            matchedPath = this.myEnvironment.toLocalPath(this.myBaseDir, matchedPath);
            isAbsolute = true;
        }
        if (isAbsolute) {
            file2 = CidrPathConsoleFilter.fileByIOFile(new File(matchedPath));
        } else if (isHomePath) {
            String userHome = System.getProperty("user.home");
            file2 = CidrPathConsoleFilter.fileByIOFile(new File(userHome, matchedPath.substring(1)));
        } else {
            VirtualFile virtualFile = file2 = this.myBaseDir == null ? null : CidrPathConsoleFilter.fileByIOFile(new File(this.myBaseDir, matchedPath));
            if (file2 == null && !hasSeparator) {
                file2 = this.findFirstFileByName(matchedPath);
            }
        }
        return file2 == null ? null : this.createHyperlinkInfo(file2, line, column);
    }

    @NotNull
    protected HyperlinkInfo createHyperlinkInfo(@NotNull VirtualFile file2, int line, int column) {
        return new OpenFileHyperlinkInfo(this.myProject, file2, line, column);
    }

    @Nullable
    private static VirtualFile fileByIOFile(@NotNull File ioFile) {
        return LocalFileSystem.getInstance().findFileByPath(ioFile.getAbsolutePath());
    }

    @Nullable
    private VirtualFile findFirstFileByName(@NotNull String name) {
        try {
            return (VirtualFile)ContainerUtil.getFirstItem(FilenameIndex.getVirtualFilesByName(this.myProject, name, GlobalSearchScope.projectScope((Project)this.myProject)));
        }
        catch (IndexNotReadyException ignore) {
            return null;
        }
    }
}

