/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunProfile;
import com.jetbrains.cidr.lang.workspace.OCRunConfigurationWithResolveConfiguration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrRunConfiguration<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>>
extends LocatableConfigurationBase
implements CidrRunProfile,
OCRunConfigurationWithResolveConfiguration,
CommonProgramRunConfigurationParameters {
    @Nullable
    private BuildTargetAndConfigurationData myTargetAndConfigurationData;
    @Nullable
    private String myProgramParameters;
    @Nullable
    private String myWorkingDirectory;
    @NotNull
    private LinkedHashMap<String, String> myEnvs = ContainerUtil.newLinkedHashMap();
    private static final boolean DEFAULT_PASS_PARENT_ENVS = true;
    private boolean myPassParentEnvs = true;

    public CidrRunConfiguration(Project project2, ConfigurationFactory factory, String name) {
        super(project2, factory, name);
    }

    public String suggestedName() {
        return this.suggestNameForTarget();
    }

    @Nullable
    public String suggestNameForTarget() {
        BuildTargetAndConfigurationData data = this.myTargetAndConfigurationData;
        return data != null && data.target != null ? data.target.targetName : null;
    }

    public void setTargetAndConfigurationData(@Nullable BuildTargetAndConfigurationData data) {
        this.myTargetAndConfigurationData = data;
    }

    @Nullable
    public BuildTargetAndConfigurationData getTargetAndConfigurationData() {
        return this.myTargetAndConfigurationData;
    }

    @Override
    public void setProgramParameters(@Nullable String value2) {
        this.myProgramParameters = StringUtil.isEmptyOrSpaces((String)value2) ? null : value2;
    }

    @Override
    @Nullable
    public String getProgramParameters() {
        return this.myProgramParameters;
    }

    @Override
    public void setWorkingDirectory(@Nullable String value2) {
        this.myWorkingDirectory = ExternalizablePath.urlValue(value2);
    }

    @Override
    @Nullable
    public String getWorkingDirectory() {
        return ExternalizablePath.localPathValue(this.myWorkingDirectory);
    }

    @Override
    public void setEnvs(@NotNull Map<String, String> envs) {
        this.myEnvs = new LinkedHashMap<String, String>(envs);
    }

    @Override
    @NotNull
    public Map<String, String> getEnvs() {
        return this.myEnvs;
    }

    @Override
    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myPassParentEnvs = passParentEnvs;
    }

    @Override
    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    @NotNull
    protected BuildTargetAndConfigurationData createBuildTargetAndConfigurationData(@Nullable String projectName, @Nullable String targetName, @Nullable String configName) {
        return new BuildTargetAndConfigurationData(projectName, targetName, configName);
    }

    @Override
    @Nullable
    public abstract CidrCommandLineState getState(@NotNull Executor var1, @NotNull ExecutionEnvironment var2) throws ExecutionException;

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myProgramParameters = element.getAttributeValue("PROGRAM_PARAMS");
        this.myWorkingDirectory = element.getAttributeValue("WORKING_DIR");
        this.myEnvs = CidrRunConfiguration.createEnvMap();
        EnvironmentVariablesComponent.readExternal(element, this.myEnvs);
        this.myPassParentEnvs = CidrRunConfiguration.getBoolean(element.getAttributeValue("PASS_PARENT_ENVS_2"), true);
        String projectName = element.getAttributeValue("PROJECT_NAME");
        String targetName = element.getAttributeValue("TARGET_NAME");
        String configName = element.getAttributeValue("CONFIG_NAME");
        this.myTargetAndConfigurationData = this.createBuildTargetAndConfigurationData(projectName, targetName, configName);
    }

    @NotNull
    private static LinkedHashMap<String, String> createEnvMap() {
        return new LinkedHashMap<String, String>();
    }

    @NotNull
    private static Boolean getBoolean(@Nullable String reload, boolean def) {
        return StringUtil.isEmptyOrSpaces((String)reload) ? def : Boolean.valueOf(reload);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        ProgramParametersUtil.checkWorkingDirectoryExist(this, this.getProject(), null);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (!StringUtil.isEmptyOrSpaces((String)this.myProgramParameters)) {
            element.setAttribute("PROGRAM_PARAMS", this.myProgramParameters);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myWorkingDirectory)) {
            element.setAttribute("WORKING_DIR", this.myWorkingDirectory);
        }
        EnvironmentVariablesComponent.writeExternal(element, this.myEnvs);
        element.setAttribute("PASS_PARENT_ENVS_2", String.valueOf(this.myPassParentEnvs));
        if (this.myTargetAndConfigurationData != null) {
            BuildTargetData targetData = this.myTargetAndConfigurationData.target;
            if (targetData != null) {
                element.setAttribute("PROJECT_NAME", targetData.projectName);
                element.setAttribute("TARGET_NAME", targetData.targetName);
            }
            if (this.myTargetAndConfigurationData.configurationName != null) {
                element.setAttribute("CONFIG_NAME", this.myTargetAndConfigurationData.configurationName);
            }
        }
    }

    public RunConfiguration clone() {
        CidrRunConfiguration result2 = (CidrRunConfiguration)super.clone();
        result2.myProgramParameters = this.myProgramParameters;
        result2.myWorkingDirectory = this.myWorkingDirectory;
        result2.myEnvs = new LinkedHashMap<String, String>(this.myEnvs);
        result2.myPassParentEnvs = this.myPassParentEnvs;
        result2.myTargetAndConfigurationData = this.myTargetAndConfigurationData;
        return result2;
    }

    public void setupDefaultTargetAndExecutable() {
        CidrBuildConfigurationHelper<BC, CidrBuildTarget> helper = this.getHelper();
        CidrBuildTarget target = null;
        BuildTargetAndConfigurationData data = this.getTargetAndConfigurationData();
        if (data != null && data.target != null) {
            target = (CidrBuildTarget)helper.findRunTarget(data.target);
        }
        if (target == null) {
            target = (CidrBuildTarget)helper.getDefaultTarget();
            data = null;
        }
        String configurationName = null;
        if (data != null && data.configurationName != null) {
            configurationName = data.configurationName;
        } else {
            CidrBuildConfiguration config = helper.getDefaultConfiguration(target);
            if (config != null) {
                configurationName = config.getName();
            }
        }
        this.setTargetAndConfigurationData(new BuildTargetAndConfigurationData(target == null ? null : target.getProjectName(), target == null ? null : target.getName(), configurationName));
    }

    @NotNull
    public abstract CidrBuildConfigurationHelper<BC, TARGET> getHelper();
}

