/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.DefaultProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugProcessConfiguratorStarter;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunProfile;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrRunner
extends DefaultProgramRunner {
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile2) {
        if (profile2 instanceof RunConfigurationWithSuppressedDefaultRunAction && DefaultRunExecutor.EXECUTOR_ID.equals(executorId)) {
            return false;
        }
        if (profile2 instanceof RunConfigurationWithSuppressedDefaultDebugAction && DefaultDebugExecutor.EXECUTOR_ID.equals(executorId)) {
            return false;
        }
        return profile2 instanceof CidrRunProfile;
    }

    protected static void triggerUsage(@Nullable RunnerAndConfigurationSettings configuration) {
        String frameworkName;
        RunConfiguration runConfiguration;
        if (configuration != null && (runConfiguration = configuration.getConfiguration()) instanceof CidrTestRunConfiguration && (frameworkName = ((CidrTestRunConfiguration)runConfiguration).getTestingFrameworkName()) != null) {
            UsageTrigger.trigger("execute.testingFramework." + ConvertUsagesUtil.ensureProperKey(frameworkName));
        }
    }

    public XDebugSession startDebugSession(final CidrCommandLineState state, ExecutionEnvironment env, final boolean muteBreakpoints, final XDebugSessionListener ... listeners) throws ExecutionException {
        return XDebuggerManager.getInstance((Project)env.getProject()).startSession(env, (XDebugProcessStarter)new XDebugProcessConfiguratorStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session2) throws ExecutionException {
                for (XDebugSessionListener l : listeners) {
                    session2.addSessionListener(l);
                }
                return state.startDebugProcess(session2);
            }

            @Override
            public void configure(XDebugSessionData data) {
                if (muteBreakpoints) {
                    data.setBreakpointsMuted(true);
                }
            }
        });
    }
}

