/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.pty4j.unix.Pty;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProcessOutputReaders {
    private final AtomicReference<MyOutputReader[]> myReaders = new AtomicReference<MyOutputReader[]>(new MyOutputReader[2]);
    private volatile File myOutFile;
    private volatile File myErrFile;
    private volatile Pty myOutPty;
    private volatile Pty myErrPty;

    public void init(@NotNull GeneralCommandLine commandLine, boolean usePty) throws ExecutionException {
        try {
            Charset charset = commandLine.getCharset();
            if (usePty) {
                this.myOutPty = new Pty(true);
                this.myErrPty = new Pty(true);
                this.getReaders()[0] = new MyOutputReader(this.myOutPty, charset, commandLine, ProcessOutputTypes.STDOUT);
                this.getReaders()[1] = new MyOutputReader(this.myErrPty, charset, commandLine, ProcessOutputTypes.STDERR);
            } else {
                this.myOutFile = FileUtil.createTempFile((String)this.getClass().getSimpleName(), (String)"out");
                this.myErrFile = FileUtil.createTempFile((String)this.getClass().getSimpleName(), (String)"err");
                this.getReaders()[0] = new MyOutputReader(this.myOutFile, charset, commandLine, ProcessOutputTypes.STDOUT);
                this.getReaders()[1] = new MyOutputReader(this.myErrFile, charset, commandLine, ProcessOutputTypes.STDERR);
            }
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot create output file", (Throwable)e);
        }
    }

    public String getOutFileAbsolutePath() {
        return this.myOutPty != null ? this.myOutPty.getSlaveName() : this.myOutFile.getAbsolutePath();
    }

    public String getErrFileAbsolutePath() {
        return this.myErrPty != null ? this.myErrPty.getSlaveName() : this.myErrFile.getAbsolutePath();
    }

    protected MyOutputReader[] getReaders() {
        return this.myReaders.get();
    }

    protected boolean doWaitFor(MyOutputReader[] readers) {
        for (MyOutputReader each : readers) {
            try {
                each.waitFor();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return false;
            }
        }
        return true;
    }

    protected boolean doWaitFor(MyOutputReader[] readers, long timeout, TimeUnit unit) {
        for (MyOutputReader each : readers) {
            try {
                each.waitFor(timeout, unit);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return false;
            }
            catch (TimeoutException e) {
                return false;
            }
        }
        return true;
    }

    public boolean waitFor() {
        return this.doWaitFor(this.getReaders());
    }

    public boolean waitFor(long timeout, TimeUnit unit) {
        return this.doWaitFor(this.getReaders(), timeout, unit);
    }

    public void close() {
        MyOutputReader[] readers;
        for (MyOutputReader each : readers = this.myReaders.getAndSet(new MyOutputReader[0])) {
            each.stop();
        }
        this.doWaitFor(readers);
        for (MyOutputReader each : readers) {
            File file2 = each.getFile();
            if (file2 == null) continue;
            FileUtil.delete((File)file2);
        }
    }

    protected abstract void onTextAvailable(@NotNull String var1, @NotNull Key var2);

    public static class ReaderOptions
    extends BaseOutputReader.Options {
        private final BaseDataReader.SleepingPolicy myPolicy;

        public ReaderOptions(BaseDataReader.SleepingPolicy policy) {
            this.myPolicy = policy;
        }

        public BaseDataReader.SleepingPolicy policy() {
            return this.myPolicy;
        }

        public boolean withSeparators() {
            return true;
        }

        public boolean splitToLines() {
            return false;
        }

        public boolean sendIncompleteLines() {
            return true;
        }
    }

    protected class MyOutputReader
    extends BaseOutputReader {
        private final File myFile;
        private final Key myType;

        private MyOutputReader(@NotNull File file2, @NotNull Charset encoding, @NotNull GeneralCommandLine commandLine, Key type2) throws IOException {
            super((InputStream)new FileInputStream(file2), encoding, (BaseOutputReader.Options)new ReaderOptions(BaseDataReader.SleepingPolicy.SIMPLE));
            this.myFile = file2;
            this.myType = type2;
            this.start(CommandLineUtil.extractPresentableName((String)commandLine.getCommandLineString()));
        }

        private MyOutputReader(@NotNull Pty pty, @NotNull Charset encoding, @NotNull GeneralCommandLine commandLine, Key type2) {
            super((InputStream)pty.getInputStream(), encoding, (BaseOutputReader.Options)new ReaderOptions(BaseDataReader.SleepingPolicy.BLOCKING));
            this.myFile = null;
            this.myType = type2;
            this.start(CommandLineUtil.extractPresentableName((String)commandLine.getCommandLineString()));
        }

        @Nullable
        public File getFile() {
            return this.myFile;
        }

        protected void onTextAvailable(@NotNull String text) {
            text = StringUtil.trimEnd((String)text, (String)"\r");
            text = StringUtil.convertLineSeparators((String)text);
            ProcessOutputReaders.this.onTextAvailable(text, this.myType);
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable2) {
            return ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        }

        public void stop() {
            super.stop();
            if (this.mySleepingPolicy == BaseDataReader.SleepingPolicy.BLOCKING) {
                try {
                    this.waitFor(this.mySleepingPolicy.getTimeToSleep(false), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | TimeoutException ignored) {
                    try {
                        this.close();
                    }
                    catch (IOException e) {
                        CidrDebuggerLog.LOG.error((Throwable)e);
                    }
                }
            }
        }
    }
}

