/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.BackendConsoleInjectionHelper;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportFactory;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerFatalException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerIllegalStateException;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakPointBroadcast;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointHandler;
import com.jetbrains.cidr.execution.debugger.disasm.CidrDisasmView;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrEvaluatedValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.ExpiredException;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrDebugProcess
extends XDebugProcess
implements DebuggerDriver.Handler,
UserDataHolderEx {
    public static final long ABORT_COMMAND_TIMEOUT = 3000L;
    public static final String BACKEND_CONTENT_ID = "DEBUGGER_BACKEND_CONSOLE";
    public static final Key<CidrDebugProcess> DEBUG_PROCESS_KEY = Key.create((String)CidrDebugProcess.class.getSimpleName());
    public static final Key THROW_ON_THREAD_COLLECTION = Key.create((String)"THROW_ON_THREAD_COLLECTION");
    public static final Key THROW_ON_FRAME_COLLECTION = Key.create((String)"THROW_ON_FRAME_COLLECTION");
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    private final QueueProcessor<DebuggerCommand> myCommandQueue;
    private final MyProcessHandler myProcessHandler;
    private final DebuggerDriver myDriverDoNotUse;
    private final String myDriverName;
    private final DebuggerDriverConfiguration myConfiguration;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private final CidrBreakpointHandler myBreakpointHandler;
    private final CidrWatchpointHandler myWatchpointHandler;
    private final XBreakpointHandler<?>[] myBreakpointHandlers;
    private final CidrExceptionBreakpointHandler myExceptionBreakpointHandler;
    @Nullable
    private final CidrSymbolicBreakpointHandler mySymbolicBreakpointHandler;
    private final Semaphore myAttachedSemaphore = new Semaphore(0);
    protected final ConsoleView myConsole;
    private volatile LanguageConsoleView myBackendConsole;
    @NotNull
    private final CidrDisasmView myDisassemblyView;
    protected final RunParameters myRunParameters;
    private final CidrDebuggerTypesHelper myTypesHelper = this.createTypesHelper();
    private final List<Couple<File>> mySymbolFiles = ContainerUtil.newArrayList();
    private volatile State myState = State.INITIALIZED;
    private volatile String myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.connecting", (Object[])new Object[0]);
    private final Map<Pair<String, Integer>, CachedValue<List<String>>> myCompletionCache = new HashMap();

    public CidrDebugProcess(@NotNull RunParameters parameters2, @NotNull XDebugSession session2, @NotNull TextConsoleBuilder consoleBuilder) throws ExecutionException {
        super(session2);
        session2.setPauseActionSupported(true);
        this.myCommandQueue = new QueueProcessor((Consumer)new MyCommandProcessor(), Conditions.alwaysFalse());
        this.myRunParameters = parameters2;
        this.myConfiguration = parameters2.getDebuggerDriverConfiguration();
        this.myDriverName = this.myConfiguration.getDriverName();
        this.myDriverDoNotUse = this.myConfiguration.createDriver(this);
        this.myDriverDoNotUse.start(this.myRunParameters.getInstaller(), this.myRunParameters.getArchitectureId());
        this.myProcessHandler = new MyProcessHandler();
        final ProcessHandler driverProcessHandler = this.myDriverDoNotUse.getProcessHandler();
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(ProcessEvent event) {
                driverProcessHandler.startNotify();
            }

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                CidrDebugProcess.this.doTerminateProcess(!willBeDestroyed);
            }
        });
        this.myEditorsProvider = CidrDebugProcess.createEditorsProvider(session2.getRunProfile());
        this.myBreakpointHandler = this.createBreakpointHandler();
        this.myWatchpointHandler = new CidrWatchpointHandler(this);
        this.myExceptionBreakpointHandler = this.createExceptionHandler();
        this.mySymbolicBreakpointHandler = this.createSymbolicHandler();
        List handlersList = ContainerUtil.packNullables((Object[])new XBreakpointHandler[]{this.myBreakpointHandler, this.myWatchpointHandler, this.myExceptionBreakpointHandler, this.mySymbolicBreakpointHandler});
        this.myBreakpointHandlers = (XBreakpointHandler[])ContainerUtil.toArray((List)handlersList, (Object[])new XBreakpointHandler[handlersList.size()]);
        this.myConsole = consoleBuilder.getConsole();
        this.myDisassemblyView = new CidrDisasmView(this);
    }

    @NotNull
    public String getCurrentStateMessage() {
        return this.myCurrentStateMessage;
    }

    @NotNull
    public ConsoleView getConsole() {
        return this.myConsole;
    }

    @NotNull
    private CidrDebuggerTypesHelper createTypesHelper() throws ExecutionException {
        for (CidrDebuggerLanguageSupportFactory factory : (CidrDebuggerLanguageSupportFactory[])CidrDebuggerLanguageSupportFactory.EP_NAME.getExtensions()) {
            CidrDebuggerTypesHelper typesHelper = factory.createTypesHelper(this);
            if (typesHelper == null) continue;
            return typesHelper;
        }
        throw new ExecutionException("Cannot create types helper for: " + this);
    }

    @NotNull
    private static XDebuggerEditorsProvider createEditorsProvider(RunProfile profile2) throws ExecutionException {
        for (CidrDebuggerLanguageSupportFactory factory : (CidrDebuggerLanguageSupportFactory[])CidrDebuggerLanguageSupportFactory.EP_NAME.getExtensions()) {
            XDebuggerEditorsProvider editorsProvider = factory.createEditor(profile2);
            if (editorsProvider == null) continue;
            return editorsProvider;
        }
        throw new ExecutionException("Cannot create editor for: " + profile2.getClass());
    }

    public boolean isDetachDefault() {
        return false;
    }

    private void doTerminateProcess(final boolean detach2) {
        this.myAttachedSemaphore.release();
        Alarm forceTerminateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        final Runnable terminateRunnable = () -> {
            forceTerminateAlarm.cancelAllRequests();
            this.myDriverDoNotUse.getProcessHandler().destroyProcess();
            this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.disconnected", (Object[])new Object[0]);
            this.myState = detach2 ? State.DETACHED : State.FINISHED;
        };
        forceTerminateAlarm.addRequest(() -> {
            CidrDebuggerLog.LOG.warn("Cannot detach/abort. Forcing driver termination");
            terminateRunnable.run();
        }, 3000L, ModalityState.any());
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                try {
                    if (detach2) {
                        driver.detach();
                    } else {
                        driver.abort();
                    }
                }
                finally {
                    terminateRunnable.run();
                }
                driver.checkErrors();
            }

            @Override
            public void rejected(@NotNull String reason) {
                terminateRunnable.run();
            }
        });
    }

    public boolean supportsWatchpoints() {
        return this.myDriverDoNotUse.supportsWatchpoints();
    }

    public boolean supportsWatchpointLifetime() {
        return this.myDriverDoNotUse.supportsWatchpointLifetime();
    }

    public Project getProject() {
        return this.getSession().getProject();
    }

    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull CidrStackFrame frame) {
        return this.myConfiguration.createEvaluationContext(driver, expirable, frame);
    }

    public boolean driverSupportsArrayEvaluation() {
        return this.myConfiguration.supportsArrayEvaluation();
    }

    public boolean driverSupportsCodeFragmentEvaluation() {
        return this.myConfiguration.isCodeFragmentEvaluationSupported();
    }

    public boolean driverSupportsDisasm() {
        return this.myDriverDoNotUse.supportsDisasm();
    }

    public DebuggerDriver getDriverInTests() {
        return this.myDriverDoNotUse;
    }

    protected ProcessHandler doGetProcessHandler() {
        return this.myProcessHandler;
    }

    protected boolean waitForTermination() {
        return this.myDriverDoNotUse.getProcessHandler().waitFor();
    }

    boolean waitForAttach(int timeout) throws InterruptedException {
        return this.myAttachedSemaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
    }

    public final void start() {
        this.myState = State.STARTING;
        this.myBackendConsole = new LanguageConsoleImpl(this.getProject(), this.myDriverName, this.myDriverDoNotUse.getConsoleLanguage());
        this.myBackendConsole.getConsoleEditor().getDocument().putUserData(DEBUG_PROCESS_KEY, this);
        this.myBackendConsole.setEditable(false);
        this.postCommand(new DebuggerStartupCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                CidrDebugProcess.this.doStart(driver);
                List list = CidrDebugProcess.this.mySymbolFiles;
                synchronized (list) {
                    for (Couple file2 : CidrDebugProcess.this.mySymbolFiles) {
                        driver.addSymbolsFile((File)file2.first, (File)file2.second);
                    }
                    CidrDebugProcess.this.mySymbolFiles.clear();
                }
                CidrDebugProcess.this.myState = State.STARTED;
            }
        });
    }

    protected abstract void doStart(@NotNull DebuggerDriver var1) throws ExecutionException;

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        return new XDebugTabLayouter(){

            public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
                Content content = ui.createContent(CidrDebugProcess.BACKEND_CONTENT_ID, CidrDebugProcess.this.myBackendConsole.getComponent(), CidrDebugProcess.this.myDriverName, AllIcons.Debugger.ToolConsole, null);
                Disposer.register((Disposable)ui.getContentManager(), (Disposable)CidrDebugProcess.this.myBackendConsole);
                content.setCloseable(false);
                ui.addContent(content, 0, PlaceInGrid.center, false);
                for (BackendConsoleInjectionHelper helper : (BackendConsoleInjectionHelper[])BackendConsoleInjectionHelper.EP_NAME.getExtensions()) {
                    helper.subscribeToInjection(CidrDebugProcess.this.getSession());
                }
                LanguageConsoleBuilder.registerExecuteAction(CidrDebugProcess.this.myBackendConsole, (Consumer<String>)((Consumer)text -> CidrDebugProcess.this.executeConsoleCommand((String)text)), "AppCode.Debug.Console", null, null);
                CidrDebugProcess.this.getSession().addSessionListener(new XDebugSessionListener(){

                    public void sessionPaused() {
                        this.enableConsole(true);
                    }

                    public void sessionResumed() {
                        this.enableConsole(false);
                    }

                    public void sessionStopped() {
                        this.enableConsole(false);
                    }

                    private void enableConsole(final boolean enabled) {
                        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (CidrDebugProcess.this.getProject().isDisposed() || Disposer.isDisposed((Disposable)CidrDebugProcess.this.myBackendConsole)) {
                                    return;
                                }
                                CidrDebugProcess.this.myBackendConsole.setEditable(enabled);
                            }
                        });
                    }
                });
            }
        };
    }

    public boolean checkCanPerformCommands() {
        if (this.myDriverDoNotUse.isInPromptMode()) {
            this.getSession().reportMessage(CidrDebuggerBundle.message("debug.command.error.inPrompt", new Object[0]), MessageType.WARNING);
            RunnerLayoutUi ui = this.getSession().getUI();
            Content gdbContent = ui.findContent(BACKEND_CONTENT_ID);
            ui.selectAndFocus(gdbContent, true, true);
            return false;
        }
        return true;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        return this.myEditorsProvider;
    }

    @NotNull
    protected CidrBreakpointHandler createBreakpointHandler() {
        return new CidrBreakpointHandler(this);
    }

    @NotNull
    protected CidrExceptionBreakpointHandler createExceptionHandler() {
        return new CidrExceptionBreakpointHandler(this, (Class<? extends CidrExceptionBreakpointType>)CidrExceptionBreakpointType.class);
    }

    @Nullable
    private CidrSymbolicBreakpointHandler createSymbolicHandler() {
        CidrSymbolicBreakpointType symbolicBreakpointType = (CidrSymbolicBreakpointType)((Object)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CidrSymbolicBreakpointType.class));
        return symbolicBreakpointType != null ? new CidrSymbolicBreakpointHandler(this, (Class<? extends XBreakpointType<XBreakpoint<CidrSymbolicBreakpointType.Properties>, ?>>)((Object)((Object)symbolicBreakpointType)).getClass()) : null;
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        return this.myBreakpointHandlers;
    }

    @NotNull
    public ConsoleView createConsole() {
        this.myConsole.attachToProcess((ProcessHandler)this.myProcessHandler);
        return this.myConsole;
    }

    public LanguageConsoleView getDebuggerConsole() {
        return this.myBackendConsole;
    }

    public void sessionInitialized() {
        this.postCommand(new DebuggerStartupCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                if (CidrDebugProcess.this.myState != State.STARTED) {
                    return;
                }
                CidrDebugProcess.this.doLaunchTarget(driver);
                CidrDebugProcess.this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.connected", (Object[])new Object[0]);
                CidrDebugProcess.this.getSession().rebuildViews();
            }
        });
    }

    protected abstract void doLaunchTarget(@NotNull DebuggerDriver var1) throws ExecutionException;

    public void stop() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.getProject().isDisposed()) {
                return;
            }
            this.myWatchpointHandler.cleanup();
        });
        this.getProcessHandler().destroyProcess();
    }

    public void startPausing() {
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                driver.interrupt();
            }
        });
    }

    public void resume(@Nullable XSuspendContext context) {
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                driver.resume();
            }
        });
    }

    public void runToPosition(final @NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                driver.runTo(position.getFile().getPath(), position.getLine());
            }
        });
    }

    private static boolean isDisassemblyContext(@Nullable XSuspendContext context) {
        if (context == null) {
            return false;
        }
        XExecutionStack stack = context.getActiveExecutionStack();
        if (stack == null) {
            return false;
        }
        XStackFrame frame = stack.getTopFrame();
        if (!(frame instanceof CidrStackFrame)) {
            return false;
        }
        return !((CidrStackFrame)frame).hasSourceFile();
    }

    public void startStepOver(final @Nullable XSuspendContext context) {
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                driver.stepOver(CidrDebugProcess.isDisassemblyContext(context));
            }
        });
    }

    public void startStepInto(final @Nullable XSuspendContext context) {
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                driver.stepInto(CidrDebugProcess.isDisassemblyContext(context));
            }
        });
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                driver.stepOut();
            }
        });
    }

    @Nullable
    public XSourcePosition createDisasmPosition(@NotNull Address address) {
        if (!this.driverSupportsDisasm()) {
            return null;
        }
        return this.myDisassemblyView.disassemble(address);
    }

    protected void executeConsoleCommand(final @NotNull String text) {
        final long threadId = this.getCurrentThreadId();
        final int frameIndex = this.getCurrentFrameIndex();
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                try {
                    driver.executeConsoleCommand(threadId, frameIndex, text);
                }
                catch (DebuggerCommandException e) {
                    CidrDebugProcess.this.printlnToConsole(e.getMessage());
                }
            }
        });
    }

    public void postCommand(@NotNull DebuggerCommand command) {
        this.myCommandQueue.add((Object)command);
    }

    public void handleConsoleCompletion(CompletionParameters parameters2, CompletionResultSet result2) {
        int offset;
        final String command = parameters2.getOriginalFile().getText();
        Pair key2 = new Pair((Object)command, (Object)(offset = parameters2.getOffset() > 0 ? parameters2.getOffset() - 1 : 0));
        CachedValueImpl<List<String>> cachedValue = this.myCompletionCache.get(key2);
        if (cachedValue == null) {
            cachedValue = new CachedValueImpl<List<String>>(() -> {
                final ArrayList completions = new ArrayList();
                Semaphore completionSemaphore = new Semaphore(0);
                this.postCommand(new DebuggerUIUpdateCommand(){

                    @Override
                    public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                        driver.handleCompletion(command, offset, completions);
                    }
                });
                try {
                    completionSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return new CachedValueProvider.Result(completions, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }){

                @Override
                public boolean isFromMyProject(Project project2) {
                    return true;
                }
            };
        }
        this.myCompletionCache.put((Pair<String, Integer>)key2, cachedValue);
        List completions = (List)cachedValue.getValue();
        for (String str : completions) {
            result2.addElement((LookupElement)LookupElementBuilder.create((String)str));
        }
    }

    @Nullable
    public PsiElement getDebuggerContext() {
        return this.getDebuggerContext(this.getCurrentPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PsiElement getDebuggerContext(@Nullable XSourcePosition position) {
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            PsiElement psiElement = this.getTypesHelper().getContextElement(position);
            return psiElement;
        }
        finally {
            token.finish();
        }
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key2) {
        return (T)this.myUserDataHolder.getUserData(key2);
    }

    public <T> void putUserData(@NotNull Key<T> key2, @Nullable T value2) {
        this.myUserDataHolder.putUserData(key2, value2);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key2, @NotNull T value2) {
        return (T)this.myUserDataHolder.putUserDataIfAbsent(key2, value2);
    }

    public <T> boolean replace(@NotNull Key<T> key2, @Nullable T oldValue, @Nullable T newValue) {
        return this.myUserDataHolder.replace(key2, oldValue, newValue);
    }

    @NotNull
    public CidrDebuggerTypesHelper getTypesHelper() {
        return this.myTypesHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSymbolsFile(File dSYM, File module2) {
        CidrDebuggerLog.LOG.assertTrue(this.myState == State.INITIALIZED, (Object)("Session is already started: " + (Object)((Object)this.myState)));
        List<Couple<File>> list = this.mySymbolFiles;
        synchronized (list) {
            this.mySymbolFiles.add((Couple<File>)Couple.of((Object)dSYM, (Object)module2));
        }
    }

    @NotNull
    public RunParameters getRunParameters() {
        return this.myRunParameters;
    }

    protected void handleCommandException(@NotNull DebuggerDriver driver, @NotNull DebuggerCommand command, @NotNull ExecutionException exception) {
        DebuggerIllegalStateException illegalState = (DebuggerIllegalStateException)((Object)ExceptionUtil.findCause((Throwable)exception, DebuggerIllegalStateException.class));
        if (illegalState != null) {
            CidrDebuggerLog.LOG.info((Throwable)exception);
            String message2 = CidrDebuggerUtil.getExceptionMessage((Exception)((Object)illegalState));
            command.rejected(message2);
            if (!(command instanceof DebuggerUIUpdateCommand)) {
                this.getSession().reportMessage(message2, MessageType.WARNING);
            }
            return;
        }
        if (ExceptionUtil.causedBy((Throwable)exception, ExecutionFinishedException.class)) {
            if (!ExceptionUtil.causedBy((Throwable)exception, ProcessCanceledException.class)) {
                CidrDebuggerLog.LOG.debug((Throwable)exception);
            }
            this.getSession().stop();
            return;
        }
        boolean isFatalError = ExceptionUtil.causedBy((Throwable)exception, DebuggerFatalException.class);
        if (command instanceof DebuggerStartupCommand || isFatalError) {
            CidrDebuggerLog.LOG.debug((Throwable)exception);
            this.printlnToConsole(exception.getMessage());
            this.reportErrorInRedBalloon(exception);
            if (isFatalError) {
                this.myDriverDoNotUse.getProcessHandler().destroyProcess();
            } else {
                this.getSession().stop();
            }
            return;
        }
        if (!(exception instanceof ThrowInTest.TestExecutionException)) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                CidrDebuggerLog.LOG.warn((Throwable)exception);
            } else {
                CidrDebuggerLog.LOG.error((Throwable)exception);
            }
        }
    }

    private void reportErrorInRedBalloon(ExecutionException e) {
        String message2 = e.getMessage();
        if (StringUtil.isEmptyOrSpaces((String)message2)) {
            CidrDebuggerLog.LOG.error("Execution errors must have error description", (Throwable)e);
            message2 = CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e));
        }
        this.getSession().reportMessage(message2, MessageType.ERROR, (HyperlinkListener)ExceptionUtil.findCause((Throwable)e, HyperlinkListener.class));
    }

    public void printlnToConsole(@Nullable String message2) {
        if (message2 != null && !this.getProject().isDisposed()) {
            if (!StringUtil.endsWithLineBreak((CharSequence)(message2 = StringUtil.stripHtml((String)message2, (boolean)true)))) {
                message2 = message2 + "\n";
            }
            this.getProcessHandler().notifyTextAvailable(message2, ProcessOutputTypes.SYSTEM);
        }
    }

    @Nullable
    XSourcePosition getCurrentPosition() {
        XStackFrame frame = this.getSession().getCurrentStackFrame();
        return frame != null ? frame.getSourcePosition() : null;
    }

    public long getCurrentThreadId() {
        CidrStackFrame currentStackFrame = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        return currentStackFrame != null ? currentStackFrame.getThreadId() : -1L;
    }

    public int getCurrentFrameIndex() {
        CidrStackFrame currentStackFrame = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        return currentStackFrame != null ? currentStackFrame.getFrameIndex() : -1;
    }

    @Override
    public void handleRunning() {
        this.getSession().sessionResumed();
    }

    @Override
    public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
        this.getSession().positionReached((XSuspendContext)new CidrSuspendContext(stopPlace, null));
    }

    @Override
    public void handleSignal(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
        this.doHandleSignalled(stopPlace, new CidrSuspensionCause("Signal", signal + " (" + meaning + ")"));
    }

    @Override
    public void handleException(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String description) {
        this.doHandleSignalled(stopPlace, new CidrSuspensionCause("Exception", description));
    }

    private void doHandleSignalled(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull CidrSuspensionCause cause) {
        this.printlnToConsole(cause.getDisplayString());
        ((XDebugSessionImpl)this.getSession()).positionReached(new CidrSuspendContext(stopPlace, cause), true);
    }

    @Override
    public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
        Object b = this.myBreakpointHandler.getCodepoint(breakpointNumber);
        if (b == null) {
            b = this.myExceptionBreakpointHandler.getCodepoint(breakpointNumber);
        }
        if (b == null && this.mySymbolicBreakpointHandler != null) {
            b = this.mySymbolicBreakpointHandler.getCodepoint(breakpointNumber);
        }
        this.handleCodepoint(stopPlace, (XBreakpoint<?>)b);
    }

    @Override
    public void handleWatchpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int watchpointNumber) {
        Object b = this.myWatchpointHandler.getCodepoint(watchpointNumber);
        this.handleCodepoint(stopPlace, (XBreakpoint<?>)b);
    }

    @Override
    public void handleAttached(int pid) {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.attachedTo", pid));
        this.myAttachedSemaphore.release();
    }

    @Override
    public void handleConnected(@NotNull String connection) {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.connectedTo", connection));
    }

    @Override
    public void handleDetached() {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.detached", new Object[0]));
        this.getSession().stop();
    }

    @Override
    public void handleDisconnected() {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.disconnected", new Object[0]));
        this.getSession().stop();
    }

    protected void handleCodepoint(@NotNull DebuggerDriver.StopPlace stopPlace, final @Nullable XBreakpoint<?> b) {
        XBreakpointProperties props;
        CidrSuspensionCause cause = null;
        XBreakpointProperties xBreakpointProperties = props = b != null ? b.getProperties() : null;
        if (props instanceof CidrExceptionBreakpointType.Properties) {
            cause = new CidrSuspensionCause("Exception", "Exception breakpoint");
        }
        final CidrSuspendContext suspendContext = new CidrSuspendContext(stopPlace, cause);
        if (b == null) {
            ((XDebugSessionImpl)this.getSession()).positionReached(suspendContext, true);
            return;
        }
        final String expression2 = b.getLogExpression();
        if (expression2 == null) {
            boolean shouldSuspend = this.getSession().breakpointReached(b, null, (XSuspendContext)suspendContext);
            if (!shouldSuspend) {
                this.postCommand(new DebuggerCommand(){

                    @Override
                    public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                        driver.resume();
                    }
                });
            }
            return;
        }
        this.postCommand(new DebuggerCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                boolean shouldSuspend;
                String evaluatedLogExpression;
                block7: {
                    evaluatedLogExpression = null;
                    XExecutionStack executionStack = suspendContext.getActiveExecutionStack();
                    XStackFrame frame = executionStack != null ? executionStack.getTopFrame() : null;
                    XSourcePosition sourcePosition = frame != null ? frame.getSourcePosition() : null;
                    CidrEvaluator evaluator = (CidrEvaluator)(frame != null ? frame.getEvaluator() : null);
                    try {
                        if (evaluator != null) {
                            try {
                                CidrEvaluatedValue evaluatedValue = evaluator.doEvaluate(driver, sourcePosition, XExpressionImpl.fromText(expression2));
                                evaluatedLogExpression = expression2 + " = " + evaluatedValue.getConsoleDescription(evaluatedValue.createEvaluationContext(driver, null));
                            }
                            catch (DebuggerCommandException e) {
                                evaluatedLogExpression = "error evaluating " + expression2 + ": " + e.getMessage();
                            }
                            break block7;
                        }
                        evaluatedLogExpression = "error evaluating " + expression2;
                    }
                    catch (Throwable throwable) {
                        boolean shouldSuspend2 = CidrDebugProcess.this.getSession().breakpointReached(b, evaluatedLogExpression, (XSuspendContext)suspendContext);
                        if (!shouldSuspend2) {
                            driver.resume();
                        }
                        throw throwable;
                    }
                }
                if (!(shouldSuspend = CidrDebugProcess.this.getSession().breakpointReached(b, evaluatedLogExpression, (XSuspendContext)suspendContext))) {
                    driver.resume();
                }
            }
        });
    }

    @Override
    public void handleTargetOutput(@NotNull String text, @NotNull Key type2) {
        this.myProcessHandler.notifyTextAvailable(text, type2);
    }

    @Override
    public void handleGDBOutput(@NotNull String text) {
        UIUtil.invokeLaterIfNeeded(() -> this.myBackendConsole.print(text, ConsoleViewContentType.NORMAL_OUTPUT));
    }

    @Override
    public void handlePrompt(@NotNull String prompt) {
        UIUtil.invokeLaterIfNeeded(() -> {
            LanguageConsoleView backendConsole = this.myBackendConsole;
            if (this.getProject().isDisposed() || backendConsole == null || Disposer.isDisposed((Disposable)backendConsole)) {
                return;
            }
            this.getDebuggerConsole().setPrompt(prompt);
        });
    }

    @Override
    public void handleTargetFinished(int code2, @Nullable String description) {
        this.myProcessHandler.setExitCode(code2);
        if (description != null) {
            this.myProcessHandler.notifyTextAvailable(description + "\n", ProcessOutputTypes.SYSTEM);
        }
        this.getSession().stop();
    }

    @Override
    public void handleTargetTerminated() {
        this.getSession().stop();
    }

    @Override
    public void handleExited(int code2) {
        this.getSession().stop();
    }

    @Override
    public void handleWatchpointScope(int watchpointNumber) {
        UIUtil.invokeLaterIfNeeded(() -> this.myWatchpointHandler.handleWatchpointScope(watchpointNumber));
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                driver.resume();
            }
        });
    }

    @Override
    public void handleModulesLoaded(@NotNull List<String> modules) {
    }

    @Override
    public void handleBreakpointChanged(LLBreakPointBroadcast broadcast_change) {
        XLineBreakpoint breakpoint = (XLineBreakpoint)this.myBreakpointHandler.getCodepoint(broadcast_change.getId());
        if (breakpoint == null) {
            return;
        }
        LLBreakpoint lb = new LLBreakpoint(broadcast_change.getId(), breakpoint.getFileUrl(), breakpoint.getLine(), broadcast_change.getNumLocations(), broadcast_change.getNumResolvedLocations(), false, broadcast_change.getIsValid(), "", "");
        if (lb.getBreakpointValidityState() == LLBreakpoint.ValidityState.RESOLVED) {
            this.getSession().updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_verified_breakpoint, null);
        }
    }

    @NotNull
    protected XExecutionStack newExecutionStack(@NotNull LLThread thread, @Nullable LLFrame frame, boolean current, @Nullable CidrSuspensionCause cause) {
        return new CidrExecutionStack(thread, frame, current, cause);
    }

    public static boolean viewsUpdatesDisabledInTests(@NotNull Object container) {
        return ApplicationManager.getApplication().isUnitTestMode() && !container.getClass().getSimpleName().contains("XTest");
    }

    private class CidrExecutionStack
    extends XExecutionStack {
        @NotNull
        private final LLThread myThread;
        @Nullable
        private volatile CidrStackFrame myTopFrame;
        @Nullable
        private final CidrSuspensionCause mySuspensionCause;

        public CidrExecutionStack(@Nullable LLThread thread, LLFrame frame, @Nullable boolean current, CidrSuspensionCause suspensionCause) {
            super(thread.getDisplayName(), current ? AllIcons.Debugger.ThreadCurrent : AllIcons.Debugger.ThreadSuspended);
            this.myThread = thread;
            this.mySuspensionCause = suspensionCause;
            this.myTopFrame = frame == null ? null : this.newFrame(frame);
        }

        public XStackFrame getTopFrame() {
            return this.myTopFrame;
        }

        public void computeStackFrames(final int originalFrom, final XExecutionStack.XStackFrameContainer container) {
            if (CidrDebugProcess.viewsUpdatesDisabledInTests(container)) {
                return;
            }
            CidrDebugProcess.this.postCommand(new DebuggerUIUpdateCommand(){

                @Override
                public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                    try {
                        boolean hasMore;
                        boolean repeat;
                        if (container.isObsolete()) {
                            return;
                        }
                        ThrowInTest.doThrow((UserDataHolder)CidrDebugProcess.this, THROW_ON_FRAME_COLLECTION);
                        ArrayList<CidrStackFrame> result2 = new ArrayList<CidrStackFrame>();
                        CidrStackFrame toSelect = null;
                        int currentFrom = originalFrom;
                        int currentBatchSize = 100;
                        do {
                            if (container.isObsolete()) {
                                return;
                            }
                            repeat = false;
                            DebuggerDriver.ResultList<LLFrame> framesResult = driver.getFrames(CidrExecutionStack.this.myThread.getId(), currentFrom, currentBatchSize, currentFrom == 0);
                            CidrStackFrame top = CidrExecutionStack.this.myTopFrame;
                            result2.ensureCapacity(result2.size() + framesResult.list.size());
                            for (int i2 = 0; i2 < framesResult.list.size(); ++i2) {
                                if (container.isObsolete()) {
                                    return;
                                }
                                CidrStackFrame frame = currentFrom == 0 && i2 == 0 ? (top != null ? top : (top = (CidrExecutionStack.this.myTopFrame = CidrExecutionStack.this.newFrame((LLFrame)framesResult.list.get(i2))))) : CidrExecutionStack.this.newFrame((LLFrame)framesResult.list.get(i2));
                                result2.add(frame);
                            }
                            hasMore = framesResult.hasMore;
                            if (originalFrom != 0 || top == null || top.hasSourceFile() || CidrExecutionStack.this.shouldSelectDisasmFrame() || (toSelect = (CidrStackFrame)result2.stream().filter(CidrStackFrame::hasSourceFile).findFirst().orElse(null)) != null || !hasMore || framesResult.list.size() >= currentBatchSize) continue;
                            currentFrom = framesResult.list.size();
                            currentBatchSize -= currentFrom;
                            repeat = true;
                        } while (repeat);
                        ((XStackFrameContainerEx)container).addStackFrames(result2, toSelect, !hasMore);
                        if (hasMore && !container.isObsolete()) {
                            CidrExecutionStack.this.computeStackFrames(currentFrom + result2.size(), container);
                        }
                    }
                    catch (DebuggerCommandException e) {
                        container.errorOccurred(e.getMessage());
                    }
                    catch (ExecutionException e) {
                        container.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                        throw e;
                    }
                }
            });
        }

        private boolean shouldSelectDisasmFrame() {
            if (!CidrDebugProcess.this.driverSupportsDisasm()) {
                return false;
            }
            return this.mySuspensionCause == null;
        }

        @NotNull
        private CidrStackFrame newFrame(@NotNull LLFrame frame) {
            return new CidrStackFrame(CidrDebugProcess.this, this.myThread, frame, this.mySuspensionCause);
        }

        @Nullable
        public GutterIconRenderer getExecutionLineIconRenderer() {
            if (this.mySuspensionCause == null) {
                return super.getExecutionLineIconRenderer();
            }
            return new GutterIconRenderer(){

                @NotNull
                public Icon getIcon() {
                    return ((CidrExecutionStack)CidrExecutionStack.this).mySuspensionCause.icon;
                }

                @Nullable
                public String getTooltipText() {
                    return CidrExecutionStack.this.mySuspensionCause.getDisplayString();
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                        return false;
                    }
                    return Comparing.equal((Object)CidrExecutionStack.this.mySuspensionCause, (Object)((CidrExecutionStack)((Object)o)).mySuspensionCause);
                }

                public int hashCode() {
                    return CidrExecutionStack.this.mySuspensionCause.hashCode();
                }

                public boolean isDumbAware() {
                    return true;
                }
            };
        }

        public String toString() {
            return this.myThread.toString();
        }
    }

    private class CidrSuspendContext
    extends XSuspendContext {
        @NotNull
        private final XExecutionStack myActiveStack;
        private final long myActiveStackFrameId;

        public CidrSuspendContext(@Nullable DebuggerDriver.StopPlace stopPlace, CidrSuspensionCause cause) {
            this.myActiveStack = CidrDebugProcess.this.newExecutionStack(stopPlace.thread, stopPlace.frame, true, cause);
            this.myActiveStackFrameId = stopPlace.thread.getId();
        }

        @Nullable
        public XExecutionStack getActiveExecutionStack() {
            return this.myActiveStack;
        }

        public void computeExecutionStacks(final XSuspendContext.XExecutionStackContainer container) {
            if (CidrDebugProcess.viewsUpdatesDisabledInTests(container)) {
                return;
            }
            CidrDebugProcess.this.postCommand(new DebuggerUIUpdateCommand(){

                @Override
                public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                    try {
                        ThrowInTest.doThrow((UserDataHolder)CidrDebugProcess.this, THROW_ON_THREAD_COLLECTION);
                        List<LLThread> threads = driver.getThreads();
                        ArrayList<XExecutionStack> stacks2 = new ArrayList<XExecutionStack>(threads.size());
                        for (LLThread each : threads) {
                            stacks2.add(each.getId() == CidrSuspendContext.this.myActiveStackFrameId ? CidrSuspendContext.this.myActiveStack : CidrDebugProcess.this.newExecutionStack(each, null, false, null));
                        }
                        container.addExecutionStack(stacks2, true);
                    }
                    catch (DebuggerCommandException e) {
                        container.errorOccurred(e.getMessage());
                    }
                    catch (ExecutionException e) {
                        container.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                        throw e;
                    }
                }
            });
        }
    }

    private class MyCommandProcessor
    implements Consumer<DebuggerCommand> {
        private MyCommandProcessor() {
        }

        public void consume(DebuggerCommand c) {
            ProcessHandler driverHandler = CidrDebugProcess.this.myDriverDoNotUse.getProcessHandler();
            if (driverHandler.isProcessTerminating() || driverHandler.isProcessTerminated()) {
                c.rejected("Process finished");
                return;
            }
            try {
                c.run(CidrDebugProcess.this.myDriverDoNotUse);
            }
            catch (ExpiredException expiredException) {
            }
            catch (ExecutionException e) {
                CidrDebugProcess.this.handleCommandException(CidrDebugProcess.this.myDriverDoNotUse, c, e);
            }
        }
    }

    private class MyProcessHandler
    extends ProcessHandler
    implements AnsiEscapeDecoder.ColoredTextAcceptor {
        private final AtomicReference<Integer> myExitCode = new AtomicReference();
        private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();

        private MyProcessHandler() {
        }

        public void setExitCode(int exitCode) {
            this.myExitCode.set(exitCode);
        }

        @NotNull
        public Integer getExitCode() {
            Integer exitCode = this.myExitCode.get();
            return exitCode == null ? 0 : exitCode;
        }

        protected void destroyProcessImpl() {
            this.doDestroyOrDetach(false);
        }

        protected void detachProcessImpl() {
            this.doDestroyOrDetach(true);
        }

        private void doDestroyOrDetach(boolean detach2) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (CidrDebugProcess.this.waitForTermination()) {
                    if (detach2) {
                        this.notifyProcessDetached();
                    } else {
                        this.notifyProcessTerminated(this.getExitCode());
                    }
                }
            });
        }

        public boolean detachIsDefault() {
            return CidrDebugProcess.this.isDetachDefault();
        }

        public OutputStream getProcessInput() {
            return CidrDebugProcess.this.myDriverDoNotUse.getProcessInput();
        }

        public final void notifyTextAvailable(String text, Key outputType) {
            this.myAnsiEscapeDecoder.escapeText(text, outputType, (AnsiEscapeDecoder.ColoredTextAcceptor)this);
        }

        public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
            super.notifyTextAvailable(text, attributes);
        }
    }

    public static abstract class DebuggerUIUpdateCommand
    extends DebuggerCommand {
    }

    public static abstract class DebuggerStartupCommand
    extends DebuggerCommand {
    }

    public static abstract class DebuggerCommand {
        public abstract void run(@NotNull DebuggerDriver var1) throws ExecutionException;

        public void rejected(@NotNull String reason) {
        }
    }

    static enum State {
        INITIALIZED,
        STARTING,
        STARTED,
        FINISHED,
        DETACHED;

    }
}

