/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.CidrPathManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDebuggerPathManager {
    @NotNull
    public static File getLLDBBinFile(@NotNull String relativePath) {
        if (CidrDebuggerPathManager.isFromSources()) {
            String selector2 = SystemInfo.isWindows ? "win/" : (SystemInfo.isMac ? "mac/" : "linux/");
            return new File(new File(CidrPathManager.getCidrRootPath(), "cidr-debugger/bin/lldb/" + selector2), relativePath);
        }
        return new File(PathManager.getBinPath(), "lldb/" + relativePath);
    }

    @NotNull
    public static File getBundledLLDBSTLPrettyPrinters() {
        if (CidrDebuggerPathManager.isFromSources()) {
            return new File(CidrPathManager.getCidrRootPath(), "cidr-debugger/bin/lldb/renderers");
        }
        return new File(PathManager.getBinPath(), "lldb/renderers");
    }

    @NotNull
    public static File getBundledGDBBinary() {
        return CidrDebuggerPathManager.getBundledGDBFile(SystemInfo.isWindows ? "bin/gdb.exe" : "bin/gdb");
    }

    @NotNull
    public static File getBundledGDBFile(@NotNull String relativePath) {
        if (CidrDebuggerPathManager.isFromSources()) {
            String selector2 = SystemInfo.isWindows ? "win/" : (SystemInfo.isMac ? "mac/" : "linux/");
            return new File(new File(CidrPathManager.getCidrRootPath(), "cidr-debugger/bin/gdb/" + selector2 + "/"), relativePath);
        }
        return new File(PathManager.getBinPath(), "gdb/" + relativePath);
    }

    @NotNull
    public static File getWinbreakFile(@NotNull String name) {
        if (CidrDebuggerPathManager.isFromSources()) {
            return new File(new File(CidrPathManager.getCidrRootPath(), "cidr-debugger/bin/gdb/"), name);
        }
        return new File(PathManager.getBinPath(), "gdb/" + name);
    }

    @NotNull
    public static File getBundledGDBSTLPrettyPrinters() {
        if (CidrDebuggerPathManager.isFromSources()) {
            return new File(CidrPathManager.getCidrRootPath(), "cidr-debugger/bin/gdb/renderers");
        }
        return new File(PathManager.getBinPath(), "gdb/renderers");
    }

    @Nullable
    public static File getOSXSystemPythonBinDir() {
        File pythonBinDir = new File("/System/Library/Frameworks/Python.framework/Versions/Current/bin");
        if (pythonBinDir.exists() && pythonBinDir.isDirectory()) {
            return pythonBinDir;
        }
        return null;
    }

    private static boolean isFromSources() {
        return ApplicationImpl.isRunningFromSources();
    }
}

