/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CidrDebuggerSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final boolean PRESENT_AS_OBJC = PlatformUtils.isAppCode() || PlatformUtils.isRubyMine();
    @NotNull
    private final CidrDebuggerSettings mySetting;
    private JPanel myPanel;
    private JCheckBox myEnableRenderersCheckBox;
    private JCheckBox myEnableCocoaRenderersCheckBox;
    private JCheckBox myEnableCoreDataRenderersCheckBox;
    private JCheckBox myEnableGNUSTLRenderersCheckBox;
    private JBLabel myEnableGNUSTLRenderersDescriptionLabel;
    private JCheckBox myHideValuesOutOfScopeCheckBox;

    public CidrDebuggerSettingsConfigurable(@NotNull CidrDebuggerSettings setting) {
        this.mySetting = setting;
        this.$$$setupUI$$$();
        ItemListener listener2 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CidrDebuggerSettingsConfigurable.this.updateControls();
            }
        };
        this.myEnableRenderersCheckBox.addItemListener(listener2);
        this.myEnableCocoaRenderersCheckBox.addItemListener(listener2);
        if (PRESENT_AS_OBJC) {
            this.myEnableGNUSTLRenderersCheckBox.setVisible(false);
            this.myEnableGNUSTLRenderersDescriptionLabel.setVisible(false);
        } else {
            this.myEnableRenderersCheckBox.setVisible(false);
            this.myEnableCocoaRenderersCheckBox.setVisible(false);
            this.myEnableCoreDataRenderersCheckBox.setVisible(false);
        }
    }

    private void updateControls() {
        boolean allEnabled = this.myEnableRenderersCheckBox.isSelected();
        boolean cocoaEnabled = allEnabled && this.myEnableCocoaRenderersCheckBox.isSelected();
        this.myEnableCocoaRenderersCheckBox.setEnabled(allEnabled);
        this.myEnableCoreDataRenderersCheckBox.setEnabled(cocoaEnabled);
    }

    @NotNull
    public String getId() {
        return "Debugger.ObjectiveC";
    }

    @Nls
    public String getDisplayName() {
        return PRESENT_AS_OBJC ? "Objective-C" : "C/C++";
    }

    public String getHelpTopic() {
        return PRESENT_AS_OBJC ? "reference.idesettings.debugger.objectivec" : "reference.idesettings.debugger.cpp";
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return this.mySetting.RENDERERS_ENABLED != this.myEnableRenderersCheckBox.isSelected() || this.mySetting.COCOA_RENDERERS_ENABLED != this.myEnableCocoaRenderersCheckBox.isSelected() || this.mySetting.CORE_DATA_RENDERERS_ENABLED != this.myEnableCoreDataRenderersCheckBox.isSelected() || this.mySetting.STL_RENDERERS_ENABLED != this.myEnableGNUSTLRenderersCheckBox.isSelected() || this.mySetting.VALUES_FILTER_ENABLED != this.myHideValuesOutOfScopeCheckBox.isSelected();
    }

    public void apply() throws ConfigurationException {
        this.mySetting.RENDERERS_ENABLED = this.myEnableRenderersCheckBox.isSelected();
        this.mySetting.COCOA_RENDERERS_ENABLED = this.myEnableCocoaRenderersCheckBox.isSelected();
        this.mySetting.CORE_DATA_RENDERERS_ENABLED = this.myEnableCoreDataRenderersCheckBox.isSelected();
        this.mySetting.STL_RENDERERS_ENABLED = this.myEnableGNUSTLRenderersCheckBox.isSelected();
        this.mySetting.VALUES_FILTER_ENABLED = this.myHideValuesOutOfScopeCheckBox.isSelected();
    }

    public void reset() {
        this.myEnableRenderersCheckBox.setSelected(this.mySetting.RENDERERS_ENABLED);
        this.myEnableCocoaRenderersCheckBox.setSelected(this.mySetting.COCOA_RENDERERS_ENABLED);
        this.myEnableCoreDataRenderersCheckBox.setSelected(this.mySetting.CORE_DATA_RENDERERS_ENABLED);
        this.myEnableGNUSTLRenderersCheckBox.setSelected(this.mySetting.STL_RENDERERS_ENABLED);
        this.myHideValuesOutOfScopeCheckBox.setSelected(this.mySetting.VALUES_FILTER_ENABLED);
        this.updateControls();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myHideValuesOutOfScopeCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("CidrDebuggerBundle").getString("debug.settings.enableValuesFilter.checkbox"));
        jPanel.add((Component)jCheckBox4, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 8, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 4, 1, 0, 3, 3, 3, null, null, null));
        this.myEnableRenderersCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("CidrDebuggerBundle").getString("debug.settings.enableValueRenderers.checkbox"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEnableCocoaRenderersCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("CidrDebuggerBundle").getString("debug.settings.enableCocoaRenderers.checkbox"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null, 2));
        this.myEnableGNUSTLRenderersCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("CidrDebuggerBundle").getString("debug.settings.enableGNUSTLRenderers.checkbox"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBCheckBox jBCheckBox = new JBCheckBox();
        this.myEnableCoreDataRenderersCheckBox = jBCheckBox;
        jBCheckBox.setText("Core Data renderers");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 4));
        this.myEnableGNUSTLRenderersDescriptionLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("CidrDebuggerBundle").getString("debug.settings.enableGNUSTLRenderers.checkbox.description"));
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel2.add((Component)jBLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Variables");
        jPanel2.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("CidrDebuggerBundle").getString("debug.settings.enableValuesFilter.checkbox.hint"));
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel.add((Component)jBLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

