/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportFactory;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrStackFrame
extends XStackFrame
implements UserDataHolderEx {
    @NotNull
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final LLThread myThread;
    @NotNull
    private final LLFrame myFrame;
    @Nullable
    private final CidrSuspensionCause mySuspensionCause;
    public static final Key THROW_ON_VARIABLES_COLLECTION = Key.create((String)"THROW_ON_VARIABLES_COLLECTION");
    @NotNull
    private final NotNullLazyValue<Pair<XSourcePosition, Boolean>> mySourceOrDisasmLazyValue = NotNullLazyValue.createValue(this::doGetSourceOrDisasm);

    public CidrStackFrame(@NotNull CidrDebugProcess process2, @NotNull LLThread thread, @NotNull LLFrame frame, @Nullable CidrSuspensionCause suspensionCause) {
        this.myProcess = process2;
        this.myThread = thread;
        this.myFrame = frame;
        this.mySuspensionCause = suspensionCause;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key2) {
        return (T)this.myUserDataHolder.getUserData(key2);
    }

    public <T> void putUserData(@NotNull Key<T> key2, @Nullable T value2) {
        this.myUserDataHolder.putUserData(key2, value2);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key2, @NotNull T value2) {
        return (T)this.myUserDataHolder.putUserDataIfAbsent(key2, value2);
    }

    public <T> boolean replace(@NotNull Key<T> key2, @Nullable T oldValue, @Nullable T newValue) {
        return this.myUserDataHolder.replace(key2, oldValue, newValue);
    }

    @NotNull
    public CidrDebugProcess getProcess() {
        return this.myProcess;
    }

    public long getThreadId() {
        return this.myThread.getId();
    }

    @NotNull
    public LLFrame getFrame() {
        return this.myFrame;
    }

    public int getFrameIndex() {
        return this.myFrame.getIndex();
    }

    public Object getEqualityObject() {
        return Pair.create((Object)this.myThread.getId(), (Object)this.myFrame.getIndex());
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.getSourcePosition(true);
    }

    @Nullable
    public XSourcePosition getSourcePosition(boolean disassembleIfNeeded) {
        Pair sourceOrDisasm = (Pair)this.mySourceOrDisasmLazyValue.getValue();
        return disassembleIfNeeded || (Boolean)sourceOrDisasm.second != false ? (XSourcePosition)sourceOrDisasm.first : null;
    }

    public boolean hasSourceFile() {
        return this.getSourcePosition(false) != null;
    }

    @NotNull
    protected Pair<XSourcePosition, Boolean> doGetSourceOrDisasm() {
        XSourcePosition sourcePosition;
        VirtualFile resolvedFile = this.resolveFile();
        if (resolvedFile != null && (sourcePosition = XDebuggerUtil.getInstance().createPosition(resolvedFile, this.myFrame.getLine())) != null) {
            return Pair.create((Object)sourcePosition, (Object)true);
        }
        return Pair.create((Object)this.myProcess.createDisasmPosition(this.myFrame.getProgramCounter()), (Object)false);
    }

    @Nullable
    private VirtualFile resolveFile() {
        String file2 = this.myFrame.getFile();
        return file2 == null ? null : (VirtualFile)ApplicationManager.getApplication().runReadAction(() -> {
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(file2);
            if (vFile == null) {
                return null;
            }
            VirtualFile resolvedFile = ProjectRootUtil.findSymlinkedFileInContent(this.myProcess.getProject(), vFile);
            if (CidrDebuggerLog.LOG.isTraceEnabled() && !vFile.equals(resolvedFile)) {
                CidrDebuggerLog.LOG.trace("Debugger path resolved: " + vFile + " -> " + resolvedFile);
            }
            return resolvedFile;
        });
    }

    @Nullable
    public PsiElement getContext() {
        return (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> this.myProcess.getTypesHelper().getContextElement(this.getSourcePosition(false))));
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        component.setIcon(AllIcons.Debugger.StackFrame);
        XSourcePosition position = this.getSourcePosition(false);
        if (position != null) {
            component.append(this.myFrame.getFunction(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component.append(" " + position.getFile().getName() + ":" + (position.getLine() + 1), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        } else {
            component.append(this.myFrame.getFunction(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            component.append(" " + this.myFrame.getProgramCounter(), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
    }

    public final void computeChildren(final @NotNull XCompositeNode node) {
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(node)) {
            return;
        }
        this.myProcess.postCommand(new CidrDebugProcess.DebuggerUIUpdateCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                try {
                    CidrStackFrame.this.doComputeChildren(driver, node);
                }
                catch (DebuggerCommandException e) {
                    node.setErrorMessage(e.getMessage());
                }
                catch (ExecutionException e) {
                    node.setErrorMessage(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                    throw e;
                }
            }
        });
    }

    private void doComputeChildren(@NotNull DebuggerDriver driver, @NotNull XCompositeNode node) throws DebuggerCommandException, ExecutionException {
        if (node.isObsolete()) {
            return;
        }
        if (this.mySuspensionCause != null) {
            XValueChildrenList list = new XValueChildrenList(1);
            list.add(new XNamedValue(this.mySuspensionCause.type){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    node.setPresentation(((CidrStackFrame)CidrStackFrame.this).mySuspensionCause.icon, null, ((CidrStackFrame)CidrStackFrame.this).mySuspensionCause.reason, false);
                }
            });
            node.addChildren(list, false);
        }
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_VARIABLES_COLLECTION);
        XSourcePosition framePosition = this.getSourcePosition(false);
        driver.setValuesFilteringEnabled(CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED);
        List<LLValue> vars = this.myFrame.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT ? ((LLDBDriver)driver).getVariables(this.myThread.getId(), this.myFrame.getIndex(), true, false) : driver.getVariables(this.myThread.getId(), this.myFrame.getIndex());
        vars = ContainerUtil.filter(vars, value2 -> {
            if (framePosition == null) {
                value2.setValid(false);
                return true;
            }
            boolean[] resolved = new boolean[1];
            boolean[] special = new boolean[]{false};
            Integer variableLine = (Integer)ApplicationManager.getApplication().runReadAction(() -> {
                PsiElement declarator = this.myProcess.getTypesHelper().resolveToDeclaration(framePosition, (LLValue)((Object)value2));
                boolean bl = resolved[0] = declarator != null;
                if (declarator == null) {
                    Boolean thisSelfSupper = this.myProcess.getTypesHelper().isImplicitContextVariable(framePosition, (LLValue)((Object)value2));
                    special[0] = thisSelfSupper != null ? thisSelfSupper : false;
                    return null;
                }
                PsiFile targetFile = declarator.getContainingFile();
                if (!Comparing.equal((Object)targetFile.getVirtualFile(), (Object)framePosition.getFile())) {
                    return null;
                }
                int endOffset = declarator.getTextRange().getEndOffset();
                Document document = PsiDocumentManager.getInstance((Project)targetFile.getProject()).getDocument(targetFile);
                if (document == null) {
                    return null;
                }
                return document.getLineNumber(endOffset);
            });
            value2.setValid(special[0] || resolved[0] && variableLine != null && variableLine < framePosition.getLine());
            return !CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED || resolved[0] || special[0];
        });
        CidrValue.addLocalValues((Collection<LLValue>)vars, this.myProcess, framePosition, this, node);
    }

    public CidrEvaluator getEvaluator() {
        for (CidrDebuggerLanguageSupportFactory factory : (CidrDebuggerLanguageSupportFactory[])CidrDebuggerLanguageSupportFactory.EP_NAME.getExtensions()) {
            CidrEvaluator evaluator = factory.createEvaluator(this);
            if (evaluator == null) continue;
            return evaluator;
        }
        return null;
    }

    public String toString() {
        return this.myFrame.toString();
    }
}

