/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointType;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrWatchpointUtil {
    @Nullable
    public static XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> addWatchpoint(XValue valueContainer, LLWatchpoint.AccessType accessType, LLWatchpoint.Lifetime lifetime) {
        if (!(valueContainer instanceof CidrPhysicalValue)) {
            return null;
        }
        CidrPhysicalValue value2 = (CidrPhysicalValue)valueContainer;
        CidrDebugProcess process2 = ((CidrPhysicalValue)valueContainer).getProcess();
        CidrWatchpointType.CidrWatchpointProperties properties = new CidrWatchpointType.CidrWatchpointProperties();
        properties.setDebugProcess(process2);
        properties.setOriginalPosition(process2.getSession().getCurrentPosition());
        properties.setAccessType(accessType);
        properties.setLLValue(value2.getVar());
        properties.setExpr(value2.getEvaluationExpression());
        properties.setLifetime(process2.supportsWatchpointLifetime() ? lifetime : null);
        return CidrWatchpointUtil.addWatchpoint(process2.getProject(), properties);
    }

    public static XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> addWatchpoint(@NotNull Project project2, final @Nullable CidrWatchpointType.CidrWatchpointProperties properties) {
        final XDebuggerManager debuggerManager = XDebuggerManager.getInstance((Project)project2);
        return (XBreakpoint)new WriteAction<XBreakpoint<CidrWatchpointType.CidrWatchpointProperties>>(){

            protected void run(@NotNull Result<XBreakpoint<CidrWatchpointType.CidrWatchpointProperties>> res) throws Throwable {
                CidrWatchpointType type2 = (CidrWatchpointType)((Object)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CidrWatchpointType.class));
                res.setResult((Object)debuggerManager.getBreakpointManager().addBreakpoint((XBreakpointType)type2, (XBreakpointProperties)properties));
            }
        }.execute().getResultObject();
    }

    public static void showWatchpointEditor(XValueNodeImpl node, XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> breakpoint, Project project2) {
        XDebuggerTree tree = node.getTree();
        Rectangle bounds = tree.getRowBounds(tree.getSelectionRows()[0]);
        DebuggerUIUtil.showXBreakpointEditorBalloon(project2, new Point((int)bounds.getCenterX(), (int)bounds.getCenterY()), (JComponent)((Object)tree), false, breakpoint);
    }
}

