/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.ContextFreeResolveUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDebuggerTypesHelper
extends CidrDebuggerTypesHelper {
    public OCDebuggerTypesHelper(CidrDebugProcess process2) {
        super(process2);
    }

    @Override
    public PsiElement resolveToDeclaration(XSourcePosition position, LLValue var) {
        PsiElement context = this.getContextElement(position);
        if (context == null) {
            return null;
        }
        OCReference ref = this.createReferenceFromText(var, context);
        if (ref == null) {
            return null;
        }
        PsiElement resolved = ref.resolve();
        if (resolved == null) {
            return null;
        }
        if (resolved.getContainingFile() == ((PsiElement)ref).getContainingFile()) {
            return null;
        }
        return resolved;
    }

    @Nullable
    protected OCReference createReferenceFromText(@NotNull LLValue var, @NotNull PsiElement context) {
        return context.getLanguage() == OCLanguage.getInstance() ? OCElementFactory.referenceElementFromText(var.getName(), context, false) : null;
    }

    @Override
    @Nullable
    public Boolean isImplicitContextVariable(@NotNull XSourcePosition position, @NotNull LLValue var) {
        PsiElement context = this.getContextElement(position);
        if (context == null) {
            return null;
        }
        return OCThisSelfSuperSymbol.tryResolveThisSelfSuper(var.getName(), context, new OCResolveContext(context)) != null;
    }

    @Nullable
    protected OCType resolveType(CidrPhysicalValue value2, Class ... klass) {
        XSourcePosition pos = value2.getSourcePosition();
        if (pos == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProcess.getProject()).findFile(pos.getFile());
        String type2 = value2.getVar().getType();
        return this.doResolveType(pos, type2, psiFile, klass);
    }

    @Nullable
    public OCType resolveTypeInRA(final CidrPhysicalValue value2, final Class ... klasses) {
        return (OCType)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<OCType>(){

            public OCType compute() {
                if (OCDebuggerTypesHelper.this.myProcess.getProject().isDisposed()) {
                    return null;
                }
                return OCDebuggerTypesHelper.this.resolveType(value2, klasses);
            }
        });
    }

    @Nullable
    private OCType doResolveType(@NotNull XSourcePosition pos, @NotNull String typeName, PsiFile psiFile, Class ... klass) {
        PsiElement element = this.getContextElement(pos);
        return OCDebuggerTypesHelper.doResolveType(typeName, psiFile, element, klass);
    }

    @Nullable
    private static OCType doResolveType(@NotNull String typeName, PsiFile psiFile, PsiElement context, Class ... klass) {
        if (context == null) {
            return null;
        }
        OCTypeElement exp = OCElementFactory.typeElementFromTextOrNull(typeName, context, false);
        if (exp == null) {
            return null;
        }
        OCType expType = exp.getType();
        OCType resolved = expType.resolve(psiFile);
        if (resolved instanceof OCReferenceType) {
            OCReferenceType referenceType = (OCReferenceType)resolved;
            List<OCSymbol> symbols = referenceType.getReference(psiFile).resolveToSymbols(psiFile);
            for (OCSymbol symbol : symbols) {
                OCSymbol definitionSymbol = symbol.getDefinitionSymbol();
                if (definitionSymbol == null || !OCDebuggerTypesHelper.isInstanceOf(definitionSymbol.getResolvedType(), klass)) continue;
                return definitionSymbol.getResolvedType();
            }
            for (OCSymbol symbol : symbols) {
                OCType type2 = symbol.getResolvedType();
                if (type2 == null || !OCDebuggerTypesHelper.isInstanceOf(type2, klass)) continue;
                return type2;
            }
        } else if (OCDebuggerTypesHelper.isInstanceOf(resolved, klass)) {
            return resolved;
        }
        return null;
    }

    private static boolean isInstanceOf(OCType type2, Class[] klass) {
        for (Class each : klass) {
            if (!each.isInstance(type2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCPPThisPsi(CidrPhysicalValue value2) {
        if (!value2.getVar().getName().equals("this")) {
            return false;
        }
        Project project2 = this.myProcess.getProject();
        XSourcePosition position = value2.getSourcePosition();
        if (position == null) {
            return true;
        }
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        boolean result2 = false;
        try {
            PsiFile file2 = PsiManager.getInstance((Project)project2).findFile(position.getFile());
            if (file2 instanceof OCFile) {
                result2 = ((OCFile)file2).isCpp();
            }
        }
        finally {
            token.finish();
        }
        return result2;
    }

    @Override
    public boolean isCStringType(CidrPhysicalValue value2) {
        OCType pointerType = this.resolveTypeInRA(value2, OCPointerType.class);
        return pointerType != null && pointerType.isCString();
    }

    @Override
    public XSourcePosition computeSourcePosition(CidrMemberValue value2) {
        OCDeclaratorSymbol field;
        OCType type2 = this.resolveType(value2.getParent(), OCPointerType.class, OCStructType.class, OCReferenceType.class, OCObjectType.class);
        if (type2 == null) {
            return null;
        }
        OCType terminalType = type2.getTerminalType();
        if (terminalType instanceof OCObjectType) {
            OCInstanceVariableSymbol var = ((OCObjectType)terminalType).findMember(value2.getVar().getName(), OCInstanceVariableSymbol.class);
            if (var != null) {
                return XDebuggerUtil.getInstance().createPositionByOffset(var.getContainingFile(), var.getOffset());
            }
        } else if (terminalType instanceof OCStructType && (field = ((OCStructType)terminalType).findField(value2.getVar().getName())) != null) {
            return XDebuggerUtil.getInstance().createPositionByOffset(field.getContainingFile(), field.getOffset());
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement getContextElement(@Nullable XSourcePosition sourcePosition) {
        return OCDebuggerTypesHelper.getContextElement(sourcePosition, this.myProcess.getProject());
    }

    @Override
    @Nullable
    public XSourcePosition resolveProperty(@NotNull CidrMemberValue value2, @Nullable String dynamicTypeName) {
        OCMemberSymbol symbol = ContextFreeResolveUtil.resolveToProperty(dynamicTypeName, value2.getName(), this.myProcess.getProject());
        if (symbol == null) {
            return null;
        }
        return XDebuggerUtil.getInstance().createPositionByOffset(symbol.getContainingFile(), symbol.getOffset());
    }

    public static PsiElement getContextElement(XSourcePosition sourcePosition, Project project2) {
        PsiElement result2 = OCDebuggerTypesHelper.getDefaultContextElement(sourcePosition, project2);
        if (result2 != null && result2.getParent() instanceof OCForStatement) {
            result2 = ((OCForStatement)result2.getParent()).getInitializer();
        }
        return result2;
    }
}

