/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCProtocolExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCEvaluatorHelper
extends CidrEvaluatorHelper {
    @NotNull
    private static Pair<OCType, String> convertExpressionPrivate(CidrDebugProcess process2, String originalExpression, @Nullable XSourcePosition position) throws CidrEvaluatorHelper.ConversionException {
        String text;
        PsiFile psiFile;
        OCExpression expression2;
        OCType resolvedType = null;
        if (position == null) {
            throw new CidrEvaluatorHelper.ConversionException(CidrBundle.message("debug.evaluate.error.noExecutionPoint", new Object[0]));
        }
        PsiElement context = process2.getTypesHelper().getContextElement(position);
        if (context == null) {
            throw new CidrEvaluatorHelper.ConversionException(CidrBundle.message("debug.evaluate.error.debugInfoIsOutdated", new Object[0]));
        }
        OCFile fragment = OCElementFactory.expressionCodeFragment(originalExpression, context.getProject(), context, false, false);
        if (PsiTreeUtil.hasErrorElements((PsiElement)fragment.getContainingFile())) {
            fragment = OCElementFactory.expressionCodeFragmentCpp(originalExpression, context.getProject(), context, false, false);
        }
        if ((expression2 = (OCExpression)PsiTreeUtil.findChildOfType((PsiElement)(fragment = OCEvaluatorHelper.preConvertExpression(fragment)), OCExpression.class)) != null && !(expression2 instanceof OCCastExpression) && (psiFile = PsiManager.getInstance((Project)process2.getProject()).findFile(position.getFile())) != null) {
            Language language = psiFile.getLanguage();
            if (language != OCLanguage.getInstance()) {
                throw new CidrEvaluatorHelper.ConversionException(CidrBundle.message("debug.evaluate.error.cannotEvaluateExpressionForLanguage", language.getDisplayName()));
            }
            resolvedType = expression2.getType().resolve(psiFile);
        }
        if ((text = (fragment = OCEvaluatorHelper.postConvertExpression(fragment)).getText()) == null) {
            CidrDebuggerLog.LOG.error("Fragment text is 'null'" + fragment + "\noriginal expression: " + originalExpression);
            throw new CidrEvaluatorHelper.ConversionException(CidrBundle.message("debug.evaluate.error.invalidExpression", new Object[0]));
        }
        return Pair.create(resolvedType, (Object)text);
    }

    @NotNull
    private static OCFile preConvertExpression(@NotNull OCFile original) throws CidrEvaluatorHelper.ConversionException {
        OCMacroCall macro;
        LinkedHashSet<String> recursionGuard = new LinkedHashSet<String>();
        while ((macro = (OCMacroCall)PsiTreeUtil.findChildOfType((PsiElement)original, OCMacroCall.class)) != null) {
            String replacement = macro.getReplacementText();
            TextRange range = macro.getTextRange();
            String originalText = original.getText();
            if (!recursionGuard.add(originalText) || recursionGuard.size() > 1000) {
                CidrDebuggerLog.LOG.info("Cannot expands macros. Recursion guard (" + recursionGuard.size() + "):\n" + StringUtil.join(recursionGuard, (String)"\n"));
                throw new CidrEvaluatorHelper.ConversionException(CidrBundle.message("debug.evaluate.error.cannotSubstituteMacros", new Object[0]));
            }
            String newText = StringUtil.replaceSubstring((String)originalText, (TextRange)range, (String)replacement);
            original = OCElementFactory.expressionCodeFragment(newText, original.getProject(), original.getContext(), false, false);
        }
        original.accept(new PreConverter());
        return original;
    }

    @NotNull
    private static OCFile postConvertExpression(@NotNull OCFile original) throws CidrEvaluatorHelper.ConversionException {
        original.accept(new PostConverter());
        return original;
    }

    @Override
    public String convertExpression(@NotNull CidrDebugProcess process2, String originalExpression, @Nullable XSourcePosition position) throws CidrEvaluatorHelper.ConversionException {
        return (String)OCEvaluatorHelper.convertExpressionPrivate((CidrDebugProcess)process2, (String)originalExpression, (XSourcePosition)position).second;
    }

    @Override
    public Pair<LLValue, String> convertAndEvaluate(final @NotNull CidrDebugProcess process2, @NotNull DebuggerDriver driver, final @NotNull XExpression expression2, final @Nullable XSourcePosition sourcePosition, long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        final Ref convertedExpression = new Ref();
        final Ref resolvedType = new Ref();
        final LinkedHashSet expressions2 = new LinkedHashSet(3);
        final Ref lastException = new Ref();
        new WriteAction(){

            protected void run(@NotNull Result result2) throws Throwable {
                try {
                    Pair converted = OCEvaluatorHelper.convertExpressionPrivate(process2, expression2.getExpression(), sourcePosition);
                    convertedExpression.set(converted.second);
                    resolvedType.set(converted.first);
                }
                catch (CidrEvaluatorHelper.ConversionException e) {
                    lastException.set((Object)new DebuggerCommandException(e));
                    return;
                }
                expressions2.add(convertedExpression.get());
                OCType type2 = (OCType)resolvedType.get();
                PsiElement debuggerContext = process2.getDebuggerContext(sourcePosition);
                if (!resolvedType.isNull() && !type2.isUnknown()) {
                    PsiFile file2;
                    PsiFile psiFile = file2 = debuggerContext != null ? debuggerContext.getContainingFile() : null;
                    if (file2 != null) {
                        if (process2.driverSupportsArrayEvaluation() && type2 instanceof OCArrayType) {
                            type2 = OCTypeUtils.decayType(type2, file2.getProject());
                        }
                        if (type2 instanceof OCCppReferenceType && ((OCCppReferenceType)type2).isRvalueRef()) {
                            type2 = ((OCCppReferenceType)type2).getRefType();
                        }
                        if (!(type2 instanceof OCArrayType)) {
                            OCType baseType = type2;
                            while (baseType instanceof OCPointerType) {
                                baseType = ((OCPointerType)baseType).getRefType();
                            }
                            if (baseType instanceof OCStructType) {
                                expressions2.add("((" + type2.getCanonicalName((PsiElement)file2) + ")(" + (String)convertedExpression.get() + "))");
                                return;
                            }
                        }
                        expressions2.add("((" + type2.getCanonicalName((PsiElement)file2) + ")(" + (String)convertedExpression.get() + "))");
                    } else {
                        CidrDebuggerLog.LOG.warn("Cannot get PsiFile for " + (sourcePosition != null ? sourcePosition.toString() : "UNKNOWN POSITION"));
                    }
                    expressions2.add("((" + type2.getName() + ")(" + (String)convertedExpression.get() + "))");
                }
            }
        }.execute();
        if (expressions2.isEmpty()) {
            DebuggerCommandException exception = (DebuggerCommandException)lastException.get();
            if (exception == null) {
                CidrDebuggerLog.LOG.error("exception is null for: " + expression2);
                throw new DebuggerCommandException(CidrBundle.message("debug.evaluate.error.invalidExpression", new Object[0]));
            }
            throw exception;
        }
        LLValue result2 = null;
        String actualExpression = null;
        for (String each : expressions2) {
            try {
                result2 = driver.evaluate(threadId, frameIndex, each);
                actualExpression = each;
                break;
            }
            catch (DebuggerCommandException e) {
                lastException.set((Object)e);
            }
        }
        CidrDebuggerLog.LOG.assertTrue(result2 != null || !lastException.isNull());
        if (result2 == null) {
            CidrDebuggerLog.LOG.debug((Throwable)lastException.get());
            throw (DebuggerCommandException)lastException.get();
        }
        return Pair.create((Object)((Object)result2), actualExpression);
    }

    private static class PostConverter
    extends MyVisitor {
        private PostConverter() {
        }

        @Override
        public void visitReferenceExpression(OCReferenceExpression expression2) {
            OCSymbolKind kind2;
            OCSymbol symbol = expression2.resolveToSymbol();
            OCSymbolKind oCSymbolKind = kind2 = symbol == null ? null : symbol.getKind();
            if (kind2 == OCSymbolKind.INTERFACE || kind2 == OCSymbolKind.IMPLEMENTATION ? this.replaceAndVisitClass(expression2, symbol.getName()) : kind2 == OCSymbolKind.PROTOCOL && this.replaceAndVisitProtocol(expression2, symbol.getName())) {
                return;
            }
            super.visitReferenceExpression(expression2);
        }

        @Override
        public void visitProtocolExpression(OCProtocolExpression expression2) {
            OCTypeElement type2 = expression2.getTypeElement();
            if (type2 != null && this.replaceAndVisitProtocol(expression2, type2.getText())) {
                return;
            }
            super.visitProtocolExpression(expression2);
        }

        private boolean replaceAndVisitClass(OCReferenceExpression expression2, String name) {
            return this.replaceAndVisit(expression2, "(id)NSClassFromString(@\"" + name + "\")");
        }

        private boolean replaceAndVisitProtocol(OCExpression expression2, String name) {
            return this.replaceAndVisit(expression2, "(id)NSProtocolFromString(@\"" + name + "\")");
        }
    }

    private static class PreConverter
    extends MyVisitor {
        private PreConverter() {
        }

        @Override
        public void visitReferenceExpression(OCReferenceExpression expression2) {
            OCSymbolKind kind2;
            OCSymbol symbol = expression2.resolveToSymbol();
            OCSymbolKind oCSymbolKind = kind2 = symbol == null ? null : symbol.getKind();
            if (kind2 == OCSymbolKind.INSTANCE_VARIABLE) {
                String name = symbol.getName();
                if (!"self".equals(name) && this.replaceAndVisit(expression2, "self->" + name)) {
                    return;
                }
            } else if (kind2 == OCSymbolKind.ENUM_CONST) {
                Integer value2 = OCExpressionEvaluator.evaluateEnumConst(symbol, expression2.getContainingFile());
                String converted = "((int)" + (value2 == null ? expression2.getText() : String.valueOf(value2)) + ")";
                OCParenthesizedExpression result2 = MyVisitor.replace(expression2, converted);
                if (result2 != null) {
                    return;
                }
            }
            super.visitReferenceExpression(expression2);
        }

        @Override
        public void visitQualifiedExpression(OCQualifiedExpression expression2) {
            Prop prop = PreConverter.getProp(expression2);
            if (prop != null && prop.getter != null && this.replaceAndVisit(expression2, "[" + prop.receiver + " " + prop.getter + "]")) {
                return;
            }
            super.visitQualifiedExpression(expression2);
        }

        @Override
        public void visitAssignmentExpression(OCAssignmentExpression expression2) {
            Prop prop = PreConverter.getProp(expression2.getReceiverExpression());
            OCExpression argExp = expression2.getSourceExpression();
            if (prop != null && prop.isReadWrite() && argExp != null) {
                String arg = argExp.getText();
                String sign = expression2.getOperationSign().getName();
                if (sign.endsWith("=") && sign.length() == 2) {
                    arg = "([" + prop.receiver + " " + prop.getter + "]" + sign.substring(0, 1) + arg + ")";
                }
                if (this.replaceAndVisit(expression2, "[" + prop.receiver + " " + prop.setter + " " + arg + "]")) {
                    return;
                }
            }
            super.visitAssignmentExpression(expression2);
        }

        @Override
        public void visitPrefixExpression(OCPrefixExpression expression2) {
            if (this.doVisitXFixExpression(expression2, true)) {
                return;
            }
            super.visitPrefixExpression(expression2);
        }

        @Override
        public void visitPostfixExpression(OCPostfixExpression expression2) {
            if (this.doVisitXFixExpression(expression2, false)) {
                return;
            }
            super.visitPostfixExpression(expression2);
        }

        private boolean doVisitXFixExpression(OCExpression expression2, boolean isPrefix) {
            Prop prop = PreConverter.getProp(isPrefix ? ((OCPrefixExpression)expression2).getOperand() : ((OCPostfixExpression)expression2).getOperand());
            if (prop == null || !prop.isReadWrite()) {
                return false;
            }
            String sign = (isPrefix ? ((OCPrefixExpression)expression2).getOperationSign() : ((OCPostfixExpression)expression2).getOperationSign()).getName();
            String fix = sign.equals("--") ? "-1" : "+1";
            String getExpr = "[" + prop.receiver + " " + prop.getter + "]" + fix;
            return this.replaceAndVisit(expression2, "[" + prop.receiver + " " + prop.setter + " " + getExpr + "]");
        }

        @Nullable
        private static Prop getProp(@Nullable OCExpression exp) {
            if (exp instanceof OCQualifiedExpression) {
                OCSymbol symbol = ((OCQualifiedExpression)exp).resolveToSymbol();
                String receiver2 = ((OCQualifiedExpression)exp).getQualifier().getText();
                if (symbol instanceof OCPropertySymbol) {
                    return new Prop(receiver2, ((OCPropertySymbol)symbol).getGetterName(), ((OCPropertySymbol)symbol).getSetterName());
                }
                if (symbol instanceof OCMethodSymbol) {
                    OCMethodSymbol method2 = (OCMethodSymbol)symbol;
                    String name = symbol.getName();
                    return new Prop(receiver2, method2.isGetter() ? name : OCNameSuggester.getObjCGetterFromSetter(name), method2.isSetter() ? name : OCNameSuggester.getObjCSetterFromGetter(name));
                }
            }
            return null;
        }

        private static class Prop {
            @NotNull
            public final String receiver;
            @Nullable
            public final String getter;
            @Nullable
            public final String setter;

            private Prop(@NotNull String receiver2, @Nullable String getter, @Nullable String setter) {
                this.receiver = receiver2;
                this.getter = getter;
                this.setter = setter;
            }

            public boolean isReadWrite() {
                return this.getter != null && this.setter != null;
            }
        }
    }

    private static abstract class MyVisitor
    extends OCRecursiveVisitor {
        private MyVisitor() {
        }

        protected boolean replaceAndVisit(@NotNull OCExpression expression2, @NotNull String converted) {
            super.visitParenthesizedExpression(MyVisitor.replace(expression2, converted));
            return true;
        }

        @Nullable
        protected static OCParenthesizedExpression replace(@NotNull OCExpression expression2, @NotNull String converted) {
            OCExpression replacement = OCElementFactory.expressionFromText("(" + converted + ")", expression2, false);
            if (replacement == null) {
                return null;
            }
            return (OCParenthesizedExpression)expression2.replace(replacement);
        }
    }
}

