/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.ProcessOutputReaders;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakPointBroadcast;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import gnu.trove.TLongHashSet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerDriver {
    public static final Key<String> DEBUGSERVER_SOCKET = Key.create((String)"DEBUGSERVER_SOCKET");
    public static final Key<Integer> DEBUGSERVER_ID = Key.create((String)"DEBUGSERVER_ID");
    public static final int LOAD_TIMEOUT_MS = 90000;
    public static final int TIMEOUT_MS = 30000;
    public static final int EVALUATION_TIMEOUT_MS = 30000;
    public static final int CLOSE_TIMEOUT_MS = 300;
    public static final int MAX_DESCRIPTION = 1000;
    public static final int MAX_CHILD_COUNT = Integer.MAX_VALUE;
    protected final Handler myHandler;
    private volatile TargetState myState = TargetState.NOT_READY;
    protected final List<Consumer<Pair<String, Key>>> myOutputListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    protected final QueueProcessor<Runnable> myHandlerProcessor;
    @Nullable
    protected ProcessOutputReaders myReaders;
    protected volatile GeneralCommandLine myTargetCommandLine;
    protected volatile Installer myInstaller;
    protected volatile TLongHashSet myIndirectSymbols;
    protected boolean myToRedirect;

    public DebuggerDriver(@NotNull Handler handler2) {
        this.myHandler = handler2;
        this.myHandlerProcessor = QueueProcessor.createRunnableQueueProcessor();
    }

    public boolean supportsWatchpoints() {
        return true;
    }

    public abstract boolean supportsWatchpointLifetime();

    public boolean supportsDisasm() {
        return true;
    }

    @NotNull
    public abstract Language getConsoleLanguage();

    @NotNull
    public abstract ProcessHandler getProcessHandler();

    public abstract boolean isInPromptMode();

    public TargetState getState() {
        return this.myState;
    }

    public abstract void start(@NotNull Installer var1, @Nullable String var2) throws ExecutionException;

    public abstract void setValuesFilteringEnabled(boolean var1) throws ExecutionException;

    public abstract void loadForLaunch() throws ExecutionException;

    public abstract void loadForAttach() throws ExecutionException;

    public abstract long launch() throws ExecutionException;

    public abstract void attachTo(int var1) throws ExecutionException;

    public abstract void detach() throws ExecutionException;

    public abstract void attachByName(String var1, boolean var2) throws ExecutionException;

    public abstract boolean interrupt() throws ExecutionException;

    public abstract boolean resume() throws ExecutionException;

    public void stepOver() throws ExecutionException {
        this.stepOver(false);
    }

    public void stepInto() throws ExecutionException {
        this.stepInto(false);
    }

    public abstract void stepOver(boolean var1) throws ExecutionException;

    public abstract void stepInto(boolean var1) throws ExecutionException;

    public abstract void stepOut() throws ExecutionException;

    public abstract void runTo(String var1, int var2) throws ExecutionException;

    public abstract boolean abort() throws ExecutionException;

    @NotNull
    public abstract LLWatchpoint addWatchpoint(long var1, int var3, LLValue var4, String var5, LLWatchpoint.Lifetime var6, LLWatchpoint.AccessType var7) throws ExecutionException, DebuggerCommandException;

    public abstract void removeWatchpoint(List<Integer> var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public List<LLBreakpoint> addBreakpoint(String path, int line) throws ExecutionException, DebuggerCommandException {
        return this.addBreakpoint(path, line, null);
    }

    @NotNull
    public abstract List<LLBreakpoint> addBreakpoint(String var1, int var2, @Nullable String var3) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull String symbolPattern) throws ExecutionException, DebuggerCommandException {
        return this.addSymbolicBreakpoint(symbolPattern, null, null);
    }

    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull String symbolPattern, @Nullable String module2, @Nullable String condition2) throws ExecutionException, DebuggerCommandException {
        SymbolicBreakpoint symBreakpoint = new SymbolicBreakpoint();
        symBreakpoint.setPattern(symbolPattern);
        symBreakpoint.setModule(module2);
        symBreakpoint.setCondition(condition2);
        return this.addSymbolicBreakpoint(symBreakpoint);
    }

    @Nullable
    public abstract LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull SymbolicBreakpoint var1) throws ExecutionException, DebuggerCommandException;

    public abstract void removeCodepoints(@NotNull Collection<Integer> var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLThread> getThreads() throws ExecutionException, DebuggerCommandException;

    @NotNull
    public ResultList<LLFrame> getFrames(long threadId, int from, int count) throws ExecutionException, DebuggerCommandException {
        return this.getFrames(threadId, from, count, false);
    }

    @NotNull
    public abstract ResultList<LLFrame> getFrames(long var1, int var3, int var4, boolean var5) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLValue> getVariables(long var1, int var3) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public Integer getChildrenCount(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        return this.getChildrenCount(var, Integer.MAX_VALUE);
    }

    @Nullable
    public abstract Integer getChildrenCount(@NotNull LLValue var1, int var2) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract LLValueData getData(@NotNull LLValue var1) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public abstract String getDescription(@NotNull LLValue var1, int var2) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract ResultList<LLValue> getVariableChildren(LLValue var1, int var2, int var3) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public final LLValue evaluate(long threadId, int frameIndex, @NotNull String expression2) throws ExecutionException, DebuggerCommandException {
        return this.evaluate(threadId, frameIndex, expression2, null);
    }

    @NotNull
    public abstract LLValue evaluate(long var1, int var3, @NotNull String var4, @Nullable DebuggerLanguage var5) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLInstruction> disassemble(@NotNull AddressRange var1) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public LLInstruction disassemble(@NotNull Address address) throws ExecutionException, DebuggerCommandException {
        List<LLInstruction> instructions = this.disassemble(address.rangeTo(address));
        return instructions.isEmpty() ? null : instructions.get(0);
    }

    @NotNull
    public abstract ShellCommandResult executeShellCommand(@NotNull String var1, @Nullable List<String> var2, @Nullable String var3, int var4) throws ExecutionException;

    public abstract void executeConsoleCommand(String var1) throws ExecutionException, DebuggerCommandException;

    public abstract void executeConsoleCommand(long var1, int var3, String var4) throws ExecutionException, DebuggerCommandException;

    public abstract void handleCompletion(String var1, int var2, List<String> var3) throws ExecutionException;

    public abstract void handleSignal(String var1, boolean var2, boolean var3, boolean var4) throws ExecutionException, DebuggerCommandException;

    public void addOutputListener(Consumer<Pair<String, Key>> listener2) {
        this.myOutputListeners.add(listener2);
    }

    protected void setState(TargetState state) {
        this.myState = state;
        if (state == TargetState.FINISHED) {
            this.closeOutputReaders();
        }
    }

    protected void handleRunning() {
        this.setState(TargetState.RUNNING);
        this.myHandlerProcessor.add(this.myHandler::handleRunning);
    }

    protected void handleModulesLoaded(@NotNull List<String> modules) {
        this.myHandlerProcessor.add(() -> this.myHandler.handleModulesLoaded(modules));
    }

    protected void handleBreakpointChanged(LLBreakPointBroadcast broadcast_change) {
        this.myHandlerProcessor.add(() -> this.myHandler.handleBreakpointChanged(broadcast_change));
    }

    protected void handleInterrupted(@NotNull StopPlace stopPlace) {
        this.setState(TargetState.SUSPENDED);
        this.myHandlerProcessor.add(() -> this.myHandler.handleInterrupted(stopPlace));
    }

    protected void handleSignal(@NotNull StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
        this.setState(TargetState.SUSPENDED);
        this.myHandlerProcessor.add(() -> this.myHandler.handleSignal(stopPlace, signal, meaning));
    }

    protected void handleException(@NotNull StopPlace stopPlace, @NotNull String description) {
        this.setState(TargetState.SUSPENDED);
        this.myHandlerProcessor.add(() -> this.myHandler.handleException(stopPlace, description));
    }

    protected void handleBreakpoint(@NotNull StopPlace stopPlace, int breakpointNumber) {
        this.setState(TargetState.SUSPENDED);
        this.myHandlerProcessor.add(() -> this.myHandler.handleBreakpoint(stopPlace, breakpointNumber));
    }

    protected void handleWatchpoint(@NotNull StopPlace stopPlace, int watchpointNumber) {
        this.setState(TargetState.SUSPENDED);
        this.myHandlerProcessor.add(() -> this.myHandler.handleWatchpoint(stopPlace, watchpointNumber));
    }

    protected void handleWatchpointScope(int watchpointNumber) {
        this.setState(TargetState.SUSPENDED);
        this.myHandlerProcessor.add(() -> this.myHandler.handleWatchpointScope(watchpointNumber));
    }

    protected void handleTargetOutput(@NotNull String text, @NotNull Key type2) {
        this.myHandlerProcessor.add(() -> {
            this.myHandler.handleTargetOutput(text, type2);
            for (Consumer<Pair<String, Key>> each : this.myOutputListeners) {
                each.consume((Object)Pair.create((Object)text, (Object)type2));
            }
        });
    }

    protected void handleAttached(int pid) {
        this.myHandlerProcessor.add(() -> this.myHandler.handleAttached(pid));
    }

    protected void handleConnected(@NotNull String connection) {
        this.myHandlerProcessor.add(() -> this.myHandler.handleConnected(connection));
    }

    protected void handleDisconnected() {
        this.myHandlerProcessor.add(this.myHandler::handleDisconnected);
    }

    protected void handleGDBOutput(@NotNull String text) {
        this.myHandlerProcessor.add(() -> this.myHandler.handleGDBOutput(text));
    }

    protected void handlePrompt() {
        this.handlePrompt(false);
    }

    protected void handlePrompt(boolean inMultiLineCommand) {
        this.handlePrompt(inMultiLineCommand ? 1 : 0);
    }

    protected void handlePrompt(int promptLevel) {
        this.handlePrompt(promptLevel == 0 ? "(" + this.getPromptText() + ") " : StringUtil.repeat((String)"> ", (int)promptLevel));
    }

    protected abstract String getPromptText();

    protected void handlePrompt(@NotNull String prompt) {
        this.myHandlerProcessor.add(() -> this.myHandler.handlePrompt(prompt));
    }

    protected void handleTargetFinished(int code2, @Nullable String description) {
        this.setState(TargetState.FINISHED);
        this.myHandlerProcessor.add(() -> this.myHandler.handleTargetFinished(code2, description));
    }

    protected void handleTargetTerminated() {
        this.setState(TargetState.FINISHED);
        this.myHandlerProcessor.add(this.myHandler::handleTargetTerminated);
    }

    protected void handleDetached() {
        this.setState(TargetState.FINISHED);
        this.myHandlerProcessor.add(this.myHandler::handleDetached);
    }

    protected void handleExited(int code2) {
        this.setState(TargetState.FINISHED);
        this.myHandlerProcessor.add(() -> this.myHandler.handleExited(code2));
    }

    public void waitHandlerProcessed() {
        this.myHandlerProcessor.waitFor();
    }

    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    public abstract void checkErrors() throws ExecutionException;

    protected void printTargetCommandLine(@Nullable GeneralCommandLine commandLine) {
        if (commandLine != null) {
            this.handleTargetOutput(commandLine.getCommandLineString() + "\n", ProcessOutputTypes.SYSTEM);
        }
    }

    public void setRedirectOutputToFiles(boolean toRedirect) {
        this.myToRedirect = toRedirect;
    }

    protected void initReaders(boolean usePty) throws ExecutionException {
        this.myReaders = new ProcessOutputReaders(){

            @Override
            protected void onTextAvailable(@NotNull String text, @NotNull Key type2) {
                DebuggerDriver.this.handleTargetOutput(text, type2);
            }
        };
        this.myReaders.init(this.myTargetCommandLine, usePty);
    }

    protected void closeOutputReaders() {
        if (this.myReaders != null) {
            try {
                if (!this.myReaders.waitFor(300L, TimeUnit.MILLISECONDS)) {
                    CidrDebuggerLog.LOG.warn("Closing inferior output readers took too long");
                }
            }
            finally {
                this.myReaders.close();
            }
            this.myReaders = null;
        }
    }

    protected static boolean isTargetTerminationSignal(int signal) {
        return 15 == signal || 9 == signal;
    }

    protected static boolean isTargetTerminationSignal(@Nullable String name) {
        return "SIGTERM".equals(name) || "SIGKILL".equals(name);
    }

    protected String getDebugServerSocket() {
        return (String)this.myTargetCommandLine.getUserData(DEBUGSERVER_SOCKET);
    }

    public abstract void addSymbolsFile(File var1, File var2) throws ExecutionException;

    private static int escapedByte(String s, int idx, ByteArrayOutputStream bs) {
        if (idx + 4 > s.length() || s.charAt(idx) != '\\') {
            return -1;
        }
        try {
            int code2 = Integer.parseInt(s.substring(idx + 1, idx + 4), 8);
            bs.write(code2);
            return idx + 4;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @NotNull
    public static String unescapeString(@NotNull String s) {
        StringBuilder buffer = new StringBuilder(s.length());
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        boolean escaped = false;
        for (int idx = 0; idx < s.length(); ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case 'e': {
                    buffer.append('\u001b');
                    break;
                }
                case 'a': {
                    buffer.append('\u0007');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                default: {
                    int i2 = idx - 1;
                    bs.reset();
                    while ((i2 = DebuggerDriver.escapedByte(s, i2, bs)) != -1) {
                        idx = i2;
                    }
                    if (bs.size() > 0) {
                        try {
                            buffer.append(new String(bs.toByteArray(), "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            CidrDebuggerLog.LOG.error((Throwable)e);
                        }
                        --idx;
                        break;
                    }
                    buffer.append('\\');
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
        return buffer.toString();
    }

    @Contract(value="_, !null -> !null")
    public static Address parseAddress(@NotNull String str, Address defaultValue) {
        try {
            return Address.parseHexString(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @NotNull
    public static Address parseAddress(@NotNull String str) throws ExecutionException {
        try {
            return Address.parseHexString(str);
        }
        catch (NumberFormatException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    @NotNull
    public static Address parseAddressSafe(@NotNull String str) throws DebuggerCommandException {
        try {
            return Address.parseHexString(str);
        }
        catch (NumberFormatException e) {
            throw new DebuggerCommandException(e);
        }
    }

    protected static int getTimeoutMs() {
        return Registry.intValue((String)"cidr.debugger.timeout", (int)30000);
    }

    protected static int getLoadTimeoutMs() {
        return Registry.intValue((String)"cidr.debugger.timeout.load", (int)90000);
    }

    protected static int getEvaluationTimeoutMs() {
        return Registry.intValue((String)"cidr.debugger.timeout.evaluate", (int)30000);
    }

    public static class SymbolicBreakpoint {
        public static final int INVALID_THREAD_ID = 0;
        private String myPattern;
        private boolean myRegexpPattern = false;
        @Nullable
        private String myModule;
        @Nullable
        private String myCondition;
        private long myThreadId = 0L;

        public String getPattern() {
            return this.myPattern;
        }

        public void setPattern(String pattern) {
            this.myPattern = pattern;
        }

        public boolean isRegexpPattern() {
            return this.myRegexpPattern;
        }

        public void setRegexpPattern(boolean regexpPattern) {
            this.myRegexpPattern = regexpPattern;
        }

        @Nullable
        public String getModule() {
            return this.myModule;
        }

        public void setModule(@Nullable String module2) {
            this.myModule = module2;
        }

        @Nullable
        public String getCondition() {
            return this.myCondition;
        }

        public void setCondition(@Nullable String condition2) {
            this.myCondition = condition2;
        }

        public long getThreadId() {
            return this.myThreadId;
        }

        public void setThreadId(long threadId) {
            this.myThreadId = threadId;
        }
    }

    public static enum StandardDebuggerLanguage implements DebuggerLanguage
    {
        C("C"),
        C_PLUS_PLUS("C++"),
        OBJC("Objective-C"),
        OBJC_PLUS_PLUS("Objective-C++"),
        SWIFT("Swift");

        private final String myName;

        private StandardDebuggerLanguage(String name) {
            this.myName = name;
        }

        @Override
        @NotNull
        public String toString() {
            return this.myName;
        }
    }

    public static interface DebuggerLanguage {
        public String toString();
    }

    public static class ResultList<T> {
        @NotNull
        public final List<T> list;
        public final boolean hasMore;

        public ResultList(@NotNull List<T> list, boolean hasMore) {
            this.list = list;
            this.hasMore = hasMore;
        }

        @NotNull
        public static <T> ResultList<T> create(@NotNull List<T> list, boolean hasMore) {
            return new ResultList<T>(list, hasMore);
        }

        @NotNull
        public static <T> ResultList<T> empty() {
            return ResultList.create(Collections.emptyList(), false);
        }
    }

    public static class StopPlace {
        @NotNull
        public final LLThread thread;
        @NotNull
        public final LLFrame frame;

        public StopPlace(@NotNull LLThread thread, @NotNull LLFrame frame) {
            this.thread = thread;
            this.frame = frame;
        }
    }

    public static class PathMapping {
        @NotNull
        public final String from;
        @NotNull
        public final String to;

        public PathMapping(@NotNull String from, @NotNull String to) {
            this.from = from;
            this.to = to;
        }
    }

    public static interface Handler
    extends EventListener {
        default public void handleRunning() {
        }

        default public void handleModulesLoaded(@NotNull List<String> modules) {
        }

        default public void handleBreakpointChanged(LLBreakPointBroadcast bc) {
        }

        default public void handleInterrupted(@NotNull StopPlace stopPlace) {
        }

        default public void handleSignal(@NotNull StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
        }

        default public void handleException(@NotNull StopPlace stopPlace, @NotNull String description) {
        }

        default public void handleBreakpoint(@NotNull StopPlace stopPlace, int breakpointNumber) {
        }

        default public void handleWatchpoint(@NotNull StopPlace stopPlace, int watchpointNumber) {
        }

        default public void handleWatchpointScope(int watchpointNumber) {
        }

        default public void handleTargetOutput(@NotNull String text, @NotNull Key type2) {
        }

        default public void handleGDBOutput(@NotNull String text) {
        }

        default public void handlePrompt(@NotNull String prompt) {
        }

        default public void handleTargetFinished(int code2, @Nullable String description) {
        }

        default public void handleTargetTerminated() {
        }

        default public void handleExited(int code2) {
        }

        default public void handleAttached(int pid) {
        }

        default public void handleDetached() {
        }

        default public void handleConnected(@NotNull String connection) {
        }

        default public void handleDisconnected() {
        }
    }

    public static enum TargetState {
        NOT_READY,
        RUNNING,
        SUSPENDED,
        FINISHED;

    }

    public static class ShellCommandResult {
        private final String myOutput;
        private final int myStatus;
        private final int mySignal;

        public ShellCommandResult(@NotNull String output, int status, int signal) {
            this.myOutput = output;
            this.myStatus = status;
            this.mySignal = signal;
        }

        @NotNull
        public String getOutput() {
            return this.myOutput;
        }

        public int getStatus() {
            return this.myStatus;
        }

        public int getSignal() {
            return this.mySignal;
        }
    }
}

