/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLBreakpoint
extends LLCodepoint {
    @NotNull
    private final String myFile;
    private final int myLine;
    private final boolean myPending;
    @Nullable
    private String myCondition;
    @Nullable
    private String myConditionError;
    private final boolean myIsValid;
    private long myNumLocations;
    private long myNumResolvedLocations;
    private static final long DEFAULT_NUM_LOCATIONS = 1L;
    private static final long DEFAULT_NUM_RESOLVED_LOCATIONS = 1L;
    private static boolean DEFAULT_VALID_FLAG = true;

    public LLBreakpoint(int id, @NotNull String file2, int line, boolean pending, @Nullable String condition2, @Nullable String conditionError) {
        this(id, file2, line, 1L, 1L, pending, DEFAULT_VALID_FLAG, condition2, conditionError);
    }

    public LLBreakpoint(int id, @NotNull String file2, int line, long numLocations, long numResolvedLocations, boolean pending, boolean isValid, @Nullable String condition2, @Nullable String conditionError) {
        super(id);
        this.myFile = file2;
        this.myLine = line;
        this.myPending = pending;
        this.myIsValid = isValid;
        this.myCondition = condition2;
        this.myConditionError = conditionError;
        this.myNumLocations = numLocations;
        this.myNumResolvedLocations = numResolvedLocations;
    }

    @NotNull
    public String getFile() {
        return this.myFile;
    }

    public int getLine() {
        return this.myLine;
    }

    public ValidityState getBreakpointValidityState() {
        if (this.getId() < 0 || !this.myIsValid) {
            return ValidityState.INVALID;
        }
        if (this.myNumLocations == 0L || this.myNumLocations != this.myNumResolvedLocations) {
            return ValidityState.PENDING;
        }
        return ValidityState.RESOLVED;
    }

    @Nullable
    public String getCondition() {
        return this.myCondition;
    }

    @Nullable
    public String getConditionError() {
        return this.myConditionError;
    }

    public String toString() {
        String result2 = "Breakpoint-" + this.getId() + "@" + this.myFile + ":" + this.myLine;
        if (this.myPending) {
            result2 = result2 + "(pending)";
        }
        if (this.myCondition != null) {
            result2 = result2 + ":condition:" + this.myCondition;
        }
        if (this.myConditionError != null) {
            result2 = result2 + ":condition-error:" + this.myConditionError;
        }
        return result2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LLBreakpoint that = (LLBreakpoint)o;
        if (this.myLine != that.myLine) {
            return false;
        }
        if (this.myPending != that.myPending) {
            return false;
        }
        if (this.myCondition != null ? !this.myCondition.equals(that.myCondition) : that.myCondition != null) {
            return false;
        }
        if (this.myConditionError != null ? !this.myConditionError.equals(that.myConditionError) : that.myConditionError != null) {
            return false;
        }
        return this.myFile.equals(that.myFile);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myFile.hashCode();
        result2 = 31 * result2 + this.myLine;
        result2 = 31 * result2 + (this.myPending ? 1 : 0);
        result2 = 31 * result2 + (this.myCondition != null ? this.myCondition.hashCode() : 0);
        result2 = 31 * result2 + (this.myConditionError != null ? this.myConditionError.hashCode() : 0);
        return result2;
    }

    public static enum ValidityState {
        INVALID,
        PENDING,
        RESOLVED;

    }
}

