/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBEvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBDriverConfiguration
extends DebuggerDriverConfiguration {
    @Override
    @NotNull
    public String getDriverName() {
        return "LLDB";
    }

    @Nullable
    public String readVersion() throws ExecutionException {
        GeneralCommandLine commandLine = this.createLLDBFrontendCommandLine();
        commandLine.addParameter("--version");
        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine);
        if (output.getExitCode() != 0) {
            throw new ExecutionException(output.getStderr());
        }
        return (String)ContainerUtil.getFirstItem((Collection)output.getStdoutLines(), (Object)"");
    }

    @Override
    public boolean isAttachSupported() {
        return true;
    }

    @Override
    @NotNull
    public DebuggerDriver createDriver(@NotNull DebuggerDriver.Handler handler2) {
        return new LLDBDriver(handler2, this);
    }

    @NotNull
    protected File getLLDBFrameworkFile() {
        return this.getLLDBBinFile(SystemInfo.isWindows ? "liblldb.dll" : (SystemInfo.isLinux ? "lib/liblldb.so" : "LLDB.framework"));
    }

    @NotNull
    protected File getLLDBBinFile(@NotNull String relativePath) {
        return CidrDebuggerPathManager.getLLDBBinFile(relativePath);
    }

    @Override
    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver, @NotNull Installer installer) throws ExecutionException {
        GeneralCommandLine result2 = this.createLLDBFrontendCommandLine();
        result2.addParameter(String.valueOf(((LLDBDriver)driver).getPort()));
        this.configureDriverCommandLine(result2);
        return result2;
    }

    @NotNull
    private GeneralCommandLine createLLDBFrontendCommandLine() throws ExecutionException {
        File lldbFrameworkFile = this.getLLDBFrameworkFile();
        if (!lldbFrameworkFile.exists()) {
            throw new ExecutionException(lldbFrameworkFile + " not found");
        }
        File frontendExecutable = this.getLLDBBinFile(SystemInfo.isWindows ? "LLDBFrontend.exe" : "LLDBFrontend");
        if (!frontendExecutable.exists()) {
            throw new ExecutionException(frontendExecutable.getAbsolutePath() + " not found");
        }
        GeneralCommandLine result2 = new GeneralCommandLine();
        result2.setExePath(frontendExecutable.getAbsolutePath());
        Map env = result2.getEnvironment();
        if (SystemInfo.isLinux) {
            env.put("LD_LIBRARY_PATH", lldbFrameworkFile.getParent());
        } else if (SystemInfo.isWindows) {
            env.put("PATH", lldbFrameworkFile.getParent() + ";" + frontendExecutable.getParent());
        } else if (SystemInfo.isMac) {
            env.put("DYLD_FRAMEWORK_PATH", lldbFrameworkFile.getParent());
            File debugserver = new File(lldbFrameworkFile, "Resources/debugserver");
            if (debugserver.exists()) {
                env.put("LLDB_DEBUGSERVER_PATH", debugserver.getAbsolutePath());
                env.put("LLDB_DEBUGSERVER_EXTRA_ARG_1", "--reverse-connect");
            }
            env.put("NSUnbufferedIO", "YES");
            File pythonDir = CidrDebuggerPathManager.getOSXSystemPythonBinDir();
            if (pythonDir != null) {
                env.put("PATH", pythonDir.getAbsolutePath());
            } else {
                CidrDebuggerLog.LOG.warn("Python bin dir not found");
            }
            result2.putUserData(LLDBDriver.ENABLE_STL_RENDERERS, (Object)true);
            env.put("PYTHONPATH", CidrDebuggerPathManager.getBundledLLDBSTLPrettyPrinters().getAbsolutePath());
        }
        if (this.disableASLR()) {
            env.put("LLDB_LAUNCH_FLAG_DISABLE_ASLR", "1");
        }
        LLDBDriverConfiguration.setupCommonParameters(result2);
        return result2;
    }

    protected void configureDriverCommandLine(@NotNull GeneralCommandLine result2) {
    }

    @Override
    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull CidrStackFrame frame) {
        return new LLDBEvaluationContext(driver, expirable, frame);
    }

    @Override
    public boolean supportsArrayEvaluation() {
        return true;
    }

    @Override
    public boolean isCodeFragmentEvaluationSupported() {
        return true;
    }

    public boolean isStaticVarsLoadingEnabled() {
        return false;
    }

    public boolean disableASLR() {
        return false;
    }

    @Contract(value="null -> null")
    public String convertToProjectModelPath(@Nullable String absolutePath) {
        return absolutePath;
    }
}

