/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLFrame {
    public static final String UNKNOWN_FUNCTION = "<unknown function>";
    private final int myIndex;
    @NotNull
    private final String myFunction;
    @Nullable
    private final String myFile;
    private final int myLine;
    @NotNull
    private final Address myProgramCounter;
    @Nullable
    private final DebuggerDriver.DebuggerLanguage myLanguage;
    private final boolean myOptimized;

    public LLFrame(int index, @Nullable String function, @Nullable String file2, int line, long pc, @Nullable DebuggerDriver.DebuggerLanguage language, boolean optimized) {
        this(index, function, file2, line, Address.fromUnsignedLong(pc), language, optimized);
    }

    public LLFrame(int index, @Nullable String function, @Nullable String file2, int line, @NotNull Address pc, @Nullable DebuggerDriver.DebuggerLanguage language, boolean optimized) {
        this.myIndex = index;
        this.myFunction = StringUtil.defaultIfEmpty((String)function, (String)UNKNOWN_FUNCTION);
        this.myFile = file2 == null ? null : FileUtil.toSystemIndependentName((String)file2);
        this.myLine = line;
        this.myProgramCounter = pc;
        this.myLanguage = language;
        this.myOptimized = optimized;
    }

    public int getIndex() {
        return this.myIndex;
    }

    @NotNull
    public String getFunction() {
        return this.myFunction;
    }

    @Nullable
    public String getFile() {
        return this.myFile;
    }

    public int getLine() {
        return this.myLine;
    }

    @NotNull
    public Address getProgramCounter() {
        return this.myProgramCounter;
    }

    @Nullable
    public DebuggerDriver.DebuggerLanguage getLanguage() {
        return this.myLanguage;
    }

    public boolean getOptimized() {
        return this.myOptimized;
    }

    public String toString() {
        return String.format("%d: %s %s@%s:%d (%s)%s", this.myIndex, this.myProgramCounter, this.myFunction, this.myFile, this.myLine, this.myLanguage, this.myOptimized ? " [opt]" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLFrame gdbFrame = (LLFrame)o;
        if (this.myLine != gdbFrame.myLine) {
            return false;
        }
        if (this.myIndex != gdbFrame.myIndex) {
            return false;
        }
        if (!this.myFunction.equals(gdbFrame.myFunction)) {
            return false;
        }
        if (this.myFile != null ? !this.myFile.equals(gdbFrame.myFile) : gdbFrame.myFile != null) {
            return false;
        }
        if (!this.myProgramCounter.equals(gdbFrame.myProgramCounter)) {
            return false;
        }
        if (this.myLanguage != null ? !this.myLanguage.equals(gdbFrame.myLanguage) : gdbFrame.myLanguage != null) {
            return false;
        }
        return this.myOptimized == gdbFrame.myOptimized;
    }

    public int hashCode() {
        int result2 = this.myIndex;
        result2 = 31 * result2 + this.myFunction.hashCode();
        result2 = 31 * result2 + (this.myFile != null ? this.myFile.hashCode() : 0);
        result2 = 31 * result2 + this.myLine;
        result2 = 31 * result2 + this.myProgramCounter.hashCode();
        result2 = 31 * result2 + (this.myLanguage != null ? this.myLanguage.hashCode() : 0);
        result2 = 31 * result2 + (this.myOptimized ? 1 : 0);
        return result2;
    }
}

