/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.jetbrains.cidr.execution.debugger.memory.Address;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "disassembly", "", "function", "functionOffset", "", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;Ljava/lang/String;Ljava/lang/String;I)V", "getAddress", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getDisassembly", "()Ljava/lang/String;", "getFunction", "getFunctionOffset", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "cidr-debugger"})
public final class LLInstruction {
    @NotNull
    private final Address address;
    @NotNull
    private final String disassembly;
    @Nullable
    private final String function;
    private final int functionOffset;

    @NotNull
    public final Address getAddress() {
        return this.address;
    }

    @NotNull
    public final String getDisassembly() {
        return this.disassembly;
    }

    @Nullable
    public final String getFunction() {
        return this.function;
    }

    public final int getFunctionOffset() {
        return this.functionOffset;
    }

    @JvmOverloads
    public LLInstruction(@NotNull Address address, @NotNull String disassembly, @Nullable String function, int functionOffset) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull((Object)disassembly, (String)"disassembly");
        this.address = address;
        this.disassembly = disassembly;
        this.function = function;
        this.functionOffset = functionOffset;
    }

    @JvmOverloads
    public /* synthetic */ LLInstruction(Address address, String string, String string2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        this(address, string, string2, n);
    }

    @JvmOverloads
    public LLInstruction(@NotNull Address address, @NotNull String disassembly, @Nullable String function) {
        this(address, disassembly, function, 0, 8, null);
    }

    @JvmOverloads
    public LLInstruction(@NotNull Address address, @NotNull String disassembly) {
        this(address, disassembly, null, 0, 12, null);
    }

    @NotNull
    public final Address component1() {
        return this.address;
    }

    @NotNull
    public final String component2() {
        return this.disassembly;
    }

    @Nullable
    public final String component3() {
        return this.function;
    }

    public final int component4() {
        return this.functionOffset;
    }

    @NotNull
    public final LLInstruction copy(@NotNull Address address, @NotNull String disassembly, @Nullable String function, int functionOffset) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull((Object)disassembly, (String)"disassembly");
        return new LLInstruction(address, disassembly, function, functionOffset);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ LLInstruction copy$default(LLInstruction lLInstruction, Address address, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            address = lLInstruction.address;
        }
        if ((n2 & 2) != 0) {
            string = lLInstruction.disassembly;
        }
        if ((n2 & 4) != 0) {
            string2 = lLInstruction.function;
        }
        if ((n2 & 8) != 0) {
            n = lLInstruction.functionOffset;
        }
        return lLInstruction.copy(address, string, string2, n);
    }

    public String toString() {
        return "LLInstruction(address=" + this.address + ", disassembly=" + this.disassembly + ", function=" + this.function + ", functionOffset=" + this.functionOffset + ")";
    }

    public int hashCode() {
        Address address = this.address;
        String string = this.disassembly;
        String string2 = this.function;
        return (((address != null ? ((Object)address).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + this.functionOffset;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LLInstruction)) break block3;
                LLInstruction lLInstruction = (LLInstruction)object;
                if (!Intrinsics.areEqual((Object)this.address, (Object)lLInstruction.address) || !Intrinsics.areEqual((Object)this.disassembly, (Object)lLInstruction.disassembly) || !Intrinsics.areEqual((Object)this.function, (Object)lLInstruction.function) || !(this.functionOffset == lLInstruction.functionOffset)) break block3;
            }
            return true;
        }
        return false;
    }
}

