/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLValue
extends UserDataHolderBase {
    @NotNull
    private final String myName;
    @NotNull
    private final String myType;
    @Nullable
    private final TypeClass myTypeClass;
    @NotNull
    private final String myReferenceExpression;
    private boolean myValid = true;

    public LLValue(@NotNull String name, @NotNull String type2, @Nullable TypeClass typeClass, @NotNull String referenceExpression) {
        this.myName = name;
        this.myType = type2;
        this.myTypeClass = typeClass;
        this.myReferenceExpression = referenceExpression;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getType() {
        return this.myType;
    }

    @Nullable
    public TypeClass getTypeClass() {
        return this.myTypeClass;
    }

    @NotNull
    public String getReferenceExpression() {
        return this.myReferenceExpression;
    }

    public boolean isValid() {
        return this.myValid;
    }

    public void setValid(boolean valid) {
        this.myValid = valid;
    }

    public String toString() {
        return this.myName + ":" + this.myType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LLValue value2 = (LLValue)((Object)o);
        if (this.myValid != value2.myValid) {
            return false;
        }
        if (!this.myName.equals(value2.myName)) {
            return false;
        }
        if (!this.myType.equals(value2.myType)) {
            return false;
        }
        if (this.myTypeClass != value2.myTypeClass) {
            return false;
        }
        return this.myReferenceExpression.equals(value2.myReferenceExpression);
    }

    public int hashCode() {
        int result2 = this.myName.hashCode();
        result2 = 31 * result2 + this.myType.hashCode();
        result2 = 31 * result2 + (this.myTypeClass != null ? this.myTypeClass.hashCode() : 0);
        result2 = 31 * result2 + this.myReferenceExpression.hashCode();
        result2 = 31 * result2 + (this.myValid ? 1 : 0);
        return result2;
    }

    public static enum TypeClass {
        CLASS_STRUCT,
        OBJC_POINTER,
        FUNCTION,
        BUILTIN;

    }
}

