/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import org.jetbrains.annotations.NotNull;

public class LLWatchpoint
extends LLCodepoint {
    @NotNull
    private final String myExpression;

    public LLWatchpoint(int id, @NotNull String expression2) {
        super(id);
        this.myExpression = expression2;
    }

    @NotNull
    public String getExpression() {
        return this.myExpression;
    }

    public String toString() {
        return "Watchpoint-" + this.getId() + "@" + this.myExpression;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LLWatchpoint that = (LLWatchpoint)o;
        return this.myExpression.equals(that.myExpression);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myExpression.hashCode();
        return result2;
    }

    public static enum Lifetime {
        STACK_FRAME("Stack Frame"),
        PERSISTENT("Persistent");

        private String myDisplayText;

        private Lifetime(String displayText) {
            this.myDisplayText = displayText;
        }

        public String toString() {
            return this.myDisplayText;
        }
    }

    public static enum AccessType {
        READ("-r", "Read", "hw-rwpt"),
        WRITE("", "Write", "wpt"),
        ANY("-a", "Any", "hw-awpt");

        private String myParam;
        private String myDisplayText;
        private String myTupleKey;

        private AccessType(String param, String displayText, String tupleKey) {
            this.myParam = param;
            this.myDisplayText = displayText;
            this.myTupleKey = tupleKey;
        }

        @NotNull
        public String getParamString() {
            return this.myParam;
        }

        public String toString() {
            return this.myDisplayText;
        }

        public String getTupleKey() {
            return this.myTupleKey;
        }
    }
}

