/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.util.ExecUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NotNullProducer;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.ExecutionQueueProcessor;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerIllegalStateException;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponse;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBVarsCache;
import com.jetbrains.cidr.execution.debugger.backend.gdb.MacOSDebugSymbols;
import com.jetbrains.cidr.execution.debugger.backend.gdb.MacOSSierraDuringStartupProgramTerminatedException;
import com.jetbrains.cidr.execution.debugger.backend.gdb.lang.GDBLanguage;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.pty4j.unix.PTYOutputStream;
import com.pty4j.unix.Pty;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.PrintFormat;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GDBDriver
extends DebuggerDriver {
    public static final Key<String> PRETTY_PRINTERS_PATH = Key.create((String)"GDBDriver.PRETTY_PRINTERS_PATH");
    public static final Key<Boolean> ENABLE_STL_PRETTY_PRINTERS = Key.create((String)"GDBDriver.ENABLE_STL_PRETTY_PRINTERS");
    private static final Key<LLValueLoader> LLVALUE_DATA_LOADER = Key.create((String)"GDBDriver.LLVALUE_DATA_LOADER");
    private static final Key<LLValueLoadedData> LLVALUE_DATA = Key.create((String)"GDBDriver.LLVALUE_DATA");
    private static final Key<GDBTuple> LLVALUE_CLASS_CHILDREN_CACHE = Key.create((String)"GDBDriver.LLVALUE_CLASS_CHILDREN");
    private static final Key<Integer> LLVALUE_CLASS_CHILDREN_COUNT_CACHE = Key.create((String)"GDBDriver.LLVALUE_CLASS_CHILDREN_COUNT_CACHE");
    private static final Key<MapElement> LLVALUE_MAP_ELEMENT = Key.create((String)"GDBDriver.LLVALUE_MAP_ELEMENT");
    private static final String INFERIOR_NOT_EXECUTING = "mi_cmd_exec_interrupt: Inferior not executing.";
    private static final String CANNOT_SET_WATCHPOINT_FOR_EXPRESSION = "Cannot set a watchpoint for this expression";
    private static final Pattern CANNOT_ACCESS_MEMORY_AT_ADDRESS = Pattern.compile("Cannot access memory at address 0x([0-9a-f]+)(?: .*)?");
    private static final Pattern BAD_INSTRUCTION_WITH_PREFIX_SUFFIX = Pattern.compile("^[^#]*(\\(bad\\)).*$");
    private static final Pattern INSTRUCTION_ENDING_WITH_ADDRESS_AND_SYMBOL_NAME = Pattern.compile("^([^#]*(?:0|0x[0-9a-f]+))\\s*(<.*>)\\s*$", 2);
    private static final Pattern ORIGINAL_LOCATION = Pattern.compile("(.*):(\\d+)");
    private static final Pattern PROMPT = Pattern.compile("[ ]*>");
    @Nullable
    private static Boolean ourShellAvailable;
    @Nullable
    private volatile Consumer<String> myFrameVarDisposeListener;
    @Nullable
    private volatile MIResponseFilter myMIResponseFilter;
    @Nullable
    private String myWinBreakPath;
    private volatile GeneralCommandLine myGdbCommandLine;
    private volatile boolean myEnableStlPrettyPrinters;
    @Nullable
    private volatile String myPrettyPrintersPath;
    private volatile OSProcessHandler myProcessHandler;
    private final DebuggerDriverConfiguration myStarter;
    private volatile boolean myRemoteTarget = false;
    private volatile boolean myMIAsyncMode = false;
    private volatile int myPromptLevel;
    private volatile OutputStream mySink;
    @Nullable
    private volatile PTYOutputStream myProcessInput;
    private final OutputStream myProcessInputProxy = new OutputStream(){

        @Override
        public void write(int i2) throws IOException {
            PTYOutputStream input = GDBDriver.this.myProcessInput;
            if (input != null) {
                input.write(i2);
            }
        }

        @Override
        public void write(byte[] bytes, int i2, int i1) throws IOException {
            PTYOutputStream input = GDBDriver.this.myProcessInput;
            if (input != null) {
                input.write(bytes, i2, i1);
            }
        }

        @Override
        public void close() throws IOException {
            PTYOutputStream input = GDBDriver.this.myProcessInput;
            if (input != null) {
                input.close();
            }
        }
    };
    private final Semaphore myCommandSemaphore = new Semaphore();
    private final ExecutionQueueProcessor myCommandProcessor;
    private final BlockingQueue<Response> myResultQueue = new LinkedBlockingQueue<Response>();
    private final Semaphore myInterrupted = new Semaphore();
    private final Semaphore myPendingForAttachNotification = new Semaphore();
    @Nullable
    private volatile Integer myTargetPID = null;
    @Nullable
    private volatile DebuggerDriver.StopPlace myStopPlace = null;
    @NotNull
    private volatile Communication myCommunication = new Communication("");
    @Nullable
    private volatile String myLastCommand = null;
    private boolean myIsConsoleCommand;
    private final List<GDBResponse.Record> myVarsDropPool = new ArrayList<GDBResponse.Record>();
    private final GDBVarsCache myVarsCache = new GDBVarsCache(this.myVarsDropPool::add);
    private final BidirectionalMap<String, String> myFrameVarIDCache = new BidirectionalMap();
    private final HashMap<String, LLValueLoadedData> myFrameVarDataCache = new HashMap();
    private static final Pattern VALUE_DESCRIPTION_PATTERN;

    public void setMIOutputFilterInTests(@NotNull @RegExp String regexp, @NotNull String replacement) {
        this.setMIOutputFilterInTests((NotNullFunction<String, String>)((NotNullFunction)s -> s.replaceAll(regexp, replacement)));
    }

    public void setMIOutputFilterInTests(@Nullable NotNullFunction<String, String> miOutputFilter) {
        this.setMIResponseFilterInTests(miOutputFilter == null ? null : (request, s) -> (String)miOutputFilter.fun((Object)s));
    }

    public void setMIResponseFilterInTests(@Nullable MIResponseFilter miResponseFilter) {
        this.myMIResponseFilter = miResponseFilter;
    }

    public void setFrameVarDisposeListenerInTests(@Nullable Consumer<String> listener2) {
        this.myFrameVarDisposeListener = listener2;
    }

    public GDBDriver(DebuggerDriver.Handler handler2, DebuggerDriverConfiguration starter) {
        super(handler2);
        this.myStarter = starter;
        this.myCommandProcessor = new ExecutionQueueProcessor();
    }

    @Override
    public boolean supportsWatchpointLifetime() {
        return true;
    }

    @Override
    @NotNull
    public Language getConsoleLanguage() {
        return GDBLanguage.INSTANCE;
    }

    @Override
    @NotNull
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @Override
    @Nullable
    public OutputStream getProcessInput() {
        return this.myProcessInputProxy;
    }

    @Override
    public void removeWatchpoint(List<Integer> ids) throws ExecutionException, DebuggerCommandException {
        this.removeCodepoints(ids);
    }

    @Override
    public void addSymbolsFile(File file2, File module2) {
    }

    @Override
    public boolean isInPromptMode() {
        return this.myPromptLevel > 0;
    }

    @Override
    public String getPromptText() {
        return "gdb";
    }

    @Override
    protected void setState(DebuggerDriver.TargetState state) {
        super.setState(state);
        if (this.getState() == DebuggerDriver.TargetState.SUSPENDED) {
            this.executeAsyncCommand(new VoidCommand(){

                @Override
                public void run() throws ExecutionException {
                    for (GDBResponse.Record record : GDBDriver.this.myVarsDropPool) {
                        GDBDriver.this.doDeleteVar(record);
                    }
                    GDBDriver.this.myVarsDropPool.clear();
                }
            });
        }
    }

    private void doDeleteVar(GDBResponse.Record var) {
        try {
            String name = var.getResultList().getRequiredString("name");
            this.sendRequestAndWaitForDone("-var-delete %s", GDBDriver.stringify(name));
        }
        catch (ExecutionException | DebuggerCommandException e) {
            CidrDebuggerLog.LOG.debug(e);
        }
    }

    @Override
    public void start(@NotNull Installer installer, @Nullable String architecture) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            assert (this.myProcessHandler == null) : "myProcessHandler is already initialized: " + this.myProcessHandler;
            this.myInstaller = installer;
            this.myGdbCommandLine = this.myStarter.createDriverCommandLine(this, installer);
            this.myPrettyPrintersPath = (String)this.myGdbCommandLine.getUserData(PRETTY_PRINTERS_PATH);
            this.myEnableStlPrettyPrinters = this.myGdbCommandLine.getUserData(ENABLE_STL_PRETTY_PRINTERS) == Boolean.TRUE;
            this.myGdbCommandLine.putUserData(PRETTY_PRINTERS_PATH, null);
            this.myProcessHandler = new OSProcessHandler(this.myGdbCommandLine){

                protected void doDestroyProcess() {
                    OSProcessUtil.killProcess(this.myProcess);
                }
            };
            this.myProcessHandler.setShouldDestroyProcessRecursively(false);
            this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
                StringBuilder myBuffer = new StringBuilder();

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        int end;
                        this.myBuffer.append(event.getText());
                        String content = this.myBuffer.toString();
                        boolean changed = false;
                        while ((end = content.indexOf("\n")) != -1) {
                            String response = content.substring(0, end).trim();
                            content = content.substring(end + 1);
                            changed = true;
                            MIResponseFilter filter = GDBDriver.this.myMIResponseFilter;
                            if (filter != null) {
                                response = filter.apply(((GDBDriver)GDBDriver.this).myCommunication.command, response);
                            }
                            GDBDriver.this.processResponse(response);
                        }
                        if (changed) {
                            this.myBuffer = new StringBuilder(content);
                        }
                    } else {
                        String text = event.getText();
                        if (text != null && CidrDebuggerLog.LOG.isDebugEnabled()) {
                            CidrDebuggerLog.LOG.debug("<" + text);
                        }
                        if (outputType == ProcessOutputTypes.STDERR) {
                            GDBDriver.this.handleTargetOutput(event.getText(), outputType);
                        }
                    }
                }

                public void processTerminated(ProcessEvent event) {
                    CidrDebuggerLog.LOG.info("Debugger exited with code " + event.getExitCode());
                    CidrDebuggerLog.LOG.debug("<[terminated]");
                    GDBDriver.this.cleanupOnTermination();
                    GDBDriver.this.handleExited(event.getExitCode());
                }
            });
            this.mySink = this.myProcessHandler.getProcessInput();
            this.myCommandSemaphore.down();
            this.handlePrompt();
            CidrDebuggerLog.LOG.info("Debugger started");
        });
    }

    @NotNull
    protected static String stringify(@NotNull String s) {
        StringBuilder buffer = new StringBuilder(s.length() + 2).append('\"');
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"\"", (StringBuilder)buffer);
        return buffer.append('\"').toString();
    }

    @NotNull
    protected static String shellQuote(@NotNull String s) {
        return String.format("'%s'", s.replace("'", "'\\''"));
    }

    private void warnUser(@NotNull String message2) {
        this.warnUser(message2, null);
    }

    private void warnUser(@NotNull String message2, @Nullable Throwable e) {
        message2 = message2.trim();
        this.handleTargetOutput(message2 + "\n\n", ProcessOutputTypes.SYSTEM);
        CidrDebuggerLog.LOG.warn(message2, e);
    }

    @Override
    public void setValuesFilteringEnabled(boolean enabled) throws ExecutionException {
    }

    private void doSetUpGDB() throws ExecutionException {
        try {
            this.doSetMaxDescription(true);
            this.gdbSet("print repeats", 0);
            this.gdbSet("print object", true);
            this.gdbSet("step-mode", true);
            this.doSetMIAsync(this.myRemoteTarget);
        }
        catch (DebuggerCommandException e) {
            this.warnUser("Cannot configure GDB defaults: " + e.getMessage(), e);
        }
        try {
            String printersPath = this.myPrettyPrintersPath;
            if (printersPath != null) {
                Response response;
                boolean hasSTLprinters;
                String script = "import sys\nsys.path.insert(0, " + GDBDriver.stringify(printersPath) + ")\n";
                script = script + "from default.printers import register_default_printers\nregister_default_printers(None)\n";
                if (this.myEnableStlPrettyPrinters && !(hasSTLprinters = (response = this.sendSilentRequestAndWaitForDone("info pretty-printer", new Object[0])).getOutput().contains("libstdc++-v6"))) {
                    script = script + "from libstdcxx.v6.printers import register_libstdcxx_printers\nregister_libstdcxx_printers(None)\n";
                }
                this.sendSilentRequestAndWaitForDone("python\n%s\nend", script);
                this.sendRequestAndWaitForDone("-enable-pretty-printing", new Object[0]);
            }
        }
        catch (GDBCommandException e) {
            this.warnUser("Error during pretty printers setup: " + e.getMessage() + "\n\nSome features and performance optimizations will not be available.\n\n" + e.getResponse().getOutput(), e);
        }
    }

    private void doSetMIAsync(boolean enabled) throws ExecutionException, DebuggerCommandException {
        this.gdbSet("mi-async", enabled);
        this.myMIAsyncMode = enabled;
    }

    private void doSetMaxDescription(boolean enabled) throws ExecutionException, DebuggerCommandException {
        this.gdbSet("print elements", enabled ? 1000 : 0);
    }

    protected void gdbSet(@NotNull String setting, boolean enabled) throws ExecutionException, DebuggerCommandException {
        this.gdbSet(setting, enabled ? "on" : "off");
    }

    protected void gdbSet(@NotNull String setting, int value2) throws ExecutionException, DebuggerCommandException {
        this.gdbSet(setting, String.valueOf(value2));
    }

    protected void gdbSet(@NotNull String setting, @Nullable String value2) throws ExecutionException, DebuggerCommandException {
        if (value2 != null && !StringUtil.containsLineBreak((CharSequence)value2)) {
            this.sendRequestAndWaitForDone("-gdb-set %s %s", setting, value2);
        } else {
            String command = value2 != null ? String.format("set %s %s", setting, value2) : String.format("unset %s", setting);
            this.sendRequestAndWaitForDone("%s", GDBDriver.createConsoleCommand(command));
        }
    }

    @NotNull
    protected GDBTuple gdbShow(@NotNull String setting) throws ExecutionException, DebuggerCommandException {
        return this.sendRequestAndWaitForDone("-gdb-show %s", setting).getResultList();
    }

    @Override
    public void loadForLaunch() throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            this.doSetUpGDB();
            this.doLoad();
        });
    }

    @Override
    public void loadForAttach() throws ExecutionException {
        this.executeCommandNoUserException(this::doSetUpGDB);
    }

    public void loadForRemote(@Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            this.myRemoteTarget = true;
            this.doSetUpGDB();
            if (symbolFile != null) {
                try {
                    this.doLoadExecutable(symbolFile);
                }
                catch (DebuggerCommandException e) {
                    throw new DebuggerCommandException("Cannot load symbol file: " + e.getMessage(), e);
                }
            }
            if (sysroot != null) {
                try {
                    this.gdbSet("sysroot", sysroot.getPath());
                }
                catch (DebuggerCommandException e) {
                    throw new DebuggerCommandException("Cannot set sysroot: " + e.getMessage(), e);
                }
            }
            for (DebuggerDriver.PathMapping each : pathMappings) {
                String from = FileUtil.toSystemIndependentName((String)each.from);
                String to = FileUtil.toSystemIndependentName((String)each.to);
                try {
                    this.sendRequestAndWaitForDone("-gdb-set substitute-path %s %s", GDBDriver.stringify(from), GDBDriver.stringify(to));
                    String envFrom = this.myStarter.convertToEnvPath(from);
                    if (from.equals(envFrom)) continue;
                    this.sendRequestAndWaitForDone("-gdb-set substitute-path %s %s", GDBDriver.stringify(envFrom), GDBDriver.stringify(to));
                }
                catch (DebuggerCommandException e) {
                    throw new DebuggerCommandException("Cannot set path mapping: " + e.getMessage(), e);
                }
            }
        });
    }

    protected void doLoad() throws ExecutionException, DebuggerCommandException {
        this.myTargetCommandLine = this.myInstaller.install();
        if (SystemInfo.isMac) {
            try {
                this.myIndirectSymbols = MacOSDebugSymbols.load(this.myTargetCommandLine);
            }
            catch (IOException e) {
                this.warnUser("Cannot create and read debug symbols: " + ExceptionUtil.getMessage((Throwable)e), e);
            }
        }
        this.doLoadExecutable(this.myInstaller.getExecutableFile());
    }

    private void doLoadExecutable(@NotNull File file2) throws ExecutionException, DebuggerCommandException {
        String path = file2.getPath();
        this.sendRequestAndWaitForDone("-file-exec-and-symbols %s", GDBDriver.stringify(FileUtil.toSystemIndependentName((String)path)));
        this.handleModulesLoaded(Collections.singletonList(path));
    }

    @Override
    public long launch() throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            CidrDebuggerLog.LOG.assertTrue(this.myTargetCommandLine != null, (Object)"target not loaded");
            this.printTargetCommandLine(this.myTargetCommandLine);
            Map gdbEnv = this.myGdbCommandLine.getEffectiveEnvironment();
            this.doPrepareInferiorEnv(this.myTargetCommandLine, gdbEnv);
            StringBuilder params = new StringBuilder();
            for (String each : this.myTargetCommandLine.getParametersList().getParameters()) {
                params.append(' ').append(SystemInfo.isWindows ? GDBDriver.stringify(each) : GDBDriver.shellQuote(each));
            }
            if (!this.myRemoteTarget && !SystemInfo.isWindows) {
                try {
                    Pty pty = new Pty(true);
                    PTYOutputStream processInput = pty.getOutputStream();
                    String slaveName = pty.getSlaveName();
                    this.sendRequestAndWaitForDone("-inferior-tty-set %s", GDBDriver.stringify(slaveName));
                    this.myProcessInput = processInput;
                }
                catch (IOException e) {
                    CidrDebuggerLog.LOG.error((Throwable)e);
                }
            }
            if (this.myToRedirect) {
                if (SystemInfo.isWindows) {
                    this.sendRequestAndWaitForDone("-gdb-set new-console on", new Object[0]);
                } else {
                    this.initReaders(true);
                    if (this.myReaders != null) {
                        String redirectParams = String.format(" 1> %s 2> %s", GDBDriver.shellQuote(this.myReaders.getOutFileAbsolutePath()), GDBDriver.shellQuote(this.myReaders.getErrFileAbsolutePath()));
                        String gdbShell = gdbEnv.getOrDefault("SHELL", "/bin/sh");
                        boolean isCsh = gdbShell.endsWith("csh");
                        if (!isCsh) {
                            params.append(redirectParams);
                        } else if (GDBDriver.isBourneShellAvailable()) {
                            this.doWrapExec(GDBDriver.getShellCommandLineString("exec \"$@\" " + redirectParams));
                        } else {
                            params.append(" >&! ").append(GDBDriver.shellQuote(this.myReaders.getOutFileAbsolutePath()));
                            this.warnUser(gdbShell + " doesn't support separate IO redirection.\nThe output will appear without stderr coloring");
                        }
                    } else {
                        CidrDebuggerLog.LOG.error("stderr/stdout readers are not initialized");
                    }
                }
            }
            this.doSelectWinbreakBinary();
            this.gdbSet("args", params.toString());
            try {
                this.sendRequestAndWaitForRunning("-exec-run", new Object[0]);
            }
            catch (GDBCommandException e) {
                if (SystemInfo.isMacOSSierra && e.getMessage().startsWith("During startup program terminated with")) {
                    throw new MacOSSierraDuringStartupProgramTerminatedException(e);
                }
                throw e;
            }
        });
        Integer pid = this.myTargetPID;
        CidrDebuggerLog.LOG.assertTrue(pid != null);
        return pid.intValue();
    }

    protected void doWrapExec(String wrapper) throws ExecutionException, DebuggerCommandException {
        String oldWrapper = this.gdbShow("exec-wrapper").getString("value");
        if (oldWrapper != null) {
            wrapper = wrapper + " " + oldWrapper;
        }
        this.gdbSet("exec-wrapper", wrapper);
    }

    protected static boolean isBourneShellAvailable() throws ExecutionException {
        if (ourShellAvailable == null) {
            ourShellAvailable = ExecUtil.execAndGetOutput((GeneralCommandLine)GDBDriver.getShellWrapper("exit \"$@\" 1> /dev/null 2> /dev/null", "0")).checkSuccess(CidrDebuggerLog.LOG);
        }
        return ourShellAvailable;
    }

    @NotNull
    protected static GeneralCommandLine getShellWrapper(@NotNull String command, String ... parameters2) {
        return new GeneralCommandLine(new String[]{"/bin/sh", "-c", command, "--"}).withParameters(parameters2);
    }

    @NotNull
    protected static String getShellCommandLineString(@NotNull String command) {
        return GDBDriver.getShellCommandLineString(GDBDriver.getShellWrapper(command, new String[0]));
    }

    @NotNull
    protected static String getShellCommandLineString(@NotNull GeneralCommandLine commandLine) {
        return commandLine.getCommandLineList(null).stream().map(GDBDriver::shellQuote).collect(Collectors.joining(" "));
    }

    protected void doPrepareInferiorEnv(GeneralCommandLine targetCommandLine, Map<String, String> gdbEnv) throws ExecutionException, DebuggerCommandException {
        boolean unbufferedIO;
        if (!targetCommandLine.isPassParentEnvironment()) {
            this.sendSilentRequestAndWaitForDone("unset env", new Object[0]);
            gdbEnv = Collections.emptyMap();
        }
        Map targetEnv = targetCommandLine.getEffectiveEnvironment();
        for (Map.Entry entry : ContainerUtil.diff((Map)targetEnv, gdbEnv).entrySet()) {
            String key2 = StringUtil.escapeLineBreak((String)((String)entry.getKey()));
            String value2 = (String)((Couple)entry.getValue()).first;
            this.gdbSet("env " + key2, value2);
        }
        if (SystemInfo.isMac && !(unbufferedIO = "YES".equalsIgnoreCase((String)targetEnv.get("NSUnbufferedIO")))) {
            this.warnUser("NSUnbufferedIO is not set, output may be delayed");
        }
    }

    protected void doSelectWinbreakBinary() throws ExecutionException, DebuggerCommandException {
        Pattern pattern;
        String command;
        if (!SystemInfo.isWindows || this.myMIAsyncMode) {
            return;
        }
        String winBreakName = null;
        if (this.myRemoteTarget) {
            command = "show configuration";
            pattern = Pattern.compile(".*--host=(\\S+).*");
        } else {
            command = "info target";
            pattern = Pattern.compile(".+, file type (.+)\\.");
        }
        Response response = this.sendSilentRequestAndWaitForDone("%s", command);
        String consoleOutput = response.getOutput();
        for (String eachLine : StringUtil.splitByLines((String)consoleOutput)) {
            Matcher matcher = pattern.matcher(eachLine);
            if (!matcher.matches()) continue;
            String type2 = matcher.group(1);
            if (type2.matches(".*\\bi\\d86\\b.*")) {
                winBreakName = "winbreak32.exe";
            } else if (type2.contains("86_64") || type2.contains("86-64")) {
                winBreakName = "winbreak64.exe";
            } else {
                throw new ExecutionException("Cannot determine architecture of the target: " + type2);
            }
            CidrDebuggerLog.LOG.debug("Winbreak selected: " + winBreakName + " for: " + type2);
            break;
        }
        if (winBreakName == null) {
            throw new ExecutionException("Cannot determine architecture of the target:\n" + consoleOutput);
        }
        File winBreakFile = CidrDebuggerPathManager.getWinbreakFile(winBreakName);
        if (!winBreakFile.exists()) {
            throw new ExecutionException("Cannot find " + winBreakFile.getPath());
        }
        this.myWinBreakPath = winBreakFile.getPath();
    }

    @Override
    public void attachTo(final int pid) throws ExecutionException {
        if (SystemInfo.isMac) {
            throw new ExecutionException("Attaching is unsupported for GDB on OS X");
        }
        this.executeCommandNoUserException(new AttachConnectCommand(){

            @Override
            protected void attach() throws ExecutionException, DebuggerCommandException {
                GDBDriver.this.buildRequest("-target-attach %d", pid).suppressRunningEvent(SystemInfo.isWindows).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
            }

            @Override
            protected void whenAttached() throws ExecutionException, DebuggerCommandException {
                GDBDriver.this.handleAttached(pid);
            }
        });
    }

    @Override
    public void attachByName(String name, boolean wait) throws ExecutionException {
        throw new ExecutionException("Attaching by name is not implemented for GDB");
    }

    @Override
    public void detach() throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            this.doInterruptAndWait();
            Response response = this.buildRequest("-target-detach", new Object[0]).suppressTargetFinishedEvent().send().waitFor(new GDBResponse.ResultRecord.Type[0]);
            String message2 = GDBDriver.getErrorMessage(response);
            if (message2 != null) {
                if (message2.equals("Remote connection closed") || message2.startsWith("Remote communication error.  Target disconnected.")) {
                    this.warnUser(message2);
                } else if (!message2.equals("The program is not being run.")) {
                    throw new GDBCommandException(response, message2);
                }
            }
            if (this.myRemoteTarget) {
                this.handleDisconnected();
            } else {
                this.handleDetached();
            }
        });
    }

    public void connectTo(final @NotNull String connectionString) throws ExecutionException {
        this.executeCommandNoUserException(new AttachConnectCommand(){

            @Override
            protected void attach() throws ExecutionException, DebuggerCommandException {
                GDBDriver.this.sendRequest("-target-select remote %s", connectionString).waitFor(GDBResponse.ResultRecord.Type.connected);
            }

            @Override
            protected void whenAttached() throws ExecutionException, DebuggerCommandException {
                GDBDriver.this.handleConnected(connectionString);
            }
        });
    }

    @Override
    public boolean interrupt() throws ExecutionException {
        return this.executeCommandNoUserException(this::doInterrupt);
    }

    private boolean doInterrupt() throws ExecutionException {
        this.throwIfTerminatedOrHasPendingErrors();
        Integer pid = this.myTargetPID;
        if (pid == null || this.getState() != DebuggerDriver.TargetState.RUNNING) {
            return false;
        }
        if (this.myMIAsyncMode) {
            this.doInterruptAsync();
        } else {
            this.doInterruptWithSignal(pid);
        }
        return true;
    }

    protected void doInterruptAsync() throws ExecutionException {
        try {
            this.sendRequestAndWaitForDone("-exec-interrupt", new Object[0]);
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.error((Throwable)e);
        }
    }

    protected void doInterruptWithSignal(int pid) throws ExecutionException {
        this.sendRequestOrSpecialCommunication("interrupt", (ThrowableRunnable<ExecutionException>)((ThrowableRunnable)() -> {
            if (SystemInfo.isWindows) {
                this.doInterruptWinBreak(pid);
            } else {
                GDBDriver.doInterruptSigInt(pid);
            }
        }));
    }

    private void doInterruptWinBreak(int pid) throws ExecutionException {
        CidrDebuggerLog.LOG.debug(">Sending interrupt signal using 'winbreak'");
        if (this.myWinBreakPath == null) {
            throw new ExecutionException("winbreak was not selected");
        }
        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{this.myWinBreakPath, Integer.toString(pid)}));
        String stderr = output.getStderr();
        CidrDebuggerLog.LOG.debug(stderr);
        int exitCode = output.getExitCode();
        if (exitCode != 0) {
            StringBuilder errorMessage;
            CidrDebuggerLog.LOG.debug("winbreak failed with exit code " + exitCode);
            try (Scanner scanner = new Scanner(new ByteArrayInputStream(stderr.getBytes(Charset.forName("UTF-8"))));){
                errorMessage = new StringBuilder();
                while (scanner.hasNext()) {
                    if (scanner.findInLine("ERROR: (.*)") != null) {
                        MatchResult result2 = scanner.match();
                        if (errorMessage.length() > 0) {
                            errorMessage.append('\n');
                        }
                        errorMessage.append(result2.group(1));
                    }
                    scanner.nextLine();
                }
            }
            throw new ExecutionException(errorMessage.toString());
        }
    }

    private static void doInterruptSigInt(int pid) throws ExecutionException {
        int signal = 2;
        String signalDisplayName = "'SIGINT' (" + signal + ")";
        String signalCommand = "Sending " + signalDisplayName + " to " + pid;
        CidrDebuggerLog.LOG.debug(">" + signalCommand);
        try {
            UnixProcessManager.sendSignal((int)pid, (int)signal);
        }
        catch (Throwable e) {
            throw new ExecutionException("Cannot send " + signalDisplayName + " to " + pid, e);
        }
    }

    private boolean doInterruptAndWait() throws ExecutionException {
        this.myInterrupted.down();
        try {
            if (this.doInterrupt()) {
                GDBDriver.waitForSemaphore(this.myInterrupted);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.myInterrupted.up();
        }
    }

    @Override
    public boolean resume() throws ExecutionException {
        return this.executeCommandNoUserException(this::doResume);
    }

    private boolean doResume() throws ExecutionException, DebuggerCommandException {
        return this.doResume(false);
    }

    private boolean doResume(boolean suppressRunningEvent) throws ExecutionException, DebuggerCommandException {
        if (this.getState() == DebuggerDriver.TargetState.NOT_READY) {
            return false;
        }
        try {
            this.buildRequest("-exec-continue %s", this.onStoppedThreadAndFrame()).suppressRunningEvent(suppressRunningEvent).send().waitFor(GDBResponse.ResultRecord.Type.running);
            return true;
        }
        catch (GDBCommandException e) {
            if (GDBDriver.messageContains(e, "The program is not being run.")) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void stepOver(boolean stepByInstruction) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            try {
                DebuggerDriver.StopPlace stopPlace = this.myStopPlace;
                if (SystemInfo.isMac && stopPlace != null && stopPlace.frame.getFile() == null) {
                    DebuggerDriver.ResultList<LLFrame> currentFrames = this.doGetFrames(stopPlace.thread.getId(), 1, 10, false);
                    boolean noFrameWithDebug = true;
                    for (LLFrame frame : currentFrames.list) {
                        if (frame.getFile() == null) continue;
                        noFrameWithDebug = false;
                        break;
                    }
                    if (noFrameWithDebug) {
                        this.doResume();
                        return;
                    }
                }
                this.sendRequestAndWaitForRunning("-exec-next%s", stepByInstruction ? "-instruction" : "");
            }
            catch (GDBCommandException e) {
                if (GDBDriver.messageContains(e, "Cannot find bounds of current function")) {
                    this.doResume();
                    return;
                }
                throw e;
            }
        });
    }

    @Override
    public void stepInto(boolean stepByInstruction) throws ExecutionException {
        this.executeCommandNoUserException(() -> this.sendRequestAndWaitForRunning("-exec-step%s %s", stepByInstruction ? "-instruction" : "", this.onStoppedThreadAndFrame()));
    }

    @Override
    public void stepOut() throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            Response response = this.sendRequestAndWaitForDone("-stack-info-depth %s", this.onStoppedThreadAndFrame());
            if (response.getResultList().getRequiredInt("depth") != 1) {
                this.sendRequestAndWaitForRunning("-exec-finish %s", this.onStoppedThreadAndFrame());
            } else {
                this.sendRequestAndWaitForRunning("-exec-continue %s", this.onStoppedThreadAndFrame());
            }
        });
    }

    @Override
    public void runTo(String path, int line) throws ExecutionException {
        this.executeCommandNoUserException(() -> this.sendRequestAndWaitForRunning("-exec-until %s %s", this.onStoppedThreadAndFrame(), GDBDriver.atSourceLine(path, line)));
    }

    @Override
    public boolean abort() throws ExecutionException {
        return this.executeCommandNoUserException(() -> {
            if (this.getState() == DebuggerDriver.TargetState.NOT_READY) {
                return false;
            }
            this.doInterruptAndWait();
            this.sendRequest("-gdb-exit", new Object[0]).waitFor(GDBResponse.ResultRecord.Type.exit);
            return true;
        });
    }

    @Override
    @NotNull
    public LLWatchpoint addWatchpoint(long threadId, int frameIndex, LLValue value2, String expr, LLWatchpoint.Lifetime lifetime, LLWatchpoint.AccessType accessType) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> {
            if (this.getState() == DebuggerDriver.TargetState.RUNNING) {
                throw new ExecutionException("Cannot set watchpoint while program is running");
            }
            String watchpointExpression = this.doGetWatchpointExpression(threadId, frameIndex, lifetime, expr);
            Response response = this.sendRequestAndWaitForDone("-break-watch %s %s", accessType.getParamString(), GDBDriver.stringify(watchpointExpression));
            return GDBDriver.readWatchpoint(response.getResultList(), accessType);
        });
    }

    @NotNull
    private String doGetWatchpointExpression(long threadId, int frameIndex, LLWatchpoint.Lifetime lifetime, String expression2) throws ExecutionException, DebuggerCommandException {
        if (lifetime == LLWatchpoint.Lifetime.PERSISTENT) {
            LLValue evaluated = this.doEvaluate(threadId, frameIndex, "&(" + expression2 + ")", null);
            String value2 = GDBDriver.doLoadVariable((LLValue)evaluated).data.getValue();
            if (value2.isEmpty()) {
                throw new DebuggerCommandException(CANNOT_SET_WATCHPOINT_FOR_EXPRESSION);
            }
            expression2 = "*" + value2;
        }
        return expression2;
    }

    private static LLWatchpoint readWatchpoint(GDBTuple resultList, LLWatchpoint.AccessType accessType) throws ExecutionException {
        GDBTuple tuple = resultList.getRequiredTuple(accessType.getTupleKey());
        return new LLWatchpoint(tuple.getRequiredInt("number"), tuple.getRequiredString("exp"));
    }

    @Override
    @NotNull
    public List<LLBreakpoint> addBreakpoint(String path, int line, @Nullable String condition2) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                Response response = this.sendRequestAndWaitForDone("-break-insert -f %s", GDBDriver.atSourceLine(path, line));
                List<GDBTuple> bkpts = response.getResultList().getAll("bkpt", GDBTuple.class);
                ArrayList<LLBreakpoint> breakpoints = new ArrayList<LLBreakpoint>(bkpts.size());
                for (GDBTuple bkpt : bkpts) {
                    if (bkpt == null) continue;
                    String error = null;
                    if (condition2 != null) {
                        try {
                            this.sendRequestAndWaitForDone("-break-condition %d %s", bkpt.getRequiredInt("number"), condition2);
                        }
                        catch (GDBCommandException e) {
                            error = e.getMessage();
                        }
                    }
                    breakpoints.add(GDBDriver.readBreakpoint(bkpt, path, condition2, error));
                }
                if (breakpoints.isEmpty()) {
                    throw new DebuggerCommandException("No code at this line");
                }
                ArrayList<LLBreakpoint> arrayList = breakpoints;
                return arrayList;
            }
            finally {
                if (interrupted) {
                    this.doResume(true);
                }
            }
        });
    }

    @Override
    @NotNull
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> {
            StringBuilder commandSb = new StringBuilder();
            commandSb.append("-break-insert -f ").append(symBreakpoint.getPattern());
            if (symBreakpoint.getThreadId() != 0L) {
                commandSb.append(" -p ").append(symBreakpoint.getThreadId());
            }
            Response response = this.sendRequestAndWaitForDone("%s", commandSb.toString());
            GDBTuple pairs = response.getResultList();
            for (Pair each : pairs) {
                GDBTuple bkpt = (GDBTuple)each.second;
                if (bkpt == null) continue;
                int number = bkpt.getRequiredInt("number");
                return new LLSymbolicBreakpoint(number);
            }
            throw new DebuggerCommandException("No code at this line");
        });
    }

    @Override
    public void removeCodepoints(@NotNull Collection<Integer> ids) throws ExecutionException, DebuggerCommandException {
        this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                for (Integer each : ids) {
                    this.sendRequestAndWaitForDone("-break-delete %d", each);
                }
            }
            finally {
                if (interrupted) {
                    this.doResume(true);
                }
            }
        });
    }

    private static LLBreakpoint readBreakpoint(GDBTuple info, @NotNull String path, String condition2, String error) throws ExecutionException, DebuggerCommandException {
        int number = info.getRequiredInt("number");
        int line = -1;
        boolean pending = info.getString("pending") != null;
        boolean multipleLocations = info.getString("addr", "<MULTIPLE>").equals("<MULTIPLE>");
        if (multipleLocations) {
            String originalLocation = info.getRequiredStringOrThrow("original-location", msg -> {
                CidrDebuggerLog.LOG.warn(msg);
                return new DebuggerCommandException("GDB does not allow to set breakpoint here");
            });
            Matcher matcher = ORIGINAL_LOCATION.matcher(originalLocation);
            if (matcher.find()) {
                line = Integer.parseInt(matcher.group(2)) - 1;
            }
        } else if (!pending) {
            line = info.getInt("line", 0) - 1;
        }
        return new LLBreakpoint(number, path, line, pending, condition2, error);
    }

    @NotNull
    private DebuggerDriver.StopPlace doReadStopPlace(@NotNull GDBTuple stopTuple) throws ExecutionException {
        long threadId = stopTuple.getRequiredInt("thread-id");
        LLThread thread = new LLThread(threadId, "STOPPED", null);
        GDBTuple frameTuple = stopTuple.getRequiredTupleOrThrow("frame", () -> new ExecutionException("Cannot read stop place: " + stopTuple));
        LLFrame frame = this.doReadFrame(0, frameTuple);
        return new DebuggerDriver.StopPlace(thread, frame);
    }

    @Override
    @NotNull
    public List<LLThread> getThreads() throws ExecutionException, DebuggerCommandException {
        return (List)this.executeCommand(this::doGetThreads);
    }

    @NotNull
    private List<LLThread> doGetThreads() throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-thread-info", new Object[0]);
        GDBTuple threads = response.getResultList().getRequiredTuple("threads");
        ArrayList<LLThread> result2 = new ArrayList<LLThread>(threads.size());
        for (GDBTuple each : threads) {
            int id = each.getRequiredInt("id");
            String name = each.getString("name");
            String state = each.getRequiredString("state");
            result2.add(new LLThread(id, state.toUpperCase(), null, name));
        }
        Collections.sort(result2, Comparator.comparingLong(LLThread::getId));
        return result2;
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLFrame> getFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> this.doGetFrames(threadId, from, count, untilFirstLineWithCode));
    }

    @NotNull
    private DebuggerDriver.ResultList<LLFrame> doGetFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequest("-stack-list-frames --thread %d %d %d", threadId, from, from + count).waitFor(new GDBResponse.ResultRecord.Type[0]);
        GDBTuple stack = response.getResultList().getTuple("stack");
        List<GDBTuple> frames = stack == null ? null : stack.getAll("frame", GDBTuple.class);
        String msg = GDBDriver.getErrorMessage(response);
        if (frames == null) {
            if (msg != null && msg.contains(" Not enough frames in stack")) {
                return DebuggerDriver.ResultList.empty();
            }
            throw new DebuggerCommandException(msg != null ? msg : "Cannot collect frames");
        }
        if (msg != null) {
            this.warnUser(msg);
        }
        ArrayList<LLFrame> result2 = new ArrayList<LLFrame>(frames.size());
        for (int i2 = 0; i2 < Math.min(frames.size(), count); ++i2) {
            GDBTuple each = frames.get(i2);
            LLFrame frame = this.doReadFrame(each.getRequiredInt("level"), each);
            result2.add(frame);
            if (untilFirstLineWithCode && frame.getLine() != -1) break;
        }
        boolean hasMore = result2.size() < frames.size();
        return DebuggerDriver.ResultList.create(result2, hasMore);
    }

    @NotNull
    private LLFrame doReadFrame(int level, @NotNull GDBTuple frameTuple) {
        String func = frameTuple.getString("func");
        String addrStr = frameTuple.getString("addr");
        String fullname = frameTuple.getString("fullname");
        String file2 = this.myStarter.convertToLocalPath(fullname != null ? fullname : frameTuple.getString("file"));
        int line = -1;
        if (file2 != null) {
            line = frameTuple.getInt("line", 0) - 1;
        }
        Address addr = Address.NULL;
        if (addrStr != null) {
            try {
                addr = GDBDriver.parseAddress(addrStr);
            }
            catch (ExecutionException e) {
                CidrDebuggerLog.LOG.warn((Throwable)e);
            }
        }
        return new LLFrame(level, func, file2, line, addr, null, false);
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        return (List)this.executeCommand(() -> this.doGetFrameVariables(threadId, frameIndex));
    }

    @NotNull
    private String doGetFrameAddr(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-data-evaluate-expression %s $fp", GDBDriver.onThreadAndFrame(threadId, frameIndex));
        String value2 = response.getResultList().getRequiredStringOrThrow("value", () -> new ExecutionException("Cannot evaluate frame address for thread: " + threadId + " frame: " + frameIndex));
        String address = LLValueData.getPointer(value2);
        if (address == null) {
            throw new ExecutionException("Cannot parse frame address: " + value2);
        }
        return address;
    }

    @NotNull
    private List<LLValue> doGetFrameVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        SmartList result2 = new SmartList();
        String currentFrameAddr = this.doGetFrameAddr(threadId, frameIndex);
        for (Object o : this.doUpdateAndListFrameVariables(threadId, frameIndex, currentFrameAddr)) {
            result2.add(this.doReadVariable((GDBTuple)o, "", currentFrameAddr));
        }
        return result2;
    }

    @Override
    @NotNull
    public LLValueData getData(@NotNull LLValue value2) throws ExecutionException, DebuggerCommandException {
        return (LLValueData)this.executeCommand(() -> GDBDriver.doLoadVariable((LLValue)value2).data);
    }

    @Override
    @Nullable
    public String getDescription(@NotNull LLValue value2, int maxLength) throws ExecutionException, DebuggerCommandException {
        return (String)this.executeCommand(() -> {
            Response response;
            boolean lengthChanged;
            String id = GDBDriver.doLoadVariable((LLValue)value2).id;
            boolean bl = lengthChanged = maxLength != 1000;
            if (lengthChanged) {
                this.doSetMaxDescription(false);
            }
            try {
                if (lengthChanged) {
                    this.sendRequestAndWaitForDone("-var-update --no-values %s", GDBDriver.stringify(id));
                }
                response = this.sendRequestAndWaitForDone("-var-evaluate-expression %s", GDBDriver.stringify(id));
            }
            finally {
                if (lengthChanged) {
                    this.doSetMaxDescription(true);
                }
            }
            return (String)GDBDriver.getDescriptionFromValue((String)response.getResultList().getRequiredString((String)"value")).second;
        });
    }

    @NotNull
    public String getVariableID(@NotNull LLValue value2) throws ExecutionException, DebuggerCommandException {
        return (String)this.executeCommand(() -> GDBDriver.doLoadVariable((LLValue)value2).id);
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(LLValue value2, int from, int count) throws ExecutionException, DebuggerCommandException {
        return (DebuggerDriver.ResultList)this.executeCommand(() -> this.doGetVariableChildren(value2, from, count));
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetVariableChildren(final @NotNull LLValue var, final int offset, final int count) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData data = GDBDriver.doLoadVariable(var);
        MapElement mapElement = (MapElement)var.getUserData(LLVALUE_MAP_ELEMENT);
        if (mapElement != null) {
            int endOffset = offset + count;
            List<LLValue> all = Arrays.asList(mapElement.getKey(), mapElement.getValue());
            List<LLValue> list = all.subList(Math.min(offset, 2), Math.min(endOffset, 2));
            boolean hasMore = endOffset < 2;
            return DebuggerDriver.ResultList.create(list, hasMore);
        }
        if (data.isMap) {
            return this.doGetMapChildren(var, offset, count);
        }
        final ArrayList result2 = new ArrayList();
        boolean readAsStruct = this.doVisitCppClassChildren(var, new StructChildrenVisitor(){
            int currentOffset;
            int restCount;
            {
                this.currentOffset = offset;
                this.restCount = count;
            }

            @Override
            public boolean visitRealChild(@NotNull GDBTuple child) throws ExecutionException {
                if (this.currentOffset >= 1) {
                    --this.currentOffset;
                    return true;
                }
                result2.add(GDBDriver.this.doReadVariable(child, var.getReferenceExpression(), null));
                --this.restCount;
                this.currentOffset = Math.max(0, this.currentOffset - 1);
                return this.restCount != 0;
            }

            @Override
            public boolean visitFakeChild(@NotNull LLValue fakeChild, int childrenCount) throws ExecutionException, DebuggerCommandException {
                if (this.currentOffset >= childrenCount) {
                    this.currentOffset -= childrenCount;
                    return true;
                }
                int innerEndPos = Math.min(this.currentOffset + this.restCount, childrenCount);
                result2.addAll(((GDBDriver)GDBDriver.this).doGetPlainVariableChildren((LLValue)fakeChild, (int)this.currentOffset, (int)innerEndPos).list);
                this.restCount -= innerEndPos - this.currentOffset;
                this.currentOffset = 0;
                return this.restCount != 0;
            }
        });
        if (readAsStruct) {
            int childrenCount = this.doGetChildrenCount(var);
            boolean hasMore = offset + result2.size() < childrenCount;
            return DebuggerDriver.ResultList.create(result2, hasMore);
        }
        return this.doGetPlainVariableChildren(var, offset, offset + count);
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetPlainVariableChildren(@NotNull LLValue var, int offset, int endPos) throws ExecutionException, DebuggerCommandException {
        if (offset > endPos) {
            throw new ExecutionException("Internal error, incorrect children range. from = " + offset + " to = " + endPos);
        }
        Pair<GDBTuple, Boolean> childList = this.doListChildren(var, offset, endPos);
        ArrayList<LLValue> result2 = new ArrayList<LLValue>();
        boolean hasMore = (Boolean)childList.second;
        for (Object o : (GDBTuple)childList.first) {
            GDBTuple each = GDBDriver.getChildTuple((GDBTuple)childList.first, o);
            if (each == null) {
                hasMore = false;
                break;
            }
            result2.add(this.doReadVariable(each, var.getReferenceExpression(), null));
        }
        return DebuggerDriver.ResultList.create(result2, hasMore);
    }

    @NotNull
    private Pair<GDBTuple, Boolean> doListChildren(@NotNull LLValue var, int offset, int endPos) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData loaded = GDBDriver.doLoadVariable(var);
        if (!loaded.mayHaveChildren()) {
            return Pair.create((Object)new GDBTuple(), (Object)false);
        }
        String id = loaded.id;
        Response response = this.sendRequestAndWaitForDone("-var-list-children --simple-values %s %d %d", GDBDriver.stringify(id), offset, endPos);
        GDBTuple resultList = response.getResultList();
        GDBTuple children2 = resultList.getTupleOrEmpty("children");
        boolean hasMore = resultList.getBoolean("has_more");
        if (hasMore) {
            this.sendRequestAndWaitForDone("-var-set-update-range %s 0 %d", GDBDriver.stringify(id), endPos);
        }
        return Pair.create((Object)children2, (Object)hasMore);
    }

    private boolean doVisitCppClassChildren(@NotNull LLValue var, @NotNull StructChildrenVisitor visitor) throws ExecutionException, DebuggerCommandException {
        Object o;
        GDBTuple each;
        Integer childrenCount = GDBDriver.doLoadVariable((LLValue)var).childrenCount;
        if (childrenCount == null) {
            return false;
        }
        if (childrenCount == 0) {
            return true;
        }
        if (childrenCount > 10) {
            return false;
        }
        GDBTuple children2 = (GDBTuple)var.getUserData(LLVALUE_CLASS_CHILDREN_CACHE);
        if (children2 == null) {
            children2 = (GDBTuple)this.doListChildren((LLValue)var, (int)-1, (int)-1).first;
            var.putUserData(LLVALUE_CLASS_CHILDREN_CACHE, children2);
        }
        Iterator iterator = children2.iterator();
        while (iterator.hasNext() && (each = GDBDriver.getChildTuple(children2, o = iterator.next())) != null) {
            if (each.getString("type") != null) {
                if (visitor.visitRealChild(each)) continue;
                break;
            }
            String name = each.getRequiredStringOrThrow("name", msg -> new ExecutionException("Internal error: Unexpected gdb fake variable: " + msg));
            LLValue fakeValue = new LLValue("", "", null, name);
            int numchild = each.getInt("numchild", 0);
            GDBDriver.doUpdateLoadedData(fakeValue, new LLValueLoadedData(name, numchild, false, false, false, ""));
            if (visitor.visitFakeChild(fakeValue, numchild)) continue;
            break;
        }
        return true;
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetMapChildren(LLValue var, int offset, int count) throws ExecutionException, DebuggerCommandException {
        Pair<GDBTuple, Boolean> childList = this.doListChildren(var, offset * 2, (offset + count) * 2);
        ArrayList<LLValue> result2 = new ArrayList<LLValue>();
        boolean hasMore = (Boolean)childList.second;
        int size = ((GDBTuple)childList.first).size();
        for (int i2 = 0; i2 < size - 1; i2 += 2) {
            GDBTuple keyTuple = GDBDriver.getChildTuple((GDBTuple)childList.first, ((GDBTuple)childList.first).get(i2));
            GDBTuple valueTuple = GDBDriver.getChildTuple((GDBTuple)childList.first, ((GDBTuple)childList.first).get(i2 + 1));
            if (keyTuple == null || valueTuple == null) {
                hasMore = false;
                break;
            }
            LLValue key2 = this.doReadVariable(keyTuple, var.getReferenceExpression(), null, "first");
            LLValue value2 = this.doReadVariable(valueTuple, var.getReferenceExpression(), null, "second");
            LLValue element = new LLValue("[" + (offset + i2 / 2) + "]", "std::pair<" + key2.getType() + ", " + value2.getType() + ">", null, value2.getReferenceExpression());
            element.putUserData(LLVALUE_DATA, new LLValueLoadedData("<map element>", 2, false, false, false, ""));
            element.putUserData(LLVALUE_MAP_ELEMENT, new MapElement(key2, value2));
            result2.add(element);
        }
        return DebuggerDriver.ResultList.create(result2, hasMore);
    }

    @Nullable
    private static GDBTuple getChildTuple(GDBTuple varObjList, Object o) throws ExecutionException {
        if (!(o instanceof Pair)) {
            throw new ExecutionException("Invalid object in the list: " + varObjList);
        }
        Pair p = (Pair)o;
        if (!"child".equals(p.first)) {
            throw new ExecutionException("pair.first required to be \"child\": " + p.toString());
        }
        GDBTuple result2 = (GDBTuple)p.second;
        String name = result2.getString("name");
        return name != null && name.matches(".*\\.<error at.*") ? null : result2;
    }

    @NotNull
    private GDBResponse.Record doCreateVar(@NotNull String frameAddress, @NotNull String expression2) throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-var-create - %s %s", frameAddress, GDBDriver.stringify(expression2));
        if (response.getReceivedSignalCount() != 0) {
            String id = response.getResultList().getRequiredString("name");
            this.sendRequestAndWaitForDone("-var-set-frozen %s 1", GDBDriver.stringify(id));
        }
        return response.getRecord();
    }

    @NotNull
    private LLValue doReadVariable(@NotNull GDBTuple varTuple, @NotNull String parentRef, @Nullable String currentFrameAddr) throws ExecutionException {
        return this.doReadVariable(varTuple, parentRef, currentFrameAddr, null);
    }

    @NotNull
    private LLValue doReadVariable(@NotNull GDBTuple varTuple, @NotNull String parentRef, @Nullable String frameAddress, @Nullable String displayName) throws ExecutionException {
        String name = varTuple.getString("name");
        String type2 = varTuple.getString("type");
        boolean invalid = name == null || type2 == null;
        name = StringUtil.notNullize((String)name, (String)"<unknown>");
        type2 = StringUtil.notNullize((String)type2, (String)"<unknown>");
        String id = name;
        String exp = varTuple.getString("exp");
        if (exp != null) {
            name = exp;
        }
        String value2 = GDBDriver.fixRefValue(type2, varTuple.getString("value"));
        LLValue result2 = new LLValue(displayName != null ? displayName : name, GDBDriver.fixType(type2), null, parentRef.isEmpty() ? name : parentRef + "." + name);
        if (invalid) {
            GDBDriver.doUpdateLoadedData(result2, new LLValueLoadedData("", 0, false, false, false, StringUtil.notNullize((String)value2)));
        } else {
            boolean isFrameVariable;
            LLValueLoader loader = null;
            boolean bl = isFrameVariable = frameAddress != null;
            if (isFrameVariable) {
                loader = new FrameValueLoader(frameAddress, value2);
            } else {
                LLValueLoadedData data = GDBDriver.doReadLoadedData(varTuple, id, StringUtil.notNullize((String)value2));
                if (value2 == null) {
                    loader = new CreatedValueLoader(data);
                } else {
                    GDBDriver.doUpdateLoadedData(result2, data);
                }
            }
            result2.putUserData(LLVALUE_DATA_LOADER, loader);
        }
        return result2;
    }

    @NotNull
    private static LLValueLoadedData doLoadVariable(@NotNull LLValue value2) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData data;
        LLValueLoader loader = (LLValueLoader)value2.getUserData(LLVALUE_DATA_LOADER);
        if (loader != null) {
            loader.loadValue(value2);
            value2.putUserData(LLVALUE_DATA_LOADER, null);
        }
        if ((data = (LLValueLoadedData)value2.getUserData(LLVALUE_DATA)) == null) {
            throw new ExecutionException("Internal error, variable is not initialized: " + (Object)((Object)value2));
        }
        return data;
    }

    @NotNull
    private static LLValueLoadedData doReadLoadedData(@NotNull GDBTuple varTuple, @NotNull String id, @NotNull String value2) throws ExecutionException {
        Integer childrenCount = null;
        boolean isDynamic = varTuple.getBoolean("dynamic");
        boolean hasDynamicChildren = false;
        if (isDynamic) {
            hasDynamicChildren = varTuple.getBoolean("has_more", true);
        } else {
            childrenCount = varTuple.getInt("numchild", 0);
        }
        boolean isMap = "map".equals(varTuple.getString("displayhint"));
        return new LLValueLoadedData(id, childrenCount, isDynamic, hasDynamicChildren, isMap, value2);
    }

    @NotNull
    private static LLValueLoadedData doUpdateLoadedData(@NotNull LLValue var, @NotNull LLValueLoadedData data) {
        var.putUserData(LLVALUE_DATA, data);
        return data;
    }

    @Override
    @Nullable
    public Integer getChildrenCount(@NotNull LLValue var, int max) throws ExecutionException, DebuggerCommandException {
        return (Integer)this.executeCommand(() -> Math.min(this.doGetChildrenCount(var), max));
    }

    @Nullable
    private Integer doGetChildrenCount(LLValue var) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData data = GDBDriver.doLoadVariable(var);
        Integer nullableChildrenCount = data.childrenCount;
        if (nullableChildrenCount == null) {
            return null;
        }
        MapElement mapElement = (MapElement)var.getUserData(LLVALUE_MAP_ELEMENT);
        if (mapElement != null) {
            return nullableChildrenCount;
        }
        Integer classChildrenCountCache = (Integer)var.getUserData(LLVALUE_CLASS_CHILDREN_COUNT_CACHE);
        if (classChildrenCountCache != null) {
            return classChildrenCountCache;
        }
        final int[] childrenCount = new int[]{nullableChildrenCount};
        if (this.doVisitCppClassChildren(var, new StructChildrenVisitor(){

            @Override
            public boolean visitFakeChild(@NotNull LLValue fakeChild, int fakeChildrenCount) {
                childrenCount[0] = childrenCount[0] - 1;
                childrenCount[0] = childrenCount[0] + fakeChildrenCount;
                return true;
            }
        })) {
            var.putUserData(LLVALUE_CLASS_CHILDREN_COUNT_CACHE, childrenCount[0]);
        }
        return childrenCount[0];
    }

    private static String fixRefValue(@Nullable String type2, @Nullable String value2) {
        if (type2 != null && value2 != null && type2.endsWith("&")) {
            return value2.replaceFirst("(?i)^@0x[0-9a-f]+: ", "");
        }
        return value2;
    }

    private static String fixType(@Nullable String type2) {
        return type2 == null ? null : type2.replace("'", "");
    }

    @Override
    @NotNull
    public LLValue evaluate(final long threadId, final int frameIndex, final @NotNull String expression2, @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DebuggerCommandException {
        final String debuggerLanguage = GDBDriver.convertLanguage(language);
        return this.executeCommand(new EvaluationCommand<LLValue>(expression2){

            @Override
            public LLValue call() throws ExecutionException, DebuggerCommandException {
                return GDBDriver.this.doEvaluate(threadId, frameIndex, expression2, debuggerLanguage);
            }
        });
    }

    @Override
    @NotNull
    public List<LLInstruction> disassemble(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        return this.executeCommand(() -> {
            Response response = this.doDataDisassemble(range, true);
            if (response.getRecord().getType() == GDBResponse.ResultRecord.Type.error) {
                Matcher matcher = CANNOT_ACCESS_MEMORY_AT_ADDRESS.matcher(response.getResultList().getString("msg", ""));
                if (!matcher.matches()) {
                    throw GDBDriver.throwGDBError(response);
                }
                Address badAddress = Address.parseHexString(matcher.group(1));
                AddressRange smallerRange = range.getStart().rangeTo(badAddress.minus(1));
                if (smallerRange.isEmpty() || !range.covers(smallerRange)) {
                    throw GDBDriver.throwGDBError(response);
                }
                response = this.doDataDisassemble(smallerRange, false);
            }
            GDBTuple asmInsns = response.getResultList().getRequiredTuple("asm_insns");
            ArrayList<LLInstruction> result2 = new ArrayList<LLInstruction>(asmInsns.size());
            for (GDBTuple asmInsn : asmInsns) {
                String disassembly = asmInsn.getRequiredString("inst").trim();
                if (BAD_INSTRUCTION_WITH_PREFIX_SUFFIX.matcher(disassembly).matches()) {
                    disassembly = String.format("/* BAD: %s */", asmInsn.getRequiredString("opcodes"));
                }
                disassembly = INSTRUCTION_ENDING_WITH_ADDRESS_AND_SYMBOL_NAME.matcher(disassembly).replaceAll("$1  # $2");
                result2.add(new LLInstruction(asmInsn.getRequiredAddress("address"), disassembly));
            }
            return result2;
        });
    }

    @NotNull
    private Response doDataDisassemble(@NotNull AddressRange range, boolean allowError) throws ExecutionException, DebuggerCommandException {
        return this.sendRequest("-data-disassemble -s %s -e %s -- 2", range.getStart(), range.getEndCoerced()).waitFor(GDBResponse.ResultRecord.Type.done, allowError ? GDBResponse.ResultRecord.Type.error : GDBResponse.ResultRecord.Type.done);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLValue doEvaluate(long threadId, int frameIndex, String expression2, @Nullable String language) throws ExecutionException, DebuggerCommandException {
        GDBResponse.Record response = this.myVarsCache.getFromCache(expression2);
        if (response != null) {
            String name = response.getResultList().getRequiredString("name");
            this.sendRequestAndWaitForDone("-var-update %s", GDBDriver.stringify(name));
        } else {
            if (language != null) {
                this.sendRequestAndWaitForDone("-gdb-set language %s", language);
            }
            try {
                String currentFrameAddr = this.doGetFrameAddr(threadId, frameIndex);
                response = this.doCreateVar(currentFrameAddr, expression2);
            }
            finally {
                if (language != null) {
                    this.sendRequestAndWaitForDone("-gdb-set language auto", new Object[0]);
                }
            }
            this.myVarsCache.putIntoCache(expression2, response);
        }
        return this.doReadVariable(response.getResultList(), "", null, null);
    }

    @Nullable
    private static String convertLanguage(@Nullable DebuggerDriver.DebuggerLanguage language) throws DebuggerCommandException {
        if (language == null) {
            return null;
        }
        if (language instanceof DebuggerDriver.StandardDebuggerLanguage) {
            switch ((DebuggerDriver.StandardDebuggerLanguage)language) {
                case C: {
                    return "c";
                }
                case C_PLUS_PLUS: {
                    return "c++";
                }
                case OBJC: {
                    return "objective-c";
                }
            }
        }
        throw new DebuggerCommandException(language.toString() + " is not supported by GDB");
    }

    @Override
    @NotNull
    public DebuggerDriver.ShellCommandResult executeShellCommand(@NotNull String executable, @Nullable List<String> params, @Nullable String workingDir, int timeoutSecs) throws ExecutionException {
        throw new ExecutionException("Not implemented yet");
    }

    @Override
    public void executeConsoleCommand(String command) throws ExecutionException, DebuggerCommandException {
        this.executeConsoleCommand(-1L, -1, command);
    }

    @Override
    public void executeConsoleCommand(final long threadId, final int frameIndex, final String command) throws ExecutionException, DebuggerCommandException {
        this.executeCommand(new ConsoleCommand<Object>(command){

            @Override
            public Object call() throws ExecutionException, DebuggerCommandException {
                String commandToSend;
                if (GDBDriver.this.isInPromptMode()) {
                    commandToSend = command;
                } else {
                    String trimmed;
                    long actualThreadId = threadId;
                    int actualFrameIndex = frameIndex;
                    DebuggerDriver.StopPlace currentPlace = GDBDriver.this.myStopPlace;
                    if (actualThreadId < 0L && currentPlace != null) {
                        actualThreadId = currentPlace.thread.getId();
                        actualFrameIndex = currentPlace.frame.getIndex();
                    }
                    if ("run".equals(trimmed = command.trim())) {
                        GDBDriver.this.handleGDBOutput("Command '" + trimmed + "' is not supported.\n");
                        return null;
                    }
                    commandToSend = GDBDriver.createConsoleCommand(trimmed, actualThreadId, actualFrameIndex);
                }
                GDBDriver.this.sendRequest("%s", commandToSend).waitFor(new GDBResponse.ResultRecord.Type[0]);
                return null;
            }
        });
    }

    @Override
    public void handleCompletion(String command, int pos, List<String> completions) throws ExecutionException {
    }

    @Override
    public void handleSignal(String signalName, boolean stop2, boolean pass, boolean notify) throws ExecutionException, DebuggerCommandException {
        this.executeCommand(() -> {
            ArrayList<String> options = new ArrayList<String>(3);
            options.add(GDBDriver.handleSignalOption(stop2, "stop"));
            options.add(GDBDriver.handleSignalOption(pass, "pass"));
            options.add(GDBDriver.handleSignalOption(notify, "print"));
            String command = String.format("handle %s %s", signalName, StringUtil.join(options, (String)" "));
            this.sendRequestAndWaitForDone("%s", GDBDriver.createConsoleCommand(command));
        });
    }

    private static String handleSignalOption(boolean on, String option) {
        String prefix = "";
        if (!on) {
            prefix = "no";
        }
        return prefix + option;
    }

    @NotNull
    protected static String createConsoleCommand(@NotNull String request) {
        return GDBDriver.createConsoleCommand(request, -1L, -1);
    }

    @NotNull
    protected static String createConsoleCommand(@NotNull String request, long threadId, int frameIndex) {
        return String.format("-interpreter-exec %s console %s", GDBDriver.onThreadAndFrame(threadId, frameIndex), GDBDriver.stringify(request));
    }

    private String onStoppedThreadAndFrame() {
        DebuggerDriver.StopPlace stopPlace = this.myStopPlace;
        return stopPlace == null ? "" : GDBDriver.onThreadAndFrame(stopPlace.thread.getId(), stopPlace.frame.getIndex());
    }

    private static String onThreadAndFrame(long threadId, int frameIndex) {
        return threadId >= 0L ? String.format("--thread %d --frame %d", threadId, frameIndex) : "";
    }

    private static String atSourceLine(@NotNull String source, int line) {
        return GDBDriver.stringify(String.format("%s:%d", source, line + 1));
    }

    @NotNull
    @Contract(pure=true)
    protected Request buildRequest(@NotNull @PrintFormat String command, Object ... args) {
        return new Request(String.format(command, args));
    }

    @NotNull
    protected Communication sendRequest(@NotNull @PrintFormat String command, Object ... args) throws ExecutionException {
        return this.buildRequest(command, args).send();
    }

    @NotNull
    protected Response sendRequestAndWaitForDone(@NotNull @PrintFormat String command, Object ... args) throws ExecutionException, GDBCommandException {
        return this.sendRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done);
    }

    @NotNull
    protected Response sendRequestAndWaitForRunning(@NotNull @PrintFormat String command, Object ... args) throws ExecutionException, GDBCommandException {
        return this.sendRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
    }

    @NotNull
    private Communication sendSilentRequest(@NotNull @PrintFormat String command, Object ... args) throws ExecutionException {
        return this.buildRequest(command, args).suppressOutputEvent().send();
    }

    @NotNull
    protected Response sendSilentRequestAndWaitForDone(@NotNull @PrintFormat String command, Object ... args) throws ExecutionException, GDBCommandException {
        return this.sendSilentRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done);
    }

    protected void sendRequestOrSpecialCommunication(@NotNull String commandDisplayString, @NotNull ThrowableRunnable<ExecutionException> r) throws ExecutionException {
        GDBDriver.waitForSemaphore(this.myCommandSemaphore);
        this.throwIfTerminatedOrHasPendingErrors();
        this.myCommandSemaphore.down();
        this.myLastCommand = commandDisplayString;
        if (CidrDebuggerLog.LOG.isDebugEnabled()) {
            CidrDebuggerLog.LOG.debug(">" + commandDisplayString);
        }
        r.run();
    }

    private void throwIfTerminatedOrHasPendingErrors() throws ExecutionException {
        if (this.isTerminated()) {
            throw new ExecutionFinishedException();
        }
        this.checkErrors();
    }

    @Override
    public void checkErrors() throws ExecutionException {
        Response response;
        while ((response = (Response)this.myResultQueue.poll()) != null) {
            try {
                response.checkError();
            }
            catch (ExecutionFinishedException executionFinishedException) {}
        }
    }

    @Override
    protected void handleGDBOutput(@NotNull String text) {
        if (!this.myCommunication.suppressOutputEvent) {
            super.handleGDBOutput(text);
        }
    }

    @Override
    protected void handleRunning() {
        if (!this.myCommunication.suppressRunningEvent) {
            super.handleRunning();
        }
    }

    @Override
    protected void handleTargetFinished(int code2, @Nullable String description) {
        if (this.myCommunication.suppressTargetFinishedEvent) {
            return;
        }
        this.myInterrupted.up();
        super.handleTargetFinished(code2, description);
    }

    @Override
    protected void handleTargetTerminated() {
        this.myInterrupted.up();
        super.handleTargetTerminated();
    }

    private boolean isTerminated() {
        return this.myProcessHandler.isProcessTerminating() || this.myProcessHandler.isProcessTerminated();
    }

    @NotNull
    private Response waitForResponse(@NotNull String command, GDBResponse.ResultRecord.Type ... expectedTypes) throws ExecutionException, GDBCommandException {
        Response response = this.doWaitForResponse();
        GDBResponse.Record result2 = response.getRecord();
        Object resultType = result2.getType();
        if (expectedTypes.length == 0 || ArrayUtil.contains(resultType, (Object[])expectedTypes)) {
            return response;
        }
        if (!"-exec-interrupt".equals(command) || !INFERIOR_NOT_EXECUTING.equals(GDBDriver.getErrorMessage(result2))) {
            CidrDebuggerLog.LOG.warn(">" + command);
            CidrDebuggerLog.LOG.warn("<" + result2);
        }
        if (resultType == GDBResponse.ResultRecord.Type.error) {
            throw GDBDriver.throwGDBError(response);
        }
        throw GDBDriver.unexpectedResponse(result2);
    }

    private static GDBCommandException throwGDBError(Response response) throws ExecutionException, GDBCommandException {
        String errorMessage = GDBDriver.getErrorMessage(response);
        if (errorMessage == null) {
            errorMessage = "Unknown GDB error";
        }
        throw new GDBCommandException(response, errorMessage);
    }

    @Nullable
    private static String getErrorMessage(@NotNull Response response) throws ExecutionException {
        return GDBDriver.getErrorMessage(response.getRecord());
    }

    @Nullable
    private static String getErrorMessage(@NotNull GDBResponse.Record result2) {
        return result2.getResultList().getString("msg");
    }

    @NotNull
    private Response doWaitForResponse() throws ExecutionException {
        try {
            String errorMessage;
            Response response = this.myResultQueue.take();
            if (this.getState() != DebuggerDriver.TargetState.NOT_READY && "ptrace: No such process.".equals(errorMessage = GDBDriver.getErrorMessage(response))) {
                this.handleTargetTerminated();
                throw new ExecutionFinishedException();
            }
            return response;
        }
        catch (InterruptedException e) {
            throw new ExecutionException("Execution interrupted", (Throwable)e);
        }
    }

    private static ExecutionException unexpectedResponse(Object response) throws ExecutionException {
        return new ExecutionException("Unexpected response: " + response);
    }

    private static boolean messageContains(@NotNull Exception e, @NotNull String string) {
        String message2 = e.getMessage();
        return message2 != null && message2.contains(string);
    }

    private static void waitForSemaphore(Semaphore s) throws ExecutionException {
        try {
            s.waitForUnsafe();
        }
        catch (InterruptedException e) {
            throw new ExecutionException("Execution interrupted", (Throwable)e);
        }
    }

    private void setPromptMode(int promptLevel) {
        this.myPromptLevel = promptLevel;
        this.handlePrompt(promptLevel);
    }

    private boolean enterPromptMode(String prompt) {
        if (!PROMPT.matcher(prompt).matches()) {
            return false;
        }
        CidrDebuggerLog.LOG.assertTrue(this.myIsConsoleCommand, (Object)"Prompt mode is only expected as a result of a console command");
        GDBResponse.AsyncRecord record = new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.notify, "read-one-line", new GDBTuple());
        this.setPromptMode(prompt.length());
        this.myResultQueue.offer(this.myCommunication.createResponse(record));
        this.myCommandSemaphore.up();
        return true;
    }

    private void processResponse(@NotNull String output) {
        try {
            this.doProcessResponse(output);
        }
        catch (Throwable e) {
            this.myResultQueue.offer(new ErrorResponse(e));
        }
    }

    private void doProcessResponse(@NotNull String output) throws GDBResponse.ResponseParseException, ExecutionException {
        if (CidrDebuggerLog.LOG.isDebugEnabled()) {
            CidrDebuggerLog.LOG.debug("<" + output);
        }
        if ("(gdb)".equals(output)) {
            CidrDebuggerLog.LOG.assertTrue(!this.isInPromptMode(), (Object)"Prompt mode should have been reset on ^result record");
            this.myCommandSemaphore.up();
            return;
        }
        GDBResponse response = GDBResponse.parse(output);
        if (response instanceof GDBResponse.StreamRecord) {
            this.doProcessStreamRecord((GDBResponse.StreamRecord)response);
        } else if (response instanceof GDBResponse.ResultRecord) {
            this.doProcessResultRecord((GDBResponse.ResultRecord)response);
        } else if (response instanceof GDBResponse.AsyncRecord) {
            this.doProcessAsyncRecord((GDBResponse.AsyncRecord)response);
        } else {
            throw GDBDriver.unexpectedResponse(output);
        }
    }

    private void doProcessStreamRecord(GDBResponse.StreamRecord record) {
        String text = record.getText();
        switch (record.getCategory()) {
            case target: {
                this.handleTargetOutput(text, ProcessOutputTypes.STDOUT);
                break;
            }
            case console: {
                if (this.myIsConsoleCommand && this.enterPromptMode(text)) break;
            }
            case log: {
                this.myCommunication.consoleOutput.append(text);
                this.handleGDBOutput(text);
            }
        }
    }

    private void doProcessResultRecord(GDBResponse.ResultRecord record) throws ExecutionException {
        this.setPromptMode(0);
        switch ((GDBResponse.ResultRecord.Type)record.getType()) {
            case continuing: 
            case stepping: {
                return;
            }
            case running: {
                this.myStopPlace = null;
                this.handleRunning();
                break;
            }
            case error: {
                DebuggerDriver.StopPlace stopPlace;
                GDBTuple tuple = record.getResultList();
                String reason = tuple.getString("reason");
                if (!"breakpoint-hit".equals(reason)) break;
                this.myStopPlace = stopPlace = this.doReadStopPlace(tuple);
                this.processBreakpointHit(stopPlace, tuple);
                break;
            }
        }
        if (!this.myCommunication.suppressRunningResult) {
            this.myResultQueue.offer(this.myCommunication.createResponse(record));
        }
    }

    private void doProcessAsyncRecord(GDBResponse.AsyncRecord record) throws ExecutionException {
        String type2 = ((GDBResponse.AsyncRecord.Type)record.getType()).getValue();
        GDBTuple resultTuple = record.getResultList();
        switch ((GDBResponse.AsyncRecord.Category)record.getCategory()) {
            case notify: {
                switch (type2) {
                    case "library-loaded": {
                        String moduleName = resultTuple.getString("id");
                        if (moduleName != null) {
                            this.handleModulesLoaded(Collections.singletonList(moduleName));
                        }
                        return;
                    }
                    case "thread-group-exited": {
                        if (this.getState() == DebuggerDriver.TargetState.NOT_READY && SystemInfo.isUnix) {
                            UnixProcessManager.sendSigIntToProcessTree((Process)this.myProcessHandler.getProcess());
                            return;
                        }
                        int code2 = resultTuple.getInt("exit-code", 1);
                        this.handleTargetFinished(code2, null);
                        return;
                    }
                    case "thread-group-started": {
                        this.myTargetPID = resultTuple.getRequiredInt("pid");
                        return;
                    }
                }
                return;
            }
            case exec: {
                DebuggerDriver.StopPlace stopPlace;
                if (!type2.equals("stopped")) {
                    return;
                }
                if (resultTuple.getAll("reason", String.class).stream().anyMatch(o -> o.startsWith("exited"))) {
                    DebuggerDriver.TargetState state = this.getState();
                    CidrDebuggerLog.LOG.assertTrue(state == DebuggerDriver.TargetState.FINISHED, (Object)("Finished state should have been reported already: " + (Object)((Object)state)));
                    return;
                }
                if (this.myPendingForAttachNotification.tryUp()) {
                    return;
                }
                this.myStopPlace = stopPlace = this.doReadStopPlace(resultTuple);
                switch (resultTuple.getString("reason", "")) {
                    case "signal-received": {
                        ++this.myCommunication.receivedSignalCount;
                        if (this.myInterrupted.tryUp()) {
                            return;
                        }
                        String name = resultTuple.getString("signal-name");
                        String meaning = resultTuple.getString("signal-meaning");
                        if (GDBDriver.isTargetTerminationSignal(name)) {
                            this.handleTargetTerminated();
                            return;
                        }
                        if (name == null || meaning == null) break;
                        this.handleSignal(stopPlace, name, meaning);
                        return;
                    }
                    case "breakpoint-hit": {
                        this.processBreakpointHit(stopPlace, resultTuple);
                        return;
                    }
                    case "end-stepping-range": 
                    case "function-finished": 
                    case "location-reached": {
                        GDBTuple frameTuple = resultTuple.getRequiredTuple("frame");
                        if (!SystemInfo.isMac || this.myIndirectSymbols == null || frameTuple == null) break;
                        String addr = frameTuple.getString("addr");
                        String func = frameTuple.getString("func");
                        String file2 = frameTuple.getString("file");
                        if (file2 != null || !"??".equals(func) || addr == null || !this.myIndirectSymbols.contains(GDBDriver.parseAddress(addr, Address.NULL).unsignedLongValue())) break;
                        this.executeAsyncCommand(() -> this.buildRequest("-exec-step", new Object[0]).suppressOutputEvent().suppressRunningEvent().suppressRunningResult().send());
                        return;
                    }
                    case "watchpoint-trigger": 
                    case "read-watchpoint-trigger": 
                    case "access-watchpoint-trigger": {
                        String tupleKey;
                        String[] tupleKeys = new String[]{"wpt", "hw-rwpt", "hw-awpt"};
                        GDBTuple wpt = null;
                        String[] file2 = tupleKeys;
                        int n = file2.length;
                        for (int j = 0; j < n && (wpt = resultTuple.getTuple(tupleKey = file2[j])) == null; ++j) {
                        }
                        if (wpt == null) break;
                        int number = wpt.getRequiredInt("number");
                        this.handleWatchpoint(stopPlace, number);
                        return;
                    }
                    case "watchpoint-scope": {
                        int wpnum = resultTuple.getRequiredInt("wpnum");
                        this.handleWatchpointScope(wpnum);
                        return;
                    }
                }
                this.handleInterrupted(stopPlace);
                return;
            }
        }
    }

    private void processBreakpointHit(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull GDBTuple resultTuple) throws ExecutionException {
        int num = resultTuple.getRequiredInt("bkptno");
        this.handleBreakpoint(stopPlace, num);
    }

    private void cleanupOnTermination() {
        PTYOutputStream processInput = this.myProcessInput;
        if (processInput != null) {
            try {
                processInput.close();
            }
            catch (IOException e) {
                CidrDebuggerLog.LOG.warn((Throwable)e);
            }
        }
        this.myProcessInput = null;
        this.myResultQueue.offer(new ErrorResponse((NotNullProducer<ExecutionException>)((NotNullProducer)ExecutionFinishedException::new)));
        this.myCommandSemaphore.up();
        this.myInterrupted.up();
        this.myPendingForAttachNotification.up();
    }

    protected <T> T executeCommandNoUserException(Command<T> c) throws ExecutionException {
        long timeout = c.getTimeout();
        try {
            ExecutionResult<T> executionResult = this.doExecuteCommand(c, false);
            return timeout < 0L ? executionResult.get() : executionResult.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            CidrDebuggerLog.LOG.warn("Command timed out (" + timeout + "): " + this.myLastCommand);
            if (c instanceof EvaluationCommand) {
                throw new DebuggerEvaluationTimedOutException(((EvaluationCommand)c).getExpression());
            }
            throw new DebuggerCommandTimedOutException(CidrDebuggerBundle.message("debug.command.error.timedOut", new Object[0]));
        }
    }

    protected <T> T executeCommand(Command<T> c) throws ExecutionException, DebuggerCommandException {
        try {
            return this.executeCommandNoUserException(c);
        }
        catch (ExecutionException e) {
            DebuggerCommandException cause = (DebuggerCommandException)ExceptionUtil.findCause((Throwable)e, DebuggerCommandException.class);
            if (cause != null) {
                throw new DebuggerCommandException(cause.getMessage(), cause);
            }
            throw e;
        }
    }

    private void executeAsyncCommand(Command<?> c) {
        this.doExecuteCommand(c, true);
    }

    private <T> ExecutionResult<T> doExecuteCommand(Command<T> c, boolean async) {
        return this.myCommandProcessor.submit(() -> {
            try {
                if (c instanceof SuspendedCommand && this.getState() == DebuggerDriver.TargetState.RUNNING) {
                    throw new DebuggerIllegalStateException(CidrDebuggerBundle.message("debug.command.error.notSuspended", new Object[0]));
                }
                this.myIsConsoleCommand = c instanceof ConsoleCommand;
                if (!this.myIsConsoleCommand && this.isInPromptMode()) {
                    throw new DebuggerIllegalStateException(CidrDebuggerBundle.message("debug.command.error.inPrompt", new Object[0]));
                }
                return c.call();
            }
            catch (Throwable e) {
                if (async) {
                    this.myResultQueue.offer(new ErrorResponse(e));
                }
                throw e;
            }
        });
    }

    @NotNull
    public static Pair<String, String> getDescriptionFromValue(@NotNull String value2) {
        String description = null;
        Matcher matcher = VALUE_DESCRIPTION_PATTERN.matcher(value2);
        if (matcher.matches()) {
            value2 = matcher.group(1);
            description = matcher.group(2);
        }
        if (description == null) {
            description = value2;
        }
        return Pair.create((Object)value2, (Object)description);
    }

    @NotNull
    private GDBTuple doUpdateAndListFrameVariables(long threadId, int frameIndex, @NotNull String currentFrameAddr) throws ExecutionException, DebuggerCommandException {
        Consumer<String> frameVarDisposeListener = this.myFrameVarDisposeListener;
        Response updateResponse = this.sendRequestAndWaitForDone("-var-update --simple-values *", new Object[0]);
        GDBTuple changeList = updateResponse.getResultList().getRequiredTuple("changelist");
        for (Object each : changeList) {
            if (!(each instanceof GDBTuple)) continue;
            GDBTuple change = (GDBTuple)each;
            String fVar = change.getString("name", "");
            boolean inScope = change.getBoolean("in_scope", true);
            boolean typeChanged = change.getBoolean("type_changed");
            if (!inScope || typeChanged) {
                this.myFrameVarIDCache.removeValue((Object)fVar);
                this.myFrameVarDataCache.remove(fVar);
                this.sendRequestAndWaitForDone("-var-delete %s", GDBDriver.stringify(fVar));
                if (frameVarDisposeListener == null) continue;
                frameVarDisposeListener.consume((Object)fVar);
                continue;
            }
            String changedValue = change.getString("value");
            if (changedValue == null) continue;
            this.updateFrameVarDataCache(fVar, changedValue);
        }
        Response response = this.sendRequestAndWaitForDone("-stack-list-variables %s --simple-values", GDBDriver.onThreadAndFrame(threadId, frameIndex));
        HashSet<String> uniqueSet = new HashSet<String>();
        GDBTuple result2 = new GDBTuple();
        GDBTuple variables = response.getResultList().getRequiredTuple("variables");
        for (Object each : variables) {
            GDBTuple gdbTuple = (GDBTuple)each;
            String name = gdbTuple.getString("name", "");
            String fvKey = GDBDriver.makeFVKey(currentFrameAddr, name);
            if (uniqueSet.contains(name)) {
                String fVar = (String)this.myFrameVarIDCache.remove((Object)fvKey);
                if (fVar == null) continue;
                this.myFrameVarDataCache.remove(fVar);
                this.sendRequestAndWaitForDone("-var-delete %s", GDBDriver.stringify(fVar));
                if (frameVarDisposeListener == null) continue;
                frameVarDisposeListener.consume((Object)fVar);
                continue;
            }
            uniqueSet.add(name);
            result2.add(each);
        }
        return result2;
    }

    private void updateFrameVarDataCache(@NotNull String id, @NotNull String newValue) {
        LLValueLoadedData data = this.myFrameVarDataCache.get(id);
        if (data != null) {
            data = new LLValueLoadedData(data.id, data.childrenCount, data.isDynamic, data.hasDynamicChildren, data.isMap, newValue);
            this.myFrameVarDataCache.put(id, data);
        }
    }

    @NotNull
    private static String makeFVKey(@NotNull String frameAddr, @NotNull String name) {
        return frameAddr + "-" + name;
    }

    static {
        VALUE_DESCRIPTION_PATTERN = Pattern.compile("^(0x\\p{XDigit}+)(?: <.+?>)?(?: (\\w?\".*\"(?:\\.\\.\\.)?))?$");
    }

    private static class GDBCommandException
    extends DebuggerCommandException {
        @NotNull
        private final Response myResponse;

        public GDBCommandException(@NotNull Response response, @NotNull String message2) {
            super(message2);
            this.myResponse = response;
        }

        @NotNull
        public Response getResponse() {
            return this.myResponse;
        }
    }

    private class FrameValueLoader
    implements LLValueLoader {
        @NotNull
        private final String myFrameAddr;
        @Nullable
        private final String myAvailableValue;

        public FrameValueLoader(@Nullable String frameAddr, String availableValue) {
            this.myFrameAddr = frameAddr;
            this.myAvailableValue = availableValue;
        }

        @Override
        public void loadValue(@NotNull LLValue value2) throws ExecutionException, DebuggerCommandException {
            LLValueLoadedData data;
            String name = value2.getName();
            String fVKey = GDBDriver.makeFVKey(this.myFrameAddr, name);
            String id = (String)GDBDriver.this.myFrameVarIDCache.get((Object)fVKey);
            if (id == null) {
                GDBResponse.Record varObj = GDBDriver.this.doCreateVar(this.myFrameAddr, name);
                id = varObj.getResultList().getRequiredString("name");
                String v = varObj.getResultList().getString("value", "");
                data = GDBDriver.doReadLoadedData(varObj.getResultList(), id, v);
                GDBDriver.this.myFrameVarIDCache.put((Object)fVKey, (Object)id);
                GDBDriver.this.myFrameVarDataCache.put(id, data);
            } else {
                if (this.myAvailableValue != null) {
                    GDBDriver.this.updateFrameVarDataCache(id, this.myAvailableValue);
                }
                data = (LLValueLoadedData)GDBDriver.this.myFrameVarDataCache.get(id);
            }
            GDBDriver.doUpdateLoadedData(value2, data);
        }
    }

    private class CreatedValueLoader
    implements LLValueLoader {
        @NotNull
        private final LLValueLoadedData partialLoadedData;

        public CreatedValueLoader(LLValueLoadedData partialLoadedData) {
            this.partialLoadedData = partialLoadedData;
        }

        @Override
        public void loadValue(@NotNull LLValue value2) throws ExecutionException, DebuggerCommandException {
            String id = this.partialLoadedData.id;
            Response varObj = GDBDriver.this.sendRequestAndWaitForDone("-var-evaluate-expression %s", GDBDriver.stringify(id));
            String val = varObj.getResultList().getRequiredString("value");
            GDBDriver.doUpdateLoadedData(value2, new LLValueLoadedData(id, this.partialLoadedData.childrenCount, this.partialLoadedData.isDynamic, this.partialLoadedData.hasDynamicChildren, this.partialLoadedData.isMap, val));
        }
    }

    private static interface LLValueLoader {
        public void loadValue(@NotNull LLValue var1) throws ExecutionException, DebuggerCommandException;
    }

    private static class LLValueLoadedData {
        @NotNull
        public final String id;
        @Nullable
        public final Integer childrenCount;
        public final boolean isDynamic;
        public final boolean hasDynamicChildren;
        public final boolean isMap;
        @NotNull
        public final LLValueData data;

        public LLValueLoadedData(@NotNull String id, @Nullable Integer childrenCount, boolean isDynamic, boolean hasDynamicChildren, boolean isMap, @NotNull String value2) {
            this.id = id;
            this.childrenCount = childrenCount;
            this.isDynamic = isDynamic;
            this.hasDynamicChildren = hasDynamicChildren;
            this.isMap = isMap;
            Pair<String, String> valueAndDescription = GDBDriver.getDescriptionFromValue(value2);
            value2 = (String)valueAndDescription.first;
            String description = (String)valueAndDescription.second;
            boolean hasLongerDescription = description != null && description.length() >= 1000;
            boolean mayHaveChildren = childrenCount != null && childrenCount > 0 || hasDynamicChildren;
            this.data = new LLValueData(value2, description, hasLongerDescription, mayHaveChildren, isDynamic);
        }

        public boolean mayHaveChildren() {
            return this.data.mayHaveChildren();
        }
    }

    private static class MapElement {
        @NotNull
        private final LLValue myKey;
        @NotNull
        private final LLValue myValue;

        public MapElement(@NotNull LLValue key2, @NotNull LLValue value2) {
            this.myKey = key2;
            this.myValue = value2;
        }

        @NotNull
        public LLValue getKey() {
            return this.myKey;
        }

        @NotNull
        public LLValue getValue() {
            return this.myValue;
        }
    }

    private static class ErrorResponse
    implements Response {
        @NotNull
        private final NotNullProducer<ExecutionException> myErrorSupplier;

        public ErrorResponse(@Nullable Throwable throwable) {
            this((NotNullProducer<ExecutionException>)((NotNullProducer)() -> new ExecutionException(throwable)));
        }

        public ErrorResponse(@NotNull NotNullProducer<ExecutionException> errorSupplier) {
            this.myErrorSupplier = errorSupplier;
        }

        @NotNull
        public ExecutionException getError() {
            return (ExecutionException)((Object)this.myErrorSupplier.produce());
        }

        @Override
        @NotNull
        public GDBResponse.Record getRecord() throws ExecutionException {
            throw this.getError();
        }

        @Override
        @NotNull
        public String getOutput() throws ExecutionException {
            throw this.getError();
        }

        @Override
        public void checkError() throws ExecutionException {
            throw this.getError();
        }

        @Override
        public int getReceivedSignalCount() throws ExecutionException {
            throw this.getError();
        }
    }

    private static class ResultResponse
    implements Response {
        @NotNull
        private final GDBResponse.Record myRecord;
        @NotNull
        private final String myOutput;
        private final int myReceivedSignalCount;

        public ResultResponse(@NotNull GDBResponse.Record record, @NotNull String output, int receivedSignalCount) {
            this.myRecord = record;
            this.myOutput = output;
            this.myReceivedSignalCount = receivedSignalCount;
        }

        @Override
        @NotNull
        public GDBResponse.Record getRecord() {
            return this.myRecord;
        }

        @Override
        @NotNull
        public String getOutput() {
            return this.myOutput;
        }

        @Override
        public int getReceivedSignalCount() {
            return this.myReceivedSignalCount;
        }
    }

    protected static interface Response {
        @NotNull
        public GDBResponse.Record getRecord() throws ExecutionException;

        @NotNull
        default public GDBTuple getResultList() throws ExecutionException {
            return this.getRecord().getResultList();
        }

        @NotNull
        public String getOutput() throws ExecutionException;

        default public void checkError() throws ExecutionException {
        }

        public int getReceivedSignalCount() throws ExecutionException;
    }

    protected class Communication {
        @NotNull
        public final String command;
        public final boolean suppressOutputEvent;
        public final boolean suppressRunningEvent;
        public final boolean suppressTargetFinishedEvent;
        public final boolean suppressRunningResult;
        @NotNull
        public final StringBuffer consoleOutput = new StringBuffer();
        public int receivedSignalCount;

        public Communication(String command) {
            this(command, false, false, false, false);
        }

        public Communication(String command, boolean suppressOutputEvent, boolean suppressRunningEvent, boolean suppressTargetFinishedEvent, boolean suppressRunningResult) {
            CidrDebuggerLog.LOG.assertTrue(!StringUtil.containsLineBreak((CharSequence)command) || command.endsWith("\nend"), (Object)("MI command must not contain unescaped newlines: " + command));
            this.command = command;
            this.suppressOutputEvent = suppressOutputEvent;
            this.suppressRunningEvent = suppressRunningEvent;
            this.suppressTargetFinishedEvent = suppressTargetFinishedEvent;
            this.suppressRunningResult = suppressRunningResult;
        }

        public void initiate() throws ExecutionException {
            GDBDriver.this.sendRequestOrSpecialCommunication(this.command, (ThrowableRunnable<ExecutionException>)((ThrowableRunnable)() -> {
                try {
                    GDBDriver.this.mySink.write((this.command + "\n").getBytes(GDBDriver.this.myGdbCommandLine.getCharset()));
                    GDBDriver.this.mySink.flush();
                }
                catch (IOException e) {
                    if (GDBDriver.this.isTerminated()) {
                        throw new ExecutionFinishedException((Throwable)e);
                    }
                    throw new ExecutionException("Cannot send request", (Throwable)e);
                }
            }));
        }

        public Response waitFor(GDBResponse.ResultRecord.Type ... expectedTypes) throws ExecutionException, GDBCommandException {
            return GDBDriver.this.waitForResponse(this.command, expectedTypes);
        }

        public Response createResponse(@NotNull GDBResponse.Record record) {
            return new ResultResponse(record, this.consoleOutput.toString(), this.receivedSignalCount);
        }
    }

    protected class Request {
        @NotNull
        private final String myCommand;
        private boolean mySuppressOutputEvent;
        private boolean mySuppressRunningEvent;
        private boolean mySuppressTargetFinishedEvent;
        private boolean mySuppressRunningResult;

        public Request(String command) {
            this.myCommand = command;
        }

        @NotNull
        public Communication send() throws ExecutionException {
            Communication communication = new Communication(this.myCommand, this.mySuppressOutputEvent, this.mySuppressRunningEvent, this.mySuppressTargetFinishedEvent, this.mySuppressRunningResult);
            GDBDriver.this.myCommunication = communication;
            communication.initiate();
            return communication;
        }

        @NotNull
        public String getCommand() {
            return this.myCommand;
        }

        public Request suppressOutputEvent() {
            return this.suppressOutputEvent(true);
        }

        public Request suppressOutputEvent(boolean suppressOutputEvent) {
            this.mySuppressOutputEvent = suppressOutputEvent;
            return this;
        }

        public Request suppressRunningEvent() {
            return this.suppressRunningEvent(true);
        }

        public Request suppressRunningEvent(boolean suppressRunningEvent) {
            this.mySuppressRunningEvent = suppressRunningEvent;
            return this;
        }

        public Request suppressTargetFinishedEvent() {
            return this.suppressTargetFinishedEvent(true);
        }

        public Request suppressTargetFinishedEvent(boolean suppressTargetFinishedEvent) {
            this.mySuppressTargetFinishedEvent = suppressTargetFinishedEvent;
            return this;
        }

        public Request suppressRunningResult() {
            return this.suppressRunningResult(true);
        }

        public Request suppressRunningResult(boolean suppressRunningResult) {
            this.mySuppressRunningResult = suppressRunningResult;
            return this;
        }
    }

    private static abstract class ConsoleCommand<T>
    extends EvaluationCommand<T> {
        public ConsoleCommand(@NotNull String expression2) {
            super(expression2);
        }
    }

    protected static abstract class EvaluationCommand<T>
    implements SuspendedCommand<T> {
        @NotNull
        private final String myExpression;

        public EvaluationCommand(@NotNull String expression2) {
            this.myExpression = expression2;
        }

        @NotNull
        public String getExpression() {
            return this.myExpression;
        }

        @Override
        public long getTimeout() {
            return GDBDriver.getEvaluationTimeoutMs();
        }
    }

    protected static interface SuspendedCommand<T>
    extends Command<T> {
    }

    protected static interface LoadingCommand
    extends VoidCommand {
        @Override
        default public long getTimeout() {
            return GDBDriver.getLoadTimeoutMs();
        }
    }

    protected static interface VoidCommand
    extends Command<Void> {
        @Override
        @Nullable
        default public Void call() throws ExecutionException, DebuggerCommandException {
            this.run();
            return null;
        }

        public void run() throws ExecutionException, DebuggerCommandException;
    }

    protected static interface Command<T> {
        @Nullable
        public T call() throws ExecutionException, DebuggerCommandException;

        default public long getTimeout() {
            return GDBDriver.getTimeoutMs();
        }
    }

    private static class StructChildrenVisitor {
        private StructChildrenVisitor() {
        }

        boolean visitRealChild(@NotNull GDBTuple child) throws ExecutionException {
            return true;
        }

        boolean visitFakeChild(@NotNull LLValue fakeChild, int childrenCount) throws ExecutionException, DebuggerCommandException {
            return true;
        }
    }

    private abstract class AttachConnectCommand
    implements LoadingCommand {
        private AttachConnectCommand() {
        }

        @Override
        public void run() throws ExecutionException, DebuggerCommandException {
            GDBDriver.this.myPendingForAttachNotification.down();
            try {
                this.attach();
                GDBDriver.waitForSemaphore(GDBDriver.this.myPendingForAttachNotification);
            }
            finally {
                GDBDriver.this.myPendingForAttachNotification.up();
            }
            GDBDriver.this.doSelectWinbreakBinary();
            this.whenAttached();
            GDBDriver.this.sendRequestAndWaitForRunning("-exec-continue", new Object[0]);
        }

        protected abstract void attach() throws ExecutionException, DebuggerCommandException;

        protected abstract void whenAttached() throws ExecutionException, DebuggerCommandException;
    }

    public static interface MIResponseFilter
    extends BiFunction<String, String, String> {
        @Override
        public String apply(@NotNull String var1, @NotNull String var2);
    }
}

