/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GDBTuple
extends ArrayList<Object> {
    private static final List<String> TRUE_STRINGS = Arrays.asList("true", "yes", "on");
    private static final List<String> FALSE_STRINGS = Arrays.asList("false", "no", "off");

    public static GDBTuple of(Object ... elements) {
        GDBTuple tuple = new GDBTuple();
        tuple.addAll(Arrays.asList(elements));
        return tuple;
    }

    @Contract(value="_, _, !null -> !null")
    protected <T> T get(String key2, @NotNull Class<T> clazz, @Nullable T defaultValue) {
        for (Object each : this) {
            T o = GDBTuple.getIfEquals(each, key2);
            if (!clazz.isInstance(o)) continue;
            return clazz.cast(o);
        }
        return defaultValue;
    }

    @Nullable
    public String getString(String key2) {
        return this.getString(key2, null);
    }

    @Contract(value="_, !null -> !null")
    public String getString(String key2, @Nullable String defaultValue) {
        return this.get(key2, String.class, defaultValue);
    }

    @NotNull
    public <X extends Throwable> String getRequiredStringOrThrow(String key2, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        return this.getRequiredStringOrThrow(key2, GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key2)));
    }

    @NotNull
    public <X extends Throwable> String getRequiredStringOrThrow(String key2, @NotNull Supplier<? extends X> exceptionSupplier) throws X {
        return GDBTuple.checkNotNullOrThrow(this.getString(key2), exceptionSupplier);
    }

    @NotNull
    public String getRequiredString(String key2) throws ExecutionException {
        return this.getRequiredStringOrThrow(key2, ExecutionException::new);
    }

    @Nullable
    public GDBTuple getTuple(String key2) {
        return this.get(key2, GDBTuple.class, null);
    }

    @NotNull
    public GDBTuple getTupleOrEmpty(String key2) {
        GDBTuple value2 = this.getTuple(key2);
        if (value2 == null) {
            value2 = new GDBTuple();
        }
        return value2;
    }

    @NotNull
    public GDBTuple getRequiredTuple(String key2) throws ExecutionException {
        return this.getRequiredTupleOrThrow(key2, ExecutionException::new);
    }

    @NotNull
    public <X extends Throwable> GDBTuple getRequiredTupleOrThrow(String key2, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        return this.getRequiredTupleOrThrow(key2, GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key2)));
    }

    @NotNull
    public <X extends Throwable> GDBTuple getRequiredTupleOrThrow(String key2, @NotNull Supplier<? extends X> exceptionSupplier) throws X {
        return GDBTuple.checkNotNullOrThrow(this.getTuple(key2), exceptionSupplier);
    }

    @Contract(value="_, !null -> !null")
    public Address getAddress(String key2, @Nullable Address defaultValue) {
        String s = this.getString(key2);
        if (s != null) {
            return GDBTuple.parseAddress(s, defaultValue);
        }
        return defaultValue;
    }

    @NotNull
    public Address getRequiredAddress(String key2) throws ExecutionException {
        return this.getRequiredAddressOrThrow(key2, ExecutionException::new);
    }

    @NotNull
    public <X extends Throwable> Address getRequiredAddressOrThrow(String key2, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        String s = GDBTuple.checkNotNullOrThrow(this.getString(key2), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key2)));
        return GDBTuple.checkNotNullOrThrow(GDBTuple.parseAddress(s, null), GDBTuple.withMessage(exceptionConstructor, () -> "Malformed number value '" + s + "' for key '" + key2 + "' in tuple: " + this));
    }

    @Contract(value="_, !null -> !null")
    private static Address parseAddress(@NotNull String s, @Nullable Address defaultValue) {
        try {
            return Address.parseHexString(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Contract(value="_, !null -> !null")
    public Integer getInteger(String key2, @Nullable Integer defaultValue) {
        String s = this.getString(key2);
        if (s != null) {
            return GDBTuple.parseInteger(s, defaultValue);
        }
        return defaultValue;
    }

    public int getInt(String key2, int defaultValue) {
        return this.getInteger(key2, defaultValue);
    }

    public int getRequiredInt(String key2) throws ExecutionException {
        return this.getRequiredIntOrThrow(key2, ExecutionException::new);
    }

    public <X extends Throwable> int getRequiredIntOrThrow(String key2, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        String s = GDBTuple.checkNotNullOrThrow(this.getString(key2), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key2)));
        return GDBTuple.checkNotNullOrThrow(GDBTuple.parseInteger(s, null), GDBTuple.withMessage(exceptionConstructor, () -> "Malformed number value '" + s + "' for key '" + key2 + "' in tuple: " + this));
    }

    @Contract(value="_, !null -> !null")
    private static Integer parseInteger(@NotNull String s, @Nullable Integer defaultValue) {
        try {
            return Integer.decode(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key2) {
        return this.getBoolean(key2, false);
    }

    public boolean getBoolean(String key2, boolean defaultValue) {
        String s = this.getString(key2);
        if (s != null) {
            String lowerCase = s.toLowerCase();
            if (TRUE_STRINGS.contains(lowerCase)) {
                return true;
            }
            if (FALSE_STRINGS.contains(lowerCase)) {
                return false;
            }
            Integer integer = GDBTuple.parseInteger(s, null);
            if (integer != null) {
                return integer != 0;
            }
        }
        return defaultValue;
    }

    @NotNull
    public <T> List<T> getAll(String key2, Class<T> clazz) {
        SmartList result2 = new SmartList();
        for (Object each : this) {
            T o = GDBTuple.getIfEquals(each, key2);
            if (o == null) continue;
            result2.add(clazz.cast(o));
        }
        return result2;
    }

    @NotNull
    private Supplier<String> missingKeyError(String key2) {
        return () -> "Missing required key '" + key2 + "' in tuple: " + this;
    }

    @NotNull
    private static <X extends Throwable> Supplier<X> withMessage(@NotNull Function<String, ? extends X> exceptionConstructor, @NotNull Supplier<String> messageSupplier) {
        return () -> (Throwable)exceptionConstructor.apply((String)messageSupplier.get());
    }

    @NotNull
    private static <T, X extends Throwable> T checkNotNullOrThrow(@Nullable T value2, @NotNull Supplier<? extends X> exceptionSupplier) throws X {
        if (value2 == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return value2;
    }

    @Nullable
    private static <T> T getIfEquals(@NotNull Object val, String key2) {
        if (val.equals(key2)) {
            return (T)val;
        }
        if (val instanceof Pair && ((Pair)val).first.equals(key2)) {
            return (T)((Pair)val).second;
        }
        return null;
    }
}

