/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.SLRUMap;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class GDBVarsCache {
    private final Map<String, List<Boolean>> myAliveVars = new HashMap();
    private final Map<String, List<Boolean>> myReservedVars = new HashMap();
    private final SLRUMap<Pair<String, Integer>, GDBResponse.Record> myVarsCache;

    public GDBVarsCache(final Delegate delegate) {
        this.myVarsCache = new SLRUMap<Pair<String, Integer>, GDBResponse.Record>(200, 500){

            protected void onDropFromCache(Pair<String, Integer> key2, GDBResponse.Record value2) {
                if (delegate != null) {
                    delegate.onDrop(value2);
                }
                List alive = (List)GDBVarsCache.this.myAliveVars.get(key2.first);
                List reserved = (List)GDBVarsCache.this.myReservedVars.get(key2.first);
                alive.set((Integer)key2.second, false);
                if (reserved != null) {
                    int i2 = (Integer)key2.second;
                    if (reserved.size() > i2) {
                        reserved.set(i2, false);
                    }
                }
                super.onDropFromCache(key2, (Object)value2);
            }
        };
    }

    void putIntoCache(String expression2, GDBResponse.Record result2) {
        List<Boolean> alive = this.myAliveVars.get(expression2);
        List<Boolean> reserved = this.myReservedVars.get(expression2);
        if (alive != null) {
            assert (reserved != null && reserved.size() == alive.size());
            for (int i2 = 0; i2 < alive.size(); ++i2) {
                if (alive.get(i2).booleanValue()) continue;
                this.myVarsCache.put((Object)new Pair((Object)expression2, (Object)i2), (Object)result2);
                alive.set(i2, true);
                reserved.set(i2, true);
                return;
            }
        }
        if (alive == null) {
            alive = new ArrayList<Boolean>();
        }
        if (reserved == null) {
            reserved = new ArrayList<Boolean>();
        }
        alive.add(true);
        reserved.add(true);
        this.myVarsCache.put((Object)new Pair((Object)expression2, (Object)(alive.size() - 1)), (Object)result2);
        this.myAliveVars.put(expression2, alive);
        this.myReservedVars.put(expression2, reserved);
    }

    @Nullable
    GDBResponse.Record getFromCache(String expression2) {
        List<Boolean> alive = this.myAliveVars.get(expression2);
        List<Boolean> reserved = this.myReservedVars.get(expression2);
        if (alive != null) {
            assert (reserved != null && reserved.size() == alive.size());
            for (int i2 = 0; i2 < alive.size(); ++i2) {
                if (!alive.get(i2).booleanValue() || reserved.get(i2).booleanValue()) continue;
                GDBResponse.Record result2 = (GDBResponse.Record)this.myVarsCache.get((Object)new Pair((Object)expression2, (Object)i2));
                if (result2 != null) {
                    reserved.set(i2, true);
                }
                return result2;
            }
        }
        return null;
    }

    void freeVariablesToReuse() {
        for (String exp : this.myReservedVars.keySet()) {
            List<Boolean> reserved = this.myReservedVars.get(exp);
            for (int i2 = 0; i2 < reserved.size(); ++i2) {
                reserved.set(i2, false);
            }
        }
    }

    public static interface Delegate {
        public void onDrop(GDBResponse.Record var1);
    }
}

