/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.execution.debugger.backend.lang.GDBTokenType;
import org.jetbrains.annotations.NotNull;

public class GDBParser
implements PsiParser {
    private static final String[] GDB_EXPRESSION_COMMANDS = new String[]{"print", "p", "print-object", "po", "call"};

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        this.parseGDBCommand(builder);
        mark.done(root);
        return builder.getTreeBuilt();
    }

    private void parseGDBCommand(PsiBuilder builder) {
        PsiBuilder.Marker command = builder.mark();
        if (builder.getTokenType() == GDBTokenType.IDENTIFIER) {
            String commandName = builder.getTokenText();
            PsiBuilder.Marker commandNameMarker = builder.mark();
            builder.advanceLexer();
            commandNameMarker.done((IElementType)GDBTokenType.COMMAND_NAME);
            GDBParser.parseCommandArguments(builder, GDBParser.isExpressionCommand(commandName));
        } else {
            GDBParser.eatEverything(builder);
        }
        command.done((IElementType)GDBTokenType.DBG_COMMAND);
    }

    private static boolean isExpressionCommand(String commandName) {
        return ArrayUtil.contains((String)commandName, (String[])GDB_EXPRESSION_COMMANDS);
    }

    private static void eatEverything(PsiBuilder builder) {
        while (!builder.eof()) {
            builder.advanceLexer();
        }
    }

    private static void parseCommandArguments(PsiBuilder builder, boolean isExpression) {
        PsiBuilder.Marker body2 = builder.mark();
        while (!builder.eof()) {
            builder.advanceLexer();
        }
        body2.done((IElementType)(isExpression ? GDBTokenType.EXPRESSION_PLACEHOLDER : GDBTokenType.COMMAND_ARGUMENTS));
    }
}

