/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lang.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.execution.debugger.backend.lang.GDBTokenType;
import java.io.IOException;
import java.io.Reader;

class _GDBLexer
implements FlexLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0};
    static final char[] ZZ_CMAP_Z = _GDBLexer.zzUnpackCMap("\u0001\u0000\u0001@\u0001\u0080\u010d@");
    static final char[] ZZ_CMAP_Y = _GDBLexer.zzUnpackCMap("\u0001\u0000\u0001\u0001\u0001\u0002}\u0003\u0001\u0004?\u0003");
    static final char[] ZZ_CMAP_A = _GDBLexer.zzUnpackCMap("\t\u0000\u0001\u0002\u0001\u0003\u0002\u0012\u0001\u0003\u0012\u0000\u0001\u0001\u0001\u0000\u0001\n\u0007\u0000\u0001\b\u0002\u0000\u0001\u0005\u0001\u0000\u0001\f\u0001\u0010\t\u0006\u0006\u0000\u0001\u000b\u001a\u0004\u0001\u0000\u0001\t\u0002\u0000\u0001\u0004\u0001\u0000\u0004\u000f\u0001\u0007\u0001\u000f\b\u0004\u0001\u000e\u0004\u0004\u0002\u000e\u0001\u0004\u0001\u000e\u0001\u0011\u0002\u0004\u0001\u0000\u0001\r\b\u0000\u0001\u0012\u00a2\u0000\u0002\u0012\u0016\u0000");
    private static final int[] ZZ_ACTION = _GDBLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0002\u0001\u0001\u0005\u0001\b\u0002\u0007\u0001\t\u0001\n\u0001\u0000\u0001\u000b";
    private static final int[] ZZ_ROWMAP = _GDBLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0013\u0000&\u00009\u0000L\u0000_\u0000\u0013\u0000r\u0000\u0085\u0000\u0098\u0000\u00ab\u0000\u0013\u0000\u00be\u0000\u0013\u0000\u0085\u0000\u0013\u0000\u00d1\u0000\u00d1";
    private static final int[] ZZ_TRANS = _GDBLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0002\u0003\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0004\u0001\u0007\u0001\u0002\u0001\b\u0001\t\u0001\n\u0001\u0002\u0002\u0004\u0001\u000b\u0001\u0004\u0015\u0000\u0003\u0003\u0013\u0000\u0004\u0004\u0006\u0000\u0004\u0004\u0006\u0000\u0001\f\u0013\u0000\u0001\u0006\t\u0000\u0001\u0006\u0002\u0000\u0003\b\u0001\u0000\u0005\b\u0001\r\u0001\u000e\b\b\u0006\u0000\u0001\u000f\t\u0000\u0001\u000f\u0003\u0000\u0001\u0010\u000b\u0000\u0003\u0010\u0001\u0000\u0001\u0010\u0007\u0000\u0001\u0006\t\u0000\u0001\u0006\u0001\u0011\u0001\u0000\u0003\b\u0001\u0000\u000f\b\u0006\u0000\u0002\u0012\u0007\u0000\u0002\u0012\u0002\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = _GDBLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0001\t\u0004\u0001\u0001\t\u0004\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0000\u0001\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;

    public static int ZZ_CMAP(int ch) {
        return ZZ_CMAP_A[ZZ_CMAP_Y[ZZ_CMAP_Z[ch >> 12] | ch >> 6 & 0x3F] << 6 | ch & 0x3F];
    }

    private static int[] zzUnpackAction() {
        int[] result2 = new int[18];
        int offset = 0;
        offset = _GDBLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result2);
        return result2;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result2) {
        int i2 = 0;
        int j = offset;
        int l = packed.length();
        while (i2 < l) {
            int count = packed.charAt(i2++);
            char value2 = packed.charAt(i2++);
            do {
                result2[j++] = value2;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result2 = new int[18];
        int offset = 0;
        offset = _GDBLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result2);
        return result2;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result2) {
        int i2 = 0;
        int j = offset;
        int l = packed.length();
        while (i2 < l) {
            int high = packed.charAt(i2++) << 16;
            result2[j++] = high | packed.charAt(i2++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result2 = new int[228];
        int offset = 0;
        offset = _GDBLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result2);
        return result2;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result2) {
        int i2 = 0;
        int j = offset;
        int l = packed.length();
        while (i2 < l) {
            int count = packed.charAt(i2++);
            int value2 = packed.charAt(i2++);
            do {
                result2[j++] = --value2;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result2 = new int[18];
        int offset = 0;
        offset = _GDBLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result2);
        return result2;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result2) {
        int i2 = 0;
        int j = offset;
        int l = packed.length();
        while (i2 < l) {
            int count = packed.charAt(i2++);
            char value2 = packed.charAt(i2++);
            do {
                result2[j++] = value2;
            } while (--count > 0);
        }
        return j;
    }

    _GDBLexer(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        int size = 0;
        int length = packed.length();
        for (int i2 = 0; i2 < length; i2 += 2) {
            size += packed.charAt(i2);
        }
        char[] map2 = new char[size];
        int i3 = 0;
        int j = 0;
        while (i3 < packed.length()) {
            int count = packed.charAt(i3++);
            char value2 = packed.charAt(i3++);
            do {
                map2[j++] = value2;
            } while (--count > 0);
        }
        return map2;
    }

    public final int getTokenStart() {
        return this.zzStartRead;
    }

    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    public void reset(CharSequence buffer, int start, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzMarkedPos = this.zzStartRead = start;
        this.zzCurrentPos = this.zzStartRead;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message2;
        try {
            message2 = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message2 = ZZ_ERROR_MSG[0];
        }
        throw new Error(message2);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block24: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + _GDBLexer.ZZ_CMAP(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return GDBTokenType.SOME_CHARACTER;
                }
                case 12: {
                    continue block24;
                }
                case 2: {
                    return GDBTokenType.WHITE_SPACE;
                }
                case 13: {
                    continue block24;
                }
                case 3: {
                    return GDBTokenType.IDENTIFIER;
                }
                case 14: {
                    continue block24;
                }
                case 4: {
                    return GDBTokenType.DASH;
                }
                case 15: {
                    continue block24;
                }
                case 5: {
                    return GDBTokenType.NUMBER;
                }
                case 16: {
                    continue block24;
                }
                case 6: {
                    return GDBTokenType.STAR;
                }
                case 17: {
                    continue block24;
                }
                case 7: {
                    return GDBTokenType.QUOTED_STRING;
                }
                case 18: {
                    continue block24;
                }
                case 8: {
                    return GDBTokenType.DASHDASH;
                }
                case 19: {
                    continue block24;
                }
                case 9: {
                    return GDBTokenType.AT;
                }
                case 20: {
                    continue block24;
                }
                case 10: {
                    return GDBTokenType.FORMAT_SPECIFIER;
                }
                case 21: {
                    continue block24;
                }
                case 11: {
                    return GDBTokenType.HEX_NUMBER;
                }
                case 22: {
                    continue block24;
                }
            }
            this.zzScanError(1);
        }
    }
}

