/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.google.protobuf.GeneratedMessage;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.GLogOutputReaders;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerFatalException;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakPointBroadcast;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverException;
import com.jetbrains.cidr.execution.debugger.backend.lldb.ProtobufMessageFactory;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Broadcasts;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Model;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import com.jetbrains.cidr.execution.debugger.backend.lldb.lang.LLDBLanguage;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufServer;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufTimedOutException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBDriver
extends DebuggerDriver
implements Consumer<GeneratedMessage> {
    public static final Logger LOG = CidrDebuggerLog.LOG;
    public static final Key<Boolean> ENABLE_STL_RENDERERS = Key.create((String)"LLDBDriver.synthethicsEnabled");
    private static final Key<Integer> LLVALUE_ID = Key.create((String)"LLDBDriver.LLVALUE_ID");
    private static final Key<LLValueDataLoader> LLVALUE_DATA_LOADER = Key.create((String)"LLDBDriver.LLVALUE_DATA_LOADER");
    private static final Key<LLValueData> LLVALUE_DATA = Key.create((String)"LLDBDriver.LLVALUE_DATA");
    private static final Key<Integer> CHILDREN_COUNT_CACHE = Key.create((String)"LLDBDriver.CHILDREN_COUNT_CACHE");
    private static final Key<Integer> MAX_REQUESTED_CHILDREN_COUNT_CACHE = Key.create((String)"LLDBDriver.MAX_REQUESTED_CHILDREN_COUNT_CACHE");
    public static final String NO_RESULT = "<no result>";
    private volatile boolean myRemote;
    @Nullable
    private volatile String myArchitectureId;
    private GeneralCommandLine myLLDBCommandLine;
    private OSProcessHandler myLLDBFrontendHandler;
    private final ExecutionResult<ProtobufServer<Protocol.CompositeResponse>> myConnectedClient = new ExecutionResult();
    private final Set<Integer> myTemporaryBreakpoints = new HashSet<Integer>();
    private final ProcessInputWriter myProcessInputHandler = new ProcessInputWriter();
    private volatile Integer myAsyncAttachingTo;
    private final LLDBDriverConfiguration myStarter;
    private boolean myValuesFilteringEnabled;
    private ProtobufServer<Protocol.CompositeResponse> myProtobufServer;
    private final GLogOutputReaders myGLogOutputReaders;
    private final AtomicReference<DebuggerFatalException> myAsyncFatalException = new AtomicReference();
    private volatile long myStoppedThreadID;

    private void dispatchInput(String input, Model.DispatchTarget target) throws com.intellij.execution.ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.dispatchInput(input, target);
        this.getProtobufClient().sendMessage(request, Protocol.DispatchInput_Res.class, dispatchInput_res -> {}, null);
    }

    protected ProtobufServer<Protocol.CompositeResponse> getProtobufClient() throws com.intellij.execution.ExecutionException {
        this.checkErrors();
        return this.myConnectedClient.get();
    }

    private void storeAsyncFatalException(DebuggerFatalException e) {
        this.myAsyncFatalException.compareAndSet(null, e);
    }

    @Override
    public void checkErrors() throws com.intellij.execution.ExecutionException {
        DebuggerFatalException exception = this.myAsyncFatalException.get();
        if (exception != null) {
            this.myAsyncFatalException.compareAndSet(exception, null);
            throw new DebuggerFatalException((Throwable)((Object)exception));
        }
    }

    public LLDBDriver(DebuggerDriver.Handler handler2, LLDBDriverConfiguration starter) {
        super(handler2);
        this.myStarter = starter;
        this.myGLogOutputReaders = new GLogOutputReaders(LLDBDriver.getLogDir(), "LLDBFrontend"){

            @Override
            protected void onTextAvailable(@NotNull String text, @NotNull GLogOutputReaders.LogType type2) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(text.trim());
                }
            }
        };
    }

    @NotNull
    private static File getLogDir() {
        return new File(ApplicationManager.getApplication().isUnitTestMode() ? PathManager.getSystemPath() + "/testlog" : PathManager.getLogPath());
    }

    @Override
    public boolean supportsWatchpointLifetime() {
        return false;
    }

    @Override
    public boolean supportsDisasm() {
        return false;
    }

    @Override
    @NotNull
    public Language getConsoleLanguage() {
        return LLDBLanguage.INSTANCE;
    }

    @Override
    @NotNull
    public ProcessHandler getProcessHandler() {
        return this.myLLDBFrontendHandler;
    }

    @Override
    public boolean isInPromptMode() {
        return false;
    }

    public int getPort() {
        return this.myProtobufServer.getPort();
    }

    @Override
    public void start(@NotNull Installer installer, @Nullable String architecture) throws com.intellij.execution.ExecutionException {
        this.myInstaller = installer;
        this.myArchitectureId = architecture;
        try {
            this.myProtobufServer = new ProtobufServer<Protocol.CompositeResponse>((Consumer)this, (ProtobufServer.ProtobufParser)new ProtobufServer.ProtobufParser<Protocol.CompositeResponse>(){

                @Override
                public Protocol.CompositeResponse parse(byte[] buffer) throws IOException {
                    return Protocol.CompositeResponse.parseFrom(buffer);
                }

                @Override
                public boolean decompose(GeneratedMessage response) {
                    return response instanceof Protocol.CompositeResponse || response instanceof Broadcasts.CompositeBroadcast;
                }
            }){

                @Override
                protected void handleIOException(IOException e) {
                    CidrDebuggerLog.LOG.warn((Throwable)e);
                    if (!LLDBDriver.this.myConnectedClient.isDone()) {
                        LLDBDriver.this.myConnectedClient.setException(e);
                    } else {
                        LLDBDriver.this.storeAsyncFatalException(new DebuggerFatalException(e));
                    }
                }
            };
        }
        catch (IOException e) {
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
        this.myLLDBCommandLine = this.myStarter.createDriverCommandLine(this, installer);
        Map environment = this.myLLDBCommandLine.getEnvironment();
        environment.put("GLOG_log_dir", this.myGLogOutputReaders.getLogDir().getPath());
        if (LOG.isTraceEnabled()) {
            environment.put("GLOG_minloglevel", "0");
            environment.put("GLOG_logbufsecs", "0");
            environment.put("GLOG_v", "1");
            this.myGLogOutputReaders.init();
        } else {
            environment.put("GLOG_minloglevel", "2");
        }
        this.myLLDBFrontendHandler = new LLDBProcessHandler(this.myLLDBCommandLine);
        this.myLLDBFrontendHandler.setShouldDestroyProcessRecursively(false);
        this.myLLDBFrontendHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                if (!LLDBDriver.this.myConnectedClient.isDone()) {
                    LLDBDriver.this.myConnectedClient.setException(new ExecutionFinishedException());
                }
                LLDBDriver.this.myProcessInputHandler.close();
                LLDBDriver.this.handleExited(event.getExitCode());
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                String text = event.getText();
                if (text != null && CidrDebuggerLog.LOG.isDebugEnabled()) {
                    CidrDebuggerLog.LOG.debug(PathUtil.getFileName((String)LLDBDriver.this.myLLDBCommandLine.getExePath()) + ": " + text);
                }
                if (outputType == ProcessOutputTypes.STDERR) {
                    LLDBDriver.this.handleTargetOutput(event.getText(), outputType);
                }
            }
        });
    }

    @Override
    protected void closeOutputReaders() {
        super.closeOutputReaders();
        this.myGLogOutputReaders.close();
    }

    @Override
    public void setValuesFilteringEnabled(boolean enabled) throws com.intellij.execution.ExecutionException {
        if (this.myValuesFilteringEnabled == enabled) {
            return;
        }
        this.myValuesFilteringEnabled = enabled;
        LLDBDriver.doSetValuesFilteringEnabled(enabled, this.getProtobufClient());
    }

    private static void doSetValuesFilteringEnabled(boolean enabled, ProtobufServer<Protocol.CompositeResponse> client) throws com.intellij.execution.ExecutionException {
        client.sendMessageAndWaitForReply(ProtobufMessageFactory.setValuesFilteringEnabled(enabled), Protocol.ValuesFilteringPolicy_Res.class, new ThrowIfNotValid("couldn't set values filtering policy"));
    }

    @Override
    public void loadForLaunch() throws com.intellij.execution.ExecutionException {
        this.myTargetCommandLine = this.myInstaller.install();
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget(this.myInstaller.getExecutableFile().getPath(), StringUtil.notNullize((String)this.myArchitectureId)));
    }

    @Override
    public void loadForAttach() throws com.intellij.execution.ExecutionException {
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget("", ""));
    }

    public void loadForRemoteLaunch(@NotNull File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings) throws com.intellij.execution.ExecutionException {
        this.myRemote = true;
        this.myTargetCommandLine = this.myInstaller.install();
        String exePath = this.myInstaller.getExecutableFile().getPath();
        String remoteExePath = this.myTargetCommandLine.getExePath();
        CidrDebuggerLog.LOG.debug("creating remote target: exepath: " + exePath + " remotePath: " + remoteExePath + " arch: " + StringUtil.notNullize((String)this.myArchitectureId));
        this.sendCreateTargetRequest(ProtobufMessageFactory.createRemoteTarget(exePath, StringUtil.notNullize((String)this.myArchitectureId), "remote-ios", sysroot.getAbsolutePath(), remoteExePath));
        this.addPathMapping(pathMappings);
    }

    private void addPathMapping(@NotNull List<DebuggerDriver.PathMapping> mappings) throws com.intellij.execution.ExecutionException {
        StringBuilder builder = new StringBuilder();
        for (DebuggerDriver.PathMapping each : mappings) {
            builder.append("\"").append(each.from).append("\" ");
            builder.append("\"").append(each.to).append("\" ");
        }
        this.myProtobufServer.sendMessageAndWaitForReply(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "target modules search-paths add " + builder.toString()), Protocol.HandleConsoleCommand_Res.class, new ThrowIfNotValid(CidrDebuggerBundle.message("debug.command.error.cannotAddModulesSearchPaths", new Object[0])), Integer.MAX_VALUE);
    }

    protected void sendCreateTargetRequest(@NotNull Protocol.CompositeRequest createTargetRequest) throws com.intellij.execution.ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't create target");
        this.getProtobufClient().sendMessageAndWaitForReply(createTargetRequest, Protocol.CreateTarget_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    public long launch() throws com.intellij.execution.ExecutionException {
        Protocol.CompositeRequest launchReq;
        final Ref launchedPid = new Ref();
        ThrowIfNotValid<Protocol.Launch_Res> responseHandler = new ThrowIfNotValid<Protocol.Launch_Res>("Couldn't launch process"){

            @Override
            public void consume(Protocol.Launch_Res message2) {
                super.consume(message2);
                if (this.isValid()) {
                    launchedPid.set((Object)message2.getPid());
                }
            }
        };
        assert (this.myTargetCommandLine != null) : "Not Installed";
        String debugserverSocket = this.getDebugServerSocket();
        CidrDebuggerLog.LOG.assertTrue(debugserverSocket != null || !this.myRemote);
        if (!this.myRemote) {
            File tmpDir;
            if (this.myToRedirect) {
                this.initReaders(!SystemInfo.isWindows);
            }
            String stdoutPath = this.myReaders != null ? this.myReaders.getOutFileAbsolutePath() : null;
            String stderrPath = this.myReaders != null ? this.myReaders.getErrFileAbsolutePath() : null;
            try {
                tmpDir = FileUtil.createTempDirectory((String)"process_pipe_dir", null);
            }
            catch (IOException e) {
                throw new LLDBDriverException(CidrDebuggerBundle.message("debug.lldb.cannotCreatePipe", new Object[0]));
            }
            this.myProcessInputHandler.initPipeInput(tmpDir, "process_pipe");
            launchReq = ProtobufMessageFactory.launch(this.myTargetCommandLine, new File(tmpDir, "process_pipe").getAbsolutePath(), stdoutPath, stderrPath);
        } else {
            this.myProcessInputHandler.initDispatchInput();
            launchReq = ProtobufMessageFactory.remoteLaunch(this.myInstaller.getExecutableFile().getAbsolutePath(), this.myTargetCommandLine, debugserverSocket);
        }
        this.printTargetCommandLine(this.myTargetCommandLine);
        this.getProtobufClient().sendMessageAndWaitForReply(launchReq, Protocol.Launch_Res.class, (Consumer<Protocol.CompositeResponse>)responseHandler);
        if (this.myRemote && !responseHandler.isValid() && CidrDebuggerBundle.message("debug.lldb.lockedDeviceResponse", new Object[0]).equals(responseHandler.getMessage())) {
            throw new LLDBDriverException(CidrDebuggerBundle.message("debug.lldb.lockedDeviceUserMessage", ApplicationNamesInfo.getInstance().getProductName()));
        }
        responseHandler.throwIfNeeded();
        this.handlePrompt();
        return (Long)launchedPid.get();
    }

    @Override
    public void attachTo(int pid) throws com.intellij.execution.ExecutionException {
        this.myAsyncAttachingTo = pid;
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't attach to process");
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.attach(pid), Protocol.Attach_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
        this.handlePrompt();
    }

    @Override
    public void attachByName(String name, boolean wait) throws com.intellij.execution.ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't attach to process");
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.attachByName(name, wait), Protocol.AttachByName_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
        this.handlePrompt();
    }

    @Override
    public void detach() throws com.intellij.execution.ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't detach process");
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.detach(), Protocol.Detach_Res.class, responseHandler);
        if (!responseHandler.isValid() && !"Sending disconnect packet failed.".equals(responseHandler.getMessage())) {
            responseHandler.throwIfNeeded();
        }
        this.handleDetached();
    }

    @Override
    public boolean interrupt() throws com.intellij.execution.ExecutionException {
        Ref result2 = new Ref();
        Protocol.CompositeRequest req = ProtobufMessageFactory.suspend();
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.Suspend_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)suspend_res -> result2.set((Object)suspend_res.getCommonResponse().getIsValid())));
        return result2.isNull() ? false : (Boolean)result2.get();
    }

    @Override
    public boolean resume() throws com.intellij.execution.ExecutionException {
        boolean[] res = new boolean[1];
        Protocol.CompositeRequest resume = ProtobufMessageFactory.resume();
        this.getProtobufClient().sendMessageAndWaitForReply(resume, Protocol.Continue_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)continue_res -> {
            res[0] = continue_res.getCommonResponse().getIsValid();
        }));
        return res[0];
    }

    @Override
    public void stepOver(boolean stepByInstruction) throws com.intellij.execution.ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Error stepping over");
        Protocol.CompositeRequest request = ProtobufMessageFactory.stepOver(this.myStoppedThreadID);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.StepOver_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    public void stepInto(boolean stepByInstruction) throws com.intellij.execution.ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Error stepping into");
        Protocol.CompositeRequest request = ProtobufMessageFactory.stepInto(this.myStoppedThreadID);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.StepInto_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    public void stepOut() throws com.intellij.execution.ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Error stepping out");
        Protocol.CompositeRequest request = ProtobufMessageFactory.stepOut(this.myStoppedThreadID);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.StepOut_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTo(String path, int line) throws com.intellij.execution.ExecutionException {
        Set<Integer> set2 = this.myTemporaryBreakpoints;
        synchronized (set2) {
            try {
                List<LLBreakpoint> breakpoints = this.addBreakpoint(path, line);
                for (LLBreakpoint breakpoint : breakpoints) {
                    this.myTemporaryBreakpoints.add(breakpoint.getId());
                }
            }
            catch (DebuggerCommandException e) {
                throw new com.intellij.execution.ExecutionException("Cannot set a breakpoint", (Throwable)e);
            }
            if (!this.resume()) {
                throw new com.intellij.execution.ExecutionException("Couldn't resume program");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTemporaryBreakpoints() throws com.intellij.execution.ExecutionException {
        Set<Integer> set2 = this.myTemporaryBreakpoints;
        synchronized (set2) {
            for (int num : this.myTemporaryBreakpoints) {
                Protocol.CompositeRequest request = LLDBDriver.createRemoveBreakpointRequest(num);
                this.getProtobufClient().sendMessage(request, Protocol.RemoveBreakpoint_Res.class, res -> {
                    if (!res.getCommonResponse().getIsValid()) {
                        CidrDebuggerLog.LOG.error("Couldn't remove breakpoint. error: " + res.getCommonResponse().getErrorMessage());
                    }
                }, null);
            }
            this.myTemporaryBreakpoints.clear();
        }
    }

    @Override
    public boolean abort() throws com.intellij.execution.ExecutionException {
        Ref toThrow = Ref.create();
        Ref abort = Ref.create((Object)false);
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.kill(), Protocol.Kill_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> {
            Protocol.CommonResponse commonResponse = res.getCommonResponse();
            if (commonResponse.getIsValid()) {
                abort.set((Object)true);
            } else {
                String errorMessage = commonResponse.getErrorMessage();
                if ("process not exist".equals(errorMessage)) {
                    abort.set((Object)false);
                } else {
                    if (StringUtil.isEmptyOrSpaces((String)errorMessage)) {
                        errorMessage = "Failed to abort process";
                    }
                    toThrow.set((Object)new LLDBDriverException(errorMessage));
                }
            }
        }));
        return (Boolean)abort.get();
    }

    @Override
    @NotNull
    public LLWatchpoint addWatchpoint(long threadId, int frameIndex, LLValue value2, String expr, LLWatchpoint.Lifetime lifetime, LLWatchpoint.AccessType accessType) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        String expression2 = value2.getReferenceExpression();
        Protocol.CompositeRequest request = ProtobufMessageFactory.addWatchpoint(LLDBDriver.valId(value2), null, accessType == LLWatchpoint.AccessType.ANY || accessType == LLWatchpoint.AccessType.READ, accessType == LLWatchpoint.AccessType.ANY || accessType == LLWatchpoint.AccessType.WRITE, true);
        Ref result2 = Ref.create(null);
        Ref toThrow = Ref.create(null);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.AddWatchpoint_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> {
            if (!res.getCommonResponse().getIsValid()) {
                toThrow.set((Object)new DebuggerCommandException(res.getCommonResponse().getErrorMessage()));
            } else {
                result2.set((Object)new LLWatchpoint(res.getWatchpointId(), expression2));
            }
        }));
        if (result2.isNull()) {
            throw (DebuggerCommandException)toThrow.get();
        }
        return (LLWatchpoint)result2.get();
    }

    @Override
    @NotNull
    public List<LLBreakpoint> addBreakpoint(String path, int line, @Nullable String condition2) throws com.intellij.execution.ExecutionException {
        String convertedPath = this.myStarter.convertToProjectModelPath(path);
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(convertedPath, line + 1, condition2);
        Ref result2 = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.AddBreakpoint_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> result2.set((Object)new LLBreakpoint(res.getId(), convertedPath, line, res.hasNumLocations() ? res.getNumLocations() : 1L, res.hasNumResolvedLocations() ? res.getNumResolvedLocations() : 1L, false, res.getCommonResponse().getIsValid(), condition2, null))));
        return result2.isNull() ? Collections.emptyList() : Collections.singletonList(result2.get());
    }

    @Override
    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(symBreakpoint.getPattern(), symBreakpoint.isRegexpPattern(), symBreakpoint.getModule(), symBreakpoint.getCondition(), symBreakpoint.getThreadId());
        Ref result2 = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.AddBreakpoint_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> result2.set((Object)new LLSymbolicBreakpoint(res.getId()))));
        return (LLSymbolicBreakpoint)result2.get();
    }

    @Override
    public void removeCodepoints(@NotNull Collection<Integer> ids) throws com.intellij.execution.ExecutionException {
        for (Integer each : ids) {
            ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't remove breakpoint");
            Protocol.CompositeRequest req = LLDBDriver.createRemoveBreakpointRequest(each);
            this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.RemoveBreakpoint_Res.class, responseHandler);
            responseHandler.throwIfNeeded();
        }
    }

    private static Protocol.CompositeRequest createRemoveBreakpointRequest(int num) {
        return ProtobufMessageFactory.removeBreakpoint(num);
    }

    @NotNull
    private LLThread newLLThread(@NotNull Model.LLDBThread lldbThread) {
        Model.ThreadStopReasonInfo stopReasonInfo = lldbThread.getStopReasonInfo();
        boolean isStopped = stopReasonInfo != null && stopReasonInfo.getStopReason() != Model.ThreadStopReason.ThreadStopReasonInvalid;
        return new LLThread(lldbThread.getId(), isStopped ? "STOPPED" : null, lldbThread.getQueue(), lldbThread.getName());
    }

    @NotNull
    private LLFrame newLLFrame(@NotNull Model.LLDBFrame frame) {
        return new LLFrame(frame.getNumber(), frame.hasFunction() ? frame.getFunction() : null, frame.hasFile() ? this.myStarter.convertToLocalPath(frame.getFile()) : null, frame.hasLine() ? frame.getLine() - 1 : -1, frame.hasPc() ? frame.getPc() : 0L, frame.hasLanguage() ? LLDBDriver.convertLanguage(frame.getLanguage()) : null, frame.hasOptimized() && frame.getOptimized());
    }

    @Nullable
    private static DebuggerDriver.DebuggerLanguage convertLanguage(@Nullable Model.Language language) {
        if (language != null) {
            switch (language) {
                case LanguageC: 
                case LanguageC89: 
                case LanguageC99: 
                case LanguageC11: {
                    return DebuggerDriver.StandardDebuggerLanguage.C;
                }
                case LanguageC_plus_plus: 
                case LanguageC_plus_plus_03: 
                case LanguageC_plus_plus_11: 
                case LanguageC_plus_plus_14: {
                    return DebuggerDriver.StandardDebuggerLanguage.C_PLUS_PLUS;
                }
                case LanguageObjC: {
                    return DebuggerDriver.StandardDebuggerLanguage.OBJC;
                }
                case LanguageObjC_plus_plus: {
                    return DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS;
                }
                case LanguageSwift: {
                    return DebuggerDriver.StandardDebuggerLanguage.SWIFT;
                }
                case UnsupportedLanguage: {
                    CidrDebuggerLog.LOG.warn("Unknown language reported by LLDB. Protocol needs to be updated");
                }
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static Model.Language convertLanguage(@Nullable DebuggerDriver.DebuggerLanguage language) throws DebuggerCommandException {
        if (language == null) {
            return null;
        }
        if (language instanceof DebuggerDriver.StandardDebuggerLanguage) {
            switch ((DebuggerDriver.StandardDebuggerLanguage)language) {
                case C: {
                    return Model.Language.LanguageC;
                }
                case C_PLUS_PLUS: {
                    return Model.Language.LanguageC_plus_plus;
                }
                case OBJC: {
                    return Model.Language.LanguageObjC;
                }
                case OBJC_PLUS_PLUS: {
                    return Model.Language.LanguageObjC_plus_plus;
                }
                case SWIFT: {
                    return Model.Language.LanguageSwift;
                }
            }
        }
        throw new DebuggerCommandException(language.toString() + " is not supported by LLDB");
    }

    @Override
    @NotNull
    public List<LLThread> getThreads() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        ArrayList<LLThread> result2 = new ArrayList<LLThread>();
        Protocol.CompositeRequest request = ProtobufMessageFactory.getThreads();
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetThreads_Res.class, res -> {
            for (Model.LLDBThread each : res.getThreadList()) {
                result2.add(this.newLLThread(each));
            }
        }, Integer.MAX_VALUE);
        return result2;
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLFrame> getFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Ref result2 = new Ref();
        Protocol.CompositeRequest request = ProtobufMessageFactory.getFrames(threadId, from, count, untilFirstLineWithCode);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetFrames_Res.class, res -> {
            List<Model.LLDBFrame> lldbFrames = res.getFrameList();
            ArrayList<LLFrame> frames = new ArrayList<LLFrame>(lldbFrames.size());
            for (Model.LLDBFrame frame : lldbFrames) {
                frames.add(this.newLLFrame(frame));
            }
            result2.set(DebuggerDriver.ResultList.create(frames, res.getHasMore()));
        }, Integer.MAX_VALUE);
        return (DebuggerDriver.ResultList)result2.get();
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex) throws com.intellij.execution.ExecutionException {
        boolean staticsAndGlobals = this.myStarter.isStaticVarsLoadingEnabled();
        return this.getVariables(threadId, frameIndex, staticsAndGlobals, staticsAndGlobals);
    }

    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex, boolean statics, boolean globals) throws com.intellij.execution.ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.getVars(threadId, frameIndex, statics, globals);
        ArrayList<LLValue> result2 = new ArrayList<LLValue>();
        Ref errorMessage = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetVars_Res.class, res -> {
            Protocol.CommonResponse commonResponse = res.getCommonResponse();
            if (!commonResponse.getIsValid()) {
                String message2 = commonResponse.getErrorMessage();
                if (message2 != null) {
                    errorMessage.set((Object)message2);
                }
            } else {
                for (Model.LLDBValue lldbValue : res.getValueList()) {
                    result2.add(this.createLLValue(lldbValue, null));
                }
            }
        }, 0L);
        if (!errorMessage.isNull() && !StringUtil.isEmpty((String)((String)errorMessage.get()))) {
            throw new com.intellij.execution.ExecutionException((String)errorMessage.get());
        }
        return result2;
    }

    @Override
    @NotNull
    public LLValueData getData(@NotNull LLValue value2) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        return LLDBDriver.getLLValueData(value2);
    }

    @Override
    @Nullable
    public String getDescription(@NotNull LLValue value2, int maxLength) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.getValueDescription(LLDBDriver.valId(value2), maxLength);
        Ref description = Ref.create();
        Ref exception = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.GetValueDescription_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> {
            Protocol.CommonResponse commonResponse = res.getCommonResponse();
            if (!commonResponse.getIsValid()) {
                exception.set((Object)new DebuggerCommandException(commonResponse.getErrorMessage()));
                return;
            }
            if (res.hasDescription()) {
                description.set((Object)res.getDescription());
            }
        }));
        if (!exception.isNull()) {
            throw (DebuggerCommandException)exception.get();
        }
        return (String)description.get();
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(LLValue value2, int from, int count) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Integer childrenCount = this.getChildrenCount(value2, from + count + 1);
        if (childrenCount == 0) {
            return DebuggerDriver.ResultList.empty();
        }
        Protocol.CompositeRequest request = ProtobufMessageFactory.getValueChildren(LLDBDriver.valId(value2), from, count);
        Ref errorMessage = new Ref();
        ArrayList result2 = new ArrayList();
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetValueChildren_Res.class, res -> {
            boolean isValid = res.getCommonResponse().getIsValid();
            if (!isValid) {
                errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
            } else {
                this.convertList(res.getValueList(), result2);
            }
        }, 0L);
        String message2 = (String)errorMessage.get();
        if (message2 != null) {
            throw new DebuggerCommandException(message2);
        }
        boolean hasMore = from + count < childrenCount;
        return DebuggerDriver.ResultList.create(result2, hasMore);
    }

    @Override
    public void addSymbolsFile(File dSYM, File module2) throws com.intellij.execution.ExecutionException {
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "target module add \"" + module2.getAbsolutePath() + "\""), Protocol.HandleConsoleCommand_Res.class, new ThrowIfNotValid("couldn't add module: " + module2.getAbsolutePath()));
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "target symbols add \"" + dSYM.getAbsolutePath() + "\""), Protocol.HandleConsoleCommand_Res.class, new ThrowIfNotValid("couldn't add dSYM: " + dSYM.getAbsolutePath()));
    }

    private void convertList(List<Model.LLDBValue> valuesList, List<LLValue> result2) {
        for (Model.LLDBValue val : valuesList) {
            LLValue value2 = this.createLLValue(val, null);
            result2.add(value2);
        }
    }

    private static int valId(@NotNull LLValue var) throws com.intellij.execution.ExecutionException {
        return (Integer)var.getUserData(LLVALUE_ID);
    }

    public List<LLValue> arraySlice(LLValue var, int offset, int count) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Ref errorMessage = Ref.create((Object)"unknown error");
        ArrayList<LLValue> vals = new ArrayList<LLValue>();
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.arraySlice(LLDBDriver.valId(var), offset, count), Protocol.GetArraySlice_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> {
            if (!res.getCommonResponse().getIsValid()) {
                String message2 = res.getCommonResponse().getErrorMessage();
                if (message2 != null) {
                    errorMessage.set((Object)message2);
                }
                return;
            }
            errorMessage.set(null);
            this.convertList(res.getValueList(), vals);
        }));
        if (!errorMessage.isNull()) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        return vals;
    }

    @NotNull
    private LLValue createLLValue(@NotNull Model.LLDBValue lldbValue, @Nullable String expression2) {
        LLValue.TypeClass typeClass;
        switch (lldbValue.getTypeClass()) {
            case TypeClassFunction: {
                typeClass = LLValue.TypeClass.FUNCTION;
                break;
            }
            case TypeClassBuiltin: {
                typeClass = LLValue.TypeClass.BUILTIN;
                break;
            }
            case TypeClassClass: 
            case TypeClassStruct: {
                typeClass = LLValue.TypeClass.CLASS_STRUCT;
                break;
            }
            case TypeClassObjCObjectPointer: {
                typeClass = LLValue.TypeClass.OBJC_POINTER;
                break;
            }
            default: {
                typeClass = null;
            }
        }
        String referenceExpression = lldbValue.getName();
        LLValue result2 = new LLValue(expression2 == null ? lldbValue.getName() : expression2, lldbValue.getType(), typeClass, referenceExpression);
        result2.putUserData(LLVALUE_ID, lldbValue.getId());
        result2.putUserData(LLVALUE_DATA_LOADER, new LLValueDataLoader());
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static LLValueData getLLValueData(@NotNull LLValue value2) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        LLValue lLValue = value2;
        synchronized (lLValue) {
            LLValueDataLoader loader = (LLValueDataLoader)value2.getUserData(LLVALUE_DATA_LOADER);
            if (loader != null) {
                LLValueData data = loader.loadData(value2);
                value2.putUserData(LLVALUE_DATA_LOADER, null);
                value2.putUserData(LLVALUE_DATA, data);
                return data;
            }
            LLValueData data = (LLValueData)value2.getUserData(LLVALUE_DATA);
            if (data == null) {
                throw new com.intellij.execution.ExecutionException("Internal error, variable _p not initialized: " + (Object)((Object)value2));
            }
            return data;
        }
    }

    @Override
    @NotNull
    public LLValue evaluate(long threadId, int frameIndex, @NotNull String expression2, @Nullable DebuggerDriver.DebuggerLanguage language) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.evaluateExpression(threadId, frameIndex, expression2, LLDBDriver.convertLanguage(language));
        Ref result2 = new Ref();
        Ref errorMessage = new Ref();
        try {
            this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.EvaluateExpression_Res.class, res -> {
                if (res.getCommonResponse().getIsValid()) {
                    if (res.hasResult()) {
                        Model.LLDBValue lldbValue = res.getResult();
                        LLValue value2 = this.createLLValue(lldbValue, expression2);
                        result2.set((Object)value2);
                    } else {
                        errorMessage.set((Object)NO_RESULT);
                    }
                } else {
                    String error = res.getCommonResponse().getErrorMessage();
                    errorMessage.set((Object)(error != null ? error : "Unknown evaluation error"));
                }
            }, 0L);
        }
        catch (ProtobufTimedOutException e) {
            throw new DebuggerEvaluationTimedOutException(expression2);
        }
        if (!errorMessage.isNull()) {
            String message2 = (String)errorMessage.get();
            if (NO_RESULT.equals(message2)) {
                LLValue resultValue = new LLValue("result", "void", null, "");
                resultValue.putUserData(LLVALUE_ID, 0);
                resultValue.putUserData(LLVALUE_DATA, new LLValueData("", null, false, false, false));
                resultValue.putUserData(CHILDREN_COUNT_CACHE, 0);
                return resultValue;
            }
            Pattern p = Pattern.compile("error: (.*)\nerror: \\d+ error[s]? parsing expression\n");
            Matcher matcher = p.matcher(message2);
            if (matcher.find()) {
                message2 = matcher.group(1);
            }
            throw new DebuggerCommandException(message2);
        }
        if (result2.isNull()) {
            throw new com.intellij.execution.ExecutionException("Unknown evaluation error");
        }
        return (LLValue)((Object)result2.get());
    }

    @Override
    @NotNull
    public List<LLInstruction> disassemble(@NotNull AddressRange range) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        throw new com.intellij.execution.ExecutionException("Disassembling not implemented in " + this.getClass().getSimpleName());
    }

    @Override
    @NotNull
    public DebuggerDriver.ShellCommandResult executeShellCommand(@NotNull String executable, @Nullable List<String> params, @Nullable String workingDir, int timeoutSecs) throws com.intellij.execution.ExecutionException {
        Ref result2 = new Ref();
        Ref errorMessage = new Ref();
        LinkedList<String> args = new LinkedList<String>();
        args.add(executable);
        if (params != null) {
            args.addAll(params);
        }
        String command = StringUtil.join(args, s -> StringUtil.escapeCharCharacters((String)s), (String)" ");
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.executeShellCommand(command, workingDir, timeoutSecs), Protocol.ExecuteShellCommand_Res.class, res -> {
            Protocol.CommonResponse commonResponse = res.getCommonResponse();
            if (!commonResponse.getIsValid()) {
                String message2 = commonResponse.getErrorMessage();
                errorMessage.set((Object)(message2 != null && !StringUtil.isEmpty((String)message2) ? message2 : "Invalid shell command response"));
            } else {
                result2.set((Object)new DebuggerDriver.ShellCommandResult(res.getOutput(), res.getStatus(), res.getSignal()));
            }
        }, (timeoutSecs + 10) * 1000);
        if (!errorMessage.isNull()) {
            throw new com.intellij.execution.ExecutionException((String)errorMessage.get());
        }
        return (DebuggerDriver.ShellCommandResult)result2.get();
    }

    @Override
    public void executeConsoleCommand(String command) throws com.intellij.execution.ExecutionException {
        this.executeConsoleCommand(-1L, -1, command);
    }

    @Override
    public void executeConsoleCommand(long threadId, int frameIndex, String command) throws com.intellij.execution.ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.handleConsoleCommand(threadId, frameIndex, command);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.HandleConsoleCommand_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> {
            if (res.hasOut()) {
                this.handleGDBOutput(res.getOut());
            }
            if (res.hasErr()) {
                this.handleGDBOutput(res.getErr());
            }
        }));
    }

    @Override
    public void handleCompletion(String command, int pos, List<String> completions) throws com.intellij.execution.ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.handleCompletion(command, pos);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.HandleCompletion_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> completions.addAll(res.getCompletionList())));
    }

    @Override
    public void handleSignal(String signalName, boolean stop2, boolean pass, boolean notify) throws com.intellij.execution.ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't handle signal");
        Protocol.CompositeRequest handleSignalReq = ProtobufMessageFactory.handleSignal(signalName, stop2, pass, notify);
        this.getProtobufClient().sendMessageAndWaitForReply(handleSignalReq, Protocol.HandleSignal_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    protected String getPromptText() {
        return "lldb";
    }

    @Override
    public OutputStream getProcessInput() {
        return this.myProcessInputHandler;
    }

    @Override
    public void removeWatchpoint(List<Integer> ids) throws com.intellij.execution.ExecutionException {
        int num = ids.get(0);
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't remove watchpoint");
        Protocol.CompositeRequest req = ProtobufMessageFactory.removeWatchpoint(num);
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.RemoveWatchpoint_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    @NotNull
    public Integer getChildrenCount(@NotNull LLValue var, int max) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Integer cached = (Integer)var.getUserData(CHILDREN_COUNT_CACHE);
        if (cached != null) {
            Integer max_cache = (Integer)var.getUserData(MAX_REQUESTED_CHILDREN_COUNT_CACHE);
            assert (max_cache != null);
            if (cached < max_cache) {
                return cached;
            }
            if (max < max_cache) {
                return max;
            }
        }
        Protocol.CompositeRequest request = ProtobufMessageFactory.getChildrenCount(LLDBDriver.valId(var), max);
        Ref errorMessage = new Ref();
        Ref result2 = Ref.create((Object)0);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetChildrenCount_Res.class, res -> {
            boolean isValid = res.getCommonResponse().getIsValid();
            if (!isValid) {
                errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
            } else {
                result2.set((Object)res.getCount());
            }
        }, 0L);
        if (!errorMessage.isNull()) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        var.putUserData(MAX_REQUESTED_CHILDREN_COUNT_CACHE, max);
        var.putUserData(CHILDREN_COUNT_CACHE, result2.get());
        return (Integer)result2.get();
    }

    public long getValueAddress(@NotNull LLValue var) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.getValueAddress(LLDBDriver.valId(var));
        Ref errorMessage = new Ref();
        Ref result2 = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetValueAddress_Res.class, res -> {
            boolean isValid = res.getCommonResponse().getIsValid();
            if (!isValid) {
                errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
            } else {
                result2.set((Object)res.getAddress());
            }
        }, 0L);
        if (!errorMessage.isNull()) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        return (Long)result2.get();
    }

    private void haveConnection() {
        try {
            this.myProtobufServer.sendMessage(ProtobufMessageFactory.setValuesFilteringEnabled(CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED), Protocol.ValuesFilteringPolicy_Res.class, new ThrowIfNotValid<Protocol.ValuesFilteringPolicy_Res>("couldn't set values filtering policy"){

                @Override
                public void consume(Protocol.ValuesFilteringPolicy_Res message2) {
                    super.consume(message2);
                    Consumer completion = res -> LLDBDriver.this.myConnectedClient.set(LLDBDriver.this.myProtobufServer);
                    if (LLDBDriver.this.myLLDBCommandLine.getUserData(ENABLE_STL_RENDERERS) == Boolean.TRUE) {
                        LLDBDriver.this.myProtobufServer.sendMessage(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "script import lldb_formatters.jetbrains_stl_formatters"), Protocol.HandleConsoleCommand_Res.class, res -> {
                            if (res.hasOut() || res.hasErr()) {
                                String message1 = "Error during data formatters setup:\n";
                                if (res.hasOut()) {
                                    message1 = message1 + res.getOut();
                                }
                                if (res.hasErr()) {
                                    message1 = message1 + res.getErr();
                                }
                                LLDBDriver.this.handleTargetOutput(message1, ProcessOutputTypes.SYSTEM);
                            }
                            if (CidrDebuggerLog.LOG.isTraceEnabled()) {
                                String logPath = LLDBDriver.getLogDir() + "/lldb.log";
                                LLDBDriver.this.myProtobufServer.sendMessage(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "log enable -f " + logPath + " lldb default"), Protocol.HandleConsoleCommand_Res.class, completion);
                            } else {
                                completion.consume(null);
                            }
                        });
                    } else {
                        completion.consume(null);
                    }
                }
            });
        }
        catch (Exception e) {
            this.myConnectedClient.setException(e);
        }
    }

    public void consume(GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Model.Initialized_Message) {
            this.haveConnection();
        } else if (generatedMessage instanceof Broadcasts.ProcessExited_Broadcast) {
            Broadcasts.ProcessExited_Broadcast exit = (Broadcasts.ProcessExited_Broadcast)generatedMessage;
            int exitCode = exit.getExitCode();
            this.handleTargetFinished(exitCode, exit.hasExitDescription() ? exit.getExitDescription() : null);
        } else if (generatedMessage instanceof Broadcasts.ProcessRunning_Broadcast) {
            Integer attachedTo = this.myAsyncAttachingTo;
            this.myAsyncAttachingTo = null;
            if (attachedTo != null) {
                this.handleAttached(attachedTo);
            }
            this.handleRunning();
        } else if (generatedMessage instanceof Broadcasts.ProcessInterrupted_Broadcast) {
            Model.ThreadStopReason stopReason;
            try {
                this.removeTemporaryBreakpoints();
            }
            catch (com.intellij.execution.ExecutionException attachedTo) {
                // empty catch block
            }
            Broadcasts.ProcessInterrupted_Broadcast interrupted_broadcast = (Broadcasts.ProcessInterrupted_Broadcast)generatedMessage;
            Model.LLDBThread lldbThread = interrupted_broadcast.getThread();
            LLThread thread = this.newLLThread(lldbThread);
            LLFrame frame = this.newLLFrame(interrupted_broadcast.getFrame());
            DebuggerDriver.StopPlace stopPlace = new DebuggerDriver.StopPlace(thread, frame);
            this.myStoppedThreadID = stopPlace.thread.getId();
            Model.ThreadStopReasonInfo stopReasonInfo = lldbThread.getStopReasonInfo();
            Model.ThreadStopReason threadStopReason = stopReason = stopReasonInfo == null ? null : stopReasonInfo.getStopReason();
            if (stopReason == Model.ThreadStopReason.ThreadStopReasonBreakpoint && stopReasonInfo.hasCodepointId()) {
                this.handleBreakpoint(stopPlace, stopReasonInfo.getCodepointId());
            } else if (stopReason == Model.ThreadStopReason.ThreadStopReasonWatchpoint && stopReasonInfo.hasCodepointId()) {
                this.handleWatchpoint(stopPlace, stopReasonInfo.getCodepointId());
            } else if (stopReason == Model.ThreadStopReason.ThreadStopReasonSignal) {
                int signal = stopReasonInfo.getSignal();
                String signalName = stopReasonInfo.getSignalName();
                if (LLDBDriver.isTargetTerminationSignal(signal)) {
                    this.handleTargetTerminated();
                } else {
                    this.handleSignal(stopPlace, !signalName.isEmpty() ? signalName : String.valueOf(signal), stopReasonInfo.getStopDescription());
                }
            } else if (stopReason == Model.ThreadStopReason.ThreadStopReasonException) {
                this.handleException(stopPlace, stopReasonInfo.getStopDescription());
            } else {
                this.handleInterrupted(stopPlace);
            }
        } else if (generatedMessage instanceof Broadcasts.ChangePrompt_Broadcast) {
            this.handlePrompt(((Broadcasts.ChangePrompt_Broadcast)generatedMessage).getPrompt());
        } else if (generatedMessage instanceof Broadcasts.ReadyForCommands_Broadcast) {
            this.handlePrompt(((Broadcasts.ReadyForCommands_Broadcast)generatedMessage).getReady() == 0);
        } else if (generatedMessage instanceof Broadcasts.CommandsInterpreter_Broadcast) {
            this.handleGDBOutput(((Broadcasts.CommandsInterpreter_Broadcast)generatedMessage).getMessage());
        } else if (generatedMessage instanceof Broadcasts.TargetProcessOutput_Broadcast) {
            Broadcasts.TargetProcessOutput_Broadcast outputBroadcast = (Broadcasts.TargetProcessOutput_Broadcast)generatedMessage;
            this.handleTargetOutput(outputBroadcast.getText(), LLDBDriver.outputType2ProcessOutputKey(outputBroadcast.getOutputType()));
        } else if (generatedMessage instanceof Broadcasts.LogMessage_Broadcast) {
            String message2 = ((Broadcasts.LogMessage_Broadcast)generatedMessage).getMessage();
            CidrDebuggerLog.LOG.info(message2);
        } else if (generatedMessage instanceof Broadcasts.ModulesLoaded_Broadcast) {
            this.handleModulesLoaded(((Broadcasts.ModulesLoaded_Broadcast)generatedMessage).getModulesList());
        } else if (generatedMessage instanceof Broadcasts.BreakpointChanged_Broadcast) {
            Broadcasts.BreakpointChanged_Broadcast breakpoint_change = (Broadcasts.BreakpointChanged_Broadcast)generatedMessage;
            this.handleBreakpointChanged(new LLBreakPointBroadcast(breakpoint_change.getBreakpointId(), breakpoint_change.getIsValid(), breakpoint_change.getNumLocations(), breakpoint_change.getNumResolvedLocations()));
        }
    }

    private static Key outputType2ProcessOutputKey(Model.OutputType outputType) {
        return outputType == Model.OutputType.OutputTypeStdout ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR;
    }

    private class LLDBProcessHandler
    extends OSProcessHandler {
        public LLDBProcessHandler(GeneralCommandLine commandLine) throws com.intellij.execution.ExecutionException {
            super(commandLine);
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            return BaseOutputReader.Options.BLOCKING;
        }

        protected void doDestroyProcess() {
            if (LLDBDriver.this.myConnectedClient.isDone()) {
                try {
                    ((ProtobufServer)LLDBDriver.this.myConnectedClient.get()).sendMessage(ProtobufMessageFactory.exit(), null, null);
                }
                catch (com.intellij.execution.ExecutionException executionException) {
                    // empty catch block
                }
            }
            LLDBDriver.this.myProtobufServer.tearDown();
            try {
                this.executeOnPooledThread(() -> {
                    try {
                        this.getProcess().waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }).get(4L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            super.doDestroyProcess();
        }
    }

    public class ProcessInputWriter
    extends OutputStream {
        private final Object myCloseOpLock = new Object();
        private File myInputFileDir;
        private volatile boolean closed;
        private volatile boolean pipeInput;
        private volatile OutputStream myOutputStream;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initPipeInput(@NotNull File inputFileDir, @NotNull String inputFileName) {
            this.pipeInput = true;
            this.closed = false;
            Object object = this.myCloseOpLock;
            synchronized (object) {
                this.myInputFileDir = inputFileDir;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                File inputFile = new File(inputFileDir, inputFileName);
                while (!this.closed && !inputFile.exists()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Throwable)e);
                        break;
                    }
                }
                if (this.closed) {
                    return;
                }
                Object object = this.myCloseOpLock;
                synchronized (object) {
                    if (inputFile.exists()) {
                        try {
                            this.myOutputStream = new FileOutputStream(inputFile);
                        }
                        catch (IOException e) {
                            LOG.warn((Throwable)e);
                        }
                    }
                }
            });
        }

        public void initDispatchInput() {
            this.pipeInput = false;
        }

        @Override
        public void write(int i2) throws IOException {
            LOG.error("Shouldn't be here");
        }

        @Override
        public void write(@NotNull byte[] bytes, int i2, int i1) throws IOException {
            if (this.pipeInput) {
                if (!this.closed && this.myOutputStream != null) {
                    this.myOutputStream.write(bytes, i2, i1);
                }
            } else {
                try {
                    String input = new String(bytes, i2, i1, LLDBDriver.this.myLLDBCommandLine.getCharset());
                    LLDBDriver.this.dispatchInput(input, Model.DispatchTarget.DispatchTargetProcess);
                }
                catch (com.intellij.execution.ExecutionException e) {
                    throw new IOException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        File getInputFileDir() {
            Object object = this.myCloseOpLock;
            synchronized (object) {
                return this.myInputFileDir;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (!this.pipeInput) {
                return;
            }
            this.closed = true;
            Object object = this.myCloseOpLock;
            synchronized (object) {
                if (this.myOutputStream != null) {
                    try {
                        this.myOutputStream.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                    if (this.myInputFileDir.exists()) {
                        FileUtil.delete((File)this.myInputFileDir);
                    }
                }
            }
        }
    }

    private class LLValueDataLoader {
        private LLValueDataLoader() {
        }

        @NotNull
        public LLValueData loadData(@NotNull LLValue value2) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            Protocol.CompositeRequest req = ProtobufMessageFactory.getValueData(LLDBDriver.valId(value2), 1000);
            Ref lldbDataRef = Ref.create();
            Ref exception = Ref.create();
            LLDBDriver.this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.GetValueData_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> {
                Protocol.CommonResponse commonResponse = res.getCommonResponse();
                if (!commonResponse.getIsValid()) {
                    exception.set((Object)new DebuggerCommandException(commonResponse.getErrorMessage()));
                    return;
                }
                lldbDataRef.set((Object)res.getValue());
            }));
            if (!exception.isNull()) {
                throw (DebuggerCommandException)exception.get();
            }
            Model.LLDBValueData lldbData = (Model.LLDBValueData)lldbDataRef.get();
            return new LLValueData(lldbData.getValue(), lldbData.hasDescription() ? lldbData.getDescription() : null, lldbData.getHasLongerDescription(), lldbData.getMayHaveChildren(), lldbData.getIsSynthetic());
        }
    }

    protected static class ThrowIfNotValid<T extends GeneratedMessage>
    implements Consumer<T> {
        private String myMessage;
        private boolean myIsValid = false;

        public ThrowIfNotValid(String mes) {
            this.myMessage = mes;
        }

        public void consume(T message2) {
            Map allFields = message2.getAllFields();
            for (Object val : allFields.values()) {
                String errorMessage;
                if (!(val instanceof Protocol.CommonResponse)) continue;
                Protocol.CommonResponse commonResponse = (Protocol.CommonResponse)val;
                this.myIsValid = commonResponse.getIsValid();
                if (this.myIsValid || !commonResponse.hasErrorMessage() || StringUtil.isEmptyOrSpaces((String)(errorMessage = commonResponse.getErrorMessage()))) continue;
                this.myMessage = errorMessage;
            }
        }

        public void throwIfNeeded() throws LLDBDriverException {
            if (!this.myIsValid) {
                throw new LLDBDriverException(this.myMessage);
            }
        }

        public String getMessage() {
            return this.myMessage;
        }

        public boolean isValid() {
            return this.myIsValid;
        }
    }
}

