/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import org.jetbrains.annotations.NotNull;

public class LLDBEvaluationContext
extends EvaluationContext {
    private final DebuggerDriver myDriver;

    public LLDBEvaluationContext(DebuggerDriver driver, Expirable expirable, CidrStackFrame frame) {
        super(driver, expirable, frame);
        this.myDriver = driver;
    }

    @Override
    @NotNull
    public String castIDToNumber(@NotNull String expr, @NotNull String type2) {
        return LLDBEvaluationContext.cast(expr, "long");
    }

    @Override
    @NotNull
    public String convertToRValue(@NotNull LLValueData lValueData, @NotNull Pair<LLValue, String> rValuePair) throws DebuggerCommandException, ExecutionException {
        LLValueData rValueData = this.getData((LLValue)((Object)rValuePair.first));
        if (rValueData.isNullPointer()) {
            return "((id)0)";
        }
        return lValueData.isPointer() && ((LLValue)((Object)rValuePair.first)).getType().equals("int") && rValueData.intValue() == 0L ? "0" : (String)rValuePair.getSecond();
    }

    public long getValueAddress(@NotNull LLValue value2) throws ExecutionException, DebuggerCommandException {
        return ((LLDBDriver)this.myDriver).getValueAddress(value2);
    }
}

