/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.execution.debugger.backend.lang.GDBTokenType;
import org.jetbrains.annotations.NotNull;

public class LLDBParser
implements PsiParser {
    private static final String[] LLDB_EXPRESSION_COMMANDS = new String[]{"print", "p", "po", "expression", "expr"};
    private static final String[] LLDB_NOUNS = new String[]{"breakpoint", "command", "frame", "log", "memory", "platform", "process", "register", "settings", "source", "target", "thread", "type"};

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        this.parseLLDBCommand(builder);
        mark.done(root);
        return builder.getTreeBuilt();
    }

    private void parseLLDBCommand(PsiBuilder builder) {
        PsiBuilder.Marker command = builder.mark();
        if (builder.getTokenType() == GDBTokenType.IDENTIFIER) {
            String commandName = builder.getTokenText();
            PsiBuilder.Marker commandNameMarker = builder.mark();
            builder.advanceLexer();
            if (this.isNoun(commandName) && !builder.eof() && builder.getTokenType() == GDBTokenType.IDENTIFIER) {
                builder.advanceLexer();
            }
            commandNameMarker.done((IElementType)GDBTokenType.COMMAND_NAME);
            if (!builder.eof()) {
                LLDBParser.parseCommandArguments(builder, LLDBParser.isExpressionCommand(commandName));
            }
        } else {
            LLDBParser.eatEverything(builder);
        }
        command.done((IElementType)GDBTokenType.DBG_COMMAND);
    }

    private boolean isNoun(String name) {
        return ArrayUtil.contains((String)name, (String[])LLDB_NOUNS);
    }

    private static boolean isExpressionCommand(String commandName) {
        return ArrayUtil.contains((String)commandName, (String[])LLDB_EXPRESSION_COMMANDS);
    }

    private static void parseCommandArguments(PsiBuilder builder, boolean isExpr) {
        PsiBuilder.Marker body2 = builder.mark();
        boolean noOptions = false;
        if (LLDBParser.isArgBegin(builder)) {
            boolean parseNextArg;
            do {
                parseNextArg = LLDBParser.parseArgument(builder);
            } while (LLDBParser.isArgBegin(builder) && parseNextArg);
            if (!parseNextArg) {
                if (isExpr) {
                    PsiBuilder.Marker expr = builder.mark();
                    LLDBParser.eatEverything(builder);
                    expr.done((IElementType)GDBTokenType.EXPRESSION_PLACEHOLDER);
                } else {
                    LLDBParser.eatEverything(builder);
                }
            }
        } else {
            noOptions = true;
            LLDBParser.eatEverything(builder);
        }
        body2.done((IElementType)(noOptions ? (isExpr ? GDBTokenType.EXPRESSION_PLACEHOLDER : GDBTokenType.COMMAND_ARGUMENTS) : GDBTokenType.COMMAND_ARGUMENTS));
    }

    private static boolean parseArgument(PsiBuilder builder) {
        if (builder.getTokenType() == GDBTokenType.DASHDASH && builder.rawLookup(1) == GDBTokenType.WHITE_SPACE) {
            PsiBuilder.Marker argsEnd = builder.mark();
            builder.advanceLexer();
            argsEnd.done((IElementType)GDBTokenType.COMMAND_ARGS_END);
            return false;
        }
        PsiBuilder.Marker arg = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == GDBTokenType.IDENTIFIER) {
            builder.advanceLexer();
        } else {
            builder.error("identifier expected");
        }
        LLDBParser.eatEverythingUntilWhitespace(builder);
        arg.done((IElementType)GDBTokenType.COMMAND_ARG);
        return true;
    }

    private static boolean isArgBegin(PsiBuilder builder) {
        return !builder.eof() && (builder.getTokenType() == GDBTokenType.DASH || builder.getTokenType() == GDBTokenType.DASHDASH);
    }

    private static void eatEverythingUntilWhitespace(PsiBuilder builder) {
        if (builder.getTokenType() == GDBTokenType.DASHDASH) {
            return;
        }
        do {
            builder.advanceLexer();
            if (!builder.eof()) continue;
            return;
        } while (builder.rawLookup(1) != GDBTokenType.WHITE_SPACE);
        builder.advanceLexer();
    }

    private static void eatEverything(PsiBuilder builder) {
        while (!builder.eof()) {
            builder.advanceLexer();
        }
    }
}

