/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrCodePointHandlerBase<T extends XBreakpoint<?>>
extends XBreakpointHandler<T> {
    protected final CidrDebugProcess myProcess;
    private final Map<T, List<LLCodepoint>> myBreakpoints = new FactoryMap<T, List<LLCodepoint>>(){

        @Nullable
        protected List<LLCodepoint> create(T key2) {
            return new ArrayList<LLCodepoint>();
        }
    };
    private final Map<Integer, T> myIdToBreakpoint = new THashMap();

    public CidrCodePointHandlerBase(CidrDebugProcess process2, @NotNull Class<? extends XBreakpointType<T, ?>> type2) {
        super(type2);
        this.myProcess = process2;
    }

    public void registerBreakpoint(@NotNull T breakpoint) {
        long threadId = this.myProcess.getCurrentThreadId();
        int frameIndex = this.myProcess.getCurrentFrameIndex();
        this.myProcess.postCommand(new CidrDebugProcess.DebuggerCommand((XBreakpoint)breakpoint, threadId, frameIndex){
            final /* synthetic */ XBreakpoint val$breakpoint;
            final /* synthetic */ long val$threadId;
            final /* synthetic */ int val$frameIndex;
            {
                this.val$breakpoint = xBreakpoint;
                this.val$threadId = l;
                this.val$frameIndex = n;
            }

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                CidrCodePointHandlerBase.this.doRegisterBreakpoint(driver, this.val$breakpoint, this.val$threadId, this.val$frameIndex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRegisterBreakpoint(DebuggerDriver driver, T breakpoint, long threadId, int frameIndex) throws ExecutionException {
        Collection<LLCodepoint> added = this.doAddCodepoints(driver, breakpoint, threadId, frameIndex);
        if (added.isEmpty()) {
            return;
        }
        Map<T, List<LLCodepoint>> map2 = this.myBreakpoints;
        synchronized (map2) {
            this.myBreakpoints.get(breakpoint).addAll(added);
            for (LLCodepoint each : added) {
                int id = each.getId();
                this.myIdToBreakpoint.put(id, breakpoint);
            }
        }
    }

    protected abstract Collection<LLCodepoint> doAddCodepoints(DebuggerDriver var1, T var2, long var3, int var5) throws ExecutionException;

    public void unregisterBreakpoint(@NotNull T breakpoint, boolean temporary) {
        this.myProcess.postCommand(new CidrDebugProcess.DebuggerCommand((XBreakpoint)breakpoint){
            final /* synthetic */ XBreakpoint val$breakpoint;
            {
                this.val$breakpoint = xBreakpoint;
            }

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                try {
                    CidrCodePointHandlerBase.this.doUnregisterBreakpoint(driver, this.val$breakpoint);
                }
                catch (DebuggerCommandException e) {
                    throw new ExecutionException((Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Integer> doUnregisterBreakpoint(T breakpoint) {
        List idsToRemove;
        Map<T, List<LLCodepoint>> map2 = this.myBreakpoints;
        synchronized (map2) {
            List<LLCodepoint> removed = this.myBreakpoints.remove(breakpoint);
            if (removed == null) {
                return Collections.emptyList();
            }
            idsToRemove = ContainerUtil.map(removed, LLCodepoint::getId);
            for (Integer each : idsToRemove) {
                this.myIdToBreakpoint.remove(each);
            }
        }
        return Collections.unmodifiableList(idsToRemove);
    }

    protected void doUnregisterBreakpoint(@NotNull DebuggerDriver driver, T breakpoint) throws ExecutionException, DebuggerCommandException {
        List<Integer> idsToRemove = this.doUnregisterBreakpoint(breakpoint);
        if (!idsToRemove.isEmpty()) {
            this.removeBreakpointInBackend(driver, idsToRemove, breakpoint);
        }
    }

    protected void removeBreakpointInBackend(DebuggerDriver driver, List<Integer> ids, T breakpoint) throws ExecutionException, DebuggerCommandException {
        driver.removeCodepoints(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getCodepoint(int id) {
        Map<T, List<LLCodepoint>> map2 = this.myBreakpoints;
        synchronized (map2) {
            return (T)((XBreakpoint)this.myIdToBreakpoint.get(id));
        }
    }

    @Nullable
    protected String convertCondition(final XBreakpoint<? extends XBreakpointProperties> breakpoint) {
        RunResult result2;
        String conversion;
        if (breakpoint.getCondition() != null && (conversion = (String)(result2 = new WriteAction<String>(){

            protected void run(@NotNull Result<String> stringResult) throws Throwable {
                block2: {
                    try {
                        stringResult.setResult((Object)CidrEvaluatorHelper.getInstance().convertExpression(CidrCodePointHandlerBase.this.myProcess, breakpoint.getCondition(), breakpoint.getSourcePosition()));
                    }
                    catch (CidrEvaluatorHelper.ConversionException e) {
                        if (!(breakpoint instanceof XLineBreakpoint)) break block2;
                        CidrCodePointHandlerBase.this.myProcess.getSession().updateBreakpointPresentation((XLineBreakpoint)breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, e.getMessage());
                    }
                }
            }
        }.execute()).getResultObject()) != null) {
            return conversion;
        }
        return breakpoint.getCondition();
    }
}

