/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointType;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrExceptionBreakpointPropertiesPanel
extends XBreakpointCustomPropertiesPanel<XBreakpoint<CidrExceptionBreakpointType.Properties>> {
    private JPanel myPanel;
    private JPanel myWhenThrownPanel;
    private ButtonGroup myWhenThrownGroup;
    private JBCheckBox myWhenCaughtCheckBox;
    private JBCheckBox myWhenThrownCheckBox;

    public CidrExceptionBreakpointPropertiesPanel() {
        this.$$$setupUI$$$();
        this.myWhenThrownGroup = new ButtonGroup();
        for (CidrExceptionBreakpointType.Properties.Type each : CidrExceptionBreakpointType.Properties.Type.values()) {
            if (!each.isAvailable()) continue;
            JRadioButton b = new JRadioButton(each == CidrExceptionBreakpointType.Properties.Type.ANY_EXCEPTION ? each.getDisplayString() : each.getDisplayString() + " only");
            CidrExceptionBreakpointPropertiesPanel.setValue(b, (Object)each);
            this.myWhenThrownGroup.add(b);
            this.myWhenThrownPanel.add(b);
        }
        if (this.myWhenThrownGroup.getButtonCount() < 2) {
            this.myWhenThrownPanel.setVisible(false);
        } else {
            this.myWhenThrownCheckBox.setText(this.myWhenThrownCheckBox.getText() + ":");
        }
        this.myWhenThrownCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CidrExceptionBreakpointPropertiesPanel.this.updateThrownButtons();
            }
        });
    }

    private void updateThrownButtons() {
        boolean enabled = this.myWhenThrownCheckBox.isSelected();
        Enumeration<AbstractButton> it = this.myWhenThrownGroup.getElements();
        while (it.hasMoreElements()) {
            it.nextElement().setEnabled(enabled);
        }
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    private static AbstractButton getSelectedButton(ButtonGroup group) {
        Enumeration<AbstractButton> e = group.getElements();
        while (e.hasMoreElements()) {
            AbstractButton each = e.nextElement();
            if (!each.isSelected()) continue;
            return each;
        }
        return null;
    }

    @Nullable
    private static AbstractButton findButton(@NotNull ButtonGroup group, @Nullable Object value2) {
        Enumeration<AbstractButton> e = group.getElements();
        while (e.hasMoreElements()) {
            AbstractButton each = e.nextElement();
            if (CidrExceptionBreakpointPropertiesPanel.getValue(each) != value2) continue;
            return each;
        }
        return null;
    }

    private static void setValue(JRadioButton b, Object each) {
        b.putClientProperty("value", each);
    }

    @Nullable
    private static Object getValue(@Nullable AbstractButton each) {
        return each == null ? null : each.getClientProperty("value");
    }

    public void saveTo(@NotNull XBreakpoint<CidrExceptionBreakpointType.Properties> breakpoint) {
        CidrExceptionBreakpointType.Properties properties = (CidrExceptionBreakpointType.Properties)breakpoint.getProperties();
        if (properties == null) {
            return;
        }
        properties.setWhenThrown(this.myWhenThrownCheckBox.isSelected() ? (CidrExceptionBreakpointType.Properties.Type)((Object)CidrExceptionBreakpointPropertiesPanel.getValue(CidrExceptionBreakpointPropertiesPanel.getSelectedButton(this.myWhenThrownGroup))) : null);
        properties.setWhenCaught(this.myWhenCaughtCheckBox.isSelected() ? CidrExceptionBreakpointType.Properties.Type.ANY_EXCEPTION : null);
    }

    public void loadFrom(@NotNull XBreakpoint<CidrExceptionBreakpointType.Properties> breakpoint) {
        CidrExceptionBreakpointType.Properties properties = (CidrExceptionBreakpointType.Properties)breakpoint.getProperties();
        if (properties == null) {
            this.myWhenThrownGroup.clearSelection();
            this.myWhenThrownCheckBox.setSelected(false);
            this.myWhenCaughtCheckBox.setSelected(false);
            return;
        }
        CidrExceptionBreakpointType.Properties.Type thrown = properties.getWhenThrown();
        this.myWhenThrownCheckBox.setSelected(thrown != null);
        AbstractButton buttonToSelect = CidrExceptionBreakpointPropertiesPanel.findButton(this.myWhenThrownGroup, (Object)thrown);
        if (buttonToSelect == null) {
            buttonToSelect = this.myWhenThrownGroup.getElements().nextElement();
        }
        this.myWhenThrownGroup.setSelected(buttonToSelect.getModel(), true);
        this.updateThrownButtons();
        this.myWhenCaughtCheckBox.setSelected(properties.getWhenCaught() != null);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myWhenThrownPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myWhenThrownCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("When thrown");
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myWhenCaughtCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("When caught");
        jPanel3.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

