/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCodePointHandlerBase;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class CidrSymbolicBreakpointHandler
extends CidrCodePointHandlerBase<XBreakpoint<CidrSymbolicBreakpointType.Properties>> {
    public CidrSymbolicBreakpointHandler(CidrDebugProcess process2, @NotNull Class<? extends XBreakpointType<XBreakpoint<CidrSymbolicBreakpointType.Properties>, ?>> type2) {
        super(process2, type2);
    }

    @Override
    @NotNull
    protected Collection<LLCodepoint> doAddCodepoints(@NotNull DebuggerDriver driver, @NotNull XBreakpoint<CidrSymbolicBreakpointType.Properties> breakpoint, long threadId, int frameIndex) throws ExecutionException {
        String condition2 = this.convertCondition(breakpoint);
        CidrSymbolicBreakpointType.Properties properties = (CidrSymbolicBreakpointType.Properties)breakpoint.getProperties();
        if (properties == null || properties.getSymbolPattern() == null) {
            return Collections.emptyList();
        }
        try {
            LLSymbolicBreakpoint symbolicBreakpoint = driver.addSymbolicBreakpoint(properties.getSymbolPattern(), properties.getModuleName(), condition2);
            return symbolicBreakpoint == null ? Collections.emptyList() : Collections.singletonList(symbolicBreakpoint);
        }
        catch (DebuggerCommandException e) {
            return Collections.emptyList();
        }
    }
}

