/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;

public abstract class CidrSymbolicBreakpointPropertiesPanel
extends XBreakpointCustomPropertiesPanel<XBreakpoint<CidrSymbolicBreakpointType.Properties>> {
    private JPanel myPanel;
    private TextFieldWithAutoCompletion mySymbolPatternField;
    private EditorTextField myModuleNameField;
    private JBLabel mySymbolExampleLabel;
    private JBLabel myModuleExampleLabel;
    protected final Project myProject;

    protected CidrSymbolicBreakpointPropertiesPanel(@NotNull Project project2) {
        this.myProject = project2;
        this.$$$setupUI$$$();
        this.myModuleNameField.setPlaceholder("All Modules");
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    private void createUIComponents() {
        this.mySymbolPatternField = this.createSymbolNameField();
        this.mySymbolExampleLabel = new JBLabel();
        this.mySymbolExampleLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.myModuleExampleLabel = new JBLabel();
        this.myModuleExampleLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
    }

    @NotNull
    protected abstract TextFieldWithAutoCompletion createSymbolNameField();

    public TextFieldWithAutoCompletion getSymbolPatternField() {
        return this.mySymbolPatternField;
    }

    public void saveTo(@NotNull XBreakpoint<CidrSymbolicBreakpointType.Properties> breakpoint) {
        CidrSymbolicBreakpointType.Properties properties = (CidrSymbolicBreakpointType.Properties)breakpoint.getProperties();
        properties.setSymbolPattern(this.mySymbolPatternField.getText().trim());
        properties.setModuleName(StringUtil.nullize((String)this.myModuleNameField.getText().trim()));
    }

    public void loadFrom(@NotNull XBreakpoint<CidrSymbolicBreakpointType.Properties> breakpoint) {
        CidrSymbolicBreakpointType.Properties properties = (CidrSymbolicBreakpointType.Properties)breakpoint.getProperties();
        if (properties != null) {
            this.mySymbolPatternField.setText(properties.getSymbolPattern());
            this.myModuleNameField.setText(properties.getModuleName());
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        EditorTextField editorTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText("Module name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Symbol name");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)jLabel2, gridBagConstraints2);
        this.myModuleNameField = editorTextField = new EditorTextField();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 2;
        jPanel.add((Component)((Object)editorTextField), gridBagConstraints3);
        JBLabel jBLabel = this.mySymbolExampleLabel;
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setMinimumSize(new Dimension(380, 28));
        jBLabel.setText("<html>E.g. [UIViewController viewDidLoad], viewWillAppear:,<br/> +[UIView commitAnimations], Namespace::Clazz::foo(int *)</html>");
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 18;
        gridBagConstraints4.insets = new Insets(0, 7, 5, 0);
        jPanel.add((Component)jBLabel, gridBagConstraints4);
        JBLabel jBLabel2 = this.myModuleExampleLabel;
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setText("E.g. UIKit, libobjc.A.dylib, IOSApp");
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 3;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.insets = new Insets(0, 7, 5, 0);
        jPanel.add((Component)jBLabel2, gridBagConstraints5);
        TextFieldWithAutoCompletion textFieldWithAutoCompletion = this.mySymbolPatternField;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.fill = 2;
        jPanel.add((Component)((Object)textFieldWithAutoCompletion), gridBagConstraints6);
        JSeparator jSeparator = new JSeparator();
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 4;
        gridBagConstraints7.gridwidth = 2;
        gridBagConstraints7.weighty = 1.0;
        gridBagConstraints7.fill = 2;
        jPanel.add((Component)jSeparator, gridBagConstraints7);
        jLabel.setLabelFor((Component)((Object)textFieldWithAutoCompletion));
        jLabel2.setLabelFor((Component)((Object)textFieldWithAutoCompletion));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

