/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.disasm;

import com.intellij.execution.ExecutionException;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.disasm.CidrDisasmRegion;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrDisasmView
implements AddressSpace.Listener<CidrDisasmRegion> {
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final LightVirtualFile myVirtualFile;
    @NotNull
    private final Document myDocument;
    @NotNull
    private final AddressSpace<CidrDisasmRegion> myAddressSpace;

    public CidrDisasmView(@NotNull CidrDebugProcess process2) {
        this.myProcess = process2;
        this.myVirtualFile = new LightVirtualFile("Disassembly", Language.findLanguageByID((String)"ASM"), (CharSequence)"");
        this.myVirtualFile.setWritable(false);
        this.myDocument = (Document)ReadAction.compute(() -> {
            Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)this.myVirtualFile);
            CidrDebuggerLog.LOG.assertTrue(document != null, (Object)"null Document returned for newly created LightVirtualFile");
            return document;
        });
        this.myProcess.getSession().addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                GuiUtils.invokeLaterIfNeeded(() -> {
                    Project project2 = CidrDisasmView.this.myProcess.getProject();
                    if (!project2.isDisposed()) {
                        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
                        fileEditorManager.closeFile((VirtualFile)CidrDisasmView.this.myVirtualFile);
                    }
                }, (ModalityState)ModalityState.defaultModalityState());
            }
        });
        this.myAddressSpace = new AddressSpace<CidrDisasmRegion>(CidrDisasmRegion::new);
        this.myAddressSpace.addListener(this);
        this.postWriteAction(() -> this.myAddressSpace.get(Address.NULL).addToDocument(this.myDocument, 0));
    }

    private void requestDisassemblingForMissingRanges(@NotNull Address address) {
        this.postWriteAction(() -> {
            List<AddressRange> ranges = this.myAddressSpace.preallocate(address);
            for (final AddressRange range : ranges) {
                this.myProcess.postCommand(new CidrDebugProcess.DebuggerCommand(){

                    @Override
                    public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                        try {
                            List<LLInstruction> result2 = driver.disassemble(range);
                            CidrDisasmRegion region = new CidrDisasmRegion(range, result2);
                            CidrDisasmView.this.postWriteAction(() -> CidrDisasmView.this.myAddressSpace.save(region));
                        }
                        catch (DebuggerCommandException e) {
                            CidrDebuggerLog.LOG.warn((Throwable)e);
                            CidrDisasmView.this.postWriteAction(() -> CidrDisasmView.this.myAddressSpace.unallocate(range));
                        }
                    }

                    @Override
                    public void rejected(@NotNull String reason) {
                        CidrDebuggerLog.LOG.warn(reason);
                        CidrDisasmView.this.postWriteAction(() -> CidrDisasmView.this.myAddressSpace.unallocate(range));
                    }
                });
            }
        });
    }

    public XSourcePosition disassemble(final @NotNull Address address) {
        return new XSourcePosition(){
            private boolean myRequested;

            private void requestDisassemblingIfNeeded() {
                if (!this.myRequested) {
                    CidrDisasmView.this.requestDisassemblingForMissingRanges(address);
                    this.myRequested = true;
                }
            }

            public int getLine() {
                this.requestDisassemblingIfNeeded();
                return (Integer)ReadAction.compute(() -> ((CidrDisasmRegion)CidrDisasmView.this.myAddressSpace.get(address)).getLineNumberInDocument(address));
            }

            public int getOffset() {
                this.requestDisassemblingIfNeeded();
                return (Integer)ReadAction.compute(() -> ((CidrDisasmRegion)CidrDisasmView.this.myAddressSpace.get(address)).getOffsetInDocument(address));
            }

            @NotNull
            public VirtualFile getFile() {
                return CidrDisasmView.this.myVirtualFile;
            }

            @NotNull
            public Navigatable createNavigatable(@NotNull Project project2) {
                return XSourcePositionImpl.doCreateOpenFileDescriptor(project2, this);
            }
        };
    }

    @Override
    public void regionSplit(@NotNull CidrDisasmRegion oldRegion, @NotNull List<? extends CidrDisasmRegion> newRegions) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        oldRegion.replaceWith(newRegions);
    }

    @NotNull
    private Runnable withDocumentWritable(@NotNull Runnable action) {
        return () -> {
            boolean wasWritable = this.myDocument.isWritable();
            this.myDocument.setReadOnly(false);
            try {
                action.run();
                this.myDocument.setReadOnly(!wasWritable);
            }
            catch (Throwable throwable) {
                this.myDocument.setReadOnly(!wasWritable);
                throw throwable;
            }
        };
    }

    private void postWriteAction(@NotNull Runnable action) {
        GuiUtils.invokeLaterIfNeeded(() -> DocumentUtil.writeInRunUndoTransparentAction(this.withDocumentWritable(action)), (ModalityState)ModalityState.defaultModalityState());
    }
}

