/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ContainerValueRenderer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDictionaryEntryValue
extends CidrValue {
    @NotNull
    private final CidrPhysicalValue myContainer;
    @NotNull
    private final CidrPhysicalValue myKey;
    @NotNull
    private final CidrPhysicalValue myObject;
    protected final int myIndex;

    public CidrDictionaryEntryValue(@NotNull String displayName, @NotNull CidrPhysicalValue container, @NotNull LLValue key2, @NotNull LLValue object, int index) {
        super(displayName, container.getProcess(), container.getSourcePosition(), container.getFrame());
        this.myContainer = container;
        this.myIndex = index;
        this.myKey = new CidrElementValue(key2, "key", container, this.myIndex, false);
        this.myObject = new CidrElementValue(object, "object", container, this.myIndex, false);
    }

    @NotNull
    public CidrPhysicalValue getObject() {
        return this.myObject;
    }

    public int getIndex() {
        return this.myIndex;
    }

    @Override
    protected XSourcePosition doComputePosition(@NotNull XSourcePosition position) {
        return this.myContainer.doComputePosition(position);
    }

    @Override
    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        return ((ContainerValueRenderer)this.myContainer.getPreparedRenderer()).getDictionaryEntryEvaluationExpression(this, lvalue);
    }

    @Override
    protected boolean doComputeMayHaveChildren(@NotNull EvaluationContext context) throws ExecutionException {
        return true;
    }

    @Override
    @Nullable
    protected Icon doComputeIcon(@NotNull EvaluationContext context, boolean hasChildren) throws ExecutionException {
        return AllIcons.Debugger.Value;
    }

    @Override
    @Nullable
    protected String doComputeType(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return null;
    }

    @Override
    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return Pair.create((Object)(CidrDictionaryEntryValue.shorten((String)this.myKey.doComputeValueAndEvaluator((EvaluationContext)context).first) + " -> " + CidrDictionaryEntryValue.shorten((String)this.myObject.doComputeValueAndEvaluator((EvaluationContext)context).first)), null);
    }

    @Override
    @NotNull
    public String getConsoleDescription(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return CidrDictionaryEntryValue.shorten(this.myKey.getConsoleDescription(context)) + " -> " + CidrDictionaryEntryValue.shorten(this.myObject.getConsoleDescription(context));
    }

    @NotNull
    private static String shorten(@NotNull String value2) throws ExecutionException, DebuggerCommandException {
        return StringUtil.first((String)value2, (int)100, (boolean)true);
    }

    @Override
    protected void computeValueChildren(@NotNull XCompositeNode node) {
        if (node.isObsolete()) {
            return;
        }
        XValueChildrenList values = new XValueChildrenList(2);
        values.add((XNamedValue)this.myKey);
        values.add((XNamedValue)this.myObject);
        node.addChildren(values, true);
    }
}

