/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.XValueNodeExpirable;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CachedDebuggerResult;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrPhysicalValue
extends CidrValue {
    public static final Key THROW_ON_TYPE = Key.create((String)"THROW_ON_TYPE");
    public static final Key THROW_ON_ICON = Key.create((String)"THROW_ON_ICON");
    public static final Key THROW_ON_VALUE = Key.create((String)"THROW_ON_VALUE");
    public static final Key THROW_ON_HAS_CHILDREN = Key.create((String)"THROW_ON_CHILDREN_COUNT");
    public static final Key THROW_ON_CHILDREN = Key.create((String)"THROW_ON_CHILDREN");
    @NotNull
    private final LLValue myVar;
    @Nullable
    private volatile LLValue myPresentationVar;
    @NotNull
    private final CachedDebuggerResult<LLValueData> myVarDataResult = new CachedDebuggerResult();
    @NotNull
    private final CachedDebuggerResult<LLValueData> myPresentationVarDataResult = new CachedDebuggerResult();
    @NotNull
    private final CachedDebuggerResult<ValueRenderer> myRendererResult = new CachedDebuggerResult();

    public CidrPhysicalValue(@NotNull LLValue var, @NotNull CidrDebugProcess process2, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        this(var, var.getName(), process2, position, frame);
    }

    public CidrPhysicalValue(@NotNull LLValue var, @NotNull String displayName, @NotNull CidrDebugProcess process2, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        super(displayName, process2, position, frame);
        this.myVar = var;
    }

    @NotNull
    public ValueRenderer getPreparedRenderer() {
        ValueRenderer result2 = this.myRendererResult.getResultIfAvailable();
        if (result2 == null) {
            CidrDebuggerLog.LOG.error("getPreparedRenderer() called before getRenderer()");
            return new ValueRenderer(this);
        }
        return result2;
    }

    @NotNull
    public ValueRenderer getRenderer(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return this.myRendererResult.getResult(new CachedDebuggerResult.NotNullCalculator<ValueRenderer>(){

            @Override
            @NotNull
            public ValueRenderer calculate() throws ExecutionException, DebuggerCommandException {
                return CidrPhysicalValue.this.doCreateRenderer(context);
            }
        });
    }

    @NotNull
    protected ValueRenderer doCreateRenderer(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return ValueRendererFactory.createRenderer(context, this);
    }

    @Override
    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        return this.myVar.getReferenceExpression();
    }

    @NotNull
    public LLValue getVar() {
        return this.myVar;
    }

    @NotNull
    public LLValue getPresentationVar() {
        LLValue presentationVar = this.myPresentationVar;
        return presentationVar != null ? presentationVar : this.myVar;
    }

    public void setPresentationVar(@Nullable LLValue presentationVar) {
        this.myPresentationVar = presentationVar;
    }

    public String getType() {
        return this.myVar.getType();
    }

    public boolean isValueDataAvailable() {
        return this.myVarDataResult.getResultIfAvailable() != null;
    }

    @NotNull
    public LLValueData getPreparedVarData() {
        LLValueData result2 = this.myVarDataResult.getResultIfAvailable();
        if (result2 == null) {
            CidrDebuggerLog.LOG.error("getPreparedVarData() called before getVarData()");
            return new LLValueData("", null, false, false, false);
        }
        return result2;
    }

    @NotNull
    public LLValueData getVarData(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return this.myVarDataResult.getResult(new CachedDebuggerResult.NotNullCalculator<LLValueData>(){

            @Override
            @NotNull
            public LLValueData calculate() throws ExecutionException, DebuggerCommandException {
                return context.getData(CidrPhysicalValue.this.myVar);
            }
        });
    }

    @NotNull
    public LLValueData getPresentationVarData(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        final LLValue presentationVar = this.myPresentationVar;
        if (presentationVar == null) {
            return this.getVarData(context);
        }
        return this.myPresentationVarDataResult.getResult(new CachedDebuggerResult.NotNullCalculator<LLValueData>(){

            @Override
            @NotNull
            public LLValueData calculate() throws ExecutionException, DebuggerCommandException {
                return context.getData(presentationVar);
            }
        });
    }

    @Override
    @Nullable
    protected String doComputeType(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        LLValueData data;
        String pointer;
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_TYPE);
        String type2 = this.getRenderer(context).getDisplayType();
        if (this.getProcess().getProject().getUserData(DO_NOT_SHOW_ADDRESSES) != Boolean.TRUE && (pointer = (data = this.getVarData(context)).getPresentablePointer()) != null) {
            type2 = type2 + " | " + pointer;
        }
        return type2;
    }

    @Nullable
    public String getShownAddress() {
        if (!this.isValueDataAvailable()) {
            return null;
        }
        return this.getPreparedVarData().getPresentablePointer();
    }

    @Override
    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_VALUE);
        return this.getRenderer(context).computeValueAndEvaluator(context);
    }

    @Override
    protected boolean doComputeMayHaveChildren(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_HAS_CHILDREN);
        return this.getRenderer(context).computeMayHaveChildren(context);
    }

    @Override
    @Nullable
    protected Icon doComputeIcon(@NotNull EvaluationContext context, boolean hasChildren) throws ExecutionException, DebuggerCommandException {
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_ICON);
        return this.getRenderer(context).getIcon(hasChildren);
    }

    @Override
    public final void computeValueChildren(final @NotNull XCompositeNode node) {
        this.getProcess().postCommand(new CidrDebugProcess.DebuggerUIUpdateCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                if (node.isObsolete()) {
                    return;
                }
                try {
                    ThrowInTest.doThrow((UserDataHolder)CidrPhysicalValue.this, THROW_ON_CHILDREN);
                    EvaluationContext context = CidrPhysicalValue.this.createEvaluationContext(driver, new XValueNodeExpirable((Obsolescent)node));
                    CidrPhysicalValue.this.getRenderer(context).computeChildren(context, node);
                }
                catch (DebuggerCommandException e) {
                    node.addChildren(CidrValue.createErrorChildren(Collections.singletonList(e.getMessage())), true);
                }
                catch (ExecutionException e) {
                    node.addChildren(CidrValue.createErrorChildren(Collections.singletonList(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)))), true);
                    throw e;
                }
            }
        });
    }

    @Override
    @NotNull
    public String getConsoleDescription(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return this.getRenderer(context).getConsoleDescription(context).toString();
    }

    @NotNull
    public CidrDebuggerTypesHelper getTypesHelper() {
        return this.getProcess().getTypesHelper();
    }

    public String toString() {
        return this.getVar().toString();
    }

    @Nullable
    public DebuggerDriver.DebuggerLanguage getLanguage() {
        return this.getFrame().getFrame().getLanguage();
    }

    public boolean isObjectiveCContext() {
        DebuggerDriver.DebuggerLanguage l = this.getLanguage();
        return l == DebuggerDriver.StandardDebuggerLanguage.OBJC || l == DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS;
    }

    public boolean isSwiftContext() {
        return this.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT;
    }

    public boolean isSwiftOptional() {
        return this.isSwiftContext() && CidrDebuggerTypesHelper.unwrapSwiftOptionalType(this.getType()) != null;
    }

    public boolean isSwiftVoid() {
        return this.isSwiftContext() && "()".equals(this.getType());
    }
}

