/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import org.jetbrains.annotations.NotNull;

public class CidrValueModifier
extends XValueModifier {
    @NotNull
    private final CidrPhysicalValue myValue;

    public CidrValueModifier(@NotNull CidrPhysicalValue value2) {
        this.myValue = value2;
    }

    public void setValue(final @NotNull String expr, final @NotNull XValueModifier.XModificationCallback callback) {
        this.myValue.getProcess().postCommand(new CidrDebugProcess.DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                try {
                    CidrStackFrame frame = CidrValueModifier.this.myValue.getFrame();
                    Pair<LLValue, String> valuePair = CidrEvaluatorHelper.getInstance().convertAndEvaluate(frame.getProcess(), driver, XExpressionImpl.fromText(expr), frame.getSourcePosition(), frame.getThreadId(), frame.getFrameIndex());
                    CidrValueModifier.this.setValue(expr, valuePair, callback, driver);
                }
                catch (DebuggerCommandException e) {
                    callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", expr, CidrValueModifier.this.myValue.getName()) + ":\n" + e.getMessage());
                    CidrDebuggerLog.LOG.info(e.getMessage());
                }
            }
        });
    }

    @NotNull
    public CidrPhysicalValue getValue() {
        return this.myValue;
    }

    protected void setValue(final @NotNull String origExpr, @NotNull Pair<LLValue, String> valuePair, final @NotNull XValueModifier.XModificationCallback callback, @NotNull DebuggerDriver driver) throws ExecutionException, DebuggerCommandException {
        EvaluationContext context = this.myValue.createEvaluationContext(driver, null);
        final String qualName = this.myValue.getEvaluationExpression(true);
        CidrEvaluator evaluator = this.myValue.getFrame().getEvaluator();
        if (evaluator == null) {
            callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", origExpr, qualName));
            CidrDebuggerLog.LOG.info(this.myValue.getFrame().toString() + " has null evaluator");
            return;
        }
        String rValueStr = context.convertToRValue(this.myValue.getVarData(context), valuePair);
        evaluator.evaluate(qualName + "=" + rValueStr, new XDebuggerEvaluator.XEvaluationCallback(){

            public void evaluated(@NotNull XValue result2) {
                callback.valueModified();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", origExpr, qualName) + ":\n" + errorMessage);
                CidrDebuggerLog.LOG.info(errorMessage);
            }
        }, this.myValue.getFrame().getSourcePosition());
    }
}

