/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDictionaryEntryValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ContainerValueRenderer
extends ValueRenderer {
    public ContainerValueRenderer(@NotNull CidrPhysicalValue value2) {
        super(value2);
    }

    @Override
    protected boolean shouldPrintChildrenConsoleDescription() {
        return true;
    }

    @Override
    protected void addChildrenTo(@NotNull List<LLValue> children2, @NotNull EvaluationContext context, @NotNull XCompositeNode container, boolean modifiable) throws ExecutionException, DebuggerCommandException {
        ArrayList<CidrValue> values = new ArrayList<CidrValue>(children2.size());
        for (LLValue each : children2) {
            if (container.isObsolete()) {
                return;
            }
            values.add(this.nextElementValue(each, modifiable));
        }
        CidrValue.addAllTo(values, container);
    }

    protected final CidrElementValue createElementValue(@NotNull LLValue var, int index, boolean modifiable) {
        return new CidrElementValue(var, "[" + index + "]", this.myValue, index, modifiable);
    }

    protected final CidrElementValue nextElementValue(@NotNull LLValue var) {
        return this.nextElementValue(var, false);
    }

    protected final CidrElementValue nextElementValue(@NotNull LLValue var, boolean modifiable) {
        return this.createElementValue(var, this.myCurrentIndex++, modifiable);
    }

    protected final CidrDictionaryEntryValue createMapElementValue(LLValue key2, LLValue value2, int index) {
        return new CidrDictionaryEntryValue("[" + index + "]", this.myValue, key2, value2, index);
    }

    protected final CidrDictionaryEntryValue nextMapElementValue(LLValue key2, LLValue value2) {
        return this.createMapElementValue(key2, value2, this.myCurrentIndex++);
    }

    @NotNull
    public String getDictionaryEntryEvaluationExpression(@NotNull CidrDictionaryEntryValue entry, boolean lvalue) {
        return this.getChildEvaluationExpression(entry.getObject(), lvalue);
    }
}

