/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ContainerValueRenderer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NSContainerValueRenderer
extends ContainerValueRenderer {
    public NSContainerValueRenderer(@NotNull CidrPhysicalValue value2) {
        super(value2);
    }

    @Override
    @NotNull
    protected String doComputeFallbackValue(@NotNull EvaluationContext context, @NotNull LLValue var, @NotNull LLValueData data) throws ExecutionException, DebuggerCommandException {
        String type2 = this.getValue().getType();
        String name = StringUtil.containsIgnoreCase((String)type2, (String)"Dictionary") ? "key/value pair" : (StringUtil.contains((CharSequence)type2, (CharSequence)"NS") ? "element" : "value");
        int count = this.computeChildrenCount(context);
        return count + " " + StringUtil.pluralize((String)name, (int)count);
    }

    @Override
    public Icon getIcon(boolean hasChildren) {
        return AllIcons.Debugger.Db_array;
    }

    @Nullable
    protected static Couple<LLValue> getDictionaryEntryChildren(@NotNull EvaluationContext context, @NotNull LLValue entry) throws ExecutionException, DebuggerCommandException {
        DebuggerDriver.ResultList<LLValue> result2 = context.getVariableChildren(entry, 0, 2);
        if (result2.list.size() == 2 && !result2.hasMore) {
            return Couple.of(result2.list.get(0), result2.list.get(1));
        }
        CidrDebuggerLog.LOG.warn("Unexpected dictionary layout");
        return null;
    }
}

