/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSCollectionValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSEnumerableValueRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NSEnumerableCollectionValueRenderer
extends NSEnumerableValueRenderer {
    private final NSCollectionValueRenderer.Kind myKind;
    private volatile LLValue myEnumerator;

    public NSEnumerableCollectionValueRenderer(@NotNull CidrPhysicalValue value2, @NotNull NSCollectionValueRenderer.Kind kind2) {
        super(value2);
        this.myKind = kind2;
    }

    @Override
    @Nullable
    protected Integer doComputeChildrenCount(@NotNull EvaluationContext context, int max) throws ExecutionException, DebuggerCommandException {
        if (this.myValue.getVar().getType().matches("__NS.+0 \\*")) {
            return 0;
        }
        return (int)this.messageSendToSelfData("count", "unsigned int", context).intValue();
    }

    @Override
    @Nullable
    protected CidrValue nextChild(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        CidrValue child;
        if (!context.getData(this.myEnumerator).isValidPointer()) {
            return null;
        }
        LLValue next = context.messageSend(this.myEnumerator, "nextObject");
        if (this.myKind == NSCollectionValueRenderer.Kind.DICTIONARY) {
            LLValueData nextData = context.getData(next);
            LLValue object = this.messageSendToSelf("objectForKey:" + EvaluationContext.cast(nextData.getPointer(), "id"), "id", context);
            child = this.nextMapElementValue(next, object);
        } else {
            child = this.nextElementValue(next);
        }
        return child;
    }

    @Override
    protected void willExpand(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        this.myEnumerator = this.myKind == NSCollectionValueRenderer.Kind.DICTIONARY ? context.messageSend(this.myValue.getVar(), "keyEnumerator") : context.messageSend(this.myValue.getVar(), "objectEnumerator");
    }

    @Override
    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        return NSCollectionValueRenderer.getChildEvaluationExpression(this.myValue, this.myKind, child, lvalue);
    }
}

