/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValueModifier;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValueModifier;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NSManagedObjectValueRenderer
extends ValueRenderer {
    private static final Key<Boolean> IS_NS_MANAGED_OBJECT = Key.create((String)"IS_NS_MANAGED_OBJECT");
    private volatile LLValue myEntityCache;
    protected final String myClassName;
    private static Pattern MANAGED_OBJECT_PATTERN = Pattern.compile(".+<x-coredata://.+", 32);

    protected NSManagedObjectValueRenderer(@NotNull CidrPhysicalValue value2, EvaluationContext context) throws ExecutionException, DebuggerCommandException, NotApplicableException {
        super(value2);
        String type2 = this.myValue.getVar().getType();
        Boolean isNSManagedObject = context.getCachedTypeInfo(type2, IS_NS_MANAGED_OBJECT);
        if (isNSManagedObject == null) {
            String className = StringUtil.trimEnd((String)type2.trim(), (String)"*").trim();
            isNSManagedObject = this.isManagedObjectClass(className) || MANAGED_OBJECT_PATTERN.matcher(StringUtil.notNullize((String)value2.getVarData(context).getDescription())).matches() && context.isKindOfClass("NSManagedObject", this.getValue().getVar());
            context.putCachedTypeInfo(type2, IS_NS_MANAGED_OBJECT, isNSManagedObject);
        }
        if (!isNSManagedObject.booleanValue()) {
            throw new NotApplicableException();
        }
        this.myClassName = this.determineClassName(context);
    }

    @NotNull
    protected String determineClassName(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return context.stringFromNSString(context.messageSend(this.getEntity(context), "managedObjectClassName"));
    }

    @Override
    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        if (lvalue) {
            if (child instanceof KeyedValue) {
                return "(id)[" + this.myValue.getEvaluationExpression() + " valueForKey:@\"" + child.getName() + "\"]";
            }
            return "(" + this.myValue.getEvaluationExpression(true) + ")->" + child.getName();
        }
        if (child instanceof KeyedValue) {
            return "(id)[" + this.myValue.getEvaluationExpression() + " " + child.getName() + "]";
        }
        return "((" + this.myClassName + " *)(" + this.myValue.getEvaluationExpression() + "))->" + child.getName();
    }

    @Override
    @NotNull
    public String getDisplayType() {
        return this.myClassName + " *";
    }

    @Override
    public Icon getIcon(boolean hasChildren) {
        return AllIcons.Debugger.Db_db_object;
    }

    @Override
    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        LLValue entity = this.getEntity(context);
        String entityName = context.stringFromNSString(context.messageSend(entity, "name"));
        String objectID = context.messageSendData(this.messageSendToSelf("objectID", "id", context), "URIRepresentation").getPresentableValue();
        String result2 = "entity: " + entityName + (this.messageSendToSelfData("isFault", "unsigned char", context).isTrue() ? "(Fault) " : " ") + objectID;
        return Pair.create((Object)result2, null);
    }

    @NotNull
    private LLValue getEntity(EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return this.myEntityCache != null ? this.myEntityCache : (this.myEntityCache = this.messageSendToSelf("entity", "id", context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doComputeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container) throws ExecutionException, DebuggerCommandException {
        LLValueData keyData;
        LLValue key2;
        LLValueData keyData2;
        LLValue entity = this.getEntity(context);
        LLValue attrDict = context.messageSend(entity, "attributesByName");
        LLValue attrKeys = context.messageSend(attrDict, "keyEnumerator");
        String managedObjectClassName = this.myClassName;
        SmartList values = new SmartList();
        while (!(keyData2 = context.getData(key2 = context.messageSend(attrKeys, "nextObject"))).isFalse()) {
            LLValue attrVal = this.messageSendToSelf("valueForKey:" + keyData2.getPointer(), "id", context);
            String name = context.stringFromNSString(key2);
            values.add(new KeyedValue(attrVal, name, managedObjectClassName));
        }
        LLValue relDict = context.messageSend(entity, "relationshipsByName");
        LLValue relKeys = context.messageSend(relDict, "keyEnumerator");
        while (!(keyData = context.getData(key2 = context.messageSend(relKeys, "nextObject"))).isFalse()) {
            LLValue relVal = this.messageSendToSelf("valueForKey:" + keyData.getPointer(), "id", context);
            String name = context.stringFromNSString(key2);
            values.add(new KeyedValue(relVal, name, managedObjectClassName));
        }
        try {
            if (!this.isManagedObjectClass(managedObjectClassName)) {
                LLValue intermediate;
                LLValue typed = context.evaluate(this.valueCastedToManagedObject(this.myValue.getVarData(context)));
                List children2 = context.getVariableChildren((LLValue)typed, (int)0, (int)context.getChildrenCount((LLValue)typed).intValue()).list;
                if (!children2.isEmpty() && typed.getType().equals(managedObjectClassName + "_" + managedObjectClassName + "_ *") && (intermediate = (LLValue)((Object)ContainerUtil.find(children2, child -> child.getName().equals(managedObjectClassName)))) != null) {
                    children2 = context.getVariableChildren((LLValue)intermediate, (int)0, (int)context.getChildrenCount((LLValue)intermediate).intValue()).list;
                }
                for (LLValue child2 : children2) {
                    if (this.isManagedObjectClass(child2.getName())) continue;
                    values.add(new IVarValue(child2, managedObjectClassName));
                }
            }
        }
        finally {
            CidrValue.addAllTo((Collection<CidrValue>)values, container);
        }
    }

    protected String valueCastedToManagedObject(LLValueData data) throws DebuggerCommandException {
        return EvaluationContext.cast(data.getPointer(), this.myClassName + "*");
    }

    protected boolean isManagedObjectClass(@NotNull String className) {
        return className.equals("NSManagedObject");
    }

    protected void invokeSetValue(@NotNull Pair<LLValue, String> valuePair, @NotNull EvaluationContext evaluationContext, @NotNull LLValueData parentVarData, @NotNull String keyName) throws ExecutionException, DebuggerCommandException {
        evaluationContext.messageSend(parentVarData, " setValue:((id)" + evaluationContext.convertToRValue(parentVarData, valuePair) + ") forKey:@\"" + keyName + "\"", "void");
    }

    protected static class NotApplicableException
    extends Exception {
        protected NotApplicableException() {
        }
    }

    private class KeyedValueModifier
    extends CidrValueModifier {
        public KeyedValueModifier(KeyedValue value2) {
            super(value2);
        }

        @Override
        protected void setValue(@NotNull String origExpr, @NotNull Pair<LLValue, String> valuePair, @NotNull XValueModifier.XModificationCallback callback, @NotNull DebuggerDriver driver) throws DebuggerCommandException, ExecutionException {
            EvaluationContext evaluationContext = this.getValue().createEvaluationContext(driver, null);
            try {
                LLValueData parentVarData = ((KeyedValue)this.getValue()).getParent().getVarData(evaluationContext);
                NSManagedObjectValueRenderer.this.invokeSetValue(valuePair, evaluationContext, parentVarData, this.getValue().getName());
                callback.valueModified();
            }
            catch (ExecutionException e) {
                callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", origExpr, this.getValue().getName()));
                CidrDebuggerLog.LOG.debug(e.getMessage());
            }
        }
    }

    private class KeyedValue
    extends NSManagedObjectMemberValue {
        public KeyedValue(LLValue attrVal, String displayName, String className) {
            super(attrVal, displayName, className);
        }

        @Override
        public XValueModifier getModifier() {
            return new KeyedValueModifier(this);
        }
    }

    private class IVarValue
    extends NSManagedObjectMemberValue {
        public IVarValue(LLValue attrVal, String className) {
            super(attrVal, className);
        }

        @Override
        @NotNull
        protected ValueRenderer doCreateRenderer(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
            return new IVarValueRenderer(this);
        }

        private class IVarValueRenderer
        extends ValueRenderer {
            private IVarValueRenderer(NSManagedObjectMemberValue value2) {
                super(value2);
            }

            @Override
            protected boolean areChildrenModifiable(@NotNull LLValue var, @NotNull LLValueData data) {
                return true;
            }
        }
    }

    private abstract class NSManagedObjectMemberValue
    extends CidrMemberValue {
        private final String myClassName;

        public NSManagedObjectMemberValue(LLValue attrVal, String className) {
            super(attrVal, NSManagedObjectValueRenderer.this.myValue, true);
            this.myClassName = className;
        }

        public NSManagedObjectMemberValue(LLValue attrVal, String displayName, String className) {
            super(attrVal, displayName, NSManagedObjectValueRenderer.this.myValue, true);
            this.myClassName = className;
        }

        @Override
        protected XSourcePosition doComputePosition(@NotNull XSourcePosition position) {
            return NSManagedObjectValueRenderer.this.isManagedObjectClass(this.myClassName) ? null : this.getTypesHelper().resolveProperty(this, this.myClassName);
        }
    }

    public static class Factory
    implements ValueRendererFactory {
        @Override
        @Nullable
        public ValueRenderer createRenderer(@NotNull ValueRendererFactory.FactoryContext context) throws ExecutionException, DebuggerCommandException {
            if (!context.getSettings().COCOA_RENDERERS_ENABLED || !context.getSettings().CORE_DATA_RENDERERS_ENABLED) {
                return null;
            }
            CidrPhysicalValue value2 = context.getPhysicalValue();
            if (value2.getVar().getTypeClass() != LLValue.TypeClass.OBJC_POINTER) {
                return null;
            }
            if (context.getLLValueData().isSynthetic()) {
                return null;
            }
            try {
                return new NSManagedObjectValueRenderer(context.getPhysicalValue(), context.getEvaluationContext());
            }
            catch (NotApplicableException e) {
                return null;
            }
            catch (DebuggerCommandException e) {
                return null;
            }
        }
    }
}

