/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CachedDebuggerResult;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRendererExtension;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueRenderer {
    @NotNull
    protected final CidrPhysicalValue myValue;
    @NotNull
    private final CachedDebuggerResult<Pair<String, XFullValueEvaluator>> myValueCache = new CachedDebuggerResult();
    @NotNull
    private final CachedDebuggerResult<Boolean> myMayHaveChildrenCache = new CachedDebuggerResult();
    protected int myCurrentIndex = 0;

    public ValueRenderer(@NotNull CidrPhysicalValue value2) {
        this.myValue = value2;
    }

    @NotNull
    public CidrPhysicalValue getValue() {
        return this.myValue;
    }

    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        boolean isPointer = this.myValue.getPreparedVarData().isPointer();
        boolean isSwift = this.myValue.isSwiftContext();
        if (child.getName().matches("\\[\\w+\\]")) {
            return this.getChildEvaluationExpression(child, "", this.myValue);
        }
        if (!isSwift && isPointer) {
            return this.getChildEvaluationExpression(child, "->", this.myValue);
        }
        if (!isSwift && this.myValue instanceof CidrElementValue) {
            CidrElementValue value2 = (CidrElementValue)this.myValue;
            if (value2.getIndex() == 0) {
                return this.getChildEvaluationExpression(child, "->", value2.getContainer());
            }
        } else if (this.myValue instanceof CidrMemberValue) {
            CidrPhysicalValue parent = ((CidrMemberValue)this.myValue).getParent();
            if (this.isSuperNode()) {
                return parent.getPreparedRenderer().getChildEvaluationExpression(child, lvalue);
            }
        }
        return this.getChildEvaluationExpression(child, ".", this.myValue);
    }

    private boolean isSuperNode() {
        LLValue var = this.myValue.getVar();
        return var.getType().equals(var.getName());
    }

    protected LLValueData messageSendToSelfData(String selectorAndArgs, String returnType, EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return context.getData(this.messageSendToSelf(selectorAndArgs, returnType, context));
    }

    protected LLValue messageSendToSelf(String selectorAndArgs, String returnType, EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return context.messageSend(this.myValue.getVar(), selectorAndArgs, returnType);
    }

    @Nullable
    public Icon getIcon(boolean hasChildren) {
        return hasChildren ? AllIcons.Debugger.Value : AllIcons.Debugger.Db_primitive;
    }

    @NotNull
    public StringBuilder getConsoleDescription(@NotNull EvaluationContext context) throws ExecutionException {
        StringBuilder builder = new StringBuilder();
        try {
            boolean hasChildren;
            String value2 = (String)this.computeValueAndEvaluator((EvaluationContext)context).first;
            builder.append("(").append(this.myValue.getType()).append((") " + value2).trim());
            if (this.shouldPrintChildrenConsoleDescription() && (hasChildren = this.computeMayHaveChildren(context))) {
                builder.append("\n");
                this.printChildrenConsoleDescription(context, builder);
            }
        }
        catch (DebuggerCommandException e) {
            ValueRenderer.appendConsoleError(builder, this.toString());
        }
        return builder;
    }

    protected boolean shouldPrintChildrenConsoleDescription() {
        return false;
    }

    private void printChildrenConsoleDescription(EvaluationContext context, StringBuilder builder) throws ExecutionException, DebuggerCommandException {
        builder.append("{\n");
        ConsoleDescriptionNode container = new ConsoleDescriptionNode(builder, context);
        try {
            this.computeChildren(context, container);
        }
        catch (ExecutionRuntimeException e) {
            throw e.cause;
        }
        finally {
            builder.append("}");
        }
    }

    private static void appendConsoleError(StringBuilder builder, @NotNull String errorMessage) {
        builder.append("error: ").append(errorMessage);
    }

    @NotNull
    public String getDisplayType() {
        return ValueRenderer.getShortenedType(this.myValue.getVar().getType());
    }

    @NotNull
    public static String getShortenedType(@NotNull String type2) {
        int TEMPLATE_TYPE_REDUCE_LEVEL = 1;
        StringBuilder result2 = new StringBuilder();
        int count = 0;
        for (int i2 = 0; i2 < type2.length(); ++i2) {
            char c = type2.charAt(i2);
            if (c == '<') {
                ++count;
            }
            if (count <= TEMPLATE_TYPE_REDUCE_LEVEL) {
                int length = result2.length();
                if (c == '>' && length > 2 && result2.charAt(length - 1) == ' ' && result2.charAt(length - 2) != '>') {
                    result2.setLength(length - 1);
                }
                result2.append(c);
            }
            if (c != '>') continue;
            --count;
        }
        return count == 0 ? result2.toString() : type2;
    }

    protected String getChildEvaluationExpression(CidrPhysicalValue child, String separator, CidrPhysicalValue parent) {
        boolean cast;
        ValueRendererExtension extension = ValueRendererExtension.getExtension(parent.getFrame().getFrame().getLanguage());
        if (extension != null) {
            return extension.getChildEvaluationExpression(child, separator, parent);
        }
        String parentRefExpression = parent.getEvaluationExpression();
        boolean bl = cast = parent.getVar().getTypeClass() == LLValue.TypeClass.OBJC_POINTER;
        if (cast) {
            parentRefExpression = "((" + parent.getType() + ")(" + parentRefExpression + "))";
        }
        return parentRefExpression + separator + child.getVar().getName();
    }

    @NotNull
    public Pair<String, XFullValueEvaluator> computeValueAndEvaluator(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return this.myValueCache.getResult(new CachedDebuggerResult.NotNullCalculator<Pair<String, XFullValueEvaluator>>(){

            @Override
            @NotNull
            public Pair<String, XFullValueEvaluator> calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData data = ValueRenderer.this.myValue.getVarData(context);
                if (data.isNullPointer()) {
                    LLValue var = ValueRenderer.this.getValue().getVar();
                    boolean objc = var.getTypeClass() == LLValue.TypeClass.OBJC_POINTER || "id".equals(var.getType()) && ValueRenderer.this.getValue().isObjectiveCContext();
                    return Pair.create((Object)(objc ? "nil" : "NULL"), null);
                }
                if (ValueRenderer.this.myValue.isSwiftVoid()) {
                    return Pair.create((Object)"", null);
                }
                Pair result2 = ValueRenderer.this.doComputeValueAndEvaluator(context);
                return ((String)result2.first).equals("{...}") ? Pair.create((Object)"", null) : result2;
            }
        });
    }

    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return this.doComputeValueAndEvaluator(context, this.myValue.getPresentationVar(), this.myValue.getPresentationVarData(context));
    }

    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context, LLValue var, LLValueData data) throws ExecutionException, DebuggerCommandException {
        String description = data.getDescription();
        Pair result2 = null;
        if (description != null && !StringUtil.containsLineBreak((CharSequence)(description = description.trim()))) {
            result2 = Pair.create((Object)StringUtil.first((String)description, (int)1000, (boolean)false), data.hasLongerDescription() ? this.createFullDescriptionEvaluator(var) : null);
        }
        if (result2 == null) {
            description = this.doComputeFallbackValue(context, var, data);
            ImmediateFullValueEvaluator evaluator = null;
            if (description.length() > 1000) {
                evaluator = new ImmediateFullValueEvaluator(description);
            }
            result2 = Pair.create((Object)StringUtil.first((String)description, (int)1000, (boolean)false), (Object)evaluator);
        }
        return result2;
    }

    @NotNull
    protected String doComputeFallbackValue(@NotNull EvaluationContext context, @NotNull LLValue var, @NotNull LLValueData data) throws ExecutionException, DebuggerCommandException {
        return data.getValue();
    }

    @Nullable
    private XFullValueEvaluator createFullDescriptionEvaluator(final @NotNull LLValue value2) {
        return new XFullValueEvaluator(){

            public void startEvaluation(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                ValueRenderer.this.getValue().getProcess().postCommand(new CidrDebugProcess.DebuggerUIUpdateCommand(){

                    @Override
                    public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                        if (callback.isObsolete()) {
                            return;
                        }
                        try {
                            int _10mb = 0xA00000;
                            String description = driver.getDescription(value2, _10mb);
                            callback.evaluated(StringUtil.notNullize((String)description));
                        }
                        catch (DebuggerCommandException e) {
                            callback.errorOccurred(e.getMessage());
                        }
                        catch (ExecutionException e) {
                            callback.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                            throw e;
                        }
                    }
                });
            }
        };
    }

    public boolean computeMayHaveChildren(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        Integer result2;
        if (this.mayHaveChildrenViaChildrenCount() && (result2 = this.computeChildrenCount(context, 1)) != null) {
            return result2 > 0;
        }
        return this.myMayHaveChildrenCache.getResult(new CachedDebuggerResult.NotNullCalculator<Boolean>(){

            @Override
            @NotNull
            public Boolean calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData data = ValueRenderer.this.myValue.getVarData(context);
                return data.isNullPointer() || ValueRenderer.this.myValue.isSwiftVoid() ? false : data.mayHaveChildren();
            }
        });
    }

    protected boolean mayHaveChildrenViaChildrenCount() {
        return false;
    }

    @Nullable
    protected Integer computeChildrenCount(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return this.computeChildrenCount(context, Integer.MAX_VALUE);
    }

    @Nullable
    private Integer computeChildrenCount(@NotNull EvaluationContext context, int max) throws ExecutionException, DebuggerCommandException {
        LLValueData data = this.myValue.getVarData(context);
        return data.isNullPointer() || this.myValue.isSwiftVoid() ? new Integer(0) : this.doComputeChildrenCount(context, max);
    }

    @Nullable
    protected Integer doComputeChildrenCount(@NotNull EvaluationContext context, int max) throws ExecutionException, DebuggerCommandException {
        return context.getChildrenCount(this.myValue.getPresentationVar(), max);
    }

    public void computeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container) throws ExecutionException, DebuggerCommandException {
        if (!this.computeMayHaveChildren(context)) {
            container.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        this.doComputeChildren(context, container);
    }

    protected int getBatchSize() {
        return 50;
    }

    protected void doComputeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container) throws ExecutionException, DebuggerCommandException {
        LLValue var = this.myValue.getPresentationVar();
        DebuggerDriver.ResultList<LLValue> result2 = context.getVariableChildren(var, this.getCurrentIndex(), this.getBatchSize());
        this.addChildrenTo(result2.list, context, container, this.areChildrenModifiable(var, this.myValue.getPresentationVarData(context)));
        if (result2.hasMore) {
            container.tooManyChildren(-1);
        }
    }

    protected void addChildrenTo(@NotNull List<LLValue> children2, @NotNull EvaluationContext context, @NotNull XCompositeNode container, boolean modifiable) throws ExecutionException, DebuggerCommandException {
        SmartList values = new SmartList();
        for (LLValue each : children2) {
            if (container.isObsolete()) {
                return;
            }
            values.add(new CidrMemberValue(each, this.myValue, modifiable));
        }
        CidrValue.addAllTo((Collection<CidrValue>)values, container);
        this.myCurrentIndex += children2.size();
    }

    protected int getCurrentIndex() {
        return this.myCurrentIndex;
    }

    protected boolean areChildrenModifiable(@NotNull LLValue var, @NotNull LLValueData data) {
        return !data.isSynthetic();
    }

    private static class ConsoleDescriptionNode
    implements XCompositeNode {
        private final StringBuilder myBuilder;
        private final EvaluationContext myContext;

        public ConsoleDescriptionNode(StringBuilder builder, EvaluationContext context) {
            this.myBuilder = builder;
            this.myContext = context;
        }

        public void addChildren(@NotNull XValueChildrenList children2, boolean last) {
            for (int i2 = 0; i2 < children2.size(); ++i2) {
                String name = children2.getName(i2);
                this.myBuilder.append("\t").append(name).append(" = ");
                try {
                    String shiftedChildren = ((CidrValue)children2.getValue(i2)).getConsoleDescription(this.myContext).replace("\n", "\n\t");
                    this.myBuilder.append(shiftedChildren);
                }
                catch (DebuggerCommandException e) {
                    this.setErrorMessage(e.getMessage());
                }
                catch (ExecutionException e) {
                    throw new ExecutionRuntimeException(e);
                }
                this.myBuilder.append("\n");
            }
        }

        public void tooManyChildren(int remaining) {
            this.myBuilder.append("\t...");
            if (remaining > 0) {
                this.myBuilder.append(remaining).append(" more\n");
            }
        }

        public void setErrorMessage(@NotNull String errorMessage) {
            ValueRenderer.appendConsoleError(this.myBuilder, errorMessage);
        }

        public void setErrorMessage(@NotNull String errorMessage, @Nullable XDebuggerTreeNodeHyperlink link) {
            this.setErrorMessage(errorMessage);
        }

        public void setMessage(@NotNull String message2, @Nullable Icon icon, @NotNull SimpleTextAttributes attributes, @Nullable XDebuggerTreeNodeHyperlink link) {
        }

        public boolean isObsolete() {
            return false;
        }

        public void setAlreadySorted(boolean alreadySorted) {
        }
    }

    static class ExecutionRuntimeException
    extends RuntimeException {
        ExecutionException cause;

        ExecutionRuntimeException(ExecutionException exception) {
            this.cause = exception;
        }
    }
}

