/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.jetbrains.cidr.execution.debugger.memory.Address;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0000J\u0013\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0002J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0000J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0006\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "Lkotlin/ranges/ClosedRange;", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "start", "endInclusive", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;Lcom/jetbrains/cidr/execution/debugger/memory/Address;)V", "endCoerced", "getEndCoerced", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getEndInclusive", "getStart", "coerceIn", "range", "covers", "", "equals", "other", "", "hashCode", "", "headUntil", "address", "intersectWith", "intersects", "tailFrom", "toString", "", "Companion", "cidr-debugger"})
public final class AddressRange
implements ClosedRange<Address> {
    @NotNull
    private final Address start;
    @NotNull
    private final Address endInclusive;
    @JvmField
    @NotNull
    public static final AddressRange EMPTY;
    @JvmField
    @NotNull
    public static final AddressRange WHOLE;
    public static final Companion Companion;

    @NotNull
    public final Address getEndCoerced() {
        return this.getEndInclusive().plus(Address.Companion.getCoercing(1));
    }

    public final boolean covers(@NotNull AddressRange range) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        return range.isEmpty() || this.contains((Comparable)range.getStart()) && this.contains((Comparable)range.getEndInclusive());
    }

    public final boolean intersects(@NotNull AddressRange range) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        return !range.isEmpty() && (this.contains((Comparable)range.getStart()) || this.contains((Comparable)range.getEndInclusive())) || !this.isEmpty() && (range.contains((Comparable)this.getStart()) || range.contains((Comparable)this.getEndInclusive()));
    }

    @NotNull
    public final AddressRange intersectWith(@NotNull AddressRange range) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        return !this.intersects(range) ? EMPTY : ((Address)RangesKt.coerceIn((Comparable)this.getStart(), (ClosedRange)range)).rangeTo((Address)RangesKt.coerceIn((Comparable)this.getEndInclusive(), (ClosedRange)range));
    }

    @NotNull
    public final AddressRange coerceIn(@NotNull AddressRange range) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        return this.intersectWith(range);
    }

    @NotNull
    public final AddressRange headUntil(@NotNull Address address) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        return address.compareTo(this.getStart()) <= 0 ? EMPTY : this.getStart().rangeTo(address.minus(1));
    }

    @NotNull
    public final AddressRange tailFrom(@NotNull Address address) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        return address.compareTo(this.getEndInclusive()) > 0 ? EMPTY : address.rangeTo(this.getEndInclusive());
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof AddressRange && (this.isEmpty() && ((AddressRange)other).isEmpty() || Intrinsics.areEqual((Object)this.getStart(), (Object)((AddressRange)other).getStart()) && Intrinsics.areEqual((Object)this.getEndInclusive(), (Object)((AddressRange)other).getEndInclusive()));
    }

    public int hashCode() {
        return this.isEmpty() ? -1 : this.getStart().hashCode() ^ this.getEndInclusive().hashCode();
    }

    @NotNull
    public String toString() {
        return this.getStart() + ".." + this.getEndInclusive();
    }

    @NotNull
    public Address getStart() {
        return this.start;
    }

    @NotNull
    public Address getEndInclusive() {
        return this.endInclusive;
    }

    public AddressRange(@NotNull Address start, @NotNull Address endInclusive) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)endInclusive, (String)"endInclusive");
        this.start = start;
        this.endInclusive = endInclusive;
    }

    static {
        Companion = new Companion(null);
        EMPTY = new AddressRange(Address.MIN_VALUE.plus(1), Address.MIN_VALUE);
        WHOLE = new AddressRange(Address.MIN_VALUE, Address.MAX_VALUE);
    }

    public boolean isEmpty() {
        return ClosedRange.DefaultImpls.isEmpty((ClosedRange)this);
    }

    public boolean contains(@NotNull Address value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        return ClosedRange.DefaultImpls.contains((ClosedRange)this, (Comparable)value2);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange$Companion;", "", "()V", "EMPTY", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "WHOLE", "cidr-debugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

