/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.util.EventDispatcher;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0011\u0018\u0000 +*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003+,-B%\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bJ\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0016\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u0010H\u0086\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b2\u0006\u0010\u0017\u001a\u00020\u0006H\u0086\u0002J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010\u0019\u001a\u00020\u0010J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010\u0017\u001a\u00020\u0006J\u0015\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010 J\u001d\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\"J\u001f\u0010#\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\"J\u0015\u0010$\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010 J\u001d\u0010$\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\"J\u0013\u0010%\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010&J\u001d\u0010'\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0006R\"\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\n8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0004\u001a\u001a\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006."}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;", "R", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "", "regionFactory", "Ljava/util/function/BiFunction;", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "", "(Ljava/util/function/BiFunction;)V", "myRegionEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Listener;", "myRegionEventDispatcher$annotations", "()V", "myRegionMap", "Ljava/util/NavigableMap;", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getRegionFactory", "()Ljava/util/function/BiFunction;", "addListener", "", "listener", "checkPreallocated", "range", "get", "address", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;)Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "", "preallocate", "", "putRegion", "region", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;)Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "isAllocated", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Z)Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "putRegionIfNotEmpty", "replaceRegion", "save", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;)V", "splitUnallocated", "byRange", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;)Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "unallocate", "Companion", "Listener", "Region", "cidr-debugger"})
public final class AddressSpace<R extends Region> {
    private final EventDispatcher<Listener<R>> myRegionEventDispatcher;
    private final NavigableMap<Address, R> myRegionMap;
    @NotNull
    private final BiFunction<? super AddressRange, ? super Boolean, ? extends R> regionFactory;
    private static final long DEFAULT_RANGE_BYTES_AFTER = 512L;
    private static final long DEFAULT_RANGE_BYTES_GROWTH = 256L;
    public static final Companion Companion = new Companion(null);

    private static /* synthetic */ void myRegionEventDispatcher$annotations() {
    }

    public final void addListener(@NotNull Listener<? super R> listener2) {
        Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
        this.myRegionEventDispatcher.addListener((EventListener)listener2);
    }

    @NotNull
    public final R get(@NotNull Address address) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        R r = this.myRegionMap.floorEntry(address).getValue();
        Intrinsics.checkExpressionValueIsNotNull(r, (String)"myRegionMap.floorEntry(address).value");
        return (R)((Region)r);
    }

    @NotNull
    public final Collection<R> get(@NotNull AddressRange range) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        AddressRange endRange = this.get(range.getEndInclusive()).getRange();
        boolean includeLast = Intrinsics.areEqual((Object)endRange.getEndInclusive(), (Object)range.getEndInclusive());
        Address end = includeLast ? endRange.getEndInclusive() : (Address)RangesKt.coerceAtLeast((Comparable)endRange.getStart(), (Comparable)range.getStart());
        NavigableMap<Address, R> subMap = this.myRegionMap.subMap(range.getStart(), true, end, includeLast);
        Collection collection = Collections.unmodifiableCollection(subMap.values());
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"Collections.unmodifiableCollection(subMap.values)");
        return collection;
    }

    @NotNull
    public final List<AddressRange> preallocate(@NotNull Address address) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        AddressRange range = com.jetbrains.cidr.execution.debugger.memory.AddressSpace$Companion.rangeForAddress$default(Companion, address, false, 2, null);
        R region = this.get(address);
        if (region.isAllocated() && region.getRange().covers(range)) {
            return CollectionsKt.emptyList();
        }
        return this.preallocate(Companion.rangeForAddress(address, true));
    }

    @NotNull
    public final List<AddressRange> preallocate(@NotNull AddressRange range) {
        Object object;
        Collection collection;
        Region it;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        ArrayList<Object> allocated = new ArrayList<Object>();
        R r = this.get(range.getStart());
        Object it2 = (Region)r;
        if (!it2.isAllocated()) {
            allocated.add(this.splitUnallocated(it2, range));
        }
        Iterable<Object> $receiver$iv = this.get(range);
        it2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Region)element$iv$iv;
            if (!(!it.isAllocated())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Region)item$iv$iv;
            collection = destination$iv$iv;
            object = this.replaceRegion(it.getRange(), true);
            collection.add(object);
        }
        CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)allocated);
        $receiver$iv = this.get(range.getEndInclusive());
        it2 = (Region)((Object)$receiver$iv);
        if (!it2.isAllocated()) {
            allocated.add(this.splitUnallocated(it2, range));
        }
        $receiver$iv = allocated;
        it2 = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Region)item$iv$iv;
            collection = destination$iv$iv;
            object = it.getRange();
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    private final R splitUnallocated(R region, AddressRange byRange) {
        boolean bl;
        boolean bl2 = bl = !region.isAllocated();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        AddressRange range = region.getRange();
        AddressRange $receiver$iv = byRange.intersectWith(range);
        AddressRange it = $receiver$iv;
        if (it.isEmpty()) {
            throw (Throwable)new IllegalArgumentException(byRange + " must intersect " + range);
        }
        AddressRange allocRange = $receiver$iv;
        this.myRegionMap.remove(range.getStart());
        R headRegion = this.putRegionIfNotEmpty(range.headUntil(allocRange.getStart()), false);
        R allocRegion = this.putRegion(allocRange, true);
        R tailRegion = this.putRegionIfNotEmpty(range.tailFrom(allocRange.getEndInclusive().plus(1)), false);
        ((Listener)this.myRegionEventDispatcher.getMulticaster()).regionSplit(region, CollectionsKt.filterNotNull((Iterable)CollectionsKt.arrayListOf((Object[])new Region[]{headRegion, allocRegion, tailRegion})));
        return allocRegion;
    }

    public final void unallocate(@NotNull AddressRange range) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        this.replaceRegion(this.checkPreallocated(range), false);
    }

    public final void save(@NotNull R region) {
        Intrinsics.checkParameterIsNotNull(region, (String)"region");
        this.checkPreallocated(region.getRange());
        this.replaceRegion(region);
    }

    private final AddressRange checkPreallocated(AddressRange range) {
        Region region = (Region)this.myRegionMap.get(range.getStart());
        if (region == null || Intrinsics.areEqual((Object)range, (Object)region.getRange()) ^ true || !region.isAllocated()) {
            throw (Throwable)new IllegalStateException("Range must be preallocated first");
        }
        return range;
    }

    private final R putRegion(R region) {
        Map map2 = this.myRegionMap;
        Address address = region.getRange().getStart();
        R r = region;
        map2.put(address, r);
        return region;
    }

    private final R putRegion(AddressRange range, boolean isAllocated) {
        boolean bl;
        boolean bl2 = bl = !range.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Region range must not be empty";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return (R)this.putRegion((Region)this.regionFactory.apply(range, isAllocated));
    }

    private final R putRegionIfNotEmpty(AddressRange range, boolean isAllocated) {
        return range.isEmpty() ? null : (R)this.putRegion(range, isAllocated);
    }

    private final R replaceRegion(R region) {
        Region oldRegion = (Region)this.myRegionMap.get(region.getRange().getStart());
        if (oldRegion == null || Intrinsics.areEqual((Object)region.getRange(), (Object)oldRegion.getRange()) ^ true) {
            Region region2 = oldRegion;
            throw (Throwable)new IllegalStateException("Can only replace regions of the same range: " + region.getRange() + " != " + (region2 != null ? region2.getRange() : null));
        }
        this.putRegion(region);
        ((Listener)this.myRegionEventDispatcher.getMulticaster()).regionSplit(oldRegion, CollectionsKt.arrayListOf((Object[])new Region[]{region}));
        return region;
    }

    private final R replaceRegion(AddressRange range, boolean isAllocated) {
        return (R)this.replaceRegion((Region)this.regionFactory.apply(range, isAllocated));
    }

    @NotNull
    public final BiFunction<? super AddressRange, ? super Boolean, ? extends R> getRegionFactory() {
        return this.regionFactory;
    }

    public AddressSpace(@NotNull BiFunction<? super AddressRange, ? super Boolean, ? extends R> regionFactory) {
        Intrinsics.checkParameterIsNotNull(regionFactory, (String)"regionFactory");
        this.regionFactory = regionFactory;
        EventDispatcher eventDispatcher = EventDispatcher.create(Listener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"EventDispatcher.create(L\u2026va as Class<Listener<R>>)");
        this.myRegionEventDispatcher = eventDispatcher;
        this.myRegionMap = new TreeMap();
        this.putRegion(AddressRange.WHOLE, false);
    }

    static {
        DEFAULT_RANGE_BYTES_AFTER = 512L;
        DEFAULT_RANGE_BYTES_GROWTH = 256L;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "", "isAllocated", "", "()Z", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "cidr-debugger"})
    public static interface Region {
        @NotNull
        public AddressRange getRange();

        public boolean isAllocated();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\bf\u0018\u0000*\n\b\u0001\u0010\u0001 \u0000*\u00020\u00022\u00020\u0003J#\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00028\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bH&\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Listener;", "R", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "Ljava/util/EventListener;", "regionSplit", "", "oldRegion", "newRegions", "", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;Ljava/util/List;)V", "cidr-debugger"})
    public static interface Listener<R extends Region>
    extends EventListener {
        public void regionSplit(@NotNull R var1, @NotNull List<? extends R> var2);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Companion;", "", "()V", "DEFAULT_RANGE_BYTES_AFTER", "", "getDEFAULT_RANGE_BYTES_AFTER", "()J", "DEFAULT_RANGE_BYTES_GROWTH", "getDEFAULT_RANGE_BYTES_GROWTH", "rangeForAddress", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "grow", "", "cidr-debugger"})
    public static final class Companion {
        public final long getDEFAULT_RANGE_BYTES_AFTER() {
            return DEFAULT_RANGE_BYTES_AFTER;
        }

        public final long getDEFAULT_RANGE_BYTES_GROWTH() {
            return DEFAULT_RANGE_BYTES_GROWTH;
        }

        @NotNull
        public final AddressRange rangeForAddress(@NotNull Address address, boolean grow) {
            Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
            return address.rangeTo(address.plus(Address.Companion.getCoercing(this.getDEFAULT_RANGE_BYTES_AFTER() + (grow ? this.getDEFAULT_RANGE_BYTES_GROWTH() : 0L) - (long)1)));
        }

        @NotNull
        public static /* bridge */ /* synthetic */ AddressRange rangeForAddress$default(Companion companion, Address address, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.rangeForAddress(address, bl);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

