/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.SMStacktraceParser;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrAbstractTestConsoleProperties
extends SMTRunnerConsoleProperties
implements SMCustomMessagesParsing,
SMStacktraceParser {
    private final ExecutionTarget myTarget;

    protected CidrAbstractTestConsoleProperties(@NotNull RunConfiguration config, @NotNull String testFrameworkName, @NotNull Executor executor, @NotNull ExecutionTarget target) {
        super(config, testFrameworkName, executor);
        this.myTarget = target;
    }

    @Override
    @NotNull
    public ExecutionTarget getExecutionTarget() {
        return this.myTarget;
    }

    @NotNull
    protected abstract Pattern getAssertionPattern();

    @Override
    @Nullable
    public Navigatable getErrorNavigatable(@NotNull Project project2, @NotNull String stacktrace) {
        Matcher m = this.getAssertionPattern().matcher(stacktrace);
        if (m.find()) {
            int line;
            String path = m.group(1);
            String lineString = m.group(2);
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(CidrAbstractTestConsoleProperties.normalizePath(path));
            if (file2 == null) {
                return null;
            }
            try {
                line = Integer.valueOf(lineString) - 1;
            }
            catch (NumberFormatException e) {
                return null;
            }
            return this.findSuitableNavigatableForLine(project2, file2, line);
        }
        return null;
    }

    @NotNull
    public static String normalizePath(@NotNull String fileName) {
        if (ApplicationManagerEx.getApplicationEx().isUnitTestMode() && FileUtil.isAbsolute((String)fileName)) {
            try {
                fileName = new File(fileName).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return fileName;
    }
}

