/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CidrLauncher {
    public ProcessHandler startProcess(@NotNull CommandLineState state) throws ExecutionException {
        ProcessHandler result2 = this.createProcess(state);
        this.configProcessHandler(state, result2, false, true);
        return result2;
    }

    protected abstract ProcessHandler createProcess(@NotNull CommandLineState var1) throws ExecutionException;

    @NotNull
    public CidrDebugProcess startDebugProcess(@NotNull CommandLineState state, @NotNull XDebugSession session2) throws ExecutionException {
        CidrDebugProcess result2 = this.createDebugProcess(state, session2);
        ((XDebugSessionImpl)session2).addRestartActions(this.getAdditionalActions(state, result2.getProcessHandler(), (ExecutionConsole)result2.getConsole()));
        this.configProcessHandler(state, result2.getProcessHandler(), result2.isDetachDefault(), true);
        result2.start();
        return result2;
    }

    @NotNull
    protected abstract CidrDebugProcess createDebugProcess(@NotNull CommandLineState var1, @NotNull XDebugSession var2) throws ExecutionException;

    protected void configProcessHandler(@NotNull CommandLineState state, @NotNull ProcessHandler handler2, boolean detachSupported, boolean reportExitCode) {
        if (!detachSupported) {
            handler2.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, (Object)Boolean.TRUE);
        }
        if (reportExitCode) {
            ProcessTerminatedListener.attach((ProcessHandler)handler2, (Project)this.getProject());
        }
    }

    @NotNull
    protected abstract Project getProject();

    public void configureExecutionResult(@NotNull CommandLineState state, @NotNull DefaultExecutionResult executionResult) throws ExecutionException {
        executionResult.setRestartActions(this.getAdditionalActions(state, executionResult.getProcessHandler(), executionResult.getExecutionConsole()));
    }

    @NotNull
    private AnAction[] getAdditionalActions(@NotNull CommandLineState state, ProcessHandler handler2, ExecutionConsole console) throws ExecutionException {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        this.collectAdditionalActions(state, handler2, console, actions);
        return actions.toArray(new AnAction[actions.size()]);
    }

    protected void collectAdditionalActions(@NotNull CommandLineState state, @NotNull ProcessHandler processHandler2, @NotNull ExecutionConsole console, @NotNull List<AnAction> actions) throws ExecutionException {
        if (state instanceof CidrTestCommandLineState) {
            actions.add(((CidrTestCommandLineState)state).createRerunFailedTestsAction(console));
        }
    }
}

