/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.testing.CidrScopeInfo;
import java.lang.reflect.Modifier;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestRunConfigurationData
implements JDOMExternalizable,
Cloneable {
    @Nullable
    public String myTestSuite;
    @Nullable
    public String myTestName;
    @Nullable
    protected String myTestPattern;
    @NotNull
    protected CidrScopeInfo.Mode myTestMode = CidrScopeInfo.Mode.SUITE_TEST;
    @NotNull
    protected Project myProject;

    public abstract void checkData() throws RuntimeConfigurationException;

    public CidrTestRunConfigurationData(@NotNull Project project2) {
        this.myProject = project2;
        assert (!CidrTestRunConfigurationData.isPotentiallyThisCapturing(this.getClass())) : "TestData must not be initialized from an inner/anonymous (non-static) class. Otherwise it will leak in clone() and cause unexpected behavior";
    }

    static boolean isPotentiallyThisCapturing(Class<?> clazz) {
        return clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers());
    }

    @Nullable
    public String getTestSuite() {
        return this.myTestSuite;
    }

    public void setTestSuite(@Nullable String testSuite) {
        this.myTestSuite = StringUtil.nullize((String)testSuite, (boolean)true);
    }

    @Nullable
    public String getTestName() {
        return this.myTestName;
    }

    public void setTestName(@Nullable String testName) {
        this.myTestName = StringUtil.nullize((String)testName, (boolean)true);
    }

    @Nullable
    public String getTestPattern() {
        return this.myTestPattern;
    }

    public void setTestPattern(@Nullable String testPattern) {
        this.myTestPattern = testPattern;
    }

    @NotNull
    public CidrScopeInfo.Mode getTestMode() {
        return this.myTestMode;
    }

    public void setTestMode(@NotNull CidrScopeInfo.Mode mode) {
        this.myTestMode = mode;
    }

    @NotNull
    public String suggestedName(@Nullable String fallbackName) {
        if (this.myTestSuite != null && this.myTestName != null) {
            return this.formatTestMethod();
        }
        if (this.myTestMode == CidrScopeInfo.Mode.PATTERN) {
            return "Pattern";
        }
        String scopeName = this.myTestSuite != null ? this.myTestSuite : fallbackName;
        return scopeName == null ? CidrBundle.message("test.defaultName.allTests", new Object[0]) : CidrBundle.message("test.defaultName.allTestsIn", scopeName);
    }

    @NotNull
    protected abstract String formatTestMethod();

    public void readExternal(Element element) throws InvalidDataException {
        this.setTestSuite(element.getAttributeValue("TEST_CLASS"));
        this.setTestName(element.getAttributeValue("TEST_METHOD"));
        this.setTestPattern(element.getAttributeValue("TEST_PATTERN"));
        String modeValue = element.getAttributeValue("TEST_MODE");
        this.setTestMode(modeValue == null || modeValue.equals("SUITE_TEST") ? CidrScopeInfo.Mode.SUITE_TEST : CidrScopeInfo.Mode.PATTERN);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        switch (this.myTestMode) {
            case SUITE_TEST: {
                if (this.myTestSuite == null) break;
                element.setAttribute("TEST_CLASS", this.myTestSuite);
                if (this.myTestName == null) break;
                element.setAttribute("TEST_METHOD", this.myTestName);
                break;
            }
            case PATTERN: {
                if (this.myTestPattern == null) break;
                element.setAttribute("TEST_PATTERN", this.myTestPattern);
            }
        }
        element.setAttribute("TEST_MODE", this.myTestMode.name());
    }

    public CidrTestRunConfigurationData clone() {
        try {
            CidrTestRunConfigurationData result2 = (CidrTestRunConfigurationData)super.clone();
            result2.myTestSuite = this.myTestSuite;
            result2.myTestName = this.myTestName;
            result2.myTestPattern = this.myTestPattern;
            result2.myTestMode = this.myTestMode;
            result2.myProject = this.myProject;
            return result2;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

