/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationSettingsEditor;
import com.jetbrains.cidr.execution.testing.CidrScopeInfo;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.lang.ui.OCFieldAdapter;
import com.jetbrains.cidr.lang.ui.OCTextFieldWithSymbolAutoCompletion;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestRunConfigurationEditor<SUITE, CONFIGURATION extends CidrRunConfiguration, BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends CidrRunConfigurationSettingsEditor<CONFIGURATION, BC, TARGET, BCH> {
    protected OCTextFieldWithSymbolAutoCompletion<SUITE> mySuiteField;
    protected EditorTextField myPatternField;
    private AsyncProcessIcon myProcessIcon;
    private JLabel myMethodComboLabel;
    private JLabel mySuiteFieldLabel;
    private JLabel myPatternFieldLabel;
    private JLabel mySuitesTipLabel;
    private JRadioButton myRbPattern;
    protected CidrRunConfigurationSettingsEditor.MyComboBox myMethodCombo;
    private MergingUpdateQueue myQueue;
    private Set<String> mySuiteMethods = Collections.emptySet();
    private volatile boolean myIsDisposed = false;

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    public CidrTestRunConfigurationEditor(@NotNull Project project2, @NotNull BCH configHelper) {
        super(project2, configHelper);
    }

    @Override
    protected void createEditorInner(JPanel p, GridBag g) {
        this.myQueue = new MergingUpdateQueue("UpdateMethods", 500, false, (JComponent)p, (Disposable)this, (JComponent)p, true);
        this.createTestKindRadioButtons(p, g);
        this.mySuiteFieldLabel = new JLabel(this.getSuiteFieldLabelName() + ":");
        JPanel childPanel = new JPanel(new GridBagLayout());
        p.add((Component)childPanel, g.nextLine().next().insets(0, 0, 0, 0));
        GridBag childGrid = new GridBag().setDefaultFill(1);
        childPanel.add((Component)this.mySuiteFieldLabel, childGrid.nextLine().next().weightx(0.9));
        this.myProcessIcon = new AsyncProcessIcon("TestCompletion");
        this.myProcessIcon.setVisible(false);
        childPanel.add((Component)this.myProcessIcon, childGrid.next().anchor(22).weightx(0.1));
        this.mySuiteField = this.createSuiteField();
        p.add((Component)((Object)this.mySuiteField), g.next().coverLine().insets(0, 0, 0, 0));
        this.mySuiteFieldLabel.setLabelFor((Component)((Object)this.mySuiteField));
        this.mySuitesTipLabel = new JBLabel(this.getSuitesTipMessage(), UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER);
        p.add((Component)this.mySuitesTipLabel, g.nextLine().next().next().coverLine().insets((Insets)JBUI.insets((int)-1, (int)10, (int)4, (int)0)));
        JBInsets i2 = JBUI.insets((int)-1, (int)-1, (int)12, (int)-1);
        this.myMethodComboLabel = new JLabel(this.getTestFieldLabelName() + ":");
        p.add((Component)this.myMethodComboLabel, g.nextLine().next().insets((Insets)i2));
        this.myMethodCombo = CidrTestRunConfigurationEditor.createCombo();
        p.add((Component)((Object)this.myMethodCombo), g.next().coverLine().insets((Insets)i2));
        this.myMethodComboLabel.setLabelFor((Component)((Object)this.myMethodCombo));
        this.mySuiteField.setPlaceholder(this.getSuitePlaceholder());
        this.myMethodCombo.setRenderer(new MyTestsRenderer());
        this.mySuiteField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                CidrTestRunConfigurationEditor.this.scheduleSuiteAndTestsUpdate();
            }
        });
        this.myPatternFieldLabel = new JLabel(CidrBundle.message("test.configuration.pattern", new Object[0]) + ":");
        p.add((Component)this.myPatternFieldLabel, g.nextLine().next());
        this.myPatternField = new EditorTextField();
        p.add((Component)((Object)this.myPatternField), g.next().coverLine());
        this.myPatternField.setVisible(false);
        this.myPatternField.setPlaceholder(this.getPatternPlaceholder());
        this.myPatternField.setPreferredWidth(150);
        this.myPatternFieldLabel.setLabelFor((Component)((Object)this.myPatternField));
        this.myPatternFieldLabel.setVisible(false);
        super.createEditorInner(p, g);
    }

    public void setPassThroughUpdateMode(boolean passThrough) {
        this.myQueue.setPassThrough(passThrough);
    }

    protected void scheduleSuiteAndTestsUpdate() {
        this.myQueue.cancelAllUpdates();
        this.myQueue.queue(new Update("go!"){

            public void run() {
                boolean suitesSpecified = CidrTestRunConfigurationEditor.this.isValidSuiteName();
                CidrTestRunConfigurationEditor.this.myMethodComboLabel.setEnabled(suitesSpecified);
                CidrTestRunConfigurationEditor.this.myMethodCombo.setEnabled(suitesSpecified);
                CidrTestRunConfigurationEditor.this.updateSuiteAndMethodControls();
            }
        });
    }

    protected OCTextFieldWithSymbolAutoCompletion<SUITE> createSuiteField() {
        return OCTextFieldWithSymbolAutoCompletion.create(this.myProject, this.createSuiteAdapter(), this.createSuiteCompletionCondition(), new OCTextFieldWithSymbolAutoCompletion.ProcessListener(){

            @Override
            public void onStarted() {
                CidrTestRunConfigurationEditor.this.myProcessIcon.setVisible(true);
            }

            @Override
            public void onFinished() {
                CidrTestRunConfigurationEditor.this.myProcessIcon.setVisible(false);
            }
        });
    }

    protected void disposeEditor() {
        this.myIsDisposed = true;
        this.mySuiteField.cancelRunningTasks();
        super.disposeEditor();
    }

    @NotNull
    protected abstract OCFieldAdapter<SUITE> createSuiteAdapter();

    @Nullable
    protected abstract Condition<SUITE> createSuiteCompletionCondition();

    private void createTestKindRadioButtons(JPanel p, GridBag g) {
        JBLabel typeLabel = new JBLabel(ExecutionBundle.message((String)"junit.configuration.configure.junit.test.kind.label", (Object[])new Object[0]));
        p.add((Component)typeLabel, g.nextLine().next());
        ButtonGroup bg = new ButtonGroup();
        JRadioButton myRbSuiteTest = new JRadioButton();
        myRbSuiteTest.setText(this.getSuiteFieldLabelName() + " / " + this.getTestFieldLabelName());
        myRbSuiteTest.setSelected(true);
        this.myRbPattern = new JRadioButton();
        this.myRbPattern.setText(CidrBundle.message("test.configuration.pattern", new Object[0]));
        bg.add(myRbSuiteTest);
        bg.add(this.myRbPattern);
        p.add((Component)myRbSuiteTest, g.next().weightx(0.0));
        p.add((Component)this.myRbPattern, g.next().weightx(0.0).insets((Insets)JBUI.insetsBottom((int)4)));
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CidrTestRunConfigurationEditor.this.changeTestKind();
            }
        };
        myRbSuiteTest.addActionListener(listener2);
        this.myRbPattern.addActionListener(listener2);
    }

    private void changeTestKind() {
        boolean pattern = this.myRbPattern.isSelected();
        this.mySuiteField.setVisible(!pattern);
        this.mySuiteFieldLabel.setVisible(!pattern);
        this.mySuitesTipLabel.setVisible(!pattern);
        this.myMethodCombo.setVisible(!pattern);
        this.myMethodComboLabel.setVisible(!pattern);
        this.myPatternField.setVisible(pattern);
        this.myPatternFieldLabel.setVisible(pattern);
    }

    private void updateSuiteField() {
        Editor editor = this.mySuiteField.getEditor();
        if (editor == null) {
            return;
        }
        MarkupModel markup = editor.getMarkupModel();
        markup.removeAllHighlighters();
        String suites = this.getTestSuiteText();
        if (suites == null) {
            return;
        }
        if (!this.isValidSuiteName()) {
            markup.addRangeHighlighter(0, this.mySuiteField.getDocument().getText().length(), 5000, SimpleTextAttributes.ERROR_ATTRIBUTES.toTextAttributes(), HighlighterTargetArea.EXACT_RANGE);
        }
    }

    public abstract boolean isValidSuiteName();

    private void updateMethodCombo() {
        this.updateMethodCombo((String)this.myMethodCombo.getSelectedItem());
    }

    private void updateMethodCombo(@Nullable String selectedItem) {
        if (this.getTestSuiteText() == null) {
            selectedItem = null;
        }
        this.mySuiteMethods = this.collectSuiteTests();
        ArrayList<String> items = new ArrayList<String>(this.mySuiteMethods);
        items.add("");
        if (selectedItem != null && !items.contains(selectedItem)) {
            items.add(selectedItem);
        }
        Collections.sort(items);
        if (selectedItem == null && !items.isEmpty()) {
            selectedItem = items.get(0);
        }
        this.myMethodCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(items, (Object)""));
        this.myMethodCombo.setSelectedItem(selectedItem);
    }

    @NotNull
    protected abstract Set<String> collectSuiteTests();

    @Override
    protected void resetEditorFrom(@NotNull CONFIGURATION selected) {
        super.resetEditorFrom(selected);
        assert (selected instanceof CidrTestRunConfiguration);
        CidrTestRunConfigurationData delegate = ((CidrTestRunConfiguration)selected).getTestData();
        this.mySuiteField.setText(StringUtil.notNullize((String)delegate.getTestSuite()));
        this.updateMethodCombo(StringUtil.notNullize((String)delegate.getTestName()));
        this.myPatternField.setText(StringUtil.notNullize((String)delegate.getTestPattern()));
        this.myRbPattern.setSelected(delegate.getTestMode() == CidrScopeInfo.Mode.PATTERN);
        this.changeTestKind();
    }

    @Override
    protected void applyEditorTo(@NotNull CONFIGURATION selected) throws ConfigurationException {
        super.applyEditorTo(selected);
        assert (selected instanceof CidrTestRunConfiguration);
        CidrTestRunConfigurationData delegate = ((CidrTestRunConfiguration)selected).getTestData();
        CidrScopeInfo.Mode mode = this.myRbPattern.isSelected() ? CidrScopeInfo.Mode.PATTERN : CidrScopeInfo.Mode.SUITE_TEST;
        delegate.setTestSuite(mode == CidrScopeInfo.Mode.SUITE_TEST ? this.getTestSuiteText() : null);
        delegate.setTestName(mode == CidrScopeInfo.Mode.SUITE_TEST ? this.getTestMethodText() : null);
        delegate.setTestPattern(mode == CidrScopeInfo.Mode.PATTERN ? StringUtil.nullize((String)this.myPatternField.getText().trim()) : null);
        delegate.setTestMode(mode);
    }

    @Nullable
    protected String getTestSuiteText() {
        return StringUtil.nullize((String)this.mySuiteField.getText().trim());
    }

    @Nullable
    private String getTestMethodText() {
        return StringUtil.nullize((String)((String)this.myMethodCombo.getSelectedItem()));
    }

    protected void updateSuiteAndMethodControls() {
        if (this.myIsDisposed) {
            return;
        }
        this.updateSuiteField();
        this.updateMethodCombo();
    }

    public TextFieldWithAutoCompletion<SUITE> getSuiteField() {
        return this.mySuiteField;
    }

    protected boolean isChecking() {
        return false;
    }

    protected String getPatternPlaceholder() {
        return "";
    }

    protected abstract String getSuitePlaceholder();

    protected abstract String getSuitesTipMessage();

    protected abstract String getTestFieldLabelName();

    protected abstract String getSuiteFieldLabelName();

    protected abstract String getAllTestsMessage();

    private class MyTestsRenderer
    extends CidrRunConfigurationSettingsEditor.MyBaseRenderer {
        public MyTestsRenderer() {
            super(CidrTestRunConfigurationEditor.this.hasTargetsInSeveralProjects());
        }

        @Override
        protected boolean isChecking() {
            return CidrTestRunConfigurationEditor.this.isChecking();
        }

        @Override
        protected void customizeCellRenderer(SimpleColoredComponent component, JList list, Object value2, int index, boolean selected, boolean hasFocus) {
            if (value2 instanceof String) {
                String methodName = (String)value2;
                if (methodName.isEmpty()) {
                    component.append(CidrTestRunConfigurationEditor.this.getAllTestsMessage(), this.grayed(selected));
                } else if (!CidrTestRunConfigurationEditor.this.mySuiteMethods.contains(methodName)) {
                    this.appendNotFound(methodName, selected);
                } else {
                    component.append(methodName);
                }
            }
        }
    }
}

